/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.ecore2xml.presentation;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLFactory;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLPackage;
import org.eclipse.emf.mapping.ecore2xml.ui.Ecore2XMLUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class Ecore2XMLModelWizard
extends Wizard
implements INewWizard {
    protected Ecore2XMLPackage ecore2XMLPackage = Ecore2XMLPackage.eINSTANCE;
    protected Ecore2XMLFactory ecore2XMLFactory = this.ecore2XMLPackage.getEcore2XMLFactory();
    protected Ecore2XMLModelWizardNewFileCreationPage newFileCreationPage;
    protected Ecore2XMLModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(Ecore2XMLUIPlugin.INSTANCE.getImage("full/wizban/NewEcore2XML")));
    }

    EObject createInitialModel() {
        EClass eClass = (EClass)this.ecore2XMLPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = this.ecore2XMLFactory.create(eClass);
        return rootObject;
    }

    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSet = new ResourceSetImpl();
                            URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString());
                            Resource resource = resourceSet.createResource(fileURI);
                            EObject rootObject = Ecore2XMLModelWizard.this.createInitialModel();
                            if (rootObject != null) {
                                resource.getContents().add((Object)rootObject);
                            }
                            HashMap<String, String> options = new HashMap<String, String>();
                            options.put("ENCODING", Ecore2XMLModelWizard.this.initialObjectCreationPage.getEncoding());
                            resource.save(options);
                        }
                        catch (Exception exception) {
                            Ecore2XMLUIPlugin.INSTANCE.log(exception);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var7_10 = null;
                    }
                    progressMonitor.done();
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)Ecore2XMLUIPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            Ecore2XMLUIPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new Ecore2XMLModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLModelWizard_label"));
        this.newFileCreationPage.setDescription(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLEditorFilenameDefaultBase")) + "." + Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLEditorFilenameExtension"));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLEditorFilenameExtension");
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new Ecore2XMLModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLModelWizard_label"));
        this.initialObjectCreationPage.setDescription(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    public class Ecore2XMLModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        protected IFile modelFile;

        public Ecore2XMLModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String requiredExt = Ecore2XMLUIPlugin.INSTANCE.getString("_UI_Ecore2XMLEditorFilenameExtension");
                String enteredExt = new Path(this.getFileName()).getFileExtension();
                if (enteredExt == null || !enteredExt.equals(requiredExt)) {
                    this.setErrorMessage(Ecore2XMLUIPlugin.INSTANCE.getString("_WARN_FilenameExtension", new Object[]{requiredExt}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performFinish() {
            this.modelFile = this.getModelFile();
            return true;
        }

        public IFile getModelFile() {
            return this.modelFile == null ? ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName())) : this.modelFile;
        }
    }

    public class Ecore2XMLModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected String initialObjectName;
        protected Combo initialObjectField;
        protected String encoding;
        protected Combo encodingField;

        public Ecore2XMLModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            ArrayList<String> objectNames = new ArrayList<String>();
            Iterator classifier = Ecore2XMLModelWizard.this.ecore2XMLPackage.getEClassifiers().iterator();
            while (classifier.hasNext()) {
                EClass eClass;
                EClassifier eClassifier = (EClassifier)classifier.next();
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                objectNames.add(this.getLabel(eClass));
            }
            Collections.sort(objectNames, Collator.getInstance());
            Iterator i = objectNames.iterator();
            while (i.hasNext()) {
                String objectName = (String)i.next();
                this.initialObjectField.add(objectName);
            }
            this.initialObjectField.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ Ecore2XMLModelWizardInitialObjectCreationPage this$1;
                {
                    this.this$1 = ecore2XMLModelWizardInitialObjectCreationPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.setPageComplete(this.this$1.isPageComplete());
                }
            });
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            StringTokenizer stringTokenizer = new StringTokenizer(Ecore2XMLUIPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
            while (stringTokenizer.hasMoreTokens()) {
                this.encodingField.add(stringTokenizer.nextToken());
            }
            this.encodingField.select(0);
            this.setControl((Control)composite);
        }

        public boolean isPageComplete() {
            if (super.isPageComplete()) {
                return this.initialObjectField.getSelectionIndex() != -1;
            }
            return false;
        }

        public boolean performFinish() {
            this.initialObjectName = this.getInitialObjectName();
            this.encoding = this.getEncoding();
            return true;
        }

        public String getInitialObjectName() {
            if (this.initialObjectName != null) {
                return this.initialObjectName;
            }
            String label = this.initialObjectField.getText();
            Iterator classifier = Ecore2XMLModelWizard.this.ecore2XMLPackage.getEClassifiers().iterator();
            while (classifier.hasNext()) {
                EClass eClass;
                EClassifier eClassifier = (EClassifier)classifier.next();
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract() || !this.getLabel(eClass).equals(label)) continue;
                return eClass.getName();
            }
            return label;
        }

        public String getEncoding() {
            return this.encoding == null ? this.encodingField.getText() : this.encoding;
        }

        protected String getLabel(EClass eClass) {
            String name = eClass.getName();
            try {
                return Ecore2XMLUIPlugin.INSTANCE.getString("_UI_" + name + "_type");
            }
            catch (MissingResourceException missingResourceException) {
                return name;
            }
        }
    }
}

