/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenDataType;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenModelImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenPackageImpl;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jmerge.JMerger;
import org.eclipse.emf.codegen.jmerge.PropertyMerger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class GenBaseImpl
extends EObjectImpl
implements GenBase {
    protected static GenPackage ecoreGenPackage;
    protected static GenPackage xmlTypeGenPackage;
    protected static GenPackage xmlNamespaceGenPackage;
    protected static final AnnotationFilter DEFAULT_ANNOTATION_FILTER;

    static {
        DEFAULT_ANNOTATION_FILTER = new AnnotationFilterImpl();
    }

    protected GenBaseImpl() {
    }

    protected EClass eStaticClass() {
        return GenModelPackage.eINSTANCE.getGenBase();
    }

    public GenModel getGenModel() {
        if (this instanceof GenModel) {
            return (GenModel)((Object)this);
        }
        return ((GenBase)this.eContainer()).getGenModel();
    }

    public abstract String getName();

    public String capName(String name) {
        if (name.length() == 0) {
            return name;
        }
        return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
    }

    public String uncapName(String name) {
        if (name.length() == 0) {
            return name;
        }
        return String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
    }

    public String uncapPrefixedName(String name) {
        if (name.length() == 0) {
            return name;
        }
        String lowerName = name.toLowerCase();
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == lowerName.charAt(i)) break;
            ++i;
        }
        if (i > 1 && i < name.length()) {
            --i;
        }
        return String.valueOf(name.substring(0, i).toLowerCase()) + name.substring(i);
    }

    public String safeName(String name) {
        if (GenModelUtil.isJavaReservedWord(name)) {
            return String.valueOf(name) + "_";
        }
        return name;
    }

    protected String getImplClassName(String interfaceName) {
        return String.valueOf(interfaceName) + "Impl";
    }

    public boolean canGenerate() {
        return this.getGenModel() != null && this.getGenModel().canGenerate() && this.hasModelContribution();
    }

    protected boolean hasModelContribution() {
        return false;
    }

    public void generate(IProgressMonitor progressMonitor) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void generate(IProgressMonitor progressMonitor, int style, List pluginVariables, String outputFilePath, JETEmitter jetEmitter) {
        block18: {
            block19: {
                try {
                    try {
                        boolean redirect;
                        IFile targetFile;
                        IContainer container;
                        block20: {
                            block21: {
                                Path outputPath = new Path(outputFilePath.substring(0, outputFilePath.lastIndexOf("/")));
                                progressMonitor.beginTask("", 3);
                                progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingFile_message", new Object[]{outputFilePath}));
                                container = this.findOrCreateContainer((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), style, pluginVariables, (IPath)outputPath, false);
                                if (container == null) break block18;
                                targetFile = container.getFile((IPath)new Path(outputFilePath.substring(outputFilePath.lastIndexOf("/") + 1)));
                                if (!targetFile.exists()) break block20;
                                if (outputFilePath.endsWith("/build.properties")) break block21;
                                if (outputFilePath.endsWith(".properties")) break block20;
                            }
                            Object var16_10 = null;
                            break block19;
                        }
                        boolean changed = false;
                        boolean isUnicodeEscapeEncoded = outputFilePath.endsWith(".properties");
                        String emitterResult = jetEmitter.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), new Object[]{this});
                        if (isUnicodeEscapeEncoded) {
                            emitterResult = GenBaseImpl.unicodeEscapeEncode(emitterResult);
                        }
                        progressMonitor.worked(1);
                        ByteArrayInputStream contents = new ByteArrayInputStream(emitterResult.toString().getBytes(isUnicodeEscapeEncoded ? "ISO-8859-1" : "UTF-8"));
                        if (targetFile.exists()) {
                            PropertyMerger propertyMerger = new PropertyMerger();
                            propertyMerger.setSourceProperties(emitterResult);
                            progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile.getFullPath()}));
                            String oldProperties = propertyMerger.createPropertiesForInputStream(targetFile.getContents(true));
                            propertyMerger.setTargetProperties(oldProperties);
                            progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile.getFullPath()}));
                            propertyMerger.merge();
                            progressMonitor.worked(1);
                            String mergedResult = propertyMerger.getTargetProperties();
                            boolean bl = changed = !mergedResult.equals(oldProperties);
                            if (changed) {
                                if (targetFile.isReadOnly() && targetFile.getWorkspace().validateEdit(new IFile[]{targetFile}, (Object)new SubProgressMonitor(progressMonitor, 1)).isOK()) {
                                    propertyMerger.setTargetProperties(propertyMerger.createPropertiesForInputStream(targetFile.getContents(true)));
                                    propertyMerger.merge();
                                    mergedResult = propertyMerger.getTargetProperties();
                                }
                                contents = new ByteArrayInputStream(mergedResult.getBytes(isUnicodeEscapeEncoded ? "ISO-8859-1" : "UTF-8"));
                            }
                        } else {
                            changed = true;
                        }
                        if (!changed) break block18;
                        String redirection = this.getGenModel().getRedirection();
                        boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                        if (redirect) {
                            String baseName = MessageFormat.format(redirection, targetFile.getName());
                            targetFile = container.getFile((IPath)new Path(baseName));
                            progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile.getFullPath()}));
                        }
                        if (targetFile.isReadOnly()) {
                            if (this.getGenModel().isForceOverwrite()) {
                                ResourceAttributes resourceAttributes = targetFile.getResourceAttributes();
                                if (resourceAttributes != null) {
                                    resourceAttributes.setReadOnly(false);
                                    targetFile.setResourceAttributes(resourceAttributes);
                                }
                            } else {
                                targetFile = container.getFile((IPath)new Path("." + targetFile.getName() + ".new"));
                                progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile.getFullPath()}));
                            }
                        }
                        if (targetFile.exists()) {
                            targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            break block18;
                        }
                        targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    catch (Exception exception) {
                        CodeGenEcorePlugin.INSTANCE.log(exception);
                    }
                    break block18;
                }
                catch (Throwable throwable) {
                    Object var16_11 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return;
        }
        Object var16_12 = null;
        progressMonitor.done();
    }

    protected void generate(IProgressMonitor progressMonitor, int style, List pluginVariables, String outputFilePath, GIFEmitter gifEmitter, String key) {
        this.generate(progressMonitor, style, pluginVariables, outputFilePath, gifEmitter, key, null);
    }

    protected void generate(IProgressMonitor progressMonitor, int style, List pluginVariables, String outputFilePath, GIFEmitter gifEmitter, String parentKey, String childKey) {
        try {
            IFile targetFile;
            Path outputPath = new Path(outputFilePath.substring(0, outputFilePath.lastIndexOf("/")));
            progressMonitor.beginTask("", 3);
            progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingImage_message", new Object[]{outputFilePath}));
            IContainer container = this.findOrCreateContainer((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), style, pluginVariables, (IPath)outputPath, false);
            if (container != null && !(targetFile = container.getFile((IPath)new Path(outputFilePath.substring(outputFilePath.lastIndexOf("/") + 1)))).exists()) {
                byte[] emitterResult = gifEmitter.generateGIF(parentKey, childKey);
                progressMonitor.worked(1);
                ByteArrayInputStream contents = new ByteArrayInputStream(emitterResult);
                targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (Exception exception) {
            CodeGenEcorePlugin.INSTANCE.log(exception);
        }
        progressMonitor.done();
    }

    protected void generate(IProgressMonitor progressMonitor, int style, List pluginVariables, String targetDirectory, String packageName, String className, JETEmitter jetEmitter) {
        block15: {
            try {
                boolean redirect;
                Path outputPath = new Path(String.valueOf(targetDirectory) + "/" + packageName.replace('.', '/'));
                progressMonitor.beginTask("", 4);
                IContainer container = this.findOrCreateContainer((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), style, pluginVariables, (IPath)outputPath, false);
                if (container == null) break block15;
                ImportManager importManager = new ImportManager(packageName);
                importManager.addMasterImport(packageName, className);
                this.setImportManager(importManager);
                CodeFormatter codeFormatter = this.getGenModel().isCodeFormatting() ? this.getGenModel().createCodeFormatter() : null;
                String emitterResult = jetEmitter.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), new Object[]{this});
                progressMonitor.worked(1);
                boolean changed = true;
                IFile targetFile = container.getFile((IPath)new Path(String.valueOf(className) + ".java"));
                progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{targetFile.getFullPath()}));
                JMerger jMerger = new JMerger();
                jMerger.setControlModel(this.getGenModel().getJControlModel());
                jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(emitterResult));
                String newContents = null;
                if (targetFile.exists()) {
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile.getFullPath()}));
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
                    String oldContents = jMerger.getTargetCompilationUnitContents();
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile.getFullPath()}));
                    jMerger.merge();
                    progressMonitor.worked(1);
                    newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                    boolean bl = changed = !oldContents.equals(newContents);
                    if (changed && targetFile.isReadOnly() && targetFile.getWorkspace().validateEdit(new IFile[]{targetFile}, (Object)new SubProgressMonitor(progressMonitor, 1)).isOK()) {
                        jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(targetFile.getContents(true)));
                        jMerger.remerge();
                        newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                    }
                } else {
                    changed = true;
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile.getFullPath()}));
                    jMerger.merge();
                    progressMonitor.worked(1);
                    newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                }
                if (!changed) break block15;
                String encoding = null;
                try {
                    encoding = targetFile.getCharset();
                }
                catch (CoreException coreException) {}
                byte[] bytes = encoding == null ? newContents.getBytes() : newContents.getBytes(encoding);
                ByteArrayInputStream contents = new ByteArrayInputStream(bytes);
                String redirection = this.getGenModel().getRedirection();
                boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                if (redirect) {
                    String baseName = MessageFormat.format(redirection, String.valueOf(className) + ".java");
                    targetFile = container.getFile((IPath)new Path(baseName));
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile.getFullPath()}));
                }
                if (targetFile.isReadOnly()) {
                    if (this.getGenModel().isForceOverwrite()) {
                        ResourceAttributes resourceAttributes = targetFile.getResourceAttributes();
                        if (resourceAttributes != null) {
                            resourceAttributes.setReadOnly(false);
                            targetFile.setResourceAttributes(resourceAttributes);
                        }
                    } else {
                        targetFile = container.getFile((IPath)new Path("." + className + ".java.new"));
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile.getFullPath()}));
                    }
                }
                if (targetFile.exists()) {
                    targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
            }
            catch (JETException exception) {
                CodeGenEcorePlugin.INSTANCE.log((Object)exception);
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
        this.setImportManager(null);
        progressMonitor.done();
    }

    protected ImportManager getImportManager() {
        return ((GenBaseImpl)((Object)this.getGenModel())).getImportManager();
    }

    protected void setImportManager(ImportManager importManager) {
        GenModelImpl genModel = (GenModelImpl)this.getGenModel();
        if (genModel != null) {
            genModel.setImportManager(importManager);
            if (ecoreGenPackage != null && ((GenPackageImpl)ecoreGenPackage).getImportManager() != importManager) {
                ((GenPackageImpl)ecoreGenPackage).setImportManager(this.getImportManager());
            }
            if (xmlTypeGenPackage != null && ((GenPackageImpl)xmlTypeGenPackage).getImportManager() != importManager) {
                ((GenPackageImpl)xmlTypeGenPackage).setImportManager(this.getImportManager());
            }
            if (xmlNamespaceGenPackage != null && ((GenPackageImpl)xmlNamespaceGenPackage).getImportManager() != importManager) {
                ((GenPackageImpl)xmlNamespaceGenPackage).setImportManager(this.getImportManager());
            }
        }
    }

    protected IContainer findOrCreateContainer(IProgressMonitor progressMonitor, int style, List pluginVariables, IPath outputPath, boolean forceStyle) {
        IProject container = null;
        try {
            progressMonitor.beginTask("", outputPath.segmentCount() + 1);
            progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_OpeningFolder_message", new Object[]{outputPath}));
            if (outputPath.isAbsolute()) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(outputPath.segment(0));
                if (forceStyle || !project.exists()) {
                    IPath projectLocation = null;
                    UniqueEList referencedProjects = new UniqueEList();
                    if (project.exists()) {
                        referencedProjects.addAll(Arrays.asList(project.getDescription().getReferencedProjects()));
                        projectLocation = project.getDescription().getLocation();
                    } else {
                        URI genModelURI = this.getGenModel().eResource().getURI();
                        if (genModelURI.toString().startsWith("platform:/resource/")) {
                            IProject genModelProject = workspace.getRoot().getProject(genModelURI.segments()[1]);
                            projectLocation = genModelProject.getDescription().getLocation();
                        }
                    }
                    IProject modelProject = workspace.getRoot().getProject(this.getGenModel().getModelProjectDirectory());
                    Path javaSource = new Path(this.getGenModel().getModelDirectory());
                    if ((style & Generator.EMF_TESTS_PROJECT_STYLE) != 0) {
                        IProject testsProject = workspace.getRoot().getProject(this.getGenModel().getTestsProjectDirectory());
                        if (!this.getGenModel().sameModelTestsProject()) {
                            javaSource = new Path(this.getGenModel().getTestsDirectory());
                            if (testsProject.exists()) {
                                projectLocation = testsProject.getDescription().getLocation();
                            }
                            referencedProjects.add(modelProject);
                            referencedProjects.addAll(Arrays.asList(modelProject.getDescription().getReferencedProjects()));
                        }
                    } else if ((style & Generator.EMF_MODEL_PROJECT_STYLE) == 0 && this.getGenModel().hasEditSupport()) {
                        IProject editProject = workspace.getRoot().getProject(this.getGenModel().getEditProjectDirectory());
                        if (!this.getGenModel().sameModelEditProject()) {
                            javaSource = new Path(this.getGenModel().getEditDirectory());
                            if (editProject.exists()) {
                                projectLocation = editProject.getDescription().getLocation();
                            }
                            referencedProjects.add(modelProject);
                        }
                        Iterator i = this.getGenModel().getUsedGenPackages().iterator();
                        while (i.hasNext()) {
                            IProject otherEditProject;
                            GenModel otherGenModel = ((GenPackage)i.next()).getGenModel();
                            if (!otherGenModel.hasEditSupport() || !(otherEditProject = workspace.getRoot().getProject(otherGenModel.getEditProjectDirectory())).exists()) continue;
                            referencedProjects.add(otherEditProject);
                            Iterator<IProject> j = Arrays.asList(otherEditProject.getDescription().getReferencedProjects()).iterator();
                            while (j.hasNext()) {
                                j.next();
                            }
                            referencedProjects.addAll(Arrays.asList(otherEditProject.getDescription().getReferencedProjects()));
                        }
                        if ((style & Generator.EMF_EDIT_PROJECT_STYLE) == 0 && this.getGenModel().hasEditorSupport()) {
                            javaSource = new Path(this.getGenModel().getEditorDirectory());
                            if (!this.getGenModel().sameEditEditorProject()) {
                                referencedProjects.add(editProject);
                                referencedProjects.addAll(Arrays.asList(editProject.getDescription().getReferencedProjects()));
                            }
                        }
                    }
                    Iterator i = referencedProjects.iterator();
                    while (i.hasNext()) {
                        IProject referencedProject = (IProject)i.next();
                        IJavaProject referencedJavaProject = JavaCore.create((IProject)referencedProject);
                        if (referencedJavaProject.exists()) continue;
                        i.remove();
                    }
                    if (projectLocation != null) {
                        projectLocation = projectLocation.removeLastSegments(1).append(javaSource.segment(0));
                    }
                    if (this.getGenModel().hasXMLDependency()) {
                        style |= Generator.EMF_XML_PROJECT_STYLE;
                    }
                    if ((style & Generator.EMF_MODEL_PROJECT_STYLE) == 0 || this.getGenModel().hasPluginSupport()) {
                        style |= Generator.EMF_PLUGIN_PROJECT_STYLE;
                    }
                    Generator.createEMFProject((IPath)javaSource, projectLocation, (List)referencedProjects, progressMonitor, style, pluginVariables);
                } else if (!project.isOpen()) {
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                container = project;
                int i = 1;
                int length = outputPath.segmentCount();
                while (i < length) {
                    IFolder folder = container.getFolder((IPath)new Path(outputPath.segment(i)));
                    if (!folder.exists()) {
                        folder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    container = folder;
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            CodeGenEcorePlugin.INSTANCE.log(exception);
        }
        progressMonitor.done();
        return container;
    }

    protected String formatCode(String contents, CodeFormatter codeFormatter) {
        if (this.getGenModel().isCodeFormatting()) {
            if (codeFormatter == null) {
                codeFormatter = this.getGenModel().createCodeFormatter();
            }
            Document doc = new Document(contents);
            TextEdit edit = codeFormatter.format(8, doc.get(), 0, doc.get().length(), 0, null);
            try {
                edit.apply((IDocument)doc);
                contents = doc.get();
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
        }
        return contents;
    }

    public String format(String name, char separator, String prefix, boolean includePrefix) {
        List parsedName = new ArrayList();
        if (prefix != null && name.startsWith(prefix)) {
            name = name.substring(prefix.length());
            if (includePrefix) {
                parsedName = this.parseName(prefix, '_');
            }
        }
        if (name.length() != 0) {
            parsedName.addAll(this.parseName(name, '_'));
        }
        StringBuffer result = new StringBuffer();
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(nameComponent);
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append(separator);
        }
        return result.length() == 0 && prefix != null ? prefix : result.toString();
    }

    protected List parseName(String sourceName, char sourceSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer currentWord = new StringBuffer();
        int length = sourceName.length();
        boolean lastIsLower = false;
        int index = 0;
        while (index < length) {
            char curChar = sourceName.charAt(index);
            if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == sourceSeparator) {
                if (lastIsLower || curChar == sourceSeparator) {
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                }
                lastIsLower = false;
            } else {
                int currentWordLength;
                if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                    char lastChar = currentWord.charAt(--currentWordLength);
                    currentWord.setLength(currentWordLength);
                    result.add(currentWord.toString());
                    currentWord = new StringBuffer();
                    currentWord.append(lastChar);
                }
                lastIsLower = true;
            }
            if (curChar != sourceSeparator) {
                currentWord.append(curChar);
            }
            ++index;
        }
        result.add(currentWord.toString());
        return result;
    }

    protected List getAllGenPackages() {
        ArrayList result = new ArrayList();
        result.addAll(this.getGenModel().getGenPackages());
        result.addAll(this.getGenModel().getUsedGenPackages());
        result.addAll(this.getGenModel().getStaticGenPackages());
        return result;
    }

    protected GenPackage findGenPackageHelper(GenPackage genPackage, EPackage ePackage) {
        if (ePackage.getNsURI() == null ? genPackage.getEcorePackage().getNsURI() == null : ePackage.getNsURI().equals(genPackage.getEcorePackage().getNsURI())) {
            return genPackage;
        }
        Iterator nestedGenPackages = genPackage.getNestedGenPackages().iterator();
        while (nestedGenPackages.hasNext()) {
            GenPackage nestedGenPackage = (GenPackage)nestedGenPackages.next();
            GenPackage nestedResult = this.findGenPackageHelper(nestedGenPackage, ePackage);
            if (nestedResult == null) continue;
            return nestedResult;
        }
        return null;
    }

    public GenPackage findGenPackage(EPackage ePackage) {
        if (ePackage == EcorePackage.eINSTANCE) {
            if (ecoreGenPackage == null) {
                GenModel ecoreGenModel = this.getGenModel().createGenModel();
                ecoreGenModel.initialize(Collections.singleton(EcorePackage.eINSTANCE));
                ecoreGenPackage = (GenPackage)ecoreGenModel.getGenPackages().get(0);
                ecoreGenPackage.setPrefix("Ecore");
                ecoreGenPackage.setBasePackage("org.eclipse.emf");
                ((GenPackageImpl)ecoreGenPackage).setImportManager(this.getImportManager());
            }
            return ecoreGenPackage;
        }
        if (ePackage == XMLTypePackage.eINSTANCE) {
            if (xmlTypeGenPackage == null) {
                GenModel xmlTypeGenModel = this.getGenModel().createGenModel();
                xmlTypeGenModel.initialize(Collections.singleton(XMLTypePackage.eINSTANCE));
                xmlTypeGenPackage = (GenPackage)xmlTypeGenModel.getGenPackages().get(0);
                xmlTypeGenPackage.setPrefix("XMLType");
                xmlTypeGenPackage.setBasePackage("org.eclipse.emf.ecore.xml");
                ((GenPackageImpl)xmlTypeGenPackage).setImportManager(this.getImportManager());
            }
            return xmlTypeGenPackage;
        }
        if (ePackage == XMLNamespacePackage.eINSTANCE) {
            if (xmlNamespaceGenPackage == null) {
                GenModel xmlNamespaceGenModel = this.getGenModel().createGenModel();
                xmlNamespaceGenModel.initialize(Collections.singleton(XMLNamespacePackage.eINSTANCE));
                xmlNamespaceGenPackage = (GenPackage)xmlNamespaceGenModel.getGenPackages().get(0);
                xmlNamespaceGenPackage.setPrefix("XMLNamespace");
                xmlNamespaceGenPackage.setBasePackage("org.eclipse.emf.ecore.xml");
                ((GenPackageImpl)xmlNamespaceGenPackage).setImportManager(this.getImportManager());
            }
            return xmlNamespaceGenPackage;
        }
        Iterator pIter = this.getAllGenPackages().iterator();
        while (pIter.hasNext()) {
            GenPackage genPackage = (GenPackage)pIter.next();
            GenPackage resultGenPackage = this.findGenPackageHelper(genPackage, ePackage);
            if (resultGenPackage == null) continue;
            return resultGenPackage;
        }
        return null;
    }

    protected GenClass findGenClass(EClass eClass) {
        GenPackage genPackage = this.findGenPackage(eClass.getEPackage());
        if (genPackage != null) {
            Iterator iter = genPackage.getGenClasses().iterator();
            while (iter.hasNext()) {
                GenClass genClass = (GenClass)iter.next();
                if (!eClass.getName().equals(genClass.getEcoreClass().getName())) continue;
                return genClass;
            }
        }
        return null;
    }

    protected GenEnum findGenEnum(EEnum eEnum) {
        GenPackage genPackage = this.findGenPackage(eEnum.getEPackage());
        if (genPackage != null) {
            Iterator iter = genPackage.getGenEnums().iterator();
            while (iter.hasNext()) {
                GenEnum genEnum = (GenEnum)iter.next();
                if (!eEnum.getName().equals(genEnum.getEcoreEnum().getName())) continue;
                return genEnum;
            }
        }
        return null;
    }

    protected GenDataType findGenDataType(EDataType eDataType) {
        GenPackage genPackage = this.findGenPackage(eDataType.getEPackage());
        if (genPackage != null) {
            Iterator iter = genPackage.getGenDataTypes().iterator();
            while (iter.hasNext()) {
                GenDataType genDataType = (GenDataType)iter.next();
                if (!eDataType.getName().equals(genDataType.getEcoreDataType().getName())) continue;
                return genDataType;
            }
        }
        return null;
    }

    protected GenClassifier findGenClassifier(EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            return this.findGenClass((EClass)eClassifier);
        }
        if (eClassifier instanceof EEnum) {
            return this.findGenEnum((EEnum)eClassifier);
        }
        if (eClassifier instanceof EDataType) {
            return this.findGenDataType((EDataType)eClassifier);
        }
        return null;
    }

    protected GenFeature findGenFeature(EStructuralFeature eStructuralFeature) {
        GenClass genClass = this.findGenClass(eStructuralFeature.getEContainingClass());
        Iterator i = genClass.getGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (!eStructuralFeature.getName().equals(genFeature.getEcoreFeature().getName())) continue;
            return genFeature;
        }
        return null;
    }

    protected Class getInstanceClass(EClassifier eType) {
        try {
            Class instanceClass = eType.getInstanceClass();
            return instanceClass;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected boolean isPrimitiveType(EClassifier eType) {
        try {
            Class result = eType.getInstanceClass();
            if (result == null) {
                return false;
            }
            Class instanceClass = result;
            return instanceClass.isPrimitive();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getPrimitiveObjectType(EClassifier eType) {
        Class instanceClass = this.getInstanceClass(eType);
        if (instanceClass == Boolean.TYPE) {
            return "java.lang.Boolean";
        }
        if (instanceClass == Byte.TYPE) {
            return "java.lang.Byte";
        }
        if (instanceClass == Character.TYPE) {
            return "java.lang.Character";
        }
        if (instanceClass == Double.TYPE) {
            return "java.lang.Double";
        }
        if (instanceClass == Float.TYPE) {
            return "java.lang.Float";
        }
        if (instanceClass == Integer.TYPE) {
            return "java.lang.Integer";
        }
        if (instanceClass == Long.TYPE) {
            return "java.lang.Long";
        }
        if (instanceClass == Short.TYPE) {
            return "java.lang.Short";
        }
        return null;
    }

    protected String getPrimitiveDefault(EClassifier eType) {
        if (this.isPrimitiveType(eType)) {
            Class instanceClass = eType.getInstanceClass();
            if (instanceClass == Boolean.TYPE) {
                return "false";
            }
            if (instanceClass == Byte.TYPE || instanceClass == Integer.TYPE || instanceClass == Long.TYPE || instanceClass == Short.TYPE) {
                return "0";
            }
            if (instanceClass == Character.TYPE) {
                return "'\\u0000'";
            }
            if (instanceClass == Double.TYPE) {
                return "0.0";
            }
            if (instanceClass == Float.TYPE) {
                return "0.0F";
            }
        }
        return null;
    }

    protected String getType(EClassifier eType, boolean primitiveAsObject) {
        GenEnum genEnum;
        EDataType baseType;
        if (eType instanceof EClass) {
            return this.findGenClass((EClass)eType).getQualifiedInterfaceName();
        }
        if (eType instanceof EEnum) {
            return this.findGenEnum((EEnum)eType).getQualifiedName();
        }
        if (primitiveAsObject && this.isPrimitiveType(eType)) {
            return this.getPrimitiveObjectType(eType);
        }
        if ("org.eclipse.emf.common.util.AbstractEnumerator".equals(eType.getInstanceClassName()) && (baseType = this.getExtendedMetaData().getBaseType((EDataType)eType)) instanceof EEnum && (genEnum = this.findGenEnum((EEnum)baseType)) != null) {
            return genEnum.getQualifiedName();
        }
        return eType.getInstanceClassName();
    }

    protected String getImportedType(EClassifier eType, boolean primitiveAsObject) {
        String t = this.getType(eType, primitiveAsObject);
        return !primitiveAsObject && this.isPrimitiveType(eType) ? t : this.getGenModel().getImportedName(t);
    }

    protected List getTypeGenClasses(EClassifier eType, GenPackage firstGenPackage, List genPackages, int max) {
        if (max == 0 || !(eType instanceof EClass)) {
            return Collections.EMPTY_LIST;
        }
        boolean hasMax = max > -1;
        ArrayList<GenClass> result = new ArrayList<GenClass>();
        EClass baseClass = (EClass)eType;
        ExtendedMetaData extendedMetaData = this.getExtendedMetaData();
        if (extendedMetaData.isAnonymous((EClassifier)baseClass)) {
            result.add(this.findGenClass(baseClass));
            return result;
        }
        ArrayList<GenPackage> orderedGenPackages = genPackages;
        if (firstGenPackage != null) {
            orderedGenPackages = new ArrayList<GenPackage>(genPackages.size() + 1);
            orderedGenPackages.add(firstGenPackage);
            Iterator iter = genPackages.iterator();
            while (iter.hasNext()) {
                GenPackage genPackage = (GenPackage)iter.next();
                if (genPackage == firstGenPackage) continue;
                orderedGenPackages.add(genPackage);
            }
        }
        Iterator pIter = orderedGenPackages.iterator();
        while (pIter.hasNext()) {
            GenClass genClass;
            Iterator cIter;
            if (baseClass == EcorePackage.eINSTANCE.getEObject()) {
                cIter = ((GenPackage)pIter.next()).getOrderedGenClasses().iterator();
                while (cIter.hasNext()) {
                    genClass = (GenClass)cIter.next();
                    if (genClass.isAbstract() || extendedMetaData.isAnonymous((EClassifier)genClass.getEcoreClass())) continue;
                    result.add(genClass);
                    if (!hasMax || result.size() < max) continue;
                    return result;
                }
                continue;
            }
            cIter = ((GenPackage)pIter.next()).getOrderedGenClasses().iterator();
            while (cIter.hasNext()) {
                genClass = (GenClass)cIter.next();
                if (genClass.isAbstract() || !baseClass.isSuperTypeOf(genClass.getEcoreClass()) || extendedMetaData.isAnonymous((EClassifier)genClass.getEcoreClass())) continue;
                result.add(genClass);
                if (!hasMax || result.size() < max) continue;
                return result;
            }
        }
        return result;
    }

    protected static Set getJavaReservedWords() {
        return GenModelUtil.getJavaReservedWords();
    }

    protected static Set getJavaLangTypes() {
        return GenModelUtil.getJavaDefaultTypes();
    }

    protected List filterGenClasses(List genClasses, GenClassFilter filter) {
        ArrayList<GenClass> result = new ArrayList<GenClass>();
        Iterator iter = genClasses.iterator();
        while (iter.hasNext()) {
            GenClass genClass = (GenClass)iter.next();
            if (filter != null && !filter.accept(genClass)) continue;
            result.add(genClass);
        }
        return result;
    }

    protected List collectGenClasses(List eClasses, GenClassFilter filter) {
        ArrayList<GenClass> result = new ArrayList<GenClass>();
        Iterator iter = eClasses.iterator();
        while (iter.hasNext()) {
            GenClass genClass = this.findGenClass((EClass)iter.next());
            if (filter != null && !filter.accept(genClass)) continue;
            result.add(genClass);
        }
        return result;
    }

    protected List collectGenFeatures(List genClasses, List genFeatures, GenFeatureFilter filter) {
        Iterator iter;
        ArrayList<GenFeature> result = new ArrayList<GenFeature>();
        if (genClasses != null) {
            iter = genClasses.iterator();
            while (iter.hasNext()) {
                GenClass genClass = (GenClass)iter.next();
                Iterator sIter = genClass.getGenFeatures().iterator();
                while (sIter.hasNext()) {
                    GenFeature genFeature = (GenFeature)sIter.next();
                    if (filter != null && !filter.accept(genFeature)) continue;
                    result.add(genFeature);
                }
            }
        }
        if (genFeatures != null) {
            iter = genFeatures.iterator();
            while (iter.hasNext()) {
                GenFeature genFeature = (GenFeature)iter.next();
                if (filter != null && !filter.accept(genFeature)) continue;
                result.add(genFeature);
            }
        }
        return result;
    }

    protected List collectGenOperations(List genClasses, List genOperations, GenOperationFilter filter) {
        Iterator iter;
        ArrayList<GenOperation> result = new ArrayList<GenOperation>();
        if (genClasses != null) {
            iter = genClasses.iterator();
            while (iter.hasNext()) {
                GenClass genClass = (GenClass)iter.next();
                Iterator sIter = genClass.getGenOperations().iterator();
                while (sIter.hasNext()) {
                    GenOperation genOperation = (GenOperation)sIter.next();
                    if (filter != null && !filter.accept(genOperation)) continue;
                    result.add(genOperation);
                }
            }
        }
        if (genOperations != null) {
            iter = genOperations.iterator();
            while (iter.hasNext()) {
                GenOperation genOperation = (GenOperation)iter.next();
                if (filter != null && !filter.accept(genOperation)) continue;
                result.add(genOperation);
            }
        }
        return result;
    }

    protected List collectGenConstraints(List genClassifiers, List genConstraints, GenConstraintFilter filter) {
        Iterator iter;
        UniqueEList result = new UniqueEList();
        if (genClassifiers != null) {
            iter = genClassifiers.iterator();
            while (iter.hasNext()) {
                GenClassifier genClassifier = (GenClassifier)iter.next();
                Iterator sIter = genClassifier.getGenConstraints().iterator();
                while (sIter.hasNext()) {
                    String genConstraint = (String)sIter.next();
                    if (filter != null && !filter.accept(genConstraint)) continue;
                    result.add(genConstraint);
                }
            }
        }
        if (genConstraints != null) {
            iter = genConstraints.iterator();
            while (iter.hasNext()) {
                String genConstraint = (String)iter.next();
                if (filter != null && !filter.accept(genConstraint)) continue;
                result.add(genConstraint);
            }
        }
        return result;
    }

    public String getModelInfo() {
        return "";
    }

    protected List getAnnotationInfo(EModelElement eModelElement) {
        return this.getAnnotationInfo(eModelElement, DEFAULT_ANNOTATION_FILTER);
    }

    protected List getAnnotationInfo(EModelElement eModelElement, AnnotationFilter annotationFilter) {
        ArrayList<String> result = Collections.EMPTY_LIST;
        Iterator i = eModelElement.getEAnnotations().iterator();
        while (i.hasNext()) {
            EAnnotation eAnnotation = (EAnnotation)i.next();
            String source = eAnnotation.getSource();
            if (source == null) continue;
            StringBuffer stringBuffer = null;
            Iterator j = eAnnotation.getDetails().iterator();
            while (j.hasNext()) {
                String value;
                Map.Entry mapEntry = (Map.Entry)j.next();
                String key = (String)mapEntry.getKey();
                if (!annotationFilter.accept(eModelElement, source, key, value = (String)mapEntry.getValue())) continue;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(GenBaseImpl.escapeString(source, " ="));
                }
                stringBuffer.append(' ');
                stringBuffer.append(GenBaseImpl.escapeString(key, " ="));
                stringBuffer.append("='");
                stringBuffer.append(GenBaseImpl.escapeString(value, ""));
                stringBuffer.append('\'');
            }
            if (stringBuffer == null) continue;
            if (result.size() == 0) {
                result = new ArrayList<String>();
            }
            result.add(stringBuffer.toString());
        }
        return result;
    }

    protected void appendAnnotationInfo(StringBuffer result, EModelElement eModelElement) {
        this.appendAnnotationInfo(result, eModelElement, DEFAULT_ANNOTATION_FILTER);
    }

    protected void appendAnnotationInfo(StringBuffer result, EModelElement eModelElement, AnnotationFilter annotationFilter) {
        Iterator i = this.getAnnotationInfo(eModelElement, annotationFilter).iterator();
        while (i.hasNext()) {
            String annotationInfo = (String)i.next();
            this.appendLineBreak(result);
            if (annotationInfo.startsWith("http:///org/eclipse/emf/ecore/util/ExtendedMetaData")) {
                this.appendModelSetting(result, "extendedMetaData", annotationInfo.substring("http:///org/eclipse/emf/ecore/util/ExtendedMetaData".length() + 1));
                continue;
            }
            this.appendModelSetting(result, "annotation", annotationInfo);
        }
    }

    protected static String escapeString(String s, String additionalCharactersToEscape) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer result = new StringBuffer(len + 16);
        int i = 0;
        while (i < len) {
            String num;
            char c = s.charAt(i);
            if (c == '\b') {
                result.append("\\b");
            } else if (c == '\t') {
                result.append("\\t");
            } else if (c == '\n') {
                result.append("\\n");
            } else if (c == '\f') {
                result.append("\\f");
            } else if (c == '\r') {
                result.append("\\r");
            } else if (c == '\"') {
                result.append("\\\"");
            } else if (c == '\'') {
                result.append("\\'");
            } else if (c == '\\') {
                result.append("\\\\");
            } else if (additionalCharactersToEscape.indexOf(c) == -1 && c >= ' ' && c < '\u007f') {
                result.append(c);
            } else if (c < '\u0100') {
                num = Integer.toOctalString(c);
                switch (num.length()) {
                    case 1: {
                        result.append("\\00");
                        break;
                    }
                    case 2: {
                        result.append("\\0");
                        break;
                    }
                    default: {
                        result.append("\\");
                    }
                }
                result.append(num);
            } else {
                num = Integer.toHexString(c);
                switch (num.length()) {
                    case 1: {
                        result.append("\\u000");
                        break;
                    }
                    case 2: {
                        result.append("\\u00");
                        break;
                    }
                    case 3: {
                        result.append("\\u0");
                        break;
                    }
                    default: {
                        result.append("\\u");
                    }
                }
                result.append(num);
            }
            ++i;
        }
        return result.toString();
    }

    protected void appendLineBreak(StringBuffer result) {
        int i = result.length();
        while (--i >= 0) {
            if (!Character.isWhitespace(result.charAt(i))) break;
            result.deleteCharAt(i);
        }
        result.append(System.getProperty("line.separator"));
    }

    protected void appendModelSetting(StringBuffer result, String qualifier, String name, String value) {
        if (qualifier != null) {
            result.append(qualifier);
            result.append(this.capName(name));
        } else {
            result.append(name);
        }
        result.append("=\"");
        result.append(value);
        result.append("\" ");
    }

    protected void appendModelSetting(StringBuffer result, String name, String value) {
        result.append(name);
        result.append("=\"");
        result.append(value);
        result.append("\" ");
    }

    protected static boolean isJavaUtilMapEntry(String name) {
        return "java.util.Map.Entry".equals(name) || "java.util.Map$Entry".equals(name);
    }

    protected static boolean isBlank(String string) {
        return string == null || string.length() == 0;
    }

    public boolean canGenerateEdit() {
        return this.getGenModel().canGenerateEdit() && this.hasModelContribution();
    }

    public void generateEdit(IProgressMonitor progressMonitor) {
    }

    public boolean canGenerateEditor() {
        return this.getGenModel().canGenerateEditor() && this.hasModelContribution();
    }

    public void generateEditor(IProgressMonitor progressMonitor) {
    }

    public boolean canGenerateSchema() {
        return false;
    }

    public void generateSchema(IProgressMonitor progressMonitor) {
    }

    public boolean canGenerateTests() {
        return false;
    }

    public void generateTests(IProgressMonitor progressMonitor) {
    }

    public String eURIFragmentSegment(EStructuralFeature eStructuralFeature, EObject eObject) {
        GenBaseImpl genBaseImpl;
        String name;
        if (eObject instanceof GenBaseImpl && (name = (genBaseImpl = (GenBaseImpl)eObject).getName()) != null) {
            int count = 0;
            Iterator i = this.eContents().iterator();
            while (i.hasNext()) {
                GenBaseImpl otherGenBaseImpl;
                Object otherEObject = i.next();
                if (otherEObject == eObject) break;
                if (!(otherEObject instanceof GenBaseImpl) || !name.equals((otherGenBaseImpl = (GenBaseImpl)otherEObject).getName())) continue;
                ++count;
            }
            return count > 0 ? String.valueOf(name) + "." + count : name;
        }
        return super.eURIFragmentSegment(eStructuralFeature, eObject);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        if (!uriFragmentSegment.startsWith("@")) {
            int index = uriFragmentSegment.indexOf(".");
            String name = index == -1 ? uriFragmentSegment : uriFragmentSegment.substring(0, index);
            int count = 0;
            if (index != -1) {
                try {
                    count = Integer.parseInt(uriFragmentSegment.substring(index + 1));
                }
                catch (NumberFormatException exception) {
                    throw new WrappedException((Exception)exception);
                }
            }
            Iterator i = this.eContents().iterator();
            while (i.hasNext()) {
                GenBaseImpl genBaseImpl;
                Object object = i.next();
                if (!(object instanceof GenBaseImpl) || !name.equals((genBaseImpl = (GenBaseImpl)object).getName()) || count-- != 0) continue;
                return genBaseImpl;
            }
            return null;
        }
        return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    protected static String unicodeEscapeEncode(String unicode) {
        StringBuffer result = new StringBuffer(unicode.length());
        int i = 0;
        int size = unicode.length();
        while (i < size) {
            char character = unicode.charAt(i);
            if (character > '\u00ff') {
                result.append("\\u");
                String hex = Integer.toString(character, 16);
                int j = hex.length();
                while (j < 4) {
                    result.append("0");
                    ++j;
                }
                result.append(hex);
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }

    public abstract EModelElement getEcoreModelElement();

    protected String getDocumentation() {
        return EcoreUtil.getDocumentation((EModelElement)this.getEcoreModelElement());
    }

    public boolean hasDocumentation() {
        return this.getDocumentation() != null;
    }

    public String getDocumentation(String indentation) {
        return this.indent(this.getDocumentation(), indentation);
    }

    protected String indent(String text, String indentation) {
        if (text == null) {
            return null;
        }
        String separator = String.valueOf(System.getProperty("line.separator")) + indentation;
        int increment = separator.length() - 1;
        StringBuffer stringBuffer = new StringBuffer(text);
        int i = 0;
        while (i < stringBuffer.length()) {
            switch (stringBuffer.charAt(i)) {
                case '\n': {
                    stringBuffer.replace(i, i + (i + 1 < stringBuffer.length() && stringBuffer.charAt(i + 1) == '\r' ? 2 : 1), separator);
                    i += increment;
                    break;
                }
                case '\r': {
                    stringBuffer.replace(i, i + (i + 1 < stringBuffer.length() && stringBuffer.charAt(i + 1) == '\n' ? 2 : 1), separator);
                    i += increment;
                }
            }
            ++i;
        }
        return stringBuffer.toString();
    }

    protected ExtendedMetaData getExtendedMetaData() {
        return this.eContainer() == null ? ExtendedMetaData.INSTANCE : ((GenBaseImpl)this.eContainer()).getExtendedMetaData();
    }

    protected void addNonDuplicates(Collection target, Collection source, Set noDupSet) {
        if (noDupSet == null) {
            noDupSet = new HashSet(target);
        }
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!noDupSet.add(o)) continue;
            target.add(o);
        }
    }

    protected static class ImportManager {
        protected SortedSet imports = new TreeSet();
        protected HashMap shortNameToImportMap = new HashMap();
        protected HashSet javaLangImports = null;
        protected HashSet importedPackages = new HashSet();

        public ImportManager(String compilationUnitPackage) {
            this.importedPackages.add(compilationUnitPackage);
        }

        public Collection getImports() {
            return this.imports;
        }

        public String getImportedName(String qualifiedName) {
            String registeredName;
            String baseName;
            String shortName;
            int firstDollar;
            String indices = "";
            int firstBracket = qualifiedName.indexOf("[");
            if (firstBracket != -1) {
                indices = qualifiedName.substring(firstBracket);
                qualifiedName = qualifiedName.substring(0, firstBracket);
            }
            if ((firstDollar = (shortName = (baseName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1))).indexOf("$")) != -1) {
                shortName = shortName.substring(0, firstDollar);
            }
            if ((registeredName = (String)this.shortNameToImportMap.get(shortName)) == null) {
                registeredName = "java.lang." + shortName;
                if (qualifiedName.equals(registeredName)) {
                    if (this.javaLangImports != null && this.javaLangImports.contains(shortName)) {
                        this.imports.add(qualifiedName);
                    }
                    return String.valueOf(shortName) + indices;
                }
                return String.valueOf(qualifiedName) + indices;
            }
            if (qualifiedName.startsWith(registeredName)) {
                if (qualifiedName.length() == registeredName.length()) {
                    return String.valueOf(baseName.replace('$', '.')) + indices;
                }
                char character = qualifiedName.charAt(registeredName.length());
                if (character == '.' || character == '$') {
                    return String.valueOf(baseName.replace('$', '.')) + indices;
                }
            }
            return String.valueOf(qualifiedName.replace('$', '.')) + indices;
        }

        public void addImport(String packageName, String shortName) {
            int firstBracket = shortName.indexOf("[");
            if (firstBracket != -1) {
                shortName = shortName.substring(0, firstBracket);
            }
            this.basicAdd(packageName, shortName, String.valueOf(packageName) + "." + shortName);
        }

        public void addImport(String qualifiedName) {
            int lastDot;
            String shortName;
            int firstDollar;
            int firstBracket = qualifiedName.indexOf("[");
            if (firstBracket != -1) {
                qualifiedName = qualifiedName.substring(0, firstBracket);
            }
            if ((firstDollar = (shortName = qualifiedName.substring((lastDot = qualifiedName.lastIndexOf(".")) + 1)).indexOf("$")) != -1) {
                shortName = shortName.substring(0, firstDollar);
            }
            String packageName = lastDot == -1 ? null : qualifiedName.substring(0, lastDot);
            this.basicAdd(packageName, shortName, qualifiedName);
        }

        public void addMasterImport(String packageName, String shortName) {
            this.shortNameToImportMap.put(shortName, String.valueOf(packageName) + "." + shortName);
        }

        public void addJavaLangImports(List javaLangClassNames) {
            if (!javaLangClassNames.isEmpty()) {
                this.javaLangImports = new HashSet();
                this.javaLangImports.addAll(javaLangClassNames);
            }
        }

        public boolean hasImport(String shortName) {
            return this.shortNameToImportMap.containsKey(shortName);
        }

        public void addCompilationUnitImports(String compilationUnitContents) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setSource(compilationUnitContents.toCharArray());
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            Iterator i = compilationUnit.imports().iterator();
            while (i.hasNext()) {
                int lastDot;
                ImportDeclaration importDeclaration = (ImportDeclaration)i.next();
                String qualifiedName = importDeclaration.getName().getFullyQualifiedName();
                String shortName = qualifiedName.substring((lastDot = qualifiedName.lastIndexOf(".")) + 1);
                if (shortName.equals("*")) {
                    String packageName = qualifiedName.substring(0, lastDot);
                    this.importedPackages.add(packageName);
                    continue;
                }
                this.shortNameToImportMap.put(shortName, qualifiedName);
            }
        }

        public void addPseudoImport(String qualifiedName) {
            int lastDot = qualifiedName.lastIndexOf(".");
            String shortName = qualifiedName.substring(lastDot + 1);
            if (shortName.equals("*")) {
                String packageName = qualifiedName.substring(0, lastDot);
                this.importedPackages.add(packageName);
            } else {
                this.shortNameToImportMap.put(shortName, qualifiedName);
            }
        }

        private void basicAdd(String packageName, String shortName, String qualifiedName) {
            if (shortName.equals("*")) {
                this.importedPackages.add(packageName);
                this.imports.add(qualifiedName);
            } else if (!this.shortNameToImportMap.containsKey(shortName) && !GenModelUtil.isJavaDefaultType(shortName)) {
                this.shortNameToImportMap.put(shortName, qualifiedName);
                if (!this.importedPackages.contains(packageName)) {
                    this.imports.add(qualifiedName);
                }
            }
        }
    }

    protected static interface GenClassFilter {
        public boolean accept(GenClass var1);
    }

    protected static interface GenFeatureFilter {
        public boolean accept(GenFeature var1);
    }

    protected static interface GenOperationFilter {
        public boolean accept(GenOperation var1);
    }

    protected static interface GenConstraintFilter {
        public boolean accept(String var1);
    }

    protected static interface AnnotationFilter {
        public boolean accept(EModelElement var1, String var2, String var3, String var4);
    }

    protected static class AnnotationFilterImpl
    implements AnnotationFilter {
        public boolean accept(EModelElement eModelElement, String source, String key, String value) {
            return !"http://www.eclipse.org/emf/2002/GenModel".equals(source) || !"documentation".equals(key);
        }
    }

    protected abstract class UniqueNameHelper {
        private Map nameToObjectMap;
        private Map objectToNameMap;

        protected UniqueNameHelper() {
            this.nameToObjectMap = new HashMap();
            this.objectToNameMap = new HashMap();
        }

        protected UniqueNameHelper(int initialMapCapacity) {
            this.nameToObjectMap = new HashMap(initialMapCapacity);
            this.objectToNameMap = new HashMap(initialMapCapacity);
        }

        protected abstract String getName(Object var1);

        protected List getAlternateNames(Object o) {
            return Collections.EMPTY_LIST;
        }

        public String getUniqueName(Object o) {
            if (!this.contains(o)) {
                this.add(o);
            }
            return (String)this.objectToNameMap.get(o);
        }

        protected boolean add(Object o) {
            if (this.contains(o)) {
                return false;
            }
            String name = this.getName(o);
            if (this.containsName(name)) {
                List alternates = this.getAlternateNames(o);
                Iterator i = alternates.iterator();
                while (i.hasNext()) {
                    name = (String)i.next();
                    if (!this.containsName(name)) break;
                }
            }
            if (this.containsName(name)) {
                int i = 1;
                while (true) {
                    String newName;
                    if (!this.containsName(newName = String.valueOf(name) + "_" + i)) {
                        name = newName;
                        break;
                    }
                    if (i == Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("too many objects named " + name);
                    }
                    ++i;
                }
            }
            this.nameToObjectMap.put(name, o);
            this.objectToNameMap.put(o, name);
            return true;
        }

        public boolean addAll(Collection c) {
            boolean result = false;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                if (!this.add(i.next())) continue;
                result = true;
            }
            return result;
        }

        public final boolean contains(Object o) {
            return this.objectToNameMap.containsKey(o);
        }

        public final boolean containsName(String name) {
            return this.nameToObjectMap.containsKey(name);
        }
    }

    protected static class GIFEmitter {
        protected String inputFile;
        protected static final int tableOffset1 = 49;
        protected static final int tableOffset2 = 25;

        public GIFEmitter(String inputFile) {
            this.inputFile = inputFile;
        }

        protected int code(String code) {
            int result = 0;
            int i = 0;
            while (i < code.length()) {
                result += code.charAt(i) - 32;
                ++i;
            }
            return result;
        }

        protected byte[] generateGIF(String key1, String key2) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                byte[] content = new byte[5000];
                int result = this.getContents(content, this.inputFile);
                ColorInformation info1 = ColorInformation.getColor(this.code(key1));
                ColorInformation info2 = key2 == null ? null : ColorInformation.getColor(this.code(key2));
                int j = 0;
                while (j < result) {
                    int index;
                    if (j == 49 || j == 52 || j == 55 || j == 58) {
                        index = (j - 49) / 3;
                        if (!info1.rainbow || info1.which == index - 1) {
                            content[j] = info1.scale(info1.red, info1.factor[index]);
                        }
                    } else if (j == 50 || j == 53 || j == 56 || j == 59) {
                        index = (j - 49 - 1) / 3;
                        if (!info1.rainbow || info1.which == index - 1) {
                            content[j] = info1.scale(info1.green, info1.factor[index]);
                        }
                    } else if (j == 51 || j == 54 || j == 57 || j == 60) {
                        index = (j - 49 - 2) / 3;
                        if (!info1.rainbow || info1.which == index - 1) {
                            content[j] = info1.scale(info1.blue, info1.factor[index]);
                        }
                    }
                    if (info2 != null) {
                        if (j == 25 || j == 28 || j == 31 || j == 34) {
                            index = (j - 25) / 3;
                            if (!info2.rainbow || info2.which == index - 1) {
                                content[j] = info2.scale(info2.red, info2.factor[index]);
                            }
                        } else if (j == 26 || j == 29 || j == 32 || j == 35) {
                            index = (j - 25 - 1) / 3;
                            if (!info2.rainbow || info2.which == index - 1) {
                                content[j] = info2.scale(info2.green, info2.factor[index]);
                            }
                        } else if (j == 27 || j == 30 || j == 33 || j == 36) {
                            index = (j - 25 - 2) / 3;
                            if (!info2.rainbow || info2.which == index - 1) {
                                content[j] = info2.scale(info2.blue, info2.factor[index]);
                            }
                        }
                    }
                    ++j;
                }
                DataOutputStream writer = new DataOutputStream(outputStream);
                writer.write(content, 0, result);
                writer.close();
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
            return outputStream.toByteArray();
        }

        protected int getContents(byte[] content, String gifFile) throws JETException, IOException {
            DataInputStream reader = new DataInputStream(JETCompiler.openStream((String)gifFile));
            int result = reader.read(content, 0, content.length);
            reader.close();
            return result;
        }
    }

    public static class ColorInformation {
        protected static ColorInformation instance = new ColorInformation();
        protected static List entries = new ArrayList(1000);
        public int red = 192;
        public int green = 64;
        public int blue = 64;
        public int which = 2;
        public int change = 64;
        public double[] factor = new double[]{0.35, 0.1, -0.1, -0.3};
        public boolean rainbow;

        public static ColorInformation getColor(int index) {
            index = Math.abs(index) % 61;
            while (entries.size() <= index) {
                instance.generateColor();
                ColorInformation entry = new ColorInformation();
                entry.red = ColorInformation.instance.red;
                entry.green = ColorInformation.instance.green;
                entry.blue = ColorInformation.instance.blue;
                entry.which = ColorInformation.instance.which;
                entry.factor = new double[]{ColorInformation.instance.factor[0], ColorInformation.instance.factor[1], ColorInformation.instance.factor[2], ColorInformation.instance.factor[3]};
                entry.rainbow = ColorInformation.instance.rainbow;
                entries.add(entry);
                instance.fixFactor();
            }
            return (ColorInformation)entries.get(index);
        }

        public byte scale(int value, double factor) {
            if (factor > 0.0) {
                return (byte)((double)value + (double)(255 - value) * factor);
            }
            return (byte)((double)value + (double)value * factor);
        }

        protected void generateColor() {
            switch (this.which) {
                case 0: {
                    this.red += this.change;
                    if (this.red <= 64) {
                        this.which = 1;
                        this.change = -this.change;
                        break;
                    }
                    if (this.red < 192) break;
                    this.which = 1;
                    this.change = -this.change;
                    break;
                }
                case 1: {
                    this.green += this.change;
                    if (this.green >= 192) {
                        this.which = 2;
                        this.change = -this.change;
                        break;
                    }
                    if (this.green > 64) break;
                    this.which = 2;
                    this.change = -this.change;
                    break;
                }
                case 2: {
                    this.blue += this.change;
                    if (this.blue >= 192) {
                        this.which = 0;
                        this.change = -this.change;
                        break;
                    }
                    if (this.blue > 64) break;
                    this.which = 0;
                    this.change = -this.change;
                }
            }
        }

        protected void fixFactor() {
            if (this.red == 192 && this.green == 64 && this.blue == 64) {
                int j = 0;
                while (j < this.factor.length) {
                    int n = j++;
                    this.factor[n] = this.factor[n] + 0.3;
                }
                if (this.factor[0] >= 1.0) {
                    this.rainbow = true;
                    j = 0;
                    while (j < this.factor.length) {
                        int n = j++;
                        this.factor[n] = this.factor[n] - 0.8;
                    }
                }
            }
        }
    }
}

