/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertyDescriptor
implements IPropertyDescriptor {
    protected Object object;
    protected IItemPropertyDescriptor itemPropertyDescriptor;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;
    static /* synthetic */ Class class$0;

    public PropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        this.object = object;
        this.itemPropertyDescriptor = itemPropertyDescriptor;
    }

    public String getCategory() {
        return this.itemPropertyDescriptor.getCategory(this.object);
    }

    public String getDescription() {
        return this.itemPropertyDescriptor.getDescription(this.object);
    }

    public String getDisplayName() {
        return this.itemPropertyDescriptor.getDisplayName(this.object);
    }

    public String[] getFilterFlags() {
        return this.itemPropertyDescriptor.getFilterFlags(this.object);
    }

    public Object getHelpContextIds() {
        return this.itemPropertyDescriptor.getHelpContextIds(this.object);
    }

    public Object getId() {
        return this.itemPropertyDescriptor.getId(this.object);
    }

    public ILabelProvider getLabelProvider() {
        final IItemLabelProvider itemLabelProvider = this.itemPropertyDescriptor.getLabelProvider(this.object);
        return new LabelProvider(){

            public String getText(Object object) {
                return itemLabelProvider.getText(object);
            }

            public Image getImage(Object object) {
                return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage(object));
            }
        };
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }

    public CellEditor createPropertyEditor(Composite composite) {
        if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
            return null;
        }
        Object result = null;
        Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
        if (genericFeature instanceof EReference[]) {
            result = new ExtendedComboBoxCellEditor(composite, new ArrayList(this.itemPropertyDescriptor.getChoiceOfValues(this.object)), this.getLabelProvider(), true);
        } else if (genericFeature instanceof EStructuralFeature) {
            EDataType eDataType;
            final EStructuralFeature feature = (EStructuralFeature)genericFeature;
            EClassifier eType = feature.getEType();
            final Collection choiceOfValues = this.itemPropertyDescriptor.getChoiceOfValues(this.object);
            if (choiceOfValues != null) {
                if (this.itemPropertyDescriptor.isMany(this.object)) {
                    boolean valid = true;
                    Iterator i = choiceOfValues.iterator();
                    while (i.hasNext()) {
                        Object choice = i.next();
                        if (eType.isInstance(choice)) continue;
                        valid = false;
                        break;
                    }
                    if (valid) {
                        result = new ExtendedDialogCellEditor(composite, this.getLabelProvider()){

                            protected Object openDialogBox(Control cellEditorWindow) {
                                FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), PropertyDescriptor.this.getLabelProvider(), PropertyDescriptor.this.object, feature.getEType(), (List)((IItemPropertySource)PropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(PropertyDescriptor.this.object)).getEditableValue(PropertyDescriptor.this.object), PropertyDescriptor.this.getDisplayName(), new ArrayList(choiceOfValues));
                                dialog.open();
                                return dialog.getResult();
                            }
                        };
                    }
                }
                if (result == null) {
                    result = new ExtendedComboBoxCellEditor(composite, new ArrayList(choiceOfValues), this.getLabelProvider(), true);
                }
            } else if (eType instanceof EDataType && (eDataType = (EDataType)eType).isSerializable()) {
                if (this.itemPropertyDescriptor.isMany(this.object)) {
                    result = new ExtendedDialogCellEditor(composite, this.getLabelProvider()){

                        protected Object openDialogBox(Control cellEditorWindow) {
                            FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), PropertyDescriptor.this.getLabelProvider(), PropertyDescriptor.this.object, feature.getEType(), (List)((IItemPropertySource)PropertyDescriptor.this.itemPropertyDescriptor.getPropertyValue(PropertyDescriptor.this.object)).getEditableValue(PropertyDescriptor.this.object), PropertyDescriptor.this.getDisplayName(), null);
                            dialog.open();
                            return dialog.getResult();
                        }
                    };
                } else {
                    Class clazz = eDataType.getInstanceClass();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("java.lang.Boolean");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = clazz == clazz2 || eDataType.getInstanceClass() == Boolean.TYPE ? new ExtendedComboBoxCellEditor(composite, Arrays.asList(Boolean.FALSE, Boolean.TRUE), this.getLabelProvider(), true) : new EDataTypeCellEditor(eDataType, composite);
                }
            }
        }
        return result;
    }

    public static class EDataTypeCellEditor
    extends TextCellEditor {
        protected EDataType eDataType;
        static /* synthetic */ Class class$0;

        public EDataTypeCellEditor(EDataType eDataType, Composite composite) {
            super(composite);
            this.eDataType = eDataType;
            this.setValidator(new ICellEditorValidator(this){
                final /* synthetic */ EDataTypeCellEditor this$1;
                {
                    this.this$1 = eDataTypeCellEditor;
                }

                public String isValid(Object object) {
                    if (this.this$1.eDataType.isInstance(object)) {
                        Class clazz = this.this$1.eDataType.getInstanceClass();
                        Class<?> clazz2 = EDataTypeCellEditor.class$0;
                        if (clazz2 == null) {
                            try {
                                clazz2 = EDataTypeCellEditor.class$0 = Class.forName("java.lang.Object");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz != clazz2 || !(object instanceof String)) {
                            return null;
                        }
                    }
                    String string = (String)object;
                    try {
                        this.this$1.eDataType.getEPackage().getEFactoryInstance().createFromString(this.this$1.eDataType, string);
                        return null;
                    }
                    catch (Exception exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return this.eDataType.getEPackage().getEFactoryInstance().createFromString(this.eDataType, (String)super.doGetValue());
        }

        public void doSetValue(Object value) {
            String stringValue = this.eDataType.getEPackage().getEFactoryInstance().convertToString(this.eDataType, value);
            stringValue = stringValue == null ? "" : stringValue;
            super.doSetValue((Object)stringValue);
            this.valueChanged(true, this.isCorrect(stringValue));
        }
    }

    public static class IntegerCellEditor
    extends TextCellEditor {
        public IntegerCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(this){
                final /* synthetic */ IntegerCellEditor this$1;
                {
                    this.this$1 = integerCellEditor;
                }

                public String isValid(Object object) {
                    if (object instanceof Integer) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Integer.parseInt(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return new Integer(Integer.parseInt((String)super.doGetValue()));
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }

    public static class FloatCellEditor
    extends TextCellEditor {
        public FloatCellEditor(Composite composite) {
            super(composite);
            this.setValidator(new ICellEditorValidator(this){
                final /* synthetic */ FloatCellEditor this$1;
                {
                    this.this$1 = floatCellEditor;
                }

                public String isValid(Object object) {
                    if (object instanceof Float) {
                        return null;
                    }
                    String string = (String)object;
                    try {
                        Float.parseFloat(string);
                        return null;
                    }
                    catch (NumberFormatException exception) {
                        return exception.getMessage();
                    }
                }
            });
        }

        public Object doGetValue() {
            return new Float(Float.parseFloat((String)super.doGetValue()));
        }

        public void doSetValue(Object value) {
            super.doSetValue((Object)value.toString());
        }
    }
}

