/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ant.taskdefs.codegen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.emf.ant.taskdefs.EMFTask;
import org.eclipse.emf.ant.util.Util;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;

public class JETEmitterTask
extends EMFTask {
    private String templateURI;
    private File templateFile;
    private File newFile;
    private String project;
    private List variables;
    private Object argument;
    private Class argumentClass;

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public void setTemplateURI(String templateURI) {
        this.templateURI = templateURI;
    }

    public void setNewFile(File newFile) {
        this.newFile = newFile;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public Variable createVariable() {
        Variable variable = new Variable();
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        this.variables.add(variable);
        return variable;
    }

    public void setArgument(Object argument) {
        this.argument = argument;
    }

    public void setArgumentClass(Class argumentClass) {
        this.argumentClass = argumentClass;
    }

    protected void checkAttributes() throws BuildException {
        JETEmitterTask.assertTrue("Either 'templateURI' or 'templateFile' must be specified.", this.templateURI != null || this.templateFile != null);
        JETEmitterTask.assertTrue("The 'newFile' attribute must be specified.", this.newFile != null);
    }

    protected void doExecute() throws Exception {
        this.invokeEmitter(this.createJETEmitter());
    }

    protected JETEmitter createJETEmitter() throws JETException {
        JETEmitter emitter;
        JETEmitter jETEmitter = emitter = this.templateURI != null ? new JETEmitter(this.templateURI) : new JETEmitter(this.templateFile.getAbsolutePath());
        if (this.project != null) {
            emitter.setProjectName(this.project);
        }
        if (this.variables != null) {
            Iterator i = this.variables.iterator();
            while (i.hasNext()) {
                Variable variable = (Variable)i.next();
                emitter.addVariable(variable.getName(), variable.getPluginID());
            }
        }
        return emitter;
    }

    protected void invokeEmitter(JETEmitter emitter) throws JETException, IOException, InstantiationException, IllegalAccessException {
        Object[] arguments = null;
        if (this.argument != null) {
            Object[] objectArray;
            if (this.argument instanceof Object[]) {
                objectArray = (Object[])this.argument;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.argument;
            }
            arguments = objectArray;
        } else {
            arguments = this.argumentClass != null ? new Object[]{this.argumentClass.newInstance()} : new Object[1];
        }
        String result = emitter.generate(this.getProgressMonitor(), arguments);
        Util.writeFile(this.newFile, result);
    }

    public static class Variable {
        private String name;
        private String pluginID;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPluginID() {
            return this.pluginID;
        }

        public void setPluginID(String pluginID) {
            this.pluginID = pluginID;
        }
    }
}

