/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ant.taskdefs.codegen;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.eclipse.emf.ant.taskdefs.EMFTask;
import org.eclipse.emf.ant.util.Util;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jmerge.JMerger;
import org.eclipse.emf.common.util.URI;

public class JMergerTask
extends EMFTask {
    private String mergeXMLURI;
    private File mergeXMLFile;
    private String sourceURI;
    private File sourceFile;
    private String targetURI;
    private File targetFile;
    private File newFile;

    public void setMergeXMLURI(String mergeXMLURI) {
        this.mergeXMLURI = mergeXMLURI;
    }

    public void setMergeXMLFile(File mergeXMLFile) {
        this.mergeXMLFile = mergeXMLFile;
    }

    public void setSourceURI(String sourceURI) {
        this.sourceURI = sourceURI;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setTargetURI(String targetURI) {
        this.targetURI = targetURI;
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public void setNewFile(File newFile) {
        this.newFile = newFile;
    }

    protected void checkAttributes() throws BuildException {
        JMergerTask.assertTrue("Either 'mergeXMLURI' or 'mergeXMLFile' must be specified.", this.mergeXMLURI != null || this.mergeXMLFile != null);
        JMergerTask.assertTrue("Either 'sourceURI' or 'sourceFile' must be specified.", this.sourceURI != null || this.sourceFile != null);
        JMergerTask.assertTrue("Either 'targetURI' or 'targetFile' must be specified.", this.targetURI != null || this.targetFile != null);
    }

    protected void doExecute() throws Exception {
        this.invokeMerger(this.createJMerger());
    }

    protected JMerger createJMerger() throws JETException {
        return new JMerger();
    }

    protected void invokeMerger(JMerger merger) throws IOException, BuildException {
        String mergeXML = this.mergeXMLURI != null ? this.mergeXMLURI : this.mergeXMLFile.getAbsolutePath();
        String source = this.sourceURI != null ? this.sourceURI : this.sourceFile.getAbsolutePath();
        String target = null;
        if (this.targetURI != null) {
            String file;
            target = this.targetURI;
            if (this.newFile == null && (file = URI.createFileURI((String)target).toFileString()) != null) {
                this.newFile = new File(file);
            }
        } else {
            target = this.targetFile.getAbsolutePath();
            if (this.newFile == null) {
                this.newFile = this.targetFile;
            }
        }
        JMergerTask.assertTrue("Cannot write to target", this.newFile != null);
        String contents = merger.execute(this.getProgressMonitor(), new String[]{mergeXML, source, target});
        Util.writeFile(this.newFile, contents);
    }
}

