/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ant.taskdefs.codegen.ecore;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.emf.ant.taskdefs.codegen.ecore.GeneratorTask;
import org.eclipse.emf.codegen.ecore.XSD2GenModel;

public class XSDGeneratorTask
extends GeneratorTask {
    private List models;

    public Model createModel() {
        Model model = new Model();
        if (this.models == null) {
            this.models = new ArrayList();
        }
        this.models.add(model);
        return model;
    }

    protected void checkAttributes() throws BuildException {
        if (this.models != null) {
            this.useModelAttribute = false;
            Iterator i = this.models.iterator();
            while (i.hasNext()) {
                Model model = (Model)i.next();
                XSDGeneratorTask.assertTrue("Either the 'file' or the 'uri' attributes of a 'model' element must be specified.", model.getFile() != null || model.getUri() != null);
            }
        }
        super.checkAttributes();
    }

    protected void addGenModelArguments() {
        super.addGenModelArguments();
        if (this.models != null) {
            Iterator i = this.models.iterator();
            while (i.hasNext()) {
                Model model = (Model)i.next();
                String argument = model.getUri() != null ? model.getUri() : model.getFile().getAbsolutePath();
                this.getCommandline().createArgument(true).setValue(argument);
            }
        }
    }

    protected void createGenModel(String[] arguments) throws Exception {
        new XSD2GenModel().execute(this.getProgressMonitor(), arguments);
    }

    public static class Model {
        private File file;
        private String uri;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }
    }
}

