/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.osgi.framework.Bundle;

public class ModelImporterUtil {
    public static final String MODEL_IMPORTER_DESCRIPTORS_EXTENSION_POINT = "modelImporterDescriptors";
    private static List descriptors;
    private static Map wizardNodeByDescriptor;

    public static void dispose() {
        if (descriptors != null) {
            descriptors.clear();
            descriptors = null;
        }
        ModelImporterUtil.clearWizardNodesCache();
    }

    public static void clearWizardNodesCache() {
        if (wizardNodeByDescriptor != null) {
            wizardNodeByDescriptor.clear();
            wizardNodeByDescriptor = null;
        }
    }

    public static IWizardNode getWizardNode(ModelImporterDescriptor descriptor) {
        ModelImporterDescriptorWizardNode descriptorNode;
        if (wizardNodeByDescriptor == null) {
            wizardNodeByDescriptor = new HashMap();
        }
        if ((descriptorNode = (ModelImporterDescriptorWizardNode)wizardNodeByDescriptor.get(descriptor)) == null) {
            descriptorNode = new ModelImporterDescriptorWizardNode(descriptor);
            wizardNodeByDescriptor.put(descriptor, descriptorNode);
        }
        if (descriptorNode.descriptor == null) {
            descriptorNode.descriptor = descriptor;
        }
        return descriptorNode;
    }

    public static List getModelImporterDescriptors() {
        if (descriptors == null) {
            descriptors = ModelImporterUtil.retrieveContributedModelImporterDescriptors();
        }
        return descriptors;
    }

    public static ModelImporterDescriptor getModelImporterDescriptor(String id) {
        if (id != null) {
            Iterator i = ModelImporterUtil.getModelImporterDescriptors().iterator();
            while (i.hasNext()) {
                ModelImporterDescriptor modelImporterDescriptor = (ModelImporterDescriptor)i.next();
                if (!id.equals(modelImporterDescriptor.getId())) continue;
                return modelImporterDescriptor;
            }
        }
        return null;
    }

    public static List filterModelImporterDescriptors(int type) {
        ArrayList<ModelImporterDescriptor> descriptors = new ArrayList<ModelImporterDescriptor>();
        Iterator i = ModelImporterUtil.getModelImporterDescriptors().iterator();
        while (i.hasNext()) {
            ModelImporterDescriptor descriptor = (ModelImporterDescriptor)i.next();
            if ((descriptor.getTypes() & type) != type) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public static List filterModelImporterDescriptors(String extension) {
        ArrayList<ModelImporterDescriptor> descriptors = new ArrayList<ModelImporterDescriptor>();
        Iterator i = ModelImporterUtil.getModelImporterDescriptors().iterator();
        while (i.hasNext()) {
            ModelImporterDescriptor descriptor = (ModelImporterDescriptor)i.next();
            if (!descriptor.getExtensions().contains(extension)) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public static List retrieveContributedModelImporterDescriptors() {
        ArrayList<ModelImporterDescriptor> descriptors = new ArrayList<ModelImporterDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.importer", MODEL_IMPORTER_DESCRIPTORS_EXTENSION_POINT);
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            ModelImporterDescriptor modelImporterDescriptor = ModelImporterUtil.createFromContribution(configurationElements[i]);
            if (modelImporterDescriptor != null) {
                descriptors.add(modelImporterDescriptor);
            }
            ++i;
        }
        return descriptors;
    }

    public static ModelImporterDescriptor createFromContribution(IConfigurationElement configurationElement) {
        if ("modelImporterDescriptor".equals(configurationElement.getName())) {
            String id = configurationElement.getAttribute("id");
            String name = configurationElement.getAttribute("name");
            String wizard = configurationElement.getAttribute("wizard");
            if (id != null && name != null && wizard != null) {
                String typesAttribute;
                String extensions;
                ModelImporterDescriptorImpl descriptor = new ModelImporterDescriptorImpl();
                descriptor.setId(id);
                descriptor.setName(name);
                descriptor.setDescription(configurationElement.getAttribute("description"));
                descriptor.configurationElement = configurationElement;
                String imageKey = configurationElement.getAttribute("icon");
                if (imageKey != null) {
                    Bundle pluginBundle = Platform.getBundle((String)configurationElement.getDeclaringExtension().getNamespace());
                    URL path = pluginBundle.getEntry("/");
                    URL fullPathString = null;
                    try {
                        fullPathString = new URL(path, imageKey);
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
                        descriptor.setIcon(imageDescriptor.createImage());
                    }
                    catch (Exception exception) {}
                }
                if ((extensions = configurationElement.getAttribute("extensions")) != null) {
                    String[] exts = extensions.split(",");
                    int i = 0;
                    while (i < exts.length) {
                        String ext = exts[i].trim();
                        if (ext.length() > 0) {
                            descriptor.getExtensions().add(ext);
                        }
                        ++i;
                    }
                }
                if ((typesAttribute = configurationElement.getAttribute("types")) != null) {
                    descriptor.setTypes(0);
                    String[] types = typesAttribute.split(",");
                    int i = 0;
                    while (i < types.length) {
                        String type = types[i].trim();
                        if ("project".equalsIgnoreCase(type)) {
                            descriptor.setTypes(descriptor.getTypes() | 1);
                        } else if ("file".equalsIgnoreCase(type)) {
                            descriptor.setTypes(descriptor.getTypes() | 2);
                        }
                        ++i;
                    }
                }
                return descriptor;
            }
        }
        return null;
    }

    public static class ModelImporterDescriptorImpl
    implements ModelImporterDescriptor {
        protected String id;
        protected String name;
        protected List extensions;
        protected int types = 3;
        protected Image icon;
        protected String description;
        protected IModelImporterWizard modelImporterWizard;
        protected IConfigurationElement configurationElement;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Image getIcon() {
            return this.icon;
        }

        public void setIcon(Image icon) {
            this.icon = icon;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getTypes() {
            return this.types;
        }

        public void setTypes(int types) {
            this.types = types;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List getExtensions() {
            if (this.extensions == null) {
                this.extensions = new ArrayList();
            }
            return this.extensions;
        }

        public IModelImporterWizard getWizard() {
            if (this.modelImporterWizard == null && this.configurationElement != null) {
                try {
                    Object object = this.configurationElement.createExecutableExtension("wizard");
                    if (object instanceof IModelImporterWizard) {
                        this.modelImporterWizard = (IModelImporterWizard)object;
                    }
                }
                catch (CoreException coreException) {}
            }
            return this.modelImporterWizard;
        }
    }

    public static class ModelImporterDescriptorLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ModelImporterDescriptor) {
                return ((ModelImporterDescriptor)element).getIcon();
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ModelImporterDescriptor) {
                return ((ModelImporterDescriptor)element).getName();
            }
            return super.getText(element);
        }
    }

    public static class ModelImporterDescriptorWizardNode
    implements IWizardNode {
        protected boolean contentCreated = false;
        protected ModelImporterDescriptor descriptor;
        protected Point point;

        public ModelImporterDescriptorWizardNode(ModelImporterDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public void dispose() {
            if (this.descriptor != null) {
                if (this.descriptor instanceof ModelImporterDescriptorImpl) {
                    ((ModelImporterDescriptorImpl)this.descriptor).modelImporterWizard = null;
                }
                this.descriptor = null;
            }
            this.point = null;
        }

        public IWizard getWizard() {
            return this.descriptor.getWizard();
        }

        public boolean isContentCreated() {
            return this.contentCreated;
        }

        public void setContentCreated(boolean contentCreated) {
            this.contentCreated = contentCreated;
        }

        public Point getExtent() {
            if (this.point == null) {
                this.point = new Point(-1, -1);
            }
            return this.point;
        }
    }
}

