/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.importer.ImporterPlugin;

public class ImporterUtil {
    public static final int ACTION_DEFAULT = 0;
    public static final int ACTION_MESSAGE_NONE = 1;
    public static final int ACTION_MESSAGE_SET = 2;
    public static final int ACTION_MESSAGE_SET_TYPED = 4;
    public static final int ACTION_MESSAGE_SET_ERROR = 8;
    public static final int ACTION_DIALOG_NONE = 256;
    public static final int ACTION_DIALOG_SHOW_IF_HAS_CHILD = 512;
    public static final int ACTION_DIALOG_SHOW = 1024;
    public static final int ACTION_DIALOG_SHOW_ERROR = 2048;
    private static final int ACTION_MESSAGE_MASK = 15;
    private static final int ACTION_DIALOG_MASK = 3840;

    public static DecodedAction decodeAction(int actionCode) {
        DecodedAction decodedAction = new DecodedAction();
        decodedAction.message = actionCode & 0xF;
        decodedAction.message = 8 == (decodedAction.message & 8) ? 8 : (4 == (decodedAction.message & 4) ? 4 : (2 == (decodedAction.message & 2) ? 2 : (1 == (decodedAction.message & 1) ? 1 : 0)));
        decodedAction.dialog = actionCode & 0xF00;
        decodedAction.dialog = 2048 == (decodedAction.dialog & 0x800) ? 2048 : (1024 == (decodedAction.dialog & 0x400) ? 1024 : (512 == (decodedAction.dialog & 0x200) ? 512 : (256 == (decodedAction.dialog & 0x100) ? 256 : 0)));
        return decodedAction;
    }

    public static int computeActionCode(IStatus status) {
        if ("org.eclipse.emf.importer".equals(status.getPlugin())) {
            int actionCode = status.getCode();
            if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int i = 0;
                while (i < children.length) {
                    actionCode |= ImporterUtil.computeActionCode(children[i]);
                    ++i;
                }
            }
            return actionCode;
        }
        return 0;
    }

    public static MultiStatus mergeStatus(IStatus baseStatus, IStatus statusToBeMerged) {
        if (baseStatus == null) {
            if (statusToBeMerged == null) {
                return null;
            }
            return new MergedStatus(statusToBeMerged);
        }
        Object multiStatus = null;
        multiStatus = baseStatus instanceof MultiStatus ? (MultiStatus)baseStatus : new MergedStatus(baseStatus);
        if (statusToBeMerged != null) {
            multiStatus.merge(statusToBeMerged);
        }
        return multiStatus;
    }

    public static IStatus createStatus(IStatus baseStatus, String pluginID, int code) {
        MergedStatus mergedStatus = new MergedStatus(baseStatus);
        mergedStatus.setPlugin(pluginID);
        mergedStatus.setCode(code);
        return mergedStatus;
    }

    public static IStatus createErrorStatus(Exception exception, boolean showErrorDialog) {
        String message = exception.getLocalizedMessage();
        if (message == null) {
            message = exception.getMessage();
        }
        if (message == null) {
            String exceptionName = exception.getClass().getName();
            int index = exceptionName.lastIndexOf(46);
            if (index >= 0) {
                exceptionName = exceptionName.substring(index + 1);
            }
            message = ImporterPlugin.INSTANCE.getString("_UI_GenericException_message", new Object[]{exceptionName});
        }
        return new Status(4, "org.eclipse.emf.importer", showErrorDialog ? 2048 : 0, message, (Throwable)exception);
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        return result;
    }

    public static String validPluginID(String base) {
        StringBuffer sb = new StringBuffer(base);
        int i = sb.length() - 1;
        while (i >= 0) {
            char c = sb.charAt(i);
            if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.')) {
                if (c == ' ') {
                    sb.deleteCharAt(i);
                } else if (c == '-') {
                    sb.setCharAt(i, '_');
                }
            }
            --i;
        }
        return sb.toString();
    }

    public static class DecodedAction {
        public int message;
        public int dialog;
    }

    public static class MergedStatus
    extends MultiStatus {
        public MergedStatus(IStatus baseStatus) {
            super(baseStatus.getPlugin(), baseStatus.getCode(), baseStatus.getChildren(), baseStatus.getMessage(), baseStatus.getException());
            this.setSeverity(baseStatus.getSeverity());
        }

        public void setPlugin(String pluginId) {
            super.setPlugin(pluginId);
        }

        public void setCode(int code) {
            super.setCode(code);
        }
    }
}

