/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.java.builder;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.java.JavaImporterPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;
import org.eclipse.jdt.core.jdom.IDOMType;

public class JavaEcoreBuilder {
    protected static DOMFactory jdomFactory = new DOMFactory();
    protected IFile genModelFile;
    protected GenModel genModel;
    protected Map externalPackageNameToEPackageMap = new HashMap();
    protected Map packageNameToEPackageMap = new HashMap();
    protected Map ePackageToOrderingMap = new HashMap();
    protected Map ePackageToPrefixMap = new HashMap();
    protected Map eModelElementToIDOMNodeMap = new HashMap();
    protected Map eTypedElementToTypeNameMap = new HashMap();
    protected Map eTypedElementToInstanceTypeNameMap = new HashMap();
    protected Set demandCreatedEDataTypes = new HashSet();
    protected Map eClassToSuperTypeNamesMap = new HashMap();
    protected Map eReferenceToOppositeNameMap = new HashMap();
    protected Collection externalGenModels = new ArrayList();
    protected Collection usedGenPackages = new ArrayList();
    protected MultiStatus status;
    protected GenModel oldGenModelVersion;
    protected static Pattern modelDocExpression = Pattern.compile("<!--\\s*begin-model-doc\\s*-->[ \\f\\n\\r\\t]*\\*\\s?(.*?)<!--\\s*end-model-doc\\s*-->", 40);
    protected static Pattern modelAnnotationExpression = Pattern.compile("@[ \\f\\n\\r\\t*]*model[ \\f\\n\\r\\t*]*((\\w*\\s*=\\s*(['\"])(?>\\\\.|.)*?\\3[ \\f\\n\\r\\t*]*)*)", 8);
    protected static Pattern extendsAnnotationExpression = Pattern.compile("@\\s*extends\\s*(([.\\w]*\\s*,*\\s*)+)", 8);
    protected static Pattern implementsAnnotationExpression = Pattern.compile("@\\s*implements\\s*(([.\\w]*\\s*,*\\s*)+)", 8);
    protected static Pattern eAnnotationExpression = Pattern.compile("\\G\\s*((?>\\\\.|\\S)+)((?:\\s+(?>\\\\.|\\S)+\\s*+=\\s*(['\"])((?>\\\\.|.)*?)\\3)*)");
    protected static Pattern eAnnotationDetailExpression = Pattern.compile("\\s+((?>\\\\.|\\S)+)\\s*+=\\s*((['\"])((?>\\\\.|.)*?)\\3)");

    public JavaEcoreBuilder(IFile genModelFile) {
        this.genModelFile = genModelFile;
        this.status = new MultiStatus(JavaImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, CodeGenEcorePlugin.INSTANCE.getString("_UI_ErrorsWereDetectedJava_message"), null);
    }

    public JavaEcoreBuilder(IFile genModelFile, GenModel oldGenModelVersion) {
        this(genModelFile);
        this.oldGenModelVersion = oldGenModelVersion;
    }

    public JavaEcoreBuilder(IFile genModelFile, GenModel oldGenModelVersion, GenModel genModel) {
        this(genModelFile, oldGenModelVersion);
        this.genModel = genModel;
    }

    protected ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        return result;
    }

    protected IPath analyseProject(IProject project) throws Exception {
        EClassifier eClassifier;
        Map.Entry entry;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
        HashSet visited = new HashSet();
        int i = 0;
        while (i < packageFragmentRoots.length) {
            if (packageFragmentRoots[i].getKind() == 1) {
                this.traverse((IContainer)packageFragmentRoots[i].getUnderlyingResource(), visited);
            }
            ++i;
        }
        Iterator i2 = this.eTypedElementToTypeNameMap.entrySet().iterator();
        while (i2.hasNext()) {
            EClass container;
            String typeName;
            entry = i2.next();
            ETypedElement eTypedElement = (ETypedElement)entry.getKey();
            EClassifier eClassifier2 = this.resolve((EModelElement)eTypedElement, typeName = (String)entry.getValue());
            if (eClassifier2 instanceof EClass && eTypedElement instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)eTypedElement;
                container = eAttribute.getEContainingClass();
                EReference eReference = EcoreFactory.eINSTANCE.createEReference();
                eReference.setChangeable(eAttribute.isChangeable());
                eReference.setVolatile(eAttribute.isVolatile());
                eReference.setTransient(eAttribute.isTransient());
                eReference.setLowerBound(eAttribute.getLowerBound());
                eReference.setUpperBound(eAttribute.getUpperBound());
                eReference.setName(eTypedElement.getName());
                eReference.getEAnnotations().addAll((Collection)eTypedElement.getEAnnotations());
                container.getEStructuralFeatures().add(container.getEStructuralFeatures().indexOf((Object)eTypedElement), (Object)eReference);
                container.getEStructuralFeatures().remove((Object)eTypedElement);
                eTypedElement = eReference;
            } else if (eClassifier2 instanceof EDataType && eTypedElement instanceof EReference) {
                EReference eReference = (EReference)eTypedElement;
                container = eReference.getEContainingClass();
                EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                eAttribute.setChangeable(eReference.isChangeable());
                eAttribute.setVolatile(eReference.isVolatile());
                eAttribute.setTransient(eReference.isTransient());
                eAttribute.setLowerBound(eReference.getLowerBound());
                eAttribute.setUpperBound(eReference.getUpperBound());
                eAttribute.setName(eTypedElement.getName());
                eAttribute.getEAnnotations().addAll((Collection)eTypedElement.getEAnnotations());
                container.getEStructuralFeatures().remove((Object)eTypedElement);
                eTypedElement = eAttribute;
            }
            String instanceClassName = (String)this.eTypedElementToInstanceTypeNameMap.get(eTypedElement);
            if (instanceClassName != null && this.demandCreatedEDataTypes.contains(eClassifier2)) {
                this.demandCreatedEDataTypes.remove(eClassifier2);
                EClassifier resolvedInstanceClassName = this.resolve((EModelElement)eTypedElement, instanceClassName, false);
                ((EDataType)eClassifier2).setInstanceClassName(resolvedInstanceClassName.getInstanceClassName());
            }
            if (eClassifier2 == null) {
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheTypeDoesNotResolveCorrectly_message", new Object[]{typeName}));
                eClassifier2 = EcorePackage.eINSTANCE.getEObject();
            }
            eTypedElement.setEType(eClassifier2);
            this.used((EModelElement)eClassifier2);
        }
        i2 = this.eClassToSuperTypeNamesMap.entrySet().iterator();
        while (i2.hasNext()) {
            entry = i2.next();
            EClass eClass = (EClass)entry.getKey();
            String[] superTypeNames = (String[])entry.getValue();
            if (superTypeNames == null) continue;
            int j = 0;
            while (j < superTypeNames.length) {
                eClassifier = this.resolve((EModelElement)eClass, superTypeNames[j], false);
                if (eClassifier.getEPackage() == null) {
                    EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)eClass);
                    EClass superEClass = EcoreFactory.eINSTANCE.createEClass();
                    superEClass.setInstanceClassName(eClassifier.getInstanceClassName());
                    superEClass.setName(eClassifier.getName());
                    superEClass.setAbstract(true);
                    superEClass.setInterface(true);
                    ePackage.getEClassifiers().add((Object)superEClass);
                    eClassifier = superEClass;
                }
                if (eClassifier instanceof EClass) {
                    if (eClassifier != EcorePackage.eINSTANCE.getEObject()) {
                        eClass.getESuperTypes().add((Object)eClassifier);
                        this.used((EModelElement)eClassifier);
                    }
                } else {
                    this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheSuperTypeDoesNotResolveCorrectly_message", new Object[]{superTypeNames[j]}));
                }
                ++j;
            }
        }
        i2 = this.eReferenceToOppositeNameMap.entrySet().iterator();
        while (i2.hasNext()) {
            entry = i2.next();
            EReference eReference = (EReference)entry.getKey();
            String oppositeName = (String)entry.getValue();
            EClass eClass = (EClass)eReference.getEType();
            EReference eOpposite = (EReference)eClass.getEStructuralFeature(oppositeName);
            if (eOpposite == null) {
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheAttributeIsNotAMemberOf_message", new Object[]{oppositeName, eClass.getName()}));
                continue;
            }
            if (eOpposite.getEOpposite() != eReference && eOpposite.getEOpposite() != null) {
                this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheOppositeAlreadyHasOpposite_message", new Object[]{oppositeName, eOpposite.getEOpposite().getName(), eOpposite.getEOpposite().getEContainingClass().getName()}));
                continue;
            }
            eReference.setEOpposite(eOpposite);
            eOpposite.setEOpposite(eReference);
            this.used((EModelElement)eOpposite);
            if (!eOpposite.isContainment()) continue;
            eReference.setTransient(true);
        }
        i2 = this.ePackageToOrderingMap.entrySet().iterator();
        while (i2.hasNext()) {
            entry = i2.next();
            EPackage ePackage = (EPackage)entry.getKey();
            Map nameToIDMap = (Map)entry.getValue();
            this.sort(ePackage.getEClassifiers(), nameToIDMap);
            Iterator j = ePackage.getEClassifiers().iterator();
            while (j.hasNext()) {
                eClassifier = (EClassifier)j.next();
                if (!(eClassifier instanceof EClass)) continue;
                EClass eClass = (EClass)eClassifier;
                this.sort(eClass.getEStructuralFeatures(), nameToIDMap);
            }
        }
        IPath targetFragmentRoot = project.getFullPath();
        int i3 = 0;
        while (i3 < packageFragmentRoots.length) {
            IPath path;
            if (packageFragmentRoots[i3].getKind() == 1 && targetFragmentRoot.isPrefixOf(path = packageFragmentRoots[i3].getUnderlyingResource().getFullPath())) {
                targetFragmentRoot = path;
                break;
            }
            ++i3;
        }
        return targetFragmentRoot;
    }

    public void computeEPackages(IProgressMonitor progressMonitor, ModelImporter modelImporter) throws Exception {
        IProject project = this.genModelFile.getProject();
        project.open(progressMonitor);
        ArrayList allGenModelFiles = new ArrayList();
        ArrayList allReferencedProjects = new ArrayList();
        this.getAllReferencedProjects(allReferencedProjects, project.getDescription().getReferencedProjects());
        this.getAllReferencedProjects(allReferencedProjects, project.getDescription().getDynamicReferences());
        Iterator i = allReferencedProjects.iterator();
        while (i.hasNext()) {
            this.getAllGenModelFiles(allGenModelFiles, (IContainer)((IProject)i.next()));
        }
        ResourceSet resourceSet = modelImporter.createResourceSet();
        Iterator i2 = allGenModelFiles.iterator();
        while (i2.hasNext()) {
            IFile file = (IFile)i2.next();
            Resource resource = resourceSet.getResource(modelImporter.createFileURI(file.getFullPath().toString()), true);
            GenModel genModel = (GenModel)resource.getContents().get(0);
            this.externalGenModels.add(genModel);
            Iterator j = genModel.getGenPackages().iterator();
            while (j.hasNext()) {
                GenPackage genPackage = (GenPackage)j.next();
                this.determineExternalPackages(genPackage, modelImporter);
            }
        }
        IPath targetFragmentRoot = this.analyseProject(project);
        modelImporter.setModelPluginDirectory(targetFragmentRoot.toString());
        Iterator i3 = this.packageNameToEPackageMap.values().iterator();
        block3: while (i3.hasNext()) {
            EPackage ePackage = (EPackage)i3.next();
            modelImporter.getEPackages().add(ePackage);
            ModelImporter.EPackageInfo ePackageInfo = modelImporter.getEPackageInfo(ePackage);
            ePackageInfo.setPrefix((String)this.ePackageToPrefixMap.get(ePackage));
            Iterator entries = this.packageNameToEPackageMap.entrySet().iterator();
            while (entries.hasNext()) {
                int index;
                Map.Entry entry = entries.next();
                if (entry.getValue() != ePackage) continue;
                String qualifiedPackageName = (String)entry.getKey();
                int n = index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
                if (index == -1) continue block3;
                ePackageInfo.setBasePackage(qualifiedPackageName.substring(0, index));
                continue block3;
            }
        }
    }

    public void used(EModelElement modelElement) {
        EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)modelElement);
        if (ePackage != EcorePackage.eINSTANCE) {
            Iterator i = this.externalGenModels.iterator();
            while (i.hasNext()) {
                GenModel genModel = (GenModel)i.next();
                GenPackage genPackage = genModel.findGenPackage(ePackage);
                if (genPackage == null) continue;
                if (this.usedGenPackages.contains(genPackage)) break;
                this.usedGenPackages.add(genPackage);
                TreeIterator j = ePackage.eAllContents();
                while (j.hasNext()) {
                    EObject eObject = (EObject)j.next();
                    Iterator k = eObject.eCrossReferences().iterator();
                    while (k.hasNext()) {
                        Object o = k.next();
                        if (!(o instanceof EModelElement)) continue;
                        this.used((EModelElement)o);
                    }
                }
                break block0;
            }
        }
    }

    public void determineExternalPackages(GenPackage genPackage) {
        this.determineExternalPackages(genPackage, null);
    }

    protected void determineExternalPackages(GenPackage genPackage, ModelImporter modelImporter) {
        if (modelImporter != null) {
            modelImporter.getReferencedGenPackages().add(genPackage);
        }
        EPackage ePackage = genPackage.getEcorePackage();
        this.externalPackageNameToEPackageMap.put(genPackage.getInterfacePackageName(), ePackage);
        Iterator i = genPackage.getNestedGenPackages().iterator();
        while (i.hasNext()) {
            this.determineExternalPackages((GenPackage)i.next());
        }
    }

    public void getAllReferencedProjects(Collection result, IProject[] projects) throws CoreException {
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!result.contains(project) && project.exists() && project.isOpen()) {
                result.add(project);
                this.getAllReferencedProjects(result, project.getDescription().getReferencedProjects());
                this.getAllReferencedProjects(result, project.getDescription().getDynamicReferences());
            }
            ++i;
        }
    }

    public void getAllGenModelFiles(Collection result, IContainer container) throws CoreException {
        IResource[] contents = container.members();
        int i = 0;
        while (i < contents.length) {
            IResource resource = contents[i];
            if (resource.getType() == 1) {
                this.getAllGenModelFiles(result, (IFile)resource);
            } else {
                this.getAllGenModelFiles(result, (IContainer)resource);
            }
            ++i;
        }
    }

    public void getAllGenModelFiles(Collection result, IFile file) throws CoreException {
        if (file.getName().endsWith(".genmodel")) {
            IProject project = file.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IPath outputLocation = javaProject.getOutputLocation();
                if (project == project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation()) || !outputLocation.isPrefixOf(file.getFullPath())) {
                    result.add(file);
                }
            }
            catch (JavaModelException exception) {
                JavaImporterPlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    public void traverse(IContainer container, Set visited) throws CoreException {
        IResource[] contents = container.members();
        int i = 0;
        while (i < contents.length) {
            IResource resource = contents[i];
            if (visited.add(resource)) {
                if (resource.getType() == 1) {
                    this.traverse((IFile)resource);
                } else {
                    this.traverse((IContainer)resource, visited);
                }
            }
            ++i;
        }
    }

    public void traverse(IFile file) throws CoreException {
        if ("java".equalsIgnoreCase(file.getProjectRelativePath().getFileExtension())) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(file.getContents(true));
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                String encoding = null;
                try {
                    encoding = file.getCharset();
                }
                catch (CoreException coreException) {}
                String contents = encoding == null ? new String(input) : new String(input, encoding);
                IDOMCompilationUnit jCompilationUnit = jdomFactory.createCompilationUnit(contents, "NAME");
                this.analyzeCompilationUnit(jCompilationUnit);
            }
            catch (IOException exception) {
                JavaImporterPlugin.INSTANCE.log(exception);
            }
        }
    }

    protected void analyzeCompilationUnit(IDOMCompilationUnit compilationUnit) {
        IDOMNode child = compilationUnit.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 4) {
                this.analyzeType((IDOMType)child);
                break;
            }
            child = child.getNextNode();
        }
    }

    protected void analyzeType(IDOMType type) {
        String modelAnnotation;
        IDOMCompilationUnit compilationUnit = (IDOMCompilationUnit)type.getParent();
        String qualifiedPackageName = null;
        if (compilationUnit.getFirstChild() instanceof IDOMPackage) {
            qualifiedPackageName = ((IDOMPackage)compilationUnit.getFirstChild()).getName();
        }
        if ((modelAnnotation = this.getModelAnnotation(type.getComment())) != null) {
            EPackage ePackage = (EPackage)this.packageNameToEPackageMap.get(qualifiedPackageName);
            if (ePackage == null) {
                ePackage = EcoreFactory.eINSTANCE.createEPackage();
                int index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
                String packageName = index == -1 ? qualifiedPackageName : qualifiedPackageName.substring(index + 1);
                ePackage.setName(packageName);
                ePackage.setNsURI("http:///" + (qualifiedPackageName == null ? "null" : qualifiedPackageName.replace('.', '/')) + ".ecore");
                ePackage.setNsPrefix(qualifiedPackageName == null ? "null" : qualifiedPackageName);
                this.packageNameToEPackageMap.put(qualifiedPackageName, ePackage);
                if (packageName != null) {
                    String prefix = String.valueOf(Character.toUpperCase(packageName.charAt(0))) + packageName.substring(1);
                    this.ePackageToPrefixMap.put(ePackage, prefix);
                }
            }
            if ((type.getFlags() & 0x200) != 0) {
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                this.eModelElementToIDOMNodeMap.put(eClass, type);
                eClass.setName(type.getName());
                ePackage.getEClassifiers().add((Object)eClass);
                eClass.getEAnnotations().addAll((Collection)this.extractEAnnotations(modelAnnotation));
                EcoreUtil.setDocumentation((EModelElement)eClass, (String)this.getModelDocumentation(type.getComment()));
                String[] superInterfaces = type.getSuperInterfaces();
                String extend = this.getExtendsAnnotation(type.getComment());
                if (extend != null && superInterfaces != null) {
                    ArrayList<String> superInterfaceList = new ArrayList<String>(Arrays.asList(superInterfaces));
                    StringTokenizer stringTokenizer = new StringTokenizer(extend, " ,\t\n\r\f");
                    while (stringTokenizer.hasMoreTokens()) {
                        superInterfaceList.remove(stringTokenizer.nextToken());
                    }
                    superInterfaces = new String[superInterfaceList.size()];
                    superInterfaceList.toArray(superInterfaces);
                }
                this.eClassToSuperTypeNamesMap.put(eClass, superInterfaces);
                String isAbstract = this.getModelAnnotationAttribute(modelAnnotation, "abstract");
                eClass.setAbstract("true".equals(isAbstract));
                String isInterface = this.getModelAnnotationAttribute(modelAnnotation, "interface");
                eClass.setInterface("true".equals(isInterface));
                IDOMNode child = type.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 6) {
                        this.analyzeMethod(eClass, (IDOMMethod)child);
                    }
                    child = child.getNextNode();
                }
                String features = this.getModelAnnotationAttribute(modelAnnotation, "features");
                if (features != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(features, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String feature = stringTokenizer.nextToken();
                        if (eClass.getEStructuralFeature(feature) == null) {
                            this.analyzeMethod(eClass, this.getFilteredModelAnnotations(modelAnnotation, feature), "get" + Character.toUpperCase(feature.charAt(0)) + feature.substring(1), "java.lang.Object", null, null);
                            continue;
                        }
                        this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_DuplicateFeature_message", new Object[]{feature, eClass.getName()}));
                    }
                }
            } else {
                EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
                this.eModelElementToIDOMNodeMap.put(eEnum, type);
                eEnum.setName(type.getName());
                ePackage.getEClassifiers().add((Object)eEnum);
                eEnum.getEAnnotations().addAll((Collection)this.extractEAnnotations(modelAnnotation));
                EcoreUtil.setDocumentation((EModelElement)eEnum, (String)this.getModelDocumentation(type.getComment()));
                IDOMNode child = type.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 5) {
                        this.analyzeField(eEnum, (IDOMField)child);
                    }
                    child = child.getNextNode();
                }
            }
        } else {
            String typeName = type.getName();
            boolean isPackage = false;
            if (typeName.endsWith("Package") && typeName.length() > 7) {
                String packagePrefix = typeName.substring(0, typeName.length() - 7);
                int index = qualifiedPackageName == null ? -1 : qualifiedPackageName.lastIndexOf(".");
                String name = index == -1 ? qualifiedPackageName : qualifiedPackageName.substring(index + 1);
                String nsURI = "http:///" + (qualifiedPackageName == null ? "null" : qualifiedPackageName.replace('.', '/')) + ".ecore";
                String nsPrefix = qualifiedPackageName == null ? "null" : qualifiedPackageName;
                ArrayList<EClass> eClasses = new ArrayList<EClass>();
                ArrayList<EDataType> eDataTypes = new ArrayList<EDataType>();
                HashMap<String, Integer> ordering = new HashMap<String, Integer>();
                IDOMNode child = type.getFirstChild();
                while (child != null) {
                    String returnType;
                    IDOMMethod method;
                    String methodAnnotation;
                    if (child.getNodeType() == 5) {
                        IDOMField field = (IDOMField)child;
                        String childName = child.getName();
                        String childType = field.getType();
                        if ("eNAME".equals(childName)) {
                            isPackage = true;
                            name = field.getInitializer();
                            name = name.substring(2, name.length() - 1);
                        } else if ("eNS_URI".equals(childName)) {
                            isPackage = true;
                            nsURI = field.getInitializer();
                            nsURI = nsURI.substring(2, nsURI.length() - 1);
                        } else if ("eNS_PREFIX".equals(childName)) {
                            isPackage = true;
                            nsPrefix = field.getInitializer();
                            nsPrefix = nsPrefix.substring(2, nsPrefix.length() - 1);
                        } else if ("int".equals(childType) && !childName.endsWith("FEATURE_COUNT")) {
                            try {
                                String initializer = field.getInitializer();
                                int plusIndex = initializer.lastIndexOf("+");
                                if (plusIndex != -1) {
                                    initializer = initializer.substring(plusIndex + 1);
                                }
                                initializer = initializer.trim();
                                int value = Integer.parseInt(initializer);
                                ordering.put(childName, new Integer(value));
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else if (child.getNodeType() == 6 && (methodAnnotation = this.getModelAnnotation((method = (IDOMMethod)child).getComment())) != null && (returnType = method.getReturnType()) != null) {
                        if (returnType.endsWith("EDataType")) {
                            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
                            eDataType.setInstanceClassName(this.getModelAnnotationAttribute(methodAnnotation, "instanceClass"));
                            eDataType.setName(method.getName().substring(3));
                            String isSerializable = this.getModelAnnotationAttribute(methodAnnotation, "serializable");
                            if ("false".equals(isSerializable)) {
                                eDataType.setSerializable(false);
                            }
                            eDataTypes.add(eDataType);
                            eDataType.getEAnnotations().addAll((Collection)this.extractEAnnotations(methodAnnotation));
                            EcoreUtil.setDocumentation((EModelElement)eDataType, (String)this.getModelDocumentation(method.getComment()));
                        } else if (returnType.endsWith("EClass")) {
                            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                            String instanceClass = this.getModelAnnotationAttribute(methodAnnotation, "instanceClass");
                            if (instanceClass != null) {
                                eClass.setInterface(true);
                                eClass.setAbstract(true);
                                eClass.setInstanceClassName(instanceClass);
                                eClass.setName(method.getName().substring(3));
                                eClasses.add(eClass);
                            } else {
                                eClass.setInstanceClassName("java.util.Map$Entry");
                                eClass.setName(method.getName().substring(3));
                                eClasses.add(eClass);
                                String features = this.getModelAnnotationAttribute(methodAnnotation, "features");
                                if (features != null) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(features, " ");
                                    while (stringTokenizer.hasMoreTokens()) {
                                        String feature = stringTokenizer.nextToken();
                                        this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, feature), "get" + Character.toUpperCase(feature.charAt(0)) + feature.substring(1), "java.lang.Object", null, null);
                                    }
                                } else {
                                    this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, "key"), "getKey", "java.lang.Object", null, null);
                                    this.analyzeMethod(eClass, this.getFilteredModelAnnotations(methodAnnotation, "value"), "getValue", "java.lang.Object", null, null);
                                }
                            }
                            eClass.getEAnnotations().addAll((Collection)this.extractEAnnotations(methodAnnotation));
                            EcoreUtil.setDocumentation((EModelElement)eClass, (String)this.getModelDocumentation(method.getComment()));
                        }
                    }
                    child = child.getNextNode();
                }
                if (isPackage || !eClasses.isEmpty() || !eDataTypes.isEmpty()) {
                    EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
                    this.ePackageToOrderingMap.put(ePackage, ordering);
                    this.eModelElementToIDOMNodeMap.put(ePackage, type);
                    ePackage.setNsURI(nsURI);
                    ePackage.setNsPrefix(nsPrefix);
                    ePackage.setName(name);
                    ePackage.getEClassifiers().addAll(eClasses);
                    ePackage.getEClassifiers().addAll(eDataTypes);
                    if (modelAnnotation != null) {
                        ePackage.getEAnnotations().addAll((Collection)this.extractEAnnotations(modelAnnotation));
                    }
                    EcoreUtil.setDocumentation((EModelElement)ePackage, (String)this.getModelDocumentation(type.getComment()));
                    this.ePackageToPrefixMap.put(ePackage, packagePrefix);
                    EPackage existingEPackage = (EPackage)this.packageNameToEPackageMap.get(qualifiedPackageName);
                    if (existingEPackage != null) {
                        ePackage.getEClassifiers().addAll((Collection)existingEPackage.getEClassifiers());
                    }
                    this.packageNameToEPackageMap.put(qualifiedPackageName, ePackage);
                }
            }
        }
    }

    protected void analyzeMethod(EClass eClass, IDOMMethod method) {
        String modelAnnotation = this.getModelAnnotation(method.getComment());
        if (modelAnnotation != null) {
            String[] parameterTypes;
            String[] parameterNames;
            String returnType;
            String methodName = method.getName();
            ETypedElement eTypedElement = this.analyzeMethod(eClass, modelAnnotation, methodName, returnType = method.getReturnType(), parameterNames = method.getParameterNames(), parameterTypes = method.getParameterTypes());
            if (eTypedElement != null) {
                EcoreUtil.setDocumentation((EModelElement)eTypedElement, (String)this.getModelDocumentation(method.getComment()));
            }
            this.eModelElementToIDOMNodeMap.put(eTypedElement, method);
            if (eTypedElement instanceof EOperation) {
                EOperation eOperation = (EOperation)eTypedElement;
                Iterator i = eOperation.getEParameters().iterator();
                while (i.hasNext()) {
                    EParameter eParameter = (EParameter)i.next();
                    this.eModelElementToIDOMNodeMap.put(eParameter, method);
                }
            }
        }
    }

    protected ETypedElement analyzeMethod(EClass eClass, String modelAnnotation, String methodName, String returnType, String[] parameterNames, String[] parameterTypes) {
        String dataType;
        EOperation eTypedElement = null;
        String featureName = methodName;
        String parameters = this.getModelAnnotationAttribute(modelAnnotation, "parameters");
        if (parameterNames == null && parameters == null && methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && !"boolean".equals(returnType) && !"void".equals(returnType)) {
            featureName = CodeGenUtil.uncapName((String)methodName.substring(3));
        } else if (parameterNames == null && parameters == null && methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) && "boolean".equals(returnType)) {
            featureName = CodeGenUtil.uncapName((String)methodName.substring(2));
        } else {
            EOperation eOperation;
            eTypedElement = eOperation = EcoreFactory.eINSTANCE.createEOperation();
            eClass.getEOperations().add((Object)eTypedElement);
            if (parameterTypes != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(parameters == null ? "" : parameters);
                int i = 0;
                while (i < parameterNames.length) {
                    EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
                    eOperation.getEParameters().add((Object)eParameter);
                    eParameter.setName(parameterNames[i]);
                    String parameterType = parameterTypes[i];
                    if (stringTokenizer.hasMoreTokens()) {
                        this.eTypedElementToInstanceTypeNameMap.put(eParameter, parameterType);
                        dataType = stringTokenizer.nextToken();
                        if (!"-".equals(dataType)) {
                            parameterType = dataType;
                        }
                    }
                    this.eTypedElementToTypeNameMap.put(eParameter, parameterType);
                    ++i;
                }
            }
        }
        if (!"void".equals(returnType)) {
            if (eTypedElement == null) {
                String upperBound;
                String many;
                EReference eStructuralFeature = null;
                String opposite = this.getModelAnnotationAttribute(modelAnnotation, "opposite");
                String containment = this.getModelAnnotationAttribute(modelAnnotation, "containment");
                String resolveProxies = this.getModelAnnotationAttribute(modelAnnotation, "resolveProxies");
                String mapType = this.getModelAnnotationAttribute(modelAnnotation, "mapType");
                dataType = this.getModelAnnotationAttribute(modelAnnotation, "dataType");
                String keyType = this.getModelAnnotationAttribute(modelAnnotation, "keyType");
                String valueType = this.getModelAnnotationAttribute(modelAnnotation, "valueType");
                String modelType = this.getModelAnnotationAttribute(modelAnnotation, "type");
                if (opposite != null || containment != null || resolveProxies != null || mapType != null || keyType != null && valueType != null) {
                    EReference eReference;
                    eStructuralFeature = eReference = EcoreFactory.eINSTANCE.createEReference();
                    eTypedElement = eStructuralFeature;
                    eClass.getEStructuralFeatures().add((Object)eStructuralFeature);
                    eReference.setContainment("true".equals(containment) || mapType != null && !returnType.endsWith("Entry") || keyType != null && valueType != null);
                    eReference.setResolveProxies(!eReference.isContainment() && !"false".equals(resolveProxies));
                    eReference.setUnsettable("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "unsettable")));
                    if (opposite != null) {
                        this.eReferenceToOppositeNameMap.put(eReference, opposite);
                    }
                } else {
                    EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
                    eStructuralFeature = eAttribute;
                    eTypedElement = eStructuralFeature;
                    eClass.getEStructuralFeatures().add((Object)eStructuralFeature);
                    eAttribute.setUnsettable("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "unsettable")));
                    eAttribute.setID("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "id")));
                    String defaultValueLiteral = this.getModelAnnotationAttribute(modelAnnotation, "defaultValue");
                    if (defaultValueLiteral == null) {
                        defaultValueLiteral = this.getModelAnnotationAttribute(modelAnnotation, "default");
                    }
                    eStructuralFeature.setDefaultValueLiteral(defaultValueLiteral);
                    eStructuralFeature.setUnique(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "unique")));
                }
                if (dataType == null || mapType != null) {
                    if ("EList".equals(returnType) || "org.eclipse.emf.common.util.EList".equals(returnType) || "List".equals(returnType) || "java.util.List".equals(returnType)) {
                        eStructuralFeature.setUpperBound(-1);
                        if (modelType == null) {
                            this.error(CodeGenEcorePlugin.INSTANCE.getString("_UI_TheTypeMustBeSpecifiedFor_message", new Object[]{String.valueOf(eClass.getName()) + "." + methodName}));
                            modelType = "java.lang.Object";
                        }
                    } else if ("EMap".equals(returnType) || "org.eclipse.emf.common.util.EMap".equals(returnType) || "Map".equals(returnType) || "java.util.Map".equals(returnType) || "FeatureMap".equals(returnType) || "org.eclipse.emf.common.util.FeatureMap".equals(returnType)) {
                        eStructuralFeature.setUpperBound(-1);
                    }
                }
                if ((many = this.getModelAnnotationAttribute(modelAnnotation, "many")) != null) {
                    eStructuralFeature.setUpperBound("true".equals(many) ? -1 : 1);
                }
                if (modelType != null) {
                    returnType = modelType;
                }
                if (mapType != null) {
                    returnType = keyType != null && valueType != null ? String.valueOf(mapType) + "@" + keyType + "/" + valueType : mapType;
                } else if (dataType != null) {
                    this.eTypedElementToInstanceTypeNameMap.put(eStructuralFeature, returnType);
                    returnType = dataType;
                } else if (keyType != null && valueType != null) {
                    returnType = String.valueOf(keyType) + "/" + valueType;
                }
                eStructuralFeature.setChangeable(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "changeable")));
                eStructuralFeature.setOrdered(!"false".equals(this.getModelAnnotationAttribute(modelAnnotation, "ordered")));
                eStructuralFeature.setDerived("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "derived")));
                eStructuralFeature.setVolatile("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "volatile")));
                eStructuralFeature.setTransient("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "transient")));
                eStructuralFeature.setLowerBound("true".equals(this.getModelAnnotationAttribute(modelAnnotation, "required")) ? 1 : 0);
                String lowerBound = this.getModelAnnotationAttribute(modelAnnotation, "lowerBound");
                if (lowerBound == null) {
                    lowerBound = this.getModelAnnotationAttribute(modelAnnotation, "lower");
                }
                if (lowerBound != null) {
                    eStructuralFeature.setLowerBound(Integer.parseInt(lowerBound));
                }
                if ((upperBound = this.getModelAnnotationAttribute(modelAnnotation, "upperBound")) == null) {
                    upperBound = this.getModelAnnotationAttribute(modelAnnotation, "upper");
                }
                if (upperBound != null) {
                    eStructuralFeature.setUpperBound(Integer.parseInt(upperBound));
                }
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedGetVisibility")));
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedSetVisibility")));
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedIsSetVisibility")));
                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)"true".equals(this.getModelAnnotationAttribute(modelAnnotation, "suppressedUnsetVisibility")));
            } else {
                String dataType2 = this.getModelAnnotationAttribute(modelAnnotation, "dataType");
                if (dataType2 != null) {
                    this.eTypedElementToInstanceTypeNameMap.put(eTypedElement, returnType);
                    returnType = dataType2;
                }
            }
            this.eTypedElementToTypeNameMap.put(eTypedElement, returnType);
        }
        if (eTypedElement != null) {
            eTypedElement.setName(featureName);
            eTypedElement.getEAnnotations().addAll((Collection)this.extractEAnnotations(modelAnnotation));
        }
        return eTypedElement;
    }

    protected EStructuralFeature createFeature(EClass eClass, String name, EClassifier eType) {
        if (eType instanceof EClass) {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            eReference.setName(name);
            eReference.setEType(eType);
            eClass.getEStructuralFeatures().add((Object)eReference);
            return eReference;
        }
        EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setEType(eType);
        eClass.getEStructuralFeatures().add((Object)eAttribute);
        return eAttribute;
    }

    protected void analyzeField(EEnum eEnum, IDOMField field) {
        String modelAnnotation = this.getModelAnnotation(field.getComment());
        if (modelAnnotation != null) {
            String literalName = this.getModelAnnotationAttribute(modelAnnotation, "name");
            if (literalName == null) {
                literalName = field.getName();
            }
            EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
            this.eModelElementToIDOMNodeMap.put(eEnumLiteral, field);
            eEnumLiteral.setName(literalName);
            eEnumLiteral.getEAnnotations().addAll((Collection)this.extractEAnnotations(modelAnnotation));
            EcoreUtil.setDocumentation((EModelElement)eEnumLiteral, (String)this.getModelDocumentation(field.getComment()));
            if (field.getInitializer() != null) {
                try {
                    int value = Integer.parseInt(field.getInitializer().trim());
                    eEnumLiteral.setValue(value);
                }
                catch (NumberFormatException exception) {
                    JavaImporterPlugin.INSTANCE.log(exception);
                    eEnumLiteral.setValue(eEnum.getELiterals().size());
                }
            } else {
                eEnumLiteral.setValue(eEnum.getELiterals().size());
            }
            eEnum.getELiterals().add((Object)eEnumLiteral);
        }
    }

    protected String getModelDocumentation(String comment) {
        Matcher matcher;
        if (comment != null && (matcher = modelDocExpression.matcher(comment)).find()) {
            return comment.substring(matcher.start(1), matcher.end(1)).replaceAll("[\\n\\r]*\\s*\\*[\\s]?", "\n").replaceAll("\\s*$", "");
        }
        return null;
    }

    protected String getModelAnnotation(String comment) {
        Matcher matcher;
        if (comment != null && (matcher = modelAnnotationExpression.matcher(comment)).find()) {
            return comment.substring(matcher.start(1), matcher.end(1));
        }
        return null;
    }

    protected String getExtendsAnnotation(String comment) {
        if (comment != null) {
            StringBuffer result = new StringBuffer();
            Matcher extendsMatcher = extendsAnnotationExpression.matcher(comment);
            while (extendsMatcher.find()) {
                result.append(comment.substring(extendsMatcher.start(1), extendsMatcher.end(1)));
                result.append(' ');
            }
            Matcher implementsMatcher = implementsAnnotationExpression.matcher(comment);
            while (implementsMatcher.find()) {
                result.append(comment.substring(implementsMatcher.start(1), implementsMatcher.end(1)));
                result.append(' ');
            }
            return result.length() == 0 ? null : result.toString();
        }
        return null;
    }

    protected String getModelAnnotationAttribute(String modelAnnotation, String attributeName) {
        Pattern modelAnnotationAttributeExpressionDoubleQuote = Pattern.compile("\\b" + attributeName + "\\s*=\\s*([\"'])((?>\\\\.|.)*?)\\1", 8);
        Matcher matcher = modelAnnotationAttributeExpressionDoubleQuote.matcher(modelAnnotation);
        if (matcher.find()) {
            return modelAnnotation.substring(matcher.start(2), matcher.end(2));
        }
        return null;
    }

    protected String getModelAnnotationAttributes(String modelAnnotation, String attributeName) {
        StringBuffer result = null;
        Pattern modelAnnotationAttributeExpressionDoubleQuote = Pattern.compile("\\b" + attributeName + "\\s*=\\s*([\"'])((?>\\\\.|.)*?)\\1", 8);
        Matcher matcher = modelAnnotationAttributeExpressionDoubleQuote.matcher(modelAnnotation);
        while (matcher.find()) {
            if (result == null) {
                result = new StringBuffer();
            } else {
                result.append(' ');
            }
            result.append((Object)modelAnnotation.subSequence(matcher.start(2), matcher.end(2)));
        }
        return result == null ? null : result.toString();
    }

    protected List extractEAnnotations(String modelAnnotation) {
        String extendedMetaDataAnnotations;
        Matcher detailMatcher;
        EMap details;
        EAnnotation eAnnotation;
        ArrayList<EAnnotation> result = Collections.EMPTY_LIST;
        String annotations = this.getModelAnnotationAttributes(modelAnnotation, "annotation");
        if (annotations != null) {
            Matcher matcher = eAnnotationExpression.matcher(annotations);
            while (matcher.find()) {
                if (result == Collections.EMPTY_LIST) {
                    result = new ArrayList();
                }
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                result.add(eAnnotation);
                eAnnotation.setSource(JavaEcoreBuilder.parseString(matcher.group(1)));
                details = eAnnotation.getDetails();
                detailMatcher = eAnnotationDetailExpression.matcher(matcher.group(2));
                while (detailMatcher.find()) {
                    details.put((Object)JavaEcoreBuilder.parseString(detailMatcher.group(1)), (Object)JavaEcoreBuilder.parseString(detailMatcher.group(4)));
                }
            }
        }
        if ((extendedMetaDataAnnotations = this.getModelAnnotationAttributes(modelAnnotation, "extendedMetaData")) != null) {
            if (result == Collections.EMPTY_LIST) {
                result = new ArrayList<EAnnotation>();
            }
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            result.add(eAnnotation);
            eAnnotation.setSource("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
            details = eAnnotation.getDetails();
            detailMatcher = eAnnotationDetailExpression.matcher(" " + extendedMetaDataAnnotations);
            while (detailMatcher.find()) {
                details.put((Object)JavaEcoreBuilder.parseString(detailMatcher.group(1)), (Object)JavaEcoreBuilder.parseString(detailMatcher.group(4)));
            }
        }
        return result;
    }

    private static String parseString(String stringLiteralBody) {
        return CodeGenUtil.parseString((String)stringLiteralBody);
    }

    protected String getFilteredModelAnnotations(String modelAnnotation, String filter) {
        Matcher matcher;
        StringBuffer result = new StringBuffer();
        Pattern modelAnnotationAttributeExpressionDoubleQuote = Pattern.compile("\\b" + filter + "([A-Z]\\w*\\s*=\\s*([\"'])((?>\\\\.|.)*?)\\2)", 8);
        int start = 0;
        int end = modelAnnotation.length();
        while ((matcher = modelAnnotationAttributeExpressionDoubleQuote.matcher(modelAnnotation.subSequence(start, end))).find()) {
            result.append(modelAnnotation.substring(start + matcher.start(1), start + matcher.start(1) + 1).toLowerCase());
            result.append(modelAnnotation.substring(start + matcher.start(1) + 1, start + matcher.end(1)));
            result.append(' ');
            start += matcher.end(0);
        }
        return result.toString();
    }

    protected EClassifier resolve(EModelElement eModelElement, String typeName) {
        return this.resolve(eModelElement, typeName, true);
    }

    protected EClassifier resolve(EModelElement eModelElement, String typeName, boolean recordDemandCreatedEDataType) {
        Iterator j;
        EPackage ePackage = (EPackage)EcoreUtil.getRootContainer((EObject)eModelElement);
        EClassifier eClassifier = null;
        int indexOfSlash = typeName.indexOf("/");
        if (indexOfSlash != -1) {
            String mapType = null;
            String keyType = typeName.substring(0, indexOfSlash);
            int indexOfAt = keyType.indexOf("@");
            if (indexOfAt != -1) {
                mapType = keyType.substring(0, indexOfAt);
                keyType = keyType.substring(indexOfAt + 1);
            }
            EClassifier keyEClassifier = this.resolve(eModelElement, keyType);
            String valueType = typeName.substring(indexOfSlash + 1);
            EClassifier valueEClassifier = this.resolve(eModelElement, valueType);
            if (mapType == null) {
                eClassifier = this.resolveMapEntry(ePackage, keyEClassifier, valueEClassifier);
                if (eClassifier == null) {
                    eClassifier = this.resolveMapEntry((EPackage)EcorePackage.eINSTANCE, keyEClassifier, valueEClassifier);
                }
            } else {
                eClassifier = this.resolve(eModelElement, mapType, false);
            }
            if (eClassifier == null) {
                String baseName;
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                eClass.setInstanceClassName("java.util.Map$Entry");
                String name = baseName = mapType != null ? mapType : String.valueOf(keyEClassifier.getName()) + "To" + valueEClassifier.getName() + "MapEntry";
                int j2 = 1;
                while (ePackage.getEClassifier(name) != null) {
                    name = String.valueOf(baseName) + "_" + j2;
                    ++j2;
                }
                eClass.setName(name);
                this.createFeature(eClass, "key", keyEClassifier);
                this.createFeature(eClass, "value", valueEClassifier);
                ePackage.getEClassifiers().add((Object)eClass);
                eClassifier = eClass;
            }
            return eClassifier;
        }
        String baseName = typeName;
        String packageName = "";
        int index = typeName.lastIndexOf(".");
        if (index == -1) {
            IDOMNode node = (IDOMNode)this.eModelElementToIDOMNodeMap.get(eModelElement);
            while (node != null) {
                if (node.getNodeType() == 1) {
                    boolean firstWildcard = true;
                    IDOMNode child = ((IDOMCompilationUnit)node).getFirstChild();
                    while (child != null) {
                        if (child.getNodeType() == 3) {
                            int importIndex;
                            IDOMImport jImport = (IDOMImport)child;
                            String importName = jImport.getName();
                            if (importName.endsWith("." + baseName)) {
                                importIndex = importName.lastIndexOf(".");
                                packageName = importName.substring(0, importIndex);
                                typeName = String.valueOf(packageName) + "." + baseName;
                                break;
                            }
                            if (firstWildcard && importName.endsWith(".*")) {
                                importIndex = importName.lastIndexOf(".");
                                packageName = importName.substring(0, importIndex);
                                typeName = String.valueOf(packageName) + "." + baseName;
                                firstWildcard = false;
                            }
                        }
                        child = child.getNextNode();
                    }
                    EPackage otherEPackage = (EPackage)this.packageNameToEPackageMap.get(packageName);
                    if (otherEPackage == null) {
                        otherEPackage = (EPackage)this.externalPackageNameToEPackageMap.get(packageName);
                    }
                    if (otherEPackage == null) break;
                    eClassifier = otherEPackage.getEClassifier(baseName);
                    break;
                }
                node = node.getParent();
            }
            if (eClassifier == null && "".equals(packageName)) {
                eClassifier = ePackage.getEClassifier(typeName);
            }
        } else {
            packageName = typeName.substring(0, index);
            baseName = typeName.substring(index + 1);
            EPackage otherEPackage = (EPackage)this.packageNameToEPackageMap.get(packageName);
            if (otherEPackage == null && (otherEPackage = (EPackage)this.externalPackageNameToEPackageMap.get(packageName)) == null) {
                if ("org.eclipse.emf.ecore".equals(packageName)) {
                    otherEPackage = EcorePackage.eINSTANCE;
                } else if ("org.eclipse.emf.ecore.xml.type".equals(packageName)) {
                    otherEPackage = XMLTypePackage.eINSTANCE;
                } else if ("org.eclipse.emf.ecore.xml.namespace".equals(packageName)) {
                    otherEPackage = XMLNamespacePackage.eINSTANCE;
                }
            }
            if (otherEPackage != null) {
                eClassifier = otherEPackage.getEClassifier(baseName);
            }
        }
        if (eClassifier == null) {
            j = ePackage.getEClassifiers().iterator();
            while (j.hasNext()) {
                EClassifier ePackageClassifier = (EClassifier)j.next();
                String name = ePackageClassifier.getInstanceClassName();
                if (name == null || !name.replace('$', '.').equals(typeName.replace('$', '.'))) continue;
                eClassifier = ePackageClassifier;
                break;
            }
        }
        if (EcorePackage.eINSTANCE.getEObject().getInstanceClassName().equals(typeName)) {
            eClassifier = EcorePackage.eINSTANCE.getEObject();
        }
        if (eClassifier == null && recordDemandCreatedEDataType && EcorePackage.eINSTANCE.getEFeatureMap().getInstanceClassName().equals(typeName)) {
            eClassifier = EcorePackage.eINSTANCE.getEFeatureMapEntry();
        }
        if (eClassifier == null && (packageName.length() == 0 || packageName.equals("java.lang") || packageName.equals("java.math") || packageName.equals("java.util"))) {
            j = EcorePackage.eINSTANCE.getEClassifiers().iterator();
            while (j.hasNext()) {
                String instanceClassName;
                EClassifier ecoreEClassifier = (EClassifier)j.next();
                if (!(ecoreEClassifier instanceof EDataType) || !(instanceClassName = ecoreEClassifier.getInstanceClassName()).equals(typeName) && !instanceClassName.equals("java.lang." + typeName)) continue;
                eClassifier = ecoreEClassifier;
                break;
            }
        }
        if (eClassifier == null && !(eModelElement instanceof EReference)) {
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            boolean primitive = false;
            if (packageName.length() == 0) {
                String elementTypeName;
                int i = typeName.indexOf(91);
                String string = elementTypeName = i == -1 ? typeName : typeName.substring(0, i);
                if (CodeGenUtil.isJavaPrimitiveType((String)elementTypeName)) {
                    primitive = true;
                } else if (CodeGenUtil.isJavaLangType((String)elementTypeName)) {
                    packageName = "java.lang";
                    typeName = String.valueOf(packageName) + "." + typeName;
                } else {
                    packageName = ePackage.getNsPrefix();
                    typeName = String.valueOf(packageName) + '.' + typeName;
                }
            }
            eDataType.setInstanceClassName(typeName);
            String name = baseName;
            if (primitive && name.length() > 0) {
                name = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
            }
            while (name.endsWith("[]")) {
                name = String.valueOf(name.substring(0, name.length() - 2)) + "Array";
            }
            int j3 = 1;
            while (ePackage.getEClassifier(name) != null) {
                name = String.valueOf(baseName) + "_" + j3;
                ++j3;
            }
            eDataType.setName(name);
            if (recordDemandCreatedEDataType) {
                this.demandCreatedEDataTypes.add(eDataType);
                ePackage.getEClassifiers().add((Object)eDataType);
            }
            eClassifier = eDataType;
        }
        return eClassifier;
    }

    protected EClass resolveMapEntry(EPackage ePackage, EClassifier keyEClassifier, EClassifier valueEClassifier) {
        Iterator j = ePackage.getEClassifiers().iterator();
        while (j.hasNext()) {
            EStructuralFeature valueFeature;
            EClass mapEntryInterface;
            EStructuralFeature keyFeature;
            EClassifier ePackageClassifier = (EClassifier)j.next();
            if (!(ePackageClassifier instanceof EClass) || !"java.util.Map.Entry".equals(ePackageClassifier.getInstanceClassName()) && !"java.util.Map$Entry".equals(ePackageClassifier.getInstanceClassName()) || (keyFeature = (mapEntryInterface = (EClass)ePackageClassifier).getEStructuralFeature("key")) == null || keyFeature.getEType() != keyEClassifier || keyFeature.isMany() || (valueFeature = mapEntryInterface.getEStructuralFeature("value")) == null || valueFeature.getEType() != valueEClassifier || valueFeature.isMany()) continue;
            return mapEntryInterface;
        }
        return null;
    }

    protected void sort(EList eList, final Map nameToIDMap) {
        TreeSet ordered = new TreeSet(new Comparator(){

            public boolean equals(Object object) {
                return object == this;
            }

            public int compare(Object firstObject, Object secondObject) {
                int firstValue = JavaEcoreBuilder.this.getOrderingValue((ENamedElement)firstObject, nameToIDMap);
                int secondValue = JavaEcoreBuilder.this.getOrderingValue((ENamedElement)secondObject, nameToIDMap);
                return firstValue - secondValue;
            }
        });
        ordered.addAll(eList);
        int index = 0;
        Iterator i = ordered.iterator();
        while (i.hasNext()) {
            eList.move(index, i.next());
            ++index;
        }
    }

    protected int getOrderingValue(ENamedElement eNamedElement, Map nameToIDMap) {
        Integer result = (Integer)nameToIDMap.get(eNamedElement);
        if (result == null) {
            if (eNamedElement instanceof EClassifier) {
                String prefix = (String)this.ePackageToPrefixMap.get(eNamedElement.eContainer());
                String name = eNamedElement.getName();
                String id = CodeGenUtil.format((String)name, (char)'_', (String)prefix, (boolean)true).toUpperCase();
                result = (Integer)nameToIDMap.get(id);
            } else {
                String prefix = (String)this.ePackageToPrefixMap.get(eNamedElement.eContainer().eContainer());
                String eClassName = ((ENamedElement)eNamedElement.eContainer()).getName();
                String eFeatureName = eNamedElement.getName();
                String id = String.valueOf(CodeGenUtil.format((String)eClassName, (char)'_', (String)prefix, (boolean)true).toUpperCase()) + "__" + CodeGenUtil.format((String)eFeatureName, (char)'_', (String)prefix, (boolean)true).toUpperCase();
                result = (Integer)nameToIDMap.get(id);
            }
            if (result != null) {
                nameToIDMap.put(eNamedElement, result);
            }
        }
        if (result != null) {
            return result;
        }
        return Integer.MAX_VALUE;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public GenModel getGenModel() {
        return this.genModel;
    }

    protected void error(String message) {
        System.err.println("-->Error: " + message);
        this.status.add((IStatus)new Status(4, JavaImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, message, null));
    }
}

