/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.sdo.util;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.impl.EPropertyImpl;
import org.eclipse.emf.ecore.sdo.util.BasicESequence;
import org.eclipse.emf.ecore.sdo.util.DataGraphResourceFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.EMOFResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;

public final class SDOUtil {
    protected static Map registrations;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static List getInstanceProperties(EObject eObject) {
        UniqueEList result = new UniqueEList();
        EClass eClass = eObject.eClass();
        int i = 0;
        int count = eClass.getFeatureCount();
        while (i < count) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) {
                List features = (List)eObject.eGet(eStructuralFeature);
                int j = 0;
                int size = features.size();
                while (j < size) {
                    FeatureMap.Entry entry = (FeatureMap.Entry)features.get(j);
                    EStructuralFeature entryFeature = entry.getEStructuralFeature();
                    result.add(entryFeature);
                    ++j;
                }
            } else {
                result.add(eStructuralFeature);
            }
            ++i;
        }
        return result;
    }

    protected static EStructuralFeature getEStructuralFeature(EObject eObject, String propertyName) {
        EProperty property = SDOUtil.getType(eObject).getEProperty(propertyName);
        if (property == null) {
            EStructuralFeature eStructuralFeature;
            List instanceProperties = SDOUtil.getInstanceProperties(eObject);
            int i = 0;
            int size = instanceProperties.size();
            while (i < size) {
                eStructuralFeature = (EStructuralFeature)instanceProperties.get(i);
                if (eStructuralFeature.getName().equals(propertyName)) {
                    return eStructuralFeature;
                }
                ++i;
            }
            i = 0;
            size = instanceProperties.size();
            while (i < size) {
                eStructuralFeature = (EStructuralFeature)instanceProperties.get(i);
                if (ExtendedMetaData.INSTANCE.getName(eStructuralFeature).equals(propertyName)) {
                    return eStructuralFeature;
                }
                ++i;
            }
            throw new IllegalArgumentException("Class '" + eObject.eClass().getName() + "' does not have a feature named '" + propertyName + "'");
        }
        return property.getEStructuralFeature();
    }

    protected static EReference getContainmentEReference(EObject eObject, String propertyName) {
        EProperty property = SDOUtil.getType(eObject).getEProperty(propertyName);
        if (property == null) {
            throw new IllegalArgumentException("Class '" + eObject.eClass().getName() + "' does not have a feature named '" + propertyName + "'");
        }
        return SDOUtil.getContainmentEReference(property);
    }

    protected static EReference getContainmentEReference(EProperty property) {
        EReference reference;
        EStructuralFeature feature = property.getEStructuralFeature();
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            return reference;
        }
        throw new IllegalArgumentException("The feature '" + property.getName() + "' of '" + property.getContainingType().getName() + "' isn't a containment");
    }

    public static Object get(EObject eObject, String path) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            return SDOUtil.get(eObject, eStructuralFeature);
        }
        EProperty property = SDOUtil.getType(eObject).getEProperty(path);
        if (property != null) {
            return SDOUtil.get(eObject, property.getEStructuralFeature());
        }
        return Accessor.create(eObject, path).getAndRecyle();
    }

    public static void set(EObject eObject, String path, Object value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, value);
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                SDOUtil.set(eObject, property.getEStructuralFeature(), value);
            } else {
                Accessor.create(eObject, path).setAndRecyle(value);
            }
        }
    }

    public static boolean isSet(EObject eObject, String path) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            return SDOUtil.isSet(eObject, eStructuralFeature);
        }
        EProperty property = SDOUtil.getType(eObject).getEProperty(path);
        if (property != null) {
            return SDOUtil.isSet(eObject, property.getEStructuralFeature());
        }
        return Accessor.create(eObject, path).isSetAndRecyle();
    }

    public static void unset(EObject eObject, String path) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.unset(eObject, eStructuralFeature);
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                SDOUtil.unset(eObject, property.getEStructuralFeature());
            } else {
                Accessor.create(eObject, path).unsetAndRecyle();
            }
        }
    }

    public static DataObject getDataObject(EObject eObject, String path) {
        return (DataObject)SDOUtil.get(eObject, path);
    }

    public static List getList(EObject eObject, String path) {
        return (List)SDOUtil.get(eObject, path);
    }

    public static Sequence getSequence(EObject eObject, String path) {
        return (Sequence)SDOUtil.get(eObject, path);
    }

    public static void setDataObject(EObject eObject, String path, DataObject value) {
        SDOUtil.set(eObject, path, (Object)value);
    }

    public static void setList(EObject eObject, String path, List value) {
        SDOUtil.set(eObject, path, (Object)value);
    }

    protected static EStructuralFeature getFeature(EObject eObject, int propertyIndex) {
        return eObject.eClass().getEStructuralFeature(propertyIndex);
    }

    public static Object get(EObject eObject, int propertyIndex) {
        return SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex));
    }

    public static void set(EObject eObject, int propertyIndex, Object value) {
        SDOUtil.set(eObject, SDOUtil.getFeature(eObject, propertyIndex), value);
    }

    public static boolean isSet(EObject eObject, int propertyIndex) {
        return SDOUtil.isSet(eObject, SDOUtil.getFeature(eObject, propertyIndex));
    }

    public static void unset(EObject eObject, int propertyIndex) {
        SDOUtil.unset(eObject, SDOUtil.getFeature(eObject, propertyIndex));
    }

    public static DataObject getDataObject(EObject eObject, int propertyIndex) {
        return (DataObject)SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex));
    }

    public static List getList(EObject eObject, int propertyIndex) {
        return (List)SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex));
    }

    public static Sequence getSequence(EObject eObject, int propertyIndex) {
        return (Sequence)SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex));
    }

    public static void setDataObject(EObject eObject, int propertyIndex, DataObject value) {
        SDOUtil.set(eObject, SDOUtil.getFeature(eObject, propertyIndex), (Object)value);
    }

    public static void setList(EObject eObject, int propertyIndex, List value) {
        SDOUtil.set(eObject, SDOUtil.getFeature(eObject, propertyIndex), (Object)value);
    }

    public static Object get(EObject eObject, Property property) {
        return SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature());
    }

    public static void set(EObject eObject, Property property, Object value) {
        SDOUtil.set(eObject, ((EProperty)property).getEStructuralFeature(), value);
    }

    public static boolean isSet(EObject eObject, Property property) {
        return SDOUtil.isSet(eObject, ((EProperty)property).getEStructuralFeature());
    }

    public static void unset(EObject eObject, Property property) {
        SDOUtil.unset(eObject, ((EProperty)property).getEStructuralFeature());
    }

    public static DataObject getDataObject(EObject eObject, Property property) {
        return (DataObject)SDOUtil.get(eObject, ((EPropertyImpl)property).getEStructuralFeature());
    }

    public static List getList(EObject eObject, Property property) {
        return (List)SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature());
    }

    public static Sequence getSequence(EObject eObject, Property property) {
        return (Sequence)SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature());
    }

    public static void setDataObject(EObject eObject, Property property, DataObject value) {
        SDOUtil.set(eObject, ((EPropertyImpl)property).getEStructuralFeature(), (Object)value);
    }

    public static void setList(EObject eObject, Property property, List value) {
        SDOUtil.set(eObject, ((EProperty)property).getEStructuralFeature(), (Object)value);
    }

    public static DataObject createDataObject(EObject eObject, String propertyName) {
        EReference eReference = SDOUtil.getContainmentEReference(eObject, propertyName);
        EDataObject result = SDOUtil.create(eReference.getEReferenceType());
        if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
            ((List)eObject.eGet((EStructuralFeature)eReference)).add(result);
        } else {
            eObject.eSet((EStructuralFeature)eReference, (Object)result);
        }
        return result;
    }

    public static DataObject createDataObject(EObject eObject, int propertyIndex) {
        EReference eReference = SDOUtil.getContainmentEReference((EProperty)SDOUtil.getType(eObject).getProperties().get(propertyIndex));
        EDataObject result = SDOUtil.create(eReference.getEReferenceType());
        if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
            ((List)eObject.eGet((EStructuralFeature)eReference)).add(result);
        } else {
            eObject.eSet((EStructuralFeature)eReference, (Object)result);
        }
        return result;
    }

    public static DataObject createDataObject(EObject eObject, Property property) {
        EReference eReference = SDOUtil.getContainmentEReference((EProperty)property);
        EDataObject result = SDOUtil.create(eReference.getEReferenceType());
        if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
            ((List)eObject.eGet((EStructuralFeature)eReference)).add(result);
        } else {
            eObject.eSet((EStructuralFeature)eReference, (Object)result);
        }
        return result;
    }

    public static DataObject createDataObject(EObject eObject, String propertyName, String namespaceURI, String typeName) {
        return SDOUtil.createDataObject(eObject, propertyName, SDOUtil.getDataGraph(eObject).getType(namespaceURI, typeName));
    }

    public static DataObject createDataObject(EObject eObject, String propertyName, Type type) {
        EReference eReference = SDOUtil.getContainmentEReference(eObject, propertyName);
        EDataObject result = SDOUtil.create(type);
        if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
            ((List)eObject.eGet((EStructuralFeature)eReference)).add(result);
        } else {
            eObject.eSet((EStructuralFeature)eReference, (Object)result);
        }
        return result;
    }

    public static DataObject createDataObject(EObject eObject, int propertyIndex, String namespaceURI, String typeName) {
        return SDOUtil.createDataObject(eObject, propertyIndex, SDOUtil.getDataGraph(eObject).getType(namespaceURI, typeName));
    }

    public static DataObject createDataObject(EObject eObject, int propertyIndex, Type type) {
        EReference eReference = SDOUtil.getContainmentEReference((EProperty)SDOUtil.getType(eObject).getProperties().get(propertyIndex));
        EDataObject result = SDOUtil.create(type);
        if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
            ((List)eObject.eGet((EStructuralFeature)eReference)).add(result);
        } else {
            eObject.eSet((EStructuralFeature)eReference, (Object)result);
        }
        return result;
    }

    public static DataObject createDataObject(EObject eObject, Property property, Type type) {
        EReference eReference = SDOUtil.getContainmentEReference((EProperty)property);
        EDataObject result = SDOUtil.create(type);
        if (FeatureMapUtil.isMany((EObject)eObject, (EStructuralFeature)eReference)) {
            ((List)eObject.eGet((EStructuralFeature)eReference)).add(result);
        } else {
            eObject.eSet((EStructuralFeature)eReference, (Object)result);
        }
        return result;
    }

    public static void delete(EObject eObject) {
        EcoreUtil.remove((EObject)eObject);
        ArrayList contents = new ArrayList(eObject.eContents());
        int i = 0;
        int size = contents.size();
        while (i < size) {
            SDOUtil.delete((EObject)contents.get(i));
            ++i;
        }
        EClass eClass = eObject.eClass();
        int i2 = 0;
        int size2 = eClass.getFeatureCount();
        while (i2 < size2) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i2);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() && !SDOUtil.adaptProperty(eStructuralFeature).isReadOnly()) {
                eObject.eUnset(eStructuralFeature);
            }
            ++i2;
        }
    }

    public static DataObject getContainer(EObject eObject) {
        return (DataObject)eObject.eContainer();
    }

    public static EProperty getContainmentProperty(EObject eObject) {
        EReference eContainmentFeature = eObject.eContainmentFeature();
        return eContainmentFeature == null ? null : SDOUtil.adaptProperty((EStructuralFeature)eContainmentFeature);
    }

    public static EDataGraph getEDataGraph(EObject eObject) {
        ResourceSet resourceSet;
        Resource resource = eObject.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            EList eList = resourceSet.eAdapters();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.sdo.EDataGraph");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (EDataGraph)EcoreUtil.getAdapter((List)eList, (Object)clazz);
        }
        return null;
    }

    public static DataGraph getDataGraph(EObject eObject) {
        return SDOUtil.getEDataGraph(eObject);
    }

    public static EType getType(EObject eObject) {
        return SDOUtil.adaptType((EClassifier)eObject.eClass());
    }

    public static EType adaptType(EClassifier eClassifier) {
        Adapter result;
        EList adapters = eClassifier.eAdapters();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.ecore.sdo.EType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = EcoreUtil.getAdapter((List)adapters, (Object)clazz)) != null) {
            return (EType)result;
        }
        EType eType = SDOFactory.eINSTANCE.createEType();
        adapters.add(0, eType);
        return eType;
    }

    public static EProperty adaptProperty(EStructuralFeature eStructuralFeature) {
        Adapter result;
        EList adapters = eStructuralFeature.eAdapters();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.emf.ecore.sdo.EProperty");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((result = EcoreUtil.getAdapter((List)adapters, (Object)clazz)) != null) {
            return (EProperty)result;
        }
        EProperty eProperty = SDOFactory.eINSTANCE.createEProperty();
        adapters.add(eProperty);
        return eProperty;
    }

    public static EDataObject create(Type type) {
        return SDOUtil.create((EType)type);
    }

    public static EDataObject create(EType eType) {
        return SDOUtil.create((EClass)eType.getEClassifier());
    }

    public static EDataObject create(EClass eClass) {
        return (EDataObject)EcoreUtil.create((EClass)eClass);
    }

    public static Object writeReplace(EObject eObject) throws ObjectStreamException {
        EDataGraph eDataGraph = SDOUtil.getEDataGraph(eObject);
        if (eDataGraph != null) {
            return ((EDataGraph.Internal)((Object)eDataGraph)).getWriteReplacement(eObject);
        }
        throw new InvalidObjectException("The object must be in a datagraph to be serialized " + eObject);
    }

    public static Object get(EObject eObject, EProperty property) {
        return SDOUtil.get(eObject, property.getEStructuralFeature());
    }

    public static void set(EObject eObject, EProperty property, Object value) {
        SDOUtil.set(eObject, property.getEStructuralFeature(), value);
    }

    public static boolean isSet(EObject eObject, EProperty property) {
        return SDOUtil.isSet(eObject, property.getEStructuralFeature());
    }

    public static void unset(EObject eObject, EProperty property) {
        SDOUtil.unset(eObject, property.getEStructuralFeature());
    }

    protected static Object get(EObject eObject, EStructuralFeature feature) {
        Object result = eObject.eGet(feature);
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            result = new BasicESequence((FeatureMap.Internal)result);
        }
        return result;
    }

    protected static void set(EObject eObject, EStructuralFeature feature, Object value) {
        eObject.eSet(feature, value);
    }

    protected static boolean isSet(EObject eObject, EStructuralFeature feature) {
        return eObject.eIsSet(feature);
    }

    protected static void unset(EObject eObject, EStructuralFeature feature) {
        eObject.eUnset(feature);
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        SDOUtil.configureResourceSet((ResourceSet)result);
        return result;
    }

    protected static Map getRegistrations() {
        if (registrations == null) {
            HashMap<String, DataGraphResourceFactoryImpl> result = new HashMap<String, DataGraphResourceFactoryImpl>();
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            if (!(resourceSet.getResourceFactoryRegistry().getFactory(URI.createURI((String)"*.datagraph")) instanceof DataGraphResourceFactoryImpl)) {
                result.put("datagraph", new DataGraphResourceFactoryImpl());
            }
            if (!(resourceSet.getResourceFactoryRegistry().getFactory(URI.createURI((String)"*.ecore")) instanceof EcoreResourceFactoryImpl)) {
                result.put("ecore", (DataGraphResourceFactoryImpl)new EcoreResourceFactoryImpl());
            }
            if (!(resourceSet.getResourceFactoryRegistry().getFactory(URI.createURI((String)"*.emof")) instanceof EMOFResourceFactoryImpl)) {
                result.put("emof", (DataGraphResourceFactoryImpl)new EMOFResourceFactoryImpl());
            }
            if (resourceSet.getResourceFactoryRegistry().getFactory(URI.createURI((String)"*.xmi")) == null) {
                result.put("xmi", (DataGraphResourceFactoryImpl)new XMIResourceFactoryImpl());
            }
            if (resourceSet.getResourceFactoryRegistry().getFactory(URI.createURI((String)"*.xml")) == null) {
                result.put("*", (DataGraphResourceFactoryImpl)new XMLResourceFactoryImpl());
            }
            registrations = result;
        }
        return registrations;
    }

    public static void configureResourceSet(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().putAll(SDOUtil.getRegistrations());
    }

    public static EDataGraph loadDataGraph(InputStream inputStream, Map options) throws IOException {
        ResourceSet resourceSet = SDOUtil.createResourceSet();
        Resource resource = resourceSet.createResource(URI.createURI((String)"all.datagraph"));
        resource.load(inputStream, options);
        return (EDataGraph)resource.getContents().get(0);
    }

    public static BigDecimal getBigDecimal(EObject eObject, int propertyIndex) {
        return SDOUtil.getBigDecimal(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static BigDecimal getBigDecimal(EObject eObject, Property property) {
        return SDOUtil.getBigDecimal(SDOUtil.get(eObject, ((EPropertyImpl)property).getEStructuralFeature()));
    }

    public static BigDecimal getBigDecimal(EObject eObject, String path) {
        return SDOUtil.getBigDecimal(SDOUtil.get(eObject, path));
    }

    protected static BigDecimal getBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return new BigDecimal((String)value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to BigDecimal");
    }

    public static void setBigDecimal(EObject eObject, int propertyIndex, BigDecimal value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBigDecimal(EObject eObject, Property property, BigDecimal value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBigDecimal(EObject eObject, String path, BigDecimal value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, BigDecimal value) {
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.math.BigDecimal") {
            return value;
        }
        if (name == "java.math.BigInteger") {
            return value.toBigInteger();
        }
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte(value.byteValue());
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value.doubleValue());
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value.floatValue());
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value.intValue());
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value.longValue());
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value.shortValue());
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return value;
    }

    public static BigInteger getBigInteger(EObject eObject, int propertyIndex) {
        return SDOUtil.getBigInteger(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static BigInteger getBigInteger(EObject eObject, Property property) {
        return SDOUtil.getBigInteger(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static BigInteger getBigInteger(EObject eObject, String path) {
        return SDOUtil.getBigInteger(SDOUtil.get(eObject, path));
    }

    protected static BigInteger getBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            return new BigInteger((String)value);
        }
        if (value instanceof byte[]) {
            return new BigInteger((byte[])value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to BigInteger");
    }

    public static void setBigInteger(EObject eObject, int propertyIndex, BigInteger value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBigInteger(EObject eObject, Property property, BigInteger value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBigInteger(EObject eObject, String path, BigInteger value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, BigInteger value) {
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.math.BigInteger") {
            return value;
        }
        if (name == "java.math.BigDecimal") {
            return new BigDecimal(value);
        }
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte(value.byteValue());
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value.doubleValue());
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value.floatValue());
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value.intValue());
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value.longValue());
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value.shortValue());
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        if (name == "byte[]") {
            return value.toByteArray();
        }
        return value;
    }

    public static boolean getBoolean(EObject eObject, int propertyIndex) {
        return SDOUtil.getBoolean(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static boolean getBoolean(EObject eObject, Property property) {
        return SDOUtil.getBoolean(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static boolean getBoolean(EObject eObject, String path) {
        return SDOUtil.getBoolean(SDOUtil.get(eObject, path));
    }

    protected static boolean getBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value == null) {
            return false;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to boolean");
    }

    public static void setBoolean(EObject eObject, int propertyIndex, boolean value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBoolean(EObject eObject, Property property, boolean value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBoolean(EObject eObject, String path, boolean value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, boolean value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Boolean" || name == "boolean") {
            return value ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static byte getByte(EObject eObject, int propertyIndex) {
        return SDOUtil.getByte(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static byte getByte(EObject eObject, Property property) {
        return SDOUtil.getByte(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static byte getByte(EObject eObject, String path) {
        return SDOUtil.getByte(SDOUtil.get(eObject, path));
    }

    protected static byte getByte(Object value) {
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            return Byte.parseByte((String)value);
        }
        if (value == null) {
            return 0;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to byte");
    }

    public static void setByte(EObject eObject, int propertyIndex, byte value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setByte(EObject eObject, Property property, byte value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setByte(EObject eObject, String path, byte value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, byte value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte(value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value);
        }
        if (name == "java.math.BigDecimal") {
            return SDOUtil.getBigDecimal(new Byte(value));
        }
        if (name == "java.math.BigInteger") {
            return SDOUtil.getBigInteger(new Byte(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Byte(value);
    }

    public static byte[] getBytes(EObject eObject, int propertyIndex) {
        return SDOUtil.getBytes(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static byte[] getBytes(EObject eObject, Property property) {
        return SDOUtil.getBytes(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static byte[] getBytes(EObject eObject, String path) {
        return SDOUtil.getBytes(SDOUtil.get(eObject, path));
    }

    protected static byte[] getBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).toByteArray();
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to byte array");
    }

    public static void setBytes(EObject eObject, int propertyIndex, byte[] value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBytes(EObject eObject, Property property, byte[] value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setBytes(EObject eObject, String path, byte[] value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, byte[] value) {
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "byte[]") {
            return value;
        }
        if (name == "java.math.BigInteger") {
            return new BigInteger(value);
        }
        return value;
    }

    public static char getChar(EObject eObject, int propertyIndex) {
        return SDOUtil.getChar(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static char getChar(EObject eObject, Property property) {
        return SDOUtil.getChar(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static char getChar(EObject eObject, String path) {
        return SDOUtil.getChar(SDOUtil.get(eObject, path));
    }

    protected static char getChar(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            return ((String)value).charAt(0);
        }
        if (value == null) {
            return '\u0000';
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to char");
    }

    public static void setChar(EObject eObject, int propertyIndex, char value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setChar(EObject eObject, Property property, char value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setChar(EObject eObject, String path, char value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, char value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Character" || name == "char") {
            return new Character(value);
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Character(value);
    }

    public static Date getDate(EObject eObject, int propertyIndex) {
        return SDOUtil.getDate(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static Date getDate(EObject eObject, Property property) {
        return SDOUtil.getDate(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static Date getDate(EObject eObject, String path) {
        return SDOUtil.getDate(SDOUtil.get(eObject, path));
    }

    protected static Date getDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to Date");
    }

    public static void setDate(EObject eObject, int propertyIndex, Date value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setDate(EObject eObject, Property property, Date value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setDate(EObject eObject, String path, Date value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, Date value) {
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.util.Date") {
            return value;
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value.getTime());
        }
        return value;
    }

    public static double getDouble(EObject eObject, int propertyIndex) {
        return SDOUtil.getDouble(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static double getDouble(EObject eObject, Property property) {
        return SDOUtil.getDouble(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static double getDouble(EObject eObject, String path) {
        return SDOUtil.getDouble(SDOUtil.get(eObject, path));
    }

    protected static double getDouble(Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value == null) {
            return 0.0;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to double");
    }

    public static void setDouble(EObject eObject, int propertyIndex, double value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setDouble(EObject eObject, Property property, double value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setDouble(EObject eObject, String path, double value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, double value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer((int)value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long((long)value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return SDOUtil.getBigDecimal(new Double(value));
        }
        if (name == "java.math.BigInteger") {
            return SDOUtil.getBigInteger(new Double(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Double(value);
    }

    public static float getFloat(EObject eObject, int propertyIndex) {
        return SDOUtil.getFloat(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static float getFloat(EObject eObject, Property property) {
        return SDOUtil.getFloat(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static float getFloat(EObject eObject, String path) {
        return SDOUtil.getFloat(SDOUtil.get(eObject, path));
    }

    protected static float getFloat(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            return Float.parseFloat((String)value);
        }
        if (value == null) {
            return 0.0f;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to float");
    }

    public static void setFloat(EObject eObject, int propertyIndex, float value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setFloat(EObject eObject, Property property, float value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setFloat(EObject eObject, String path, float value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, float value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer((int)value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long((long)value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return SDOUtil.getBigDecimal(new Float(value));
        }
        if (name == "java.math.BigInteger") {
            return SDOUtil.getBigInteger(new Float(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Float(value);
    }

    public static int getInt(EObject eObject, int propertyIndex) {
        return SDOUtil.getInt(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static int getInt(EObject eObject, Property property) {
        return SDOUtil.getInt(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static int getInt(EObject eObject, String path) {
        return SDOUtil.getInt(SDOUtil.get(eObject, path));
    }

    protected static int getInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value == null) {
            return 0;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to int");
    }

    public static void setInt(EObject eObject, int propertyIndex, int value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setInt(EObject eObject, Property property, int value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setInt(EObject eObject, String path, int value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, int value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return SDOUtil.getBigDecimal(new Integer(value));
        }
        if (name == "java.math.BigInteger") {
            return SDOUtil.getBigInteger(new Integer(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Integer(value);
    }

    public static long getLong(EObject eObject, int propertyIndex) {
        return SDOUtil.getLong(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static long getLong(EObject eObject, Property property) {
        return SDOUtil.getLong(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static long getLong(EObject eObject, String path) {
        return SDOUtil.getLong(SDOUtil.get(eObject, path));
    }

    protected static long getLong(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value == null) {
            return 0L;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to long");
    }

    public static void setLong(EObject eObject, int propertyIndex, long value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setLong(EObject eObject, Property property, long value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setLong(EObject eObject, String path, long value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, long value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer((int)value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short((short)value);
        }
        if (name == "java.math.BigDecimal") {
            return SDOUtil.getBigDecimal(new Long(value));
        }
        if (name == "java.math.BigInteger") {
            return SDOUtil.getBigInteger(new Long(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        if (name == "java.util.Date") {
            return new Date(value);
        }
        return new Long(value);
    }

    public static short getShort(EObject eObject, int propertyIndex) {
        return SDOUtil.getShort(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static short getShort(EObject eObject, Property property) {
        return SDOUtil.getShort(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static short getShort(EObject eObject, String path) {
        return SDOUtil.getShort(SDOUtil.get(eObject, path));
    }

    protected static short getShort(Object value) {
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            return Short.parseShort((String)value);
        }
        if (value == null) {
            return 0;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to short");
    }

    public static void setShort(EObject eObject, int propertyIndex, short value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setShort(EObject eObject, Property property, short value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setShort(EObject eObject, String path, short value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, short value) {
        String name = eStructuralFeature.getEType().getInstanceClassName();
        if (name == "java.lang.Byte" || name == "byte") {
            return new Byte((byte)value);
        }
        if (name == "java.lang.Double" || name == "double") {
            return new Double(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return new Integer(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return new Long(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return new Short(value);
        }
        if (name == "java.math.BigDecimal") {
            return SDOUtil.getBigDecimal(new Short(value));
        }
        if (name == "java.math.BigInteger") {
            return SDOUtil.getBigInteger(new Short(value));
        }
        if (name == "java.lang.String") {
            return String.valueOf(value);
        }
        return new Short(value);
    }

    public static String getString(EObject eObject, int propertyIndex) {
        return SDOUtil.getString(SDOUtil.get(eObject, SDOUtil.getFeature(eObject, propertyIndex)));
    }

    public static String getString(EObject eObject, Property property) {
        return SDOUtil.getString(SDOUtil.get(eObject, ((EProperty)property).getEStructuralFeature()));
    }

    public static String getString(EObject eObject, String path) {
        return SDOUtil.getString(SDOUtil.get(eObject, path));
    }

    protected static String getString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return String.valueOf(value);
        }
        if (value == null) {
            return null;
        }
        throw new IllegalArgumentException("The value of type '" + value.getClass().getName() + "' cannot be converted to String");
    }

    public static void setString(EObject eObject, int propertyIndex, String value) {
        EStructuralFeature eStructuralFeature = SDOUtil.getFeature(eObject, propertyIndex);
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setString(EObject eObject, Property property, String value) {
        EStructuralFeature eStructuralFeature = ((EProperty)property).getEStructuralFeature();
        SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
    }

    public static void setString(EObject eObject, String path, String value) {
        EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(path);
        if (eStructuralFeature != null) {
            SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
        } else {
            EProperty property = SDOUtil.getType(eObject).getEProperty(path);
            if (property != null) {
                eStructuralFeature = property.getEStructuralFeature();
                SDOUtil.set(eObject, eStructuralFeature, SDOUtil.getSetValue(eStructuralFeature, value));
            } else {
                Accessor accessor = Accessor.create(eObject, path);
                accessor.setAndRecyle(SDOUtil.getSetValue(accessor.getEStructuralFeature(), value));
            }
        }
    }

    protected static Object getSetValue(EStructuralFeature eStructuralFeature, String value) {
        EClassifier eType = eStructuralFeature.getEType();
        if (value == null) {
            return eType.getDefaultValue();
        }
        String name = eType.getInstanceClassName();
        if (name == "java.lang.String") {
            return value;
        }
        if (name == "java.lang.Byte" || name == "byte") {
            return Byte.valueOf(value);
        }
        if (name == "java.lang.Double" || name == "double" || name == "java.lang.Number") {
            return Double.valueOf(value);
        }
        if (name == "java.lang.Float" || name == "float") {
            return new Float(value);
        }
        if (name == "java.lang.Integer" || name == "int") {
            return Integer.valueOf(value);
        }
        if (name == "java.lang.Long" || name == "long") {
            return Long.valueOf(value);
        }
        if (name == "java.lang.Short" || name == "short") {
            return Short.valueOf(value);
        }
        if (name == "java.lang.Character" || name == "char") {
            return new Character(value.charAt(0));
        }
        if (name == "java.math.BigDecimal") {
            return SDOUtil.getBigDecimal(value);
        }
        if (name == "java.math.BigInteger") {
            return SDOUtil.getBigInteger(value);
        }
        if (name == "java.lang.Boolean" || name == "boolean") {
            return Boolean.valueOf(value);
        }
        return value;
    }

    protected static final class Accessor {
        static final Pool pool = new Pool();
        protected static final int NO_INDEX = -1;
        protected EObject eObject;
        protected EStructuralFeature feature;
        protected int index;

        public static Accessor create(EObject eObject, String path) {
            Accessor result = pool.get();
            result.init(eObject, path);
            return result;
        }

        protected Accessor() {
        }

        protected Accessor(EObject eObject, String path) {
            this.init(eObject, path);
        }

        protected void init(EObject eObject, String path) {
            this.eObject = eObject;
            this.process(path);
        }

        public Object get() {
            if (this.feature == null) {
                return this.eObject;
            }
            Object value = this.eObject.eGet(this.feature, true);
            if (this.index >= 0) {
                if ((value = ((List)value).get(this.index)) instanceof FeatureMap.Entry) {
                    value = ((FeatureMap.Entry)value).getValue();
                }
            } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)this.feature)) {
                value = new BasicESequence((FeatureMap.Internal)value);
            }
            return value;
        }

        public Object getAndRecyle() {
            pool.recycle(this);
            return this.get();
        }

        public void set(Object newValue) {
            if (this.index >= 0) {
                List list = (List)this.eObject.eGet(this.feature, true);
                list.set(this.index, newValue);
            } else {
                this.eObject.eSet(this.feature, newValue);
            }
        }

        public void setAndRecyle(Object newValue) {
            pool.recycle(this);
            this.set(newValue);
        }

        public boolean isSet() {
            return this.eObject.eIsSet(this.feature);
        }

        public boolean isSetAndRecyle() {
            pool.recycle(this);
            return this.isSet();
        }

        public void unset() {
            this.eObject.eUnset(this.feature);
        }

        public void unsetAndRecyle() {
            pool.recycle(this);
            this.unset();
        }

        public void recycle() {
            pool.recycle(this);
        }

        public EObject getEObject() {
            return this.eObject;
        }

        protected void setEObject(EObject eObject) {
            this.eObject = eObject;
            this.feature = null;
            this.index = -1;
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.feature;
        }

        protected void setFeatureName(String name) {
            this.feature = name != null ? SDOUtil.getEStructuralFeature(this.eObject, name) : null;
            this.index = -1;
        }

        protected int getIndex() {
            return this.index;
        }

        protected void setIndex(int index) {
            this.index = index;
            if (!FeatureMapUtil.isMany((EObject)this.eObject, (EStructuralFeature)this.feature)) {
                throw new IndexOutOfBoundsException("Index applies only to multi-valued features.");
            }
        }

        protected void process(String pathString) {
            TokenList tokens = new TokenList(pathString.toCharArray());
            int size = tokens.size();
            int x = 0;
            if ("/".equals(tokens.peek(0))) {
                this.setEObject(EcoreUtil.getRootContainer((EObject)this.eObject));
                ++x;
            }
            while (x < size) {
                String token = tokens.peek(x);
                char c = token.charAt(0);
                if ('/' == c) {
                    this.setEObject((EObject)this.get());
                } else if ("..".equals(token)) {
                    EObject container = this.eObject.eContainer();
                    if (container == null) {
                        throw new IllegalArgumentException("No containing object for " + this.eObject);
                    }
                    this.setEObject(container);
                } else if ('.' == c) {
                    token = tokens.peek(++x);
                    int index = Integer.parseInt(token);
                    this.setIndex(index);
                } else if ('[' == c) {
                    token = tokens.peek(++x);
                    char following = tokens.peek(x + 1).charAt(0);
                    if ('=' != following) {
                        int index = Integer.parseInt(token) - 1;
                        this.setIndex(index);
                        ++x;
                    } else {
                        String attributeValue;
                        ++x;
                        if ("\"".equals(attributeValue = tokens.peek(++x))) {
                            ++x;
                            attributeValue = tokens.peek(++x);
                        }
                        ++x;
                        int index = Accessor.matchingIndex((List)this.get(), token, attributeValue);
                        if (index < 0) {
                            this.setEObject(null);
                        } else {
                            this.setIndex(index);
                        }
                    }
                } else if ('@' == c) {
                    ++x;
                } else {
                    this.setFeatureName(token);
                }
                ++x;
            }
        }

        protected static int matchingIndex(List eObjects, String attributeName, String attributeValue) {
            int i = 0;
            int size = eObjects.size();
            while (i < size) {
                String testString;
                Object test;
                EObject eObject = (EObject)eObjects.get(i);
                EStructuralFeature feature = SDOUtil.getType(eObject).getEProperty(attributeName).getEStructuralFeature();
                if (feature != null && (test = eObject.eGet(feature, true)) != null && attributeValue.equals(testString = EcoreUtil.convertToString((EDataType)((EDataType)feature.getEType()), (Object)test))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public String toString() {
            StringBuffer result = new StringBuffer("Accessor (object:");
            result.append(this.eObject == null ? "null" : this.eObject.toString());
            result.append(", feature:");
            result.append(this.feature == null ? "null" : this.feature.getName());
            result.append(", index:");
            result.append(this.index);
            result.append(")");
            return result.toString();
        }

        protected static class Pool
        extends BasicEList {
            protected Accessor[] accessors;

            public Pool() {
                super(10);
            }

            protected Object[] newData(int capacity) {
                this.accessors = new Accessor[capacity];
                return this.accessors;
            }

            public synchronized Accessor get() {
                if (this.size > 0) {
                    return this.accessors[--this.size];
                }
                return new Accessor();
            }

            public synchronized void recycle(Accessor accessor) {
                int minimumCapacity = this.size + 1;
                if (minimumCapacity > this.data.length) {
                    this.grow(minimumCapacity);
                }
                this.accessors[this.size++] = accessor;
            }
        }

        protected static class TokenList
        extends BasicEList {
            public TokenList(char[] path) {
                super(4);
                int pathLength = path.length;
                StringBuffer token = new StringBuffer();
                char c = '\u0000';
                char stringConstant = '\u0000';
                int pos = 0;
                while (pos < pathLength) {
                    char cNext;
                    char cPrev = c;
                    c = path[pos];
                    char c2 = cNext = pos < pathLength - 1 ? path[pos + 1] : (char)'\u0000';
                    if (stringConstant != '\u0000') {
                        if (c == stringConstant) {
                            this.endToken(token, true);
                            stringConstant = '\u0000';
                        } else {
                            token.append(c);
                        }
                    } else {
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case '\r': 
                            case ' ': {
                                if (cPrev != ' ') {
                                    this.endToken(token, false);
                                }
                                c = ' ';
                                break;
                            }
                            case '\"': 
                            case '\'': {
                                this.endToken(token, false);
                                stringConstant = c;
                                break;
                            }
                            case '.': 
                            case '/': 
                            case ':': {
                                if (cPrev != c) {
                                    this.endToken(token, false);
                                }
                                token.append(c);
                                if (cNext == c) break;
                                this.endToken(token, false);
                                break;
                            }
                            case '(': 
                            case ')': 
                            case '*': 
                            case '@': 
                            case '[': 
                            case ']': 
                            case '|': {
                                this.endToken(token, false);
                                this.add(String.valueOf(c));
                                break;
                            }
                            case '!': {
                                this.endToken(token, false);
                                token.append(c);
                                break;
                            }
                            case '=': {
                                this.endToken(token, false);
                                this.add(String.valueOf(c));
                                break;
                            }
                            default: {
                                token.append(c);
                            }
                        }
                    }
                    ++pos;
                }
                this.endToken(token, false);
            }

            public String peek() {
                return this.size > 0 ? (String)this.data[0] : " ";
            }

            public String peek(int index) {
                return index < this.size ? (String)this.data[index] : " ";
            }

            public TokenList pop() {
                this.remove(0);
                return this;
            }

            public TokenList pop(int count) {
                while (count-- > 0) {
                    this.remove(count);
                }
                return this;
            }

            protected void endToken(StringBuffer token, boolean includeEmpty) {
                if (includeEmpty || token.length() > 0) {
                    this.add(token.toString());
                }
                token.setLength(0);
            }

            protected boolean canContainNull() {
                return false;
            }

            protected Object[] newData(int capacity) {
                return new String[capacity];
            }
        }
    }
}

