/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jmerge.JControlModel;
import org.eclipse.emf.codegen.jmerge.JMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;

public class CodeGen
implements IPlatformRunnable {
    public Object run(Object object) {
        try {
            final String[] arguments = (String[])object;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        block9: {
                            try {
                                String templateFile = arguments[0];
                                File file = new File(templateFile);
                                if (file.exists()) {
                                    templateFile = file.getAbsoluteFile().toURL().toString();
                                }
                                Path targetPath = new Path(new File(arguments[1]).getAbsolutePath());
                                progressMonitor.beginTask("", 5);
                                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_CompilingTemplate_message", new Object[]{templateFile}));
                                JControlModel jControlModel = arguments.length > 2 ? new JControlModel(arguments[2]) : null;
                                progressMonitor.worked(1);
                                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_ParsingTemplate_message", new Object[]{templateFile}));
                                JETCompiler jetCompiler = new JETCompiler(templateFile);
                                jetCompiler.parse();
                                progressMonitor.worked(1);
                                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_GeneratingJava_message", new Object[]{templateFile}));
                                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                                jetCompiler.generate(outputStream);
                                ByteArrayInputStream contents = new ByteArrayInputStream(outputStream.toByteArray());
                                progressMonitor.worked(1);
                                Path projectTargetPath = new Path("/Result/" + jetCompiler.getSkeleton().getPackageName().replace('.', '/'));
                                IContainer container = CodeGenUtil.findOrCreateContainer((IPath)projectTargetPath, true, (IPath)targetPath, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                IFile targetFile = container.getFile((IPath)new Path(String.valueOf(jetCompiler.getSkeleton().getClassName()) + ".java"));
                                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_Updating_message", new Object[]{targetFile.getLocation()}));
                                if (targetFile.exists()) {
                                    if (jControlModel != null) {
                                        JMerger jMerger = new JMerger();
                                        jMerger.setControlModel(jControlModel);
                                        jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(outputStream.toString()));
                                        jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForURI(targetPath.toString()));
                                        jMerger.merge();
                                        ByteArrayInputStream mergedContents = new ByteArrayInputStream(jMerger.getTargetCompilationUnitContents().getBytes());
                                        targetFile.setContents((InputStream)mergedContents, true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                        break block9;
                                    } else {
                                        targetFile.setContents((InputStream)contents, true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                    }
                                    break block9;
                                }
                                targetFile.create((InputStream)contents, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                            }
                            catch (MalformedURLException exception) {
                                System.err.println(CodeGenPlugin.getPlugin().getString("_UI_BadURL_message", new Object[]{arguments[0]}));
                                exception.printStackTrace();
                            }
                        }
                        Object var14_17 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    progressMonitor.done();
                }
            };
            workspace.run(runnable, (IProgressMonitor)new CodeGenUtil.StreamProgressMonitor(System.out));
            return new Integer(0);
        }
        catch (Exception exception) {
            System.err.println(CodeGenPlugin.getPlugin().getString("_UI_UsageArguments_message"));
            exception.printStackTrace();
            return new Integer(1);
        }
    }
}

