/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EProperty.java,v 1.4 2004/12/16 21:53:08 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

import commonj.sdo.Property;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>EProperty</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.sdo.EProperty#getEStructuralFeature <em>EStructural Feature</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEProperty()
 * @model
 * @generated
 */
public interface EProperty extends EObject, Property
{
  /**
   * Returns the value of the '<em><b>EStructural Feature</b></em>' reference.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>EStructural Feature</em>' reference isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>EStructural Feature</em>' reference.
   * @see #setEStructuralFeature(EStructuralFeature)
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#getEProperty_EStructuralFeature()
   * @model resolveProxies="false" required="true"
   * @generated
   */
  EStructuralFeature getEStructuralFeature();

  /**
   * Sets the value of the '{@link org.eclipse.emf.ecore.sdo.EProperty#getEStructuralFeature <em>EStructural Feature</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>EStructural Feature</em>' reference.
   * @see #getEStructuralFeature()
   * @generated
   */
  void setEStructuralFeature(EStructuralFeature value);

  /**
   * Returns true if values for this property cannot be modified using the SDO APIs.
   * When true, DataObject.set(Property) throws an exception.
   * Values may change due to other factors, such as services operating on DataObjects.
   * @return true if values for this property cannot be modified.
   */
  boolean isReadOnly();

  void setReadOnly(boolean readOnly);

} // EProperty
