/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.rose.RoseImporterPlugin;
import org.eclipse.emf.importer.rose.builder.RoseUtil;
import org.eclipse.emf.importer.rose.builder.UnitTreeNode;
import org.eclipse.emf.importer.util.ImporterUtil;

public class RoseImporter
extends ModelImporter {
    protected Map pathMap;
    protected boolean noQualify = false;
    protected boolean unsettablePrimitive = false;
    protected RoseUtil roseUtil;
    protected UnitTreeNode unitTreeNode;
    protected Map roseEPackageInformationMap;

    public void dispose() {
        if (this.pathMap != null) {
            this.pathMap.clear();
            this.pathMap = null;
        }
        if (this.roseEPackageInformationMap != null) {
            this.roseEPackageInformationMap.clear();
            this.roseEPackageInformationMap = null;
        }
        super.dispose();
    }

    public String getID() {
        return "org.eclipse.emf.importer.rose";
    }

    public Map getPathMap() {
        if (this.pathMap == null) {
            this.pathMap = new HashMap();
        }
        return this.pathMap;
    }

    public void setModelLocation(String location) {
        boolean isEqual;
        boolean bl = location == null ? this.getModelLocation() == null : (isEqual = location.equals(this.getModelLocation()));
        if (!isEqual) {
            this.getPathMap().clear();
        }
        super.setModelLocation(location);
    }

    public boolean isNoQualify() {
        return this.noQualify;
    }

    public void setNoQualify(boolean noQualify) {
        this.noQualify = noQualify;
    }

    public boolean isUnsettablePrimitive() {
        return this.unsettablePrimitive;
    }

    public void setUnsettablePrimitive(boolean unsettablePrimitive) {
        this.unsettablePrimitive = unsettablePrimitive;
    }

    public File computeRoseModelFile() {
        File modelFile;
        URI modelURI = this.getFirstModelLocationURI(true);
        if (modelURI != null && (modelFile = new File(modelURI.isFile() ? modelURI.toFileString() : modelURI.toString())).isFile()) {
            return modelFile;
        }
        return null;
    }

    public void clearEPackagesCollections() {
        super.clearEPackagesCollections();
        this.roseEPackageInformationMap = null;
    }

    public IStatus loadPathMap(IProgressMonitor progressMonitor) throws Exception {
        Status status;
        block5: {
            boolean hasSymbolWithoutValue;
            File roseModelFile;
            block6: {
                this.clearEPackagesCollections();
                status = null;
                roseModelFile = this.computeRoseModelFile();
                if (roseModelFile != null) break block6;
                status = new Status(4, "org.eclipse.emf.importer", 264, RoseImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidRoseModel_message"), null);
                break block5;
            }
            String roseModelAbsolutePath = roseModelFile.getAbsolutePath();
            progressMonitor.beginTask("", 2);
            progressMonitor.subTask(RoseImporterPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{roseModelAbsolutePath}));
            Map pathMap = this.getPathMap();
            do {
                this.roseUtil = this.createRoseUtil();
                this.roseUtil.getRoseEcoreBuilder().noQualify = this.noQualify;
                this.roseUtil.getRoseEcoreBuilder().unsettablePrimitive = this.unsettablePrimitive;
                this.roseUtil.getVariableToDirectoryMap().putAll(pathMap);
                this.unitTreeNode = this.roseUtil.createRoseUnitTreeAndTable(roseModelAbsolutePath, null);
                if (this.unitTreeNode == null) {
                    status = new Status(4, "org.eclipse.emf.importer", 264, RoseImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidRoseModel_message"), null);
                    break block5;
                }
                hasSymbolWithoutValue = this.adjustPathMap(this.roseUtil);
            } while (this.adjustKnownPathMapSymbols(roseModelAbsolutePath));
            if (!hasSymbolWithoutValue) {
                status = ImporterUtil.mergeStatus((IStatus)status, (IStatus)this.roseUtil.getStatus());
            }
            if (this.getGenModelFileName() != null) break block5;
            String fileName = this.unitTreeNode.getNodes().size() != 1 ? roseModelFile.getName() : ((UnitTreeNode)this.unitTreeNode.getNodes().get(0)).getRoseFileName();
            int index = fileName.lastIndexOf(File.separatorChar);
            if (index >= 0) {
                fileName = fileName.substring(index + 1);
            }
            if ((index = fileName.lastIndexOf(".")) >= 0) {
                fileName = fileName.substring(0, index);
            }
            this.setGenModelFileName(String.valueOf(fileName) + ".genmodel");
        }
        return status != null ? status : Status.OK_STATUS;
    }

    protected boolean adjustPathMap(RoseUtil roseUtil) {
        boolean hasSymbolWithoutValue = false;
        Map currentPathMap = this.getPathMap();
        HashMap<String, String> pathMap = new HashMap<String, String>();
        Iterator i = roseUtil.getVariableToDirectoryMap().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String symbol = (String)entry.getKey();
            if (symbol == null) continue;
            String value = (String)entry.getValue();
            if (value == null) {
                value = (String)currentPathMap.get(symbol);
            }
            pathMap.put(symbol, value);
            boolean bl = hasSymbolWithoutValue = hasSymbolWithoutValue || value == null;
        }
        currentPathMap.clear();
        currentPathMap.putAll(pathMap);
        return hasSymbolWithoutValue;
    }

    protected boolean adjustKnownPathMapSymbols(String roseModelAbsolutePath) {
        return false;
    }

    public boolean hasRoseGenPackageProperties(EPackage ePackage) {
        return this.roseEPackageInformationMap != null && this.roseEPackageInformationMap.get(ePackage) != null;
    }

    protected IStatus doComputeEPackages(IProgressMonitor progressMonitor) throws Exception {
        progressMonitor.beginTask("", 2);
        IStatus status = this.loadPathMap(progressMonitor);
        if (status.isOK()) {
            if (this.getPathMap().values().contains(null) && !this.roseUtil.getStatus().isOK()) {
                status = new Status(4, "org.eclipse.emf.importer", 264, RoseImporterPlugin.INSTANCE.getString("_UI_SpecifyTheSymbolLocations_message"), null);
            } else {
                this.roseUtil.createExtent4RoseUnitTree(this.unitTreeNode);
                this.roseUtil.processUnitTree(this.unitTreeNode);
                this.roseEPackageInformationMap = this.roseUtil.getEPackageToInformationMap();
                status = ImporterUtil.createStatus((IStatus)this.roseUtil.getStatus(), (String)"org.eclipse.emf.importer", (int)1);
                Iterator i = this.roseUtil.getEPackageToInformationMap().entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    List information = (List)entry.getValue();
                    if (information == null) continue;
                    ModelImporter.EPackageInfo ePackageInfo = this.getEPackageInfo((EPackage)entry.getKey());
                    ePackageInfo.setBasePackage((String)information.get(0));
                    ePackageInfo.setPrefix((String)information.get(1));
                }
                this.traverseEPackages(this.unitTreeNode);
            }
        }
        progressMonitor.done();
        return status;
    }

    protected void traverseEPackages(UnitTreeNode subNode) {
        this.getEPackages().addAll(subNode.getExtent());
        Iterator i = subNode.getExtent().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            ModelImporter.EPackageInfo ePackageInfo = this.getEPackageInfo(ePackage);
            String ecoreFileName = null;
            String roseFileName = subNode.getRoseFileName();
            int indexOfSlash = roseFileName.lastIndexOf(File.separator);
            GenPackage genPackage = this.getGenPackage(ePackage);
            if (genPackage != null) {
                String ePackagePath = genPackage.getEcorePackage().eResource().getURI().lastSegment();
                ecoreFileName = URI.decode((String)ePackagePath);
            } else if (roseFileName.endsWith(".cat") && indexOfSlash != -1) {
                String baseName = roseFileName.substring(indexOfSlash + 1, roseFileName.length() - 4);
                int indexOfDot = baseName.lastIndexOf(".");
                if (indexOfDot != -1) {
                    baseName = baseName.substring(indexOfDot + 1);
                }
                ecoreFileName = String.valueOf(baseName) + ".ecore";
            } else {
                ecoreFileName = subNode.getExtent().size() == 1 ? String.valueOf(subNode.getName()) + ".ecore" : String.valueOf(ePackage.getName()) + ".ecore";
            }
            ePackageInfo.setEcoreFileName(ecoreFileName);
        }
        i = subNode.getNodes().iterator();
        while (i.hasNext()) {
            UnitTreeNode childTree = (UnitTreeNode)i.next();
            this.traverseEPackages(childTree);
        }
    }

    protected void adjustEPackages() {
    }

    protected void adjustGenModel(IProgressMonitor progressMonitor) {
        super.adjustGenModel(progressMonitor);
        GenModel genModel = this.getGenModel();
        String projectName = this.getModelProjectName();
        IPath genModelPath = this.getGenModelPath();
        URI modelURI = (URI)this.getModelLocationURIs().get(0);
        URI genModelURI = this.getGenModel().eResource().getURI();
        genModel.getForeignModel().add((Object)this.makeRelative(modelURI, genModelURI).toFileString());
        IPath projectLocation = this.getWorkspaceRoot().getProject(projectName).getLocation();
        projectLocation = projectLocation != null ? projectLocation.removeLastSegments(1) : this.getGenModelProjectLocation();
        Iterator i = this.getPathMap().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String value = (String)entry.getValue();
            if (value == null) continue;
            genModel.getForeignModel().add(entry.getKey());
            if (new Path(value).equals((Object)projectLocation)) {
                value = "..";
                int depth = genModelPath.segmentCount();
                while (depth > 2) {
                    value = String.valueOf(value) + "/..";
                    --depth;
                }
                genModel.getForeignModel().add((Object)value);
                continue;
            }
            genModel.getForeignModel().add((Object)value);
        }
    }

    protected void loadOriginalGenModel(URI genModelURI) {
        super.loadOriginalGenModel(genModelURI);
        try {
            Iterator values = this.getOriginalGenModel().getForeignModel().iterator();
            if (values.hasNext()) {
                URI modelURI = null;
                String modelFile = (String)values.next();
                if ((modelFile = modelFile.replace('\\', '/')).endsWith(".mdl")) {
                    URI genModelFileURI = this.createFileURI(this.getOriginalGenModelPath().toString());
                    modelURI = this.makeAbsolute(URI.createFileURI((String)modelFile), genModelFileURI);
                    this.setModelLocation(modelURI.toString());
                    while (values.hasNext()) {
                        String variable = (String)values.next();
                        String value = (String)values.next();
                        this.getPathMap().put(variable, value);
                    }
                }
            }
        }
        catch (Exception exception) {
            RoseImporterPlugin.INSTANCE.log(exception);
        }
    }

    protected RoseUtil createRoseUtil() {
        RoseUtil roseUtil = new RoseUtil(this.createResourceSet().getURIConverter());
        roseUtil.getRoseEcoreBuilder().noQualify = this.noQualify;
        roseUtil.getRoseEcoreBuilder().unsettablePrimitive = this.unsettablePrimitive;
        return roseUtil;
    }
}

