/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;

public abstract class ModelImporterApplication
implements IPlatformRunnable {
    protected ModelImporter modelImporter;
    protected boolean reload = false;
    protected IPath modelProjectLocationPath;
    protected IPath modelFragmentPath;
    protected IPath editProjectLocationPath;
    protected IPath editFragmentPath;
    protected IPath editorProjectLocationPath;
    protected IPath editorFragmentPath;
    protected IPath testsProjectLocationPath;
    protected IPath testsFragmentPath;
    protected String templatePath;
    protected String copyright;
    protected boolean sdo = false;
    protected String modelPluginID;
    protected List referencedEPackages;
    protected Map referencedGenModelPathToEPackageNSURIs;
    protected boolean quiet = false;
    protected static final String NL = System.getProperties().getProperty("line.separator");

    public ModelImporter getModelImporter() {
        if (this.modelImporter == null) {
            this.modelImporter = this.createModelImporter();
        }
        return this.modelImporter;
    }

    protected abstract ModelImporter createModelImporter();

    public Object run(final Object args) throws Exception {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor progressMonitor) throws CoreException {
                    try {
                        try {
                            ModelImporterApplication.this.run(progressMonitor, (String[])args);
                        }
                        catch (Exception exception) {
                            throw new CoreException((IStatus)new Status(4, ImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, "Error", (Throwable)exception));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        progressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                    }
                    progressMonitor.done();
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, this.getProgressMonitor());
            return new Integer(0);
        }
        catch (Exception exception) {
            if (!this.quiet) {
                exception.printStackTrace();
            }
            ImporterPlugin.INSTANCE.log(exception);
            return new Integer(1);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor progressMonitor, String[] arguments) throws Exception {
        try {
            progressMonitor.beginTask("", 1);
            if (arguments.length == 0 || "-help".equalsIgnoreCase(arguments[0].toString())) {
                this.printUsage();
            } else {
                this.processArguments(arguments, 0);
                this.execute((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        progressMonitor.done();
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.quiet ? new NullProgressMonitor() : new CodeGenUtil.StreamProgressMonitor(System.out);
    }

    public void printUsage() {
        System.out.println(this.getUsage());
    }

    protected abstract StringBuffer getUsage();

    protected StringBuffer appendLine(StringBuffer buffer, String line) {
        if (line != null) {
            buffer.append(line);
        }
        buffer.append(NL);
        return buffer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(IProgressMonitor progressMonitor) throws Exception {
        try {
            progressMonitor.beginTask("", 6);
            this.adjustAttributes((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            this.adjustModelImporter((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            this.computeEPackages((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            this.adjustEPackages((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            this.adjustGenModel((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            this.doExecute((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        progressMonitor.done();
    }

    protected void processArguments(String[] arguments, int index) {
        while (index < arguments.length) {
            index = this.processArgument(arguments, index);
        }
    }

    protected int processArgument(String[] arguments, int index) {
        if (arguments[index].equalsIgnoreCase("-reload")) {
            this.reload = true;
        } else if (arguments[index].equalsIgnoreCase("-modelProject")) {
            this.modelProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
            this.modelFragmentPath = new Path(arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-editProject")) {
            this.editProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
            this.editFragmentPath = new Path(arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-editorProject")) {
            this.editorProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
            this.editorFragmentPath = new Path(arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-testsProject")) {
            this.testsProjectLocationPath = new Path(new File(arguments[++index]).getAbsolutePath());
            this.testsFragmentPath = new Path(arguments[++index]);
        } else if (arguments[index].equalsIgnoreCase("-modelPluginID")) {
            this.modelPluginID = arguments[++index];
        } else if (arguments[index].equalsIgnoreCase("-copyright")) {
            this.copyright = arguments[++index];
        } else if (arguments[index].equalsIgnoreCase("-sdo")) {
            this.sdo = true;
        } else if (arguments[index].equalsIgnoreCase("-quiet")) {
            this.quiet = true;
        } else if (arguments[index].equalsIgnoreCase("-templatePath")) {
            this.templatePath = URI.createFileURI((String)new File(arguments[++index]).getAbsolutePath()).toString();
        } else if (arguments[index].equalsIgnoreCase("-refGenModel")) {
            Path genModelPath;
            HashSet<String> ePackageNSURIs;
            if (this.referencedGenModelPathToEPackageNSURIs == null) {
                this.referencedGenModelPathToEPackageNSURIs = new HashMap();
            }
            if ((ePackageNSURIs = (HashSet<String>)this.referencedGenModelPathToEPackageNSURIs.get(genModelPath = new Path(new File(arguments[++index]).getAbsolutePath()))) == null) {
                ePackageNSURIs = new HashSet<String>();
                this.referencedGenModelPathToEPackageNSURIs.put(genModelPath, ePackageNSURIs);
            }
            do {
                ePackageNSURIs.add(arguments[++index]);
            } while (index + 1 < arguments.length && !arguments[index + 1].startsWith("-"));
        } else {
            this.handleUnrecognizedArgument(arguments[index]);
        }
        return index + 1;
    }

    protected void handleUnrecognizedArgument(String argument) {
        throw new IllegalArgumentException("Unrecognized argument: '" + argument + "'");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void adjustAttributes(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("", 1);
            if (this.modelProjectLocationPath == null) {
                this.modelProjectLocationPath = new Path(new File(".").getAbsolutePath());
            }
            if (this.modelFragmentPath == null) {
                this.modelFragmentPath = new Path(".");
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        progressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void adjustModelImporter(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("", 1);
            ModelImporter modelImporter = this.getModelImporter();
            modelImporter.setUsePlatformURI(false);
            modelImporter.setGenModelProjectLocation(this.modelProjectLocationPath);
            if (this.modelPluginID != null) {
                modelImporter.setModelPluginID(this.modelPluginID);
            }
            if (this.modelProjectLocationPath != null) {
                modelImporter.setModelPluginDirectory(this.modelProjectLocationPath + "/./" + this.modelFragmentPath + "/.");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        progressMonitor.done();
    }

    protected void handleGenModelPath(IPath genModelFullPath) {
        ModelImporter modelImporter = this.getModelImporter();
        if (this.reload) {
            modelImporter.defineOriginalGenModelPath(genModelFullPath);
        } else {
            modelImporter.setGenModelContainerPath(genModelFullPath.removeLastSegments(1));
            modelImporter.setGenModelFileName(genModelFullPath.lastSegment());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void computeEPackages(IProgressMonitor progressMonitor) throws Exception {
        try {
            progressMonitor.beginTask("", 1);
            this.getModelImporter().computeEPackages((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        progressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void adjustEPackages(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("", 1);
            if (this.referencedGenModelPathToEPackageNSURIs != null) {
                Iterator i = this.referencedGenModelPathToEPackageNSURIs.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    IPath genModelPath = (IPath)entry.getKey();
                    Set ePackageNSURIs = (Set)entry.getValue();
                    ResourceSet resourceSet = this.getModelImporter().createResourceSet();
                    Resource resource = resourceSet.getResource(URI.createFileURI((String)genModelPath.toOSString()), true);
                    GenModel referencedGenModel = (GenModel)resource.getContents().get(0);
                    Iterator j = referencedGenModel.getGenPackages().iterator();
                    while (j.hasNext()) {
                        GenPackage genPackage = (GenPackage)j.next();
                        if (!ePackageNSURIs.contains(genPackage.getEcorePackage().getNsURI())) continue;
                        this.getModelImporter().getReferencedGenPackages().add(genPackage);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        progressMonitor.done();
    }

    protected void handleEPackage(EPackage ePackage, boolean generate) {
        this.getModelImporter().getEPackageInfo(ePackage).setGenerate(generate);
        if (!generate) {
            if (this.referencedEPackages == null) {
                this.referencedEPackages = new ArrayList();
            }
            this.referencedEPackages.add(ePackage);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void adjustGenModel(IProgressMonitor progressMonitor) {
        try {
            progressMonitor.beginTask("", 1);
            GenModel genModel = this.getModelImporter().getGenModel();
            if (this.editProjectLocationPath != null) {
                genModel.setEditDirectory(this.editProjectLocationPath + "/./" + this.editFragmentPath + "/.");
            }
            if (this.editorProjectLocationPath != null) {
                genModel.setEditorDirectory(this.editorProjectLocationPath + "/./" + this.editorFragmentPath + "/.");
            }
            if (this.templatePath != null) {
                genModel.setTemplateDirectory(this.templatePath);
                genModel.setDynamicTemplates(true);
            }
            if (this.copyright != null) {
                genModel.setCopyrightText(this.copyright);
            }
            if (this.sdo) {
                this.setSDODefaults(genModel);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        progressMonitor.done();
    }

    protected void setSDODefaults(GenModel genModel) {
        Generator.setSDODefaults((GenModel)genModel);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExecute(IProgressMonitor progressMonitor) throws Exception {
        try {
            progressMonitor.beginTask("", 3);
            this.getModelImporter().prepareGenModelAndEPackages((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            this.handleReferencedEPackages();
            this.getModelImporter().saveGenModelAndEPackages((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            progressMonitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        progressMonitor.done();
    }

    protected void handleReferencedEPackages() {
        if (this.referencedEPackages != null && !this.referencedEPackages.isEmpty()) {
            ModelImporter modelImporter = this.getModelImporter();
            GenModel genModel = modelImporter.getGenModel();
            Resource genModelResource = genModel.eResource();
            GenModel referencedGenModel = GenModelFactory.eINSTANCE.createGenModel();
            genModelResource.getContents().add((Object)referencedGenModel);
            referencedGenModel.initialize((Collection)this.referencedEPackages);
            genModel.getUsedGenPackages().addAll((Collection)referencedGenModel.getGenPackages());
            referencedGenModel.getForeignModel().addAll((Collection)genModel.getForeignModel());
            modelImporter.traverseGenPackages((List)referencedGenModel.getGenPackages());
            Iterator i = referencedGenModel.getGenPackages().iterator();
            while (i.hasNext()) {
                GenPackage genPackage = (GenPackage)i.next();
                EPackage ePackage = genPackage.getEcorePackage();
                if (ePackage.eResource() == null) {
                    modelImporter.addToResource(ePackage, genModelResource.getResourceSet());
                }
                if ("http://www.eclipse.org/emf/2002/Ecore".equals(ePackage.getNsURI())) {
                    if (referencedGenModel.getGenPackages().size() == 1) {
                        referencedGenModel.setModelName("ecore");
                        referencedGenModel.setBooleanFlagsField("eFlags");
                        referencedGenModel.setBooleanFlagsReservedBits(8);
                        continue;
                    }
                    i.remove();
                    GenModel ecoreGenModel = GenModelFactory.eINSTANCE.createGenModel();
                    genModel.eResource().getContents().add((Object)ecoreGenModel);
                    ecoreGenModel.getGenPackages().add((Object)genPackage);
                    ecoreGenModel.setBooleanFlagsField("eFlags");
                    ecoreGenModel.setBooleanFlagsReservedBits(8);
                    ecoreGenModel.getForeignModel().addAll((Collection)genModel.getForeignModel());
                    ecoreGenModel.setModelName("ecore");
                    continue;
                }
                if (referencedGenModel.getModelName() != null) continue;
                referencedGenModel.setModelName(genPackage.getPackageName());
            }
        }
    }
}

