/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.emf.importer.ui.contribution.ModelImporterUtil;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class EMFModelWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected IPath genModelContainerPath;
    protected String genModelFileName;
    protected IFile reloadFile;
    protected IFile modelFile;
    protected ModelImporterDescriptor suggestedDescriptor;
    protected boolean canFinish = false;

    public EMFModelWizard() {
        this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFWizardModel_title"));
    }

    public EMFModelWizard(IFile reloadFile) {
        this();
        this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_ReloadWizard_title"));
        this.reloadFile = reloadFile;
    }

    public void dispose() {
        this.selection = null;
        this.workbench = null;
        this.genModelContainerPath = null;
        this.reloadFile = null;
        super.dispose();
    }

    protected ImageDescriptor getDefaultImageDescriptor() {
        return ExtendedImageRegistry.INSTANCE.getImageDescriptor(ImporterPlugin.INSTANCE.getImage("full/wizban/NewGenModel"));
    }

    public void addPages() {
        if (this.reloadFile == null) {
            NewGenModelFileCreationPage page = new NewGenModelFileCreationPage("NewModelFileCreationPageID");
            page.setTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFModelWizard_name"));
            page.setDescription(ImporterPlugin.INSTANCE.getString("_UI_EMFModelWizard_description"));
            this.addPage((IWizardPage)page);
        } else {
            this.setForcePreviousAndNextButtons(true);
        }
        SelectionPage selectionPage = new SelectionPage("ModelImporterDescriptorSelectionPage");
        selectionPage.setTitle(ImporterPlugin.INSTANCE.getString("_UI_SelectModelImporters_title"));
        this.addPage((IWizardPage)selectionPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.computeSuggestedDescriptor();
        this.init();
    }

    protected void init() {
        this.setDefaultPageImageDescriptor(this.getDefaultImageDescriptor());
    }

    protected String getDefaultGenModelFileName() {
        return "My.genmodel";
    }

    protected List getModelImporterDescriptors() {
        return ModelImporterUtil.filterModelImporterDescriptors(2);
    }

    protected void computeSuggestedDescriptor() {
        if (this.suggestedDescriptor == null) {
            List descriptors;
            Object element;
            if (this.reloadFile != null) {
                Object content;
                URI reloadURI = URI.createPlatformResourceURI((String)this.reloadFile.getFullPath().toString());
                Resource reloadResource = null;
                try {
                    reloadResource = ImporterUtil.createResourceSet().getResource(reloadURI, true);
                }
                catch (Exception exception) {}
                if (reloadResource != null && !reloadResource.getContents().isEmpty() && (content = reloadResource.getContents().get(0)) instanceof GenModel) {
                    GenModel genModel = (GenModel)content;
                    if (genModel.getImporterID() != null) {
                        this.suggestedDescriptor = ModelImporterUtil.getModelImporterDescriptor(genModel.getImporterID());
                    } else if (!genModel.getForeignModel().isEmpty()) {
                        String foreignModel = (String)genModel.getForeignModel().get(0);
                        if (foreignModel.endsWith(".mdl")) {
                            this.suggestedDescriptor = ModelImporterUtil.getModelImporterDescriptor("org.eclipse.emf.importer.rose");
                        } else if (foreignModel.endsWith(".xsd") || foreignModel.endsWith(".wsdl")) {
                            this.suggestedDescriptor = ModelImporterUtil.getModelImporterDescriptor("org.eclipse.xsd.ecore.importer");
                        } else if (foreignModel.endsWith("@model")) {
                            this.suggestedDescriptor = ModelImporterUtil.getModelImporterDescriptor("org.eclipse.emf.importer.java");
                        } else if (foreignModel.endsWith(".ecore") || foreignModel.endsWith(".emof")) {
                            this.suggestedDescriptor = ModelImporterUtil.getModelImporterDescriptor("org.eclipse.emf.importer.ecore");
                        }
                    }
                }
            }
            if (this.suggestedDescriptor == null && this.selection != null && !this.selection.isEmpty() && (element = this.selection.getFirstElement()) instanceof IFile && !(descriptors = ModelImporterUtil.filterModelImporterDescriptors(((IFile)element).getFileExtension())).isEmpty()) {
                this.modelFile = (IFile)element;
                this.suggestedDescriptor = (ModelImporterDescriptor)descriptors.get(0);
            }
        }
    }

    protected boolean isValidNewValue(Object newValue, Object oldValue) {
        return newValue == null ? oldValue != null : !newValue.equals(oldValue);
    }

    protected void adjustModelImportWizard(ModelImporterDescriptor modelImporterDescriptor) {
        IModelImporterWizard modelImporterWizard = modelImporterDescriptor.getWizard();
        if (this.isValidNewValue(this.reloadFile, modelImporterWizard.getOriginalGenModelFile())) {
            modelImporterWizard.setOriginalGenModelFile(this.reloadFile);
        }
        if (this.isValidNewValue(this.genModelContainerPath, modelImporterWizard.getGenModelContainerPath())) {
            modelImporterWizard.setGenModelContainerPath(this.genModelContainerPath);
        }
        if (this.isValidNewValue(this.genModelFileName, modelImporterWizard.getGenModelFileName())) {
            modelImporterWizard.setGenModelFileName(this.genModelFileName);
        }
        if (this.isValidNewValue(this.modelFile, modelImporterWizard.getModelFile()) && (this.modelFile == null || modelImporterDescriptor.getExtensions().contains(this.modelFile.getFileExtension()))) {
            modelImporterWizard.setModelFile(this.modelFile);
        }
        modelImporterWizard.getFileExtensions().clear();
        modelImporterWizard.getFileExtensions().addAll(modelImporterDescriptor.getExtensions());
    }

    public boolean canFinish() {
        return false;
    }

    public boolean performFinish() {
        return true;
    }

    public class NewGenModelFileCreationPage
    extends WizardNewFileCreationPage {
        protected boolean firstTime = true;

        public NewGenModelFileCreationPage(String pageId) {
            super(pageId, EMFModelWizard.this.selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !extension.equals("genmodel")) {
                    this.setErrorMessage(ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelFileNameMustEndWithGenModel_message"));
                    return false;
                }
                EMFModelWizard.this.genModelContainerPath = this.getContainerFullPath();
                EMFModelWizard.this.genModelFileName = this.getFileName();
                return true;
            }
            return false;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.firstTime) {
                this.firstTime = false;
                if (EMFModelWizard.this.modelFile != null) {
                    String fileName = EMFModelWizard.this.modelFile.getFullPath().removeFileExtension().lastSegment();
                    this.setFileName(String.valueOf(fileName) + ".genmodel");
                } else {
                    this.setFileName(EMFModelWizard.this.getDefaultGenModelFileName());
                }
            }
        }

        public void setFileName(String value) {
            super.setFileName(value);
            EMFModelWizard.this.genModelFileName = value;
        }
    }

    public class SelectionPage
    extends WizardSelectionPage
    implements ISelectionChangedListener {
        protected ModelImporterDescriptor modelImporterDescriptor;
        protected TableViewer modelImpoterDescriptorTableViewer;
        protected boolean firstTime = true;
        protected Set initializedWizards = new HashSet();

        public SelectionPage(String pageId) {
            super(pageId);
        }

        public void dispose() {
            if (this.modelImpoterDescriptorTableViewer != null) {
                this.modelImpoterDescriptorTableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.modelImpoterDescriptorTableViewer = null;
            }
            this.modelImporterDescriptor = null;
            if (this.initializedWizards != null) {
                this.initializedWizards.clear();
                this.initializedWizards = null;
            }
            ModelImporterUtil.clearWizardNodesCache();
            super.dispose();
        }

        public void setModelImporterDescriptor(ModelImporterDescriptor modelImporterDescriptor) {
            this.modelImporterDescriptor = modelImporterDescriptor;
            if (this.modelImpoterDescriptorTableViewer != null) {
                if (modelImporterDescriptor != null) {
                    this.modelImpoterDescriptorTableViewer.setSelection((ISelection)new StructuredSelection((Object)modelImporterDescriptor), true);
                } else {
                    this.modelImpoterDescriptorTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        }

        public ModelImporterDescriptor getModelImporterDescriptor() {
            return this.modelImporterDescriptor;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.firstTime) {
                this.firstTime = false;
                Table table = this.modelImpoterDescriptorTableViewer.getTable();
                ModelImporterDescriptor descriptor = EMFModelWizard.this.suggestedDescriptor;
                if (descriptor != null) {
                    this.setModelImporterDescriptor(descriptor);
                } else if (table.getItemCount() > 0) {
                    this.setModelImporterDescriptor((ModelImporterDescriptor)table.getItem(0).getData());
                }
                table.setFocus();
            }
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            label.setText(ImporterPlugin.INSTANCE.getString("_UI_SelectModelImporters_label"));
            data = new GridData();
            data.verticalAlignment = 4;
            data.horizontalAlignment = 4;
            label.setLayoutData((Object)data);
            Table modelImpoterDescriptorTable = new Table(composite, 67588);
            GridData data2 = new GridData();
            data2.widthHint = Display.getCurrent().getBounds().width / 5;
            data2.heightHint = Display.getCurrent().getBounds().height / 3;
            data2.verticalAlignment = 4;
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            data2.grabExcessVerticalSpace = true;
            modelImpoterDescriptorTable.setLayoutData((Object)data2);
            this.modelImpoterDescriptorTableViewer = new TableViewer(modelImpoterDescriptorTable);
            this.modelImpoterDescriptorTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.modelImpoterDescriptorTableViewer.setLabelProvider((IBaseLabelProvider)new ModelImporterUtil.ModelImporterDescriptorLabelProvider());
            this.modelImpoterDescriptorTableViewer.setSorter(new ViewerSorter());
            this.modelImpoterDescriptorTableViewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ SelectionPage this$1;
                {
                    this.this$1 = selectionPage;
                }

                public void doubleClick(DoubleClickEvent event) {
                    if (this.this$1.canFlipToNextPage()) {
                        SelectionPage.access$0(this.this$1).showPage(this.this$1.getNextPage());
                    }
                }
            });
            this.modelImpoterDescriptorTableViewer.setInput((Object)EMFModelWizard.this.getModelImporterDescriptors().toArray());
            if (this.modelImporterDescriptor != null) {
                this.modelImpoterDescriptorTableViewer.setSelection((ISelection)new StructuredSelection((Object)this.modelImporterDescriptor), true);
            }
            this.modelImpoterDescriptorTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.setControl((Control)composite);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedObject;
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof ModelImporterDescriptor) {
                this.modelImporterDescriptor = (ModelImporterDescriptor)selectedObject;
                this.setMessage(this.modelImporterDescriptor.getDescription(), 0);
                this.setSelectedNode(ModelImporterUtil.getWizardNode(this.modelImporterDescriptor));
                return;
            }
            this.setPageComplete(false);
        }

        public boolean isPageComplete() {
            return this.modelImporterDescriptor != null;
        }

        public IWizardPage getNextPage() {
            IModelImporterWizard modelImporterWizard = this.getModelImporterDescriptor().getWizard();
            if (!this.initializedWizards.contains(modelImporterWizard)) {
                this.initializedWizards.add(modelImporterWizard);
                if (modelImporterWizard instanceof Wizard) {
                    Wizard wizard = (Wizard)modelImporterWizard;
                    wizard.setDefaultPageImageDescriptor(EMFModelWizard.this.getDefaultImageDescriptor());
                }
                modelImporterWizard.init(EMFModelWizard.this.workbench, EMFModelWizard.this.selection);
            }
            EMFModelWizard.this.adjustModelImportWizard(this.getModelImporterDescriptor());
            IWizardPage wizardPage = super.getNextPage();
            IWizardNode wizardNode = this.getSelectedNode();
            if (wizardNode instanceof ModelImporterUtil.ModelImporterDescriptorWizardNode) {
                ((ModelImporterUtil.ModelImporterDescriptorWizardNode)wizardNode).setContentCreated(true);
            }
            return wizardPage;
        }

        static /* synthetic */ IWizardContainer access$0(SelectionPage selectionPage) {
            return selectionPage.getContainer();
        }
    }
}

