/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jmerge;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPlatformRunnable;

public class PropertyMerger
implements IPlatformRunnable {
    protected String sourceProperties;
    protected String targetProperties;
    protected Map sourceToTargetMap = new LinkedHashMap();
    protected Map targetToSourceMap = new LinkedHashMap();
    protected static Pattern nlPattern = Pattern.compile("([\\n][\\r]?|[\\r][\\n]?)", 8);
    protected static Pattern propertyLine = Pattern.compile("\\s*(\\S+)\\s*=.*", 8);

    public String getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(String sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public String getTargetProperties() {
        return this.targetProperties;
    }

    public void setTargetProperties(String targetProperties) {
        this.targetProperties = targetProperties;
    }

    public Map getSourceToTargetMap() {
        return this.sourceToTargetMap;
    }

    public String createPropertiesForURI(String uri) {
        try {
            URL url = null;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException malformedURLException) {
                url = new URL("file:" + uri);
            }
            if (url != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(url.openStream());
                byte[] input = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(input);
                bufferedInputStream.close();
                return new String(input, "ISO-8859-1");
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public String createPropertiesForInputStream(InputStream inputStream) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            bufferedInputStream.close();
            return new String(input, "ISO-8859-1");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void merge() {
        Matcher matcher = nlPattern.matcher(this.targetProperties);
        String nl = null;
        if (matcher.find()) {
            String sourceNL;
            nl = matcher.group(1);
            matcher = nlPattern.matcher(this.sourceProperties);
            if (matcher.find() && !(sourceNL = matcher.group(1)).equals(nl)) {
                this.sourceProperties = this.sourceProperties.replaceAll(sourceNL, nl);
            }
        } else {
            matcher = nlPattern.matcher(this.sourceProperties);
            if (matcher.find()) {
                nl = matcher.group(1);
            }
        }
        if (nl != null) {
            if (!this.targetProperties.endsWith(nl)) {
                this.targetProperties = String.valueOf(this.targetProperties) + nl;
            }
            if (!this.sourceProperties.endsWith(nl)) {
                this.sourceProperties = String.valueOf(this.sourceProperties) + nl;
            }
        }
        Map sourcePropertyFragments = this.parse(this.sourceProperties);
        Map targetPropertyFragments = this.parse(this.targetProperties);
        StringBuffer result = new StringBuffer(this.targetProperties);
        Iterator i = sourcePropertyFragments.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (targetPropertyFragments.containsKey(entry.getKey())) continue;
            result.append(entry.getValue());
        }
        this.targetProperties = result.toString();
    }

    public Map parse(String properties) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < properties.length()) {
            String property;
            Matcher matcher;
            int eol = properties.indexOf("\n", i);
            if (eol != -1) {
                if (eol + 1 < properties.length() && properties.charAt(eol + 1) == '\r') {
                    ++eol;
                }
            } else {
                eol = properties.indexOf("\r", i);
                if (eol == -1) {
                    eol = properties.length() - 1;
                }
            }
            if ((matcher = propertyLine.matcher(property = properties.substring(i, eol + 1))).find() && matcher.groupCount() >= 1) {
                int end;
                int begin = matcher.start(1);
                String propertyName = property.substring(begin, end = matcher.end(1));
                if (propertyName.indexOf("#") == -1) {
                    result.put(propertyName, property);
                } else if (propertyName.startsWith("#")) {
                    result.put(propertyName.substring(1), property);
                }
            }
            i = eol + 1;
        }
        return result;
    }

    public Object run(Object object) {
        try {
            String[] arguments = (String[])object;
            this.sourceProperties = this.createPropertiesForURI(arguments[0]);
            this.targetProperties = this.createPropertiesForURI(arguments[1]);
            this.merge();
            System.out.println("**********************************************");
            System.out.println(this.targetProperties);
            return new Integer(0);
        }
        catch (Exception exception) {
            return new Integer(1);
        }
    }
}

