/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ui.EMFModelWizard;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.emf.importer.ui.contribution.ModelImporterUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class EMFProjectWizard
extends EMFModelWizard {
    protected IPath projectLocation;
    protected IPath projectPath;

    public EMFProjectWizard() {
        this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFProjectWizard_title"));
    }

    protected ImageDescriptor getDefaultImageDescriptor() {
        return ExtendedImageRegistry.INSTANCE.getImageDescriptor(ImporterPlugin.INSTANCE.getImage("full/wizban/NewEMFProject"));
    }

    public void addPages() {
        WizardNewProjectCreationPage newProjectCreationPage = new WizardNewProjectCreationPage("NewProjectCreationPage"){

            protected boolean validatePage() {
                if (super.validatePage()) {
                    IPath locationPath = this.getLocationPath();
                    EMFProjectWizard.this.projectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationPath;
                    EMFProjectWizard.this.projectPath = this.getProjectHandle().getFullPath();
                    return true;
                }
                return false;
            }
        };
        newProjectCreationPage.setTitle(ImporterPlugin.INSTANCE.getString("_UI_EMFProjectWizard_name"));
        newProjectCreationPage.setDescription(ImporterPlugin.INSTANCE.getString("_UI_CreateEMFProject_label"));
        this.addPage((IWizardPage)newProjectCreationPage);
        EMFModelWizard.SelectionPage selectionPage = new EMFModelWizard.SelectionPage("ModelImporterDescriptorSelectionPage");
        selectionPage.setTitle(ImporterPlugin.INSTANCE.getString("_UI_SelectModelImporters_title"));
        this.addPage((IWizardPage)selectionPage);
    }

    protected List getModelImporterDescriptors() {
        return ModelImporterUtil.filterModelImporterDescriptors(1);
    }

    protected void adjustModelImportWizard(ModelImporterDescriptor modelImporterDescriptor) {
        super.adjustModelImportWizard(modelImporterDescriptor);
        IModelImporterWizard modelImporterWizard = modelImporterDescriptor.getWizard();
        if (this.isValidNewValue(this.projectLocation, modelImporterWizard.getGenModelProjectLocation())) {
            modelImporterWizard.setGenModelProjectLocation(this.projectLocation);
        }
        if (this.isValidNewValue(this.projectPath, modelImporterWizard.getGenModelProjectPath())) {
            modelImporterWizard.setGenModelProjectPath(this.projectPath);
        }
    }
}

