/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.rose.builder;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.importer.rose.RoseImporterPlugin;
import org.eclipse.emf.importer.rose.builder.RoseEcoreBuilder;
import org.eclipse.emf.importer.rose.builder.RoseWalker;
import org.eclipse.emf.importer.rose.builder.TableObject;
import org.eclipse.emf.importer.rose.builder.UnitTreeBuilder;
import org.eclipse.emf.importer.rose.builder.UnitTreeNode;
import org.eclipse.emf.importer.rose.parser.RoseLexer;
import org.eclipse.emf.importer.rose.parser.RoseLoader;
import org.eclipse.emf.importer.rose.parser.RoseNode;
import org.eclipse.emf.importer.rose.parser.RoseParser;
import org.eclipse.emf.importer.rose.parser.Util;

public class RoseUtil {
    protected Map quidTable = new HashMap();
    protected Map nameTable = new HashMap();
    protected Map superTable = new HashMap();
    protected Map refTable = new HashMap();
    protected Map typeTable = new HashMap();
    protected Map primitiveTable = new HashMap();
    protected Map variableToDirectoryMap = new HashMap();
    protected Map packageNameToNSNameMap = new HashMap();
    protected Map packageNameToNSURIMap = new HashMap();
    protected Map ePackageToInformationMap = new HashMap();
    protected URIConverter uriConverter;
    MultiStatus status = new MultiStatus(RoseImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, RoseImporterPlugin.INSTANCE.getString("_UI_ProblemsWereEncounteredLoadingTheRoseModel_message"), null);
    protected RoseEcoreBuilder roseEcoreBuilder = new RoseEcoreBuilder(this);

    public RoseUtil(URIConverter uriConverter) {
        this.uriConverter = uriConverter;
    }

    public RoseEcoreBuilder getRoseEcoreBuilder() {
        return this.roseEcoreBuilder;
    }

    public UnitTreeNode createRoseUnitTreeAndTable(String fileNameNodeValue, UnitTreeNode topNode) throws Exception {
        RoseLoader loader;
        String fileName;
        block10: {
            UnitTreeBuilder unitTreeBuilder;
            RoseNode modelTree;
            block11: {
                UnitTreeNode unitTreeNode;
                int index;
                fileName = this.resolveFileName(fileNameNodeValue);
                if (topNode == null && (index = fileName.lastIndexOf(File.separator)) != -1) {
                    this.variableToDirectoryMap.put(null, fileName.substring(0, index + 1));
                }
                loader = new RoseLoader(fileName, this.uriConverter);
                try {
                    String qualifier;
                    if (!loader.isValid()) break block10;
                    this.status = new MultiStatus(RoseImporterPlugin.getPlugin().getBundle().getSymbolicName(), 1, RoseImporterPlugin.INSTANCE.getString("_UI_ProblemsWereEncounteredConvertingTheRoseModel_message"), null);
                    RoseLexer lexer = new RoseLexer(loader);
                    RoseParser parser = new RoseParser(lexer, true, true);
                    parser.parse();
                    modelTree = parser.getModelTree();
                    unitTreeBuilder = new UnitTreeBuilder(this);
                    if (topNode != null) break block11;
                    UnitTreeNode unitTree = null;
                    if (modelTree.getKey().equals("") && Util.getType(modelTree.getValue()).equals("Class_Category")) {
                        String quid = modelTree.getRoseId();
                        quid = quid.substring(1, quid.length() - 1);
                        unitTree = new UnitTreeNode(Util.getName(modelTree.getValue()), quid, fileName);
                        String objName = Util.getName(modelTree.getValue());
                        TableObject obj = new TableObject(objName, quid, unitTree);
                        this.quidTable.put(quid, obj);
                        this.nameTable.put(objName, obj);
                        qualifier = objName;
                    } else {
                        int ind_1 = fileName.lastIndexOf(System.getProperty("file.separator"));
                        int ind_2 = fileName.lastIndexOf(".");
                        String modelName = ind_2 != -1 ? fileName.substring(ind_1 + 1, ind_2) : fileName.substring(ind_1 + 1, fileName.length());
                        String quid = modelTree.getRoseId();
                        if (quid != null) {
                            quid = quid.substring(1, quid.length() - 1);
                            unitTree = new UnitTreeNode(modelName, quid, fileName);
                        } else {
                            unitTree = new UnitTreeNode(modelName, "", fileName);
                        }
                        qualifier = null;
                    }
                    unitTreeBuilder.traverse(qualifier, modelTree, unitTree);
                    unitTreeNode = unitTree;
                    Object var15_25 = null;
                }
                catch (Throwable throwable) {
                    Object var15_28 = null;
                    loader.close();
                    throw throwable;
                }
                loader.close();
                return unitTreeNode;
            }
            String quid = modelTree.getRoseId();
            if (quid != null) {
                quid = quid.substring(1, quid.length() - 1);
                topNode.setQUID(quid);
            }
            String objName = Util.getName(modelTree.getValue());
            TableObject obj = new TableObject(objName, quid, topNode);
            this.quidTable.put(quid, obj);
            this.nameTable.put(objName, obj);
            unitTreeBuilder.traverse(objName, modelTree, topNode);
            UnitTreeNode unitTreeNode = null;
            Object var15_26 = null;
            loader.close();
            return unitTreeNode;
        }
        this.getStatus().add((IStatus)new Status(1, RoseImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, RoseImporterPlugin.INSTANCE.getString("_UI_TheUnitResolvesTo_message", new Object[]{Util.trimQuotes(fileNameNodeValue), fileName}), null));
        UnitTreeNode unitTreeNode = null;
        Object var15_27 = null;
        loader.close();
        return unitTreeNode;
    }

    public void showRoseUnitTree(UnitTreeNode unitTree) {
        if (unitTree != null) {
            System.out.println(" ");
            System.out.println("======= Unit Tree Info =============");
            System.out.println("[0]: " + unitTree.getName() + ",   " + unitTree.getQUID() + ", " + unitTree.getRoseFileName() + ",\t" + unitTree.getEcoreFileName());
            int i = 1;
            this.traverseOut(unitTree, i);
        }
        if (this.quidTable.size() > 0) {
            System.out.println("=========== Class Info ============");
            Iterator it = this.quidTable.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                TableObject obj = (TableObject)this.quidTable.get(key);
                System.out.println(key + ",\t" + obj.getName() + ",\t" + obj.getContainer().getEcoreFileName());
            }
        }
    }

    protected void traverseOut(UnitTreeNode tree, int index) {
        List nodes = tree.getNodes();
        if (nodes.size() > 0) {
            int i = 0;
            while (i < nodes.size()) {
                UnitTreeNode node = (UnitTreeNode)nodes.get(i);
                System.out.println("[" + index + "]: " + node.getName() + ",  " + node.getQUID() + ", " + node.getEcoreFileName());
                this.traverseOut(node, index + 1);
                ++i;
            }
        }
    }

    public void createExtent4RoseUnitTree(UnitTreeNode unitTree) {
        if (unitTree != null) {
            this.checkConflictFileName(unitTree);
            this.createExtent(unitTree);
        }
        this.refTable.clear();
    }

    public void checkConflictFileName(UnitTreeNode unitTree) {
        String rootEcoreFileName = unitTree.getEcoreFileName();
        if (this.checkFileName(unitTree, rootEcoreFileName)) {
            int index = rootEcoreFileName.lastIndexOf(".");
            if (index != -1) {
                rootEcoreFileName = String.valueOf(rootEcoreFileName.substring(0, index)) + "model" + rootEcoreFileName.substring(index, rootEcoreFileName.length());
            }
            unitTree.setEcoreFileName(rootEcoreFileName);
        }
    }

    public boolean checkFileName(UnitTreeNode unitTree, String name) {
        List nodes = unitTree.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            UnitTreeNode node = (UnitTreeNode)nodes.get(i);
            if (node.getEcoreFileName().equals(name) || this.checkFileName(node, name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void createExtent(UnitTreeNode unitTree) {
        BasicEList ext = new BasicEList();
        unitTree.setExtent((EList)ext);
        List nodes = unitTree.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            this.createExtent((UnitTreeNode)nodes.get(i));
            ++i;
        }
    }

    public void processUnitTree(UnitTreeNode unitTree) throws Exception {
        if (unitTree != null) {
            int dotIndex;
            this.loadTree(null, unitTree);
            String packageName = unitTree.getEcoreFileName();
            int fileSeparatorIndex = packageName.lastIndexOf(File.separator);
            if (fileSeparatorIndex != -1) {
                packageName = packageName.substring(fileSeparatorIndex + 1);
            }
            if ((dotIndex = packageName.lastIndexOf(".")) != -1) {
                packageName = packageName.substring(0, dotIndex);
            }
            this.roseEcoreBuilder.createEPackageForRootClasses(unitTree.getExtent(), unitTree.getRoseNode(), packageName);
            this.roseEcoreBuilder.setEEnums();
            this.roseEcoreBuilder.setEReferences();
            this.roseEcoreBuilder.setSuper();
            this.roseEcoreBuilder.setETypeClassifier();
            this.setIDs(unitTree);
            this.validate(unitTree);
        }
    }

    protected void setIDs(UnitTreeNode node) throws Exception {
        Iterator i = node.getExtent().iterator();
        while (i.hasNext()) {
            this.roseEcoreBuilder.setIDs(null, (EObject)i.next());
        }
        i = node.getNodes().iterator();
        while (i.hasNext()) {
            this.setIDs((UnitTreeNode)i.next());
        }
    }

    protected void validate(UnitTreeNode node) throws Exception {
        Iterator i = node.getExtent().iterator();
        while (i.hasNext()) {
            this.roseEcoreBuilder.validate((EObject)i.next());
        }
        i = node.getNodes().iterator();
        while (i.hasNext()) {
            this.validate((UnitTreeNode)i.next());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadTree(RoseNode containingNode, UnitTreeNode node) throws Exception {
        node.getName();
        String roseFile = node.getRoseFileName();
        RoseLoader loader = new RoseLoader(roseFile, this.uriConverter);
        try {
            if (loader.isValid()) {
                RoseLexer lexer = new RoseLexer(loader);
                RoseParser parser = new RoseParser(lexer, true, true);
                parser.parse();
                RoseNode modelTree = parser.getModelTree();
                modelTree.setNode(node.getExtent());
                if (containingNode != null) {
                    modelTree.setParent(containingNode);
                }
                containingNode = modelTree;
                RoseWalker roseWalker = new RoseWalker(modelTree);
                roseWalker.traverse(this.roseEcoreBuilder);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            loader.close();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        loader.close();
        Iterator i = node.getNodes().iterator();
        while (i.hasNext()) {
            UnitTreeNode subNode = (UnitTreeNode)i.next();
            this.loadTree(containingNode, subNode);
        }
        return;
    }

    public void saveEcoreFiles(ResourceSet resourceSet) throws Exception {
        Iterator it = resourceSet.getResources().iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            resource.save(Collections.EMPTY_MAP);
        }
    }

    public void createResource(UnitTreeNode tree, ResourceSet resourceSet) {
        EList ext = tree.getExtent();
        if (ext.size() > 0) {
            String ecoreFileName = tree.getEcoreFileName();
            URI ecoreURI = URI.createURI((String)ecoreFileName);
            Resource res = Resource.Factory.Registry.INSTANCE.getFactory(ecoreURI).createResource(ecoreURI);
            res.getContents().addAll((Collection)tree.getExtent());
            resourceSet.getResources().add((Object)res);
        }
        List nodes = tree.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            this.createResource((UnitTreeNode)nodes.get(i), resourceSet);
            ++i;
        }
    }

    public String resolveFileName(String name) {
        String baseName;
        int index;
        name = Util.trimQuotes(name);
        name = Util.updateFileName(name, "\\\\");
        name = Util.updateFileName(name, "\\");
        name = Util.updateFileName(name, "/");
        String result = "";
        while ((index = name.indexOf(File.separator)) != -1) {
            String variableName;
            String directoryName = name.substring(0, index);
            if (directoryName.startsWith("$") && (directoryName = (String)this.variableToDirectoryMap.get(variableName = directoryName.substring(1))) == null) {
                this.variableToDirectoryMap.put(variableName, null);
                directoryName = "";
            }
            result = String.valueOf(result) + directoryName + File.separator;
            name = name.substring(index + 1);
        }
        if ((result = String.valueOf(result) + name).indexOf(":") == -1 && !result.startsWith(File.separator) && (baseName = (String)this.variableToDirectoryMap.get(null)) != null) {
            result = String.valueOf(baseName) + result;
        }
        return result;
    }

    public Map getVariableToDirectoryMap() {
        return this.variableToDirectoryMap;
    }

    public Map getPackageNameToNSNameMap() {
        return this.packageNameToNSNameMap;
    }

    public Map getPackageNameToNSURIMap() {
        return this.packageNameToNSURIMap;
    }

    public Map getEPackageToInformationMap() {
        return this.ePackageToInformationMap;
    }

    public MultiStatus getStatus() {
        return this.status;
    }
}

