/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ValidateAction
extends Action
implements ISelectionChangedListener {
    protected ISelectionProvider selectionProvider;
    protected List selectedObjects;
    protected EditingDomain domain;
    protected EclipseResourcesUtil eclipseResourcesUtil = Platform.getBundle((String)"org.eclipse.core.resources") != null ? new EclipseResourcesUtil() : null;
    static /* synthetic */ Class class$0;

    public ValidateAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Validate_menu_item"));
        this.setDescription(EMFEditUIPlugin.INSTANCE.getString("_UI_Validate_simple_description"));
    }

    public void run() {
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    Diagnostic diagnostic = ValidateAction.this.validate(progressMonitor);
                    shell.getDisplay().asyncExec(new Runnable(this, progressMonitor, diagnostic){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IProgressMonitor val$progressMonitor;
                        private final /* synthetic */ Diagnostic val$diagnostic;
                        {
                            this.this$1 = var1_1;
                            this.val$progressMonitor = iProgressMonitor;
                            this.val$diagnostic = diagnostic;
                        }

                        public void run() {
                            if (this.val$progressMonitor.isCanceled()) {
                                1.access$0(this.this$1).handleDiagnostic(Diagnostic.CANCEL_INSTANCE);
                            } else {
                                1.access$0(this.this$1).handleDiagnostic(this.val$diagnostic);
                            }
                        }
                    });
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    progressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                progressMonitor.done();
            }

            static /* synthetic */ ValidateAction access$0(1 var0) {
                return var0.ValidateAction.this;
            }
        };
        if (this.eclipseResourcesUtil != null) {
            runnableWithProgress = this.eclipseResourcesUtil.getWorkspaceModifyOperation(runnableWithProgress);
        }
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log(exception);
        }
    }

    protected Diagnostic validate(final IProgressMonitor progressMonitor) {
        EObject eObject = (EObject)this.selectedObjects.iterator().next();
        int count = 0;
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        progressMonitor.beginTask("", count);
        final AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        Diagnostician diagnostician = new Diagnostician(){
            protected int threshold = 10;

            public String getObjectLabel(EObject eObject) {
                if (adapterFactory != null && !eObject.eIsProxy()) {
                    IItemLabelProvider itemLabelProvider;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IItemLabelProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, (Object)clazz)) != null) {
                        return itemLabelProvider.getText((Object)eObject);
                    }
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
        progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
        return diagnostician.validate(eObject);
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        int result = ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title"), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message"), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationOK_title"), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationOK_message"));
            result = 1;
        }
        if (Platform.getBundle((String)"org.eclipse.core.resources") != null) {
            IFile file = this.getFile();
            if (file != null) {
                try {
                    file.deleteMarkers("org.eclipse.emf.ecore.diagnostic", true, 0);
                }
                catch (CoreException exception) {
                    EMFEditUIPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (result == 0) {
                List data;
                if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
                    Viewer viewer;
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                    if (part instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(data.get(0)));
                    } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                    }
                }
                Iterator i = diagnostic.getChildren().iterator();
                while (i.hasNext()) {
                    Diagnostic childDiagnostic = (Diagnostic)i.next();
                    this.createMarkers(file, childDiagnostic);
                }
            }
        }
    }

    protected void createMarkers(IFile file, Diagnostic diagnostic) {
        this.eclipseResourcesUtil.createMarkers(file, diagnostic);
    }

    protected IFile getFile() {
        Resource resource = (Resource)this.domain.getResourceSet().getResources().get(0);
        if (resource != null) {
            URI uri = resource.getURI();
            uri = resource.getResourceSet().getURIConverter().normalize(uri);
            String scheme = uri.scheme();
            if ("platform".equals(scheme) && uri.segmentCount() > 1 && "resource".equals(uri.segment(0))) {
                StringBuffer platformResourcePath = new StringBuffer();
                int j = 1;
                int size = uri.segmentCount();
                while (j < size) {
                    platformResourcePath.append('/');
                    platformResourcePath.append(uri.segment(j));
                    ++j;
                }
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourcePath.toString()));
            }
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionProvider = event.getSelectionProvider();
        if (event.getSelection() instanceof IStructuredSelection) {
            this.setEnabled(this.updateSelection((IStructuredSelection)event.getSelection()));
        } else {
            this.setEnabled(false);
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selectedObjects = new ArrayList();
        Iterator objects = selection.iterator();
        while (objects.hasNext()) {
            this.selectedObjects.add(AdapterFactoryEditingDomain.unwrap(objects.next()));
        }
        return this.selectedObjects.size() == 1 && this.selectedObjects.get(0) instanceof EObject;
    }

    public void setActiveEditor(IEditorPart editorPart) {
        this.setActiveWorkbenchPart((IWorkbenchPart)editorPart);
    }

    public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
        if (workbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)workbenchPart).getEditingDomain();
        }
    }

    public static class EclipseResourcesUtil {
        public IRunnableWithProgress getWorkspaceModifyOperation(IRunnableWithProgress runnableWithProgress) {
            return new WorkspaceModifyDelegatingOperation(runnableWithProgress);
        }

        public void createMarkers(IFile file, Diagnostic diagnostic) {
            Object target;
            EObject eObject = null;
            List data = diagnostic.getData();
            if (!data.isEmpty() && (target = data.get(0)) instanceof EObject) {
                eObject = (EObject)target;
            }
            if (diagnostic.getChildren().isEmpty()) {
                try {
                    IMarker marker = file.createMarker("org.eclipse.emf.ecore.diagnostic");
                    int severity = diagnostic.getSeverity();
                    if (severity < 2) {
                        marker.setAttribute("severity", 0);
                    } else if (severity < 4) {
                        marker.setAttribute("severity", 1);
                    } else {
                        marker.setAttribute("severity", 2);
                    }
                    marker.setAttribute("message", (Object)diagnostic.getMessage());
                    if (eObject != null) {
                        marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)eObject).toString());
                    }
                }
                catch (CoreException exception) {
                    EMFEditUIPlugin.INSTANCE.log((Object)exception);
                }
            } else {
                String parentMessage = String.valueOf(diagnostic.getMessage()) + ". ";
                Iterator i = diagnostic.getChildren().iterator();
                while (i.hasNext()) {
                    Diagnostic childDiagnostic = (Diagnostic)i.next();
                    try {
                        IMarker marker = file.createMarker("org.eclipse.emf.ecore.diagnostic");
                        int severity = childDiagnostic.getSeverity();
                        if (severity < 2) {
                            marker.setAttribute("severity", 0);
                        } else if (severity < 4) {
                            marker.setAttribute("severity", 1);
                        } else {
                            marker.setAttribute("severity", 2);
                        }
                        marker.setAttribute("message", (Object)(String.valueOf(parentMessage) + childDiagnostic.getMessage()));
                        if (eObject == null) continue;
                        marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)eObject).toString());
                    }
                    catch (CoreException exception) {
                        EMFEditUIPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }
}

