/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.base.ModelImporterPage;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class ModelDetailPage
extends ModelImporterPage {
    protected Text modelLocationText;
    protected Button loadButton;
    protected Text genModelNameText;
    protected Button modelLocationBrowseFileSystemButton;
    protected Button modelLocationBrowseWorkspaceButton;
    protected String[] filterExtensions;
    protected boolean showGenModel = this.getModelImporter().getGenModelFileName() == null;
    protected boolean usingInternalSetName = true;

    public ModelDetailPage(ModelImporter modelImporter, String pageName) {
        super(modelImporter, pageName);
    }

    public void dispose() {
        if (this.modelLocationText != null) {
            this.modelLocationText.removeListener(24, (Listener)this);
            this.modelLocationText = null;
        }
        if (this.loadButton != null) {
            this.loadButton.removeListener(13, (Listener)this);
            this.loadButton = null;
        }
        if (this.genModelNameText != null) {
            this.genModelNameText.removeListener(24, (Listener)this);
            this.genModelNameText = null;
        }
        if (this.modelLocationBrowseFileSystemButton != null) {
            this.modelLocationBrowseFileSystemButton.removeListener(13, (Listener)this);
            this.modelLocationBrowseFileSystemButton = null;
        }
        if (this.modelLocationBrowseWorkspaceButton != null) {
            this.modelLocationBrowseWorkspaceButton.removeListener(13, (Listener)this);
            this.modelLocationBrowseWorkspaceButton = null;
        }
        super.dispose();
    }

    public boolean showGenModel() {
        return this.showGenModel;
    }

    protected void pageActivated(boolean firstTime, int cause) {
        if (firstTime && this.getModelImporter().getOriginalGenModelPath() != null) {
            this.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ModelDetailPage.this.handleOriginalModelFile();
                }
            });
        }
    }

    protected void handleOriginalModelFile() {
        this.refreshModel();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        composite.setLayout((Layout)layout);
        this.createModelLocationControl(composite);
        this.addControl(composite);
        if (this.showGenModel()) {
            this.createGenModelNameControl(composite);
        }
        this.adjustLoadButton();
        this.setControl((Control)composite);
    }

    protected void createModelLocationControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        layout.marginRight = -5;
        composite.setLayout((Layout)layout);
        Label modelLocationLabel = new Label(composite, 16384);
        modelLocationLabel.setLayoutData((Object)new GridData(32));
        modelLocationLabel.setText(this.getModelLocationTextLabel());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(896));
        RowLayout layout2 = new RowLayout();
        layout2.justify = true;
        layout2.pack = true;
        layout2.spacing = 5;
        layout2.marginRight = 0;
        buttonComposite.setLayout((Layout)layout2);
        this.modelLocationBrowseFileSystemButton = new Button(buttonComposite, 8);
        this.modelLocationBrowseFileSystemButton.setText(this.getBrowseFileSystemButtonLabel());
        this.modelLocationBrowseFileSystemButton.addListener(13, (Listener)this);
        this.modelLocationBrowseWorkspaceButton = new Button(buttonComposite, 8);
        this.modelLocationBrowseWorkspaceButton.setText(this.getBrowseWorkspaceButtonLabel());
        this.modelLocationBrowseWorkspaceButton.addListener(13, (Listener)this);
        Composite modelLocationComposite = new Composite(parent, 0);
        modelLocationComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout3 = new GridLayout(2, false);
        layout3.marginTop = -5;
        layout3.marginLeft = -5;
        layout3.marginRight = -5;
        modelLocationComposite.setLayout((Layout)layout3);
        this.modelLocationText = new Text(modelLocationComposite, 2052);
        this.modelLocationText.setLayoutData((Object)new GridData(768));
        if (this.getModelImporter().getModelLocation() != null) {
            this.modelLocationText.setText(this.getModelImporter().getModelLocation());
        }
        this.modelLocationText.addListener(24, (Listener)this);
        this.createLoadButton(modelLocationComposite);
    }

    protected void createLoadButton(Composite parent) {
        this.loadButton = new Button(parent, 8);
        this.loadButton.setText(ImporterPlugin.INSTANCE.getString("_UI_Load_label"));
        GridData data = new GridData(3);
        data.widthHint = 50;
        this.loadButton.setLayoutData((Object)data);
        this.loadButton.addListener(13, (Listener)this);
    }

    protected void createGenModelNameControl(Composite parent) {
        Label genModelNameLabel = new Label(parent, 16384);
        genModelNameLabel.setText(ImporterPlugin.INSTANCE.getString("_UI_GeneratorModelName_label"));
        this.genModelNameText = new Text(parent, 2052);
        this.genModelNameText.setLayoutData((Object)new GridData(768));
        this.genModelNameText.addListener(24, (Listener)this);
    }

    protected void addControl(Composite parent) {
    }

    protected void doHandleEvent(Event event) {
        if (event.type == 24 && event.widget == this.modelLocationText) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.getModelImporter().setModelLocation(null);
            this.getModelImporter().clearEPackagesCollections();
            this.adjustLoadButton();
        } else if (event.type == 13 && event.widget == this.loadButton) {
            this.refreshModel();
        } else if (event.type == 24 && event.widget == this.genModelNameText) {
            this.usingInternalSetName = false;
            this.getModelImporter().setGenModelFileName(this.genModelNameText.getText());
            IStatus status = this.getModelImporter().checkGenModelFileName();
            this.handleStatus(status);
        } else if (event.type == 13 && event.widget == this.modelLocationBrowseFileSystemButton) {
            this.browseFileSystem();
        } else if (event.type == 13 && event.widget == this.modelLocationBrowseWorkspaceButton) {
            this.browseWorkspace();
        } else {
            super.doHandleEvent(event);
        }
        this.getContainer().updateButtons();
    }

    protected void adjustLoadButton() {
        if (this.loadButton != null) {
            String text = this.modelLocationText.getText();
            this.loadButton.setEnabled(text != null && text.trim().length() > 0);
        }
    }

    protected String getModelLocationTextLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_ModelLocation_label");
    }

    protected String getBrowseFileSystemButtonLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_BrowseFileSystemFile_label");
    }

    protected String getBrowseWorkspaceButtonLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_BrowseWorkspace_label");
    }

    protected String getSelectModelLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_SelectModel_label");
    }

    protected boolean supportMultipleModelLocation() {
        return true;
    }

    protected String[] getFilterExtensions() {
        if (this.filterExtensions == null) {
            List fileExtensions = this.getModelImporter().getFileExtensions();
            if (fileExtensions.isEmpty()) {
                this.filterExtensions = new String[]{"*.*"};
            } else if (fileExtensions.size() == 1) {
                this.filterExtensions = new String[]{"*." + (String)fileExtensions.get(0)};
            } else {
                StringBuffer allFilterExtensions = new StringBuffer();
                String[] extensions = new String[fileExtensions.size() + 1];
                int i = 1;
                int lenght = extensions.length;
                while (i < lenght) {
                    extensions[i] = "*." + (String)fileExtensions.get(i - 1);
                    allFilterExtensions.append(";").append(extensions[i]);
                    ++i;
                }
                allFilterExtensions.deleteCharAt(0);
                extensions[0] = allFilterExtensions.toString();
                this.filterExtensions = extensions;
            }
        }
        return this.filterExtensions;
    }

    protected boolean isValidWorkspaceResource(IResource resource) {
        String[] filterExtensions;
        if (resource.getType() == 1 && !CodeGenUtil.isInJavaOutput((IResource)resource) && (filterExtensions = this.getFilterExtensions()).length > 0) {
            int i = 0;
            while (i < filterExtensions.length) {
                if (filterExtensions[i].endsWith(".*") || filterExtensions[i].endsWith("." + resource.getFileExtension())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void setModelLocationText(String location) {
        StringBuffer text;
        if (!(location = location.trim()).equals(text = new StringBuffer(this.modelLocationText.getText()))) {
            if (this.supportMultipleModelLocation()) {
                Point textSelection = this.modelLocationText.getSelection();
                text.delete(textSelection.x, textSelection.y);
                location = text.append(" ").append(location).toString();
            }
            this.modelLocationText.setText(location.trim());
        }
    }

    protected boolean browseFileSystem() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0x1000 | (this.supportMultipleModelLocation() ? 2 : 4));
        fileDialog.setFilterExtensions(this.getFilterExtensions());
        URI modelURI = this.getModelImporter().getFirstModelLocationURI(true);
        if (modelURI != null) {
            fileDialog.setFileName(modelURI.toFileString());
        }
        if (fileDialog.open() != null && fileDialog.getFileNames().length > 0) {
            String[] fileNames = fileDialog.getFileNames();
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < fileNames.length) {
                String filePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + fileNames[i];
                text.append(URI.createFileURI((String)filePath).toString());
                text.append(" ");
                ++i;
            }
            this.setModelLocationText(text.toString());
            this.refreshModel();
            return true;
        }
        return false;
    }

    protected boolean browseWorkspace() {
        ResourceSelectionDialog resourceSelectionDialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), this.getSelectModelLabel());
        resourceSelectionDialog.open();
        Object[] result = resourceSelectionDialog.getResult();
        if (result != null) {
            StringBuffer text = new StringBuffer();
            int length = this.supportMultipleModelLocation() ? result.length : 1;
            int i = 0;
            while (i < length) {
                IResource resource = (IResource)result[i];
                if (this.isValidWorkspaceResource(resource)) {
                    text.append(URI.createURI((String)URI.createPlatformResourceURI((String)resource.getFullPath().toString()).toString(), (boolean)true));
                    text.append("  ");
                }
                ++i;
            }
            this.setModelLocationText(text.toString());
            this.refreshModel();
            return true;
        }
        return false;
    }

    protected void refreshModel() {
        WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                IStatus errorStatus = null;
                ModelDetailPage.this.setErrorMessage(null);
                ModelDetailPage.this.setMessage(null);
                try {
                    try {
                        ModelDetailPage.this.refreshModel(progressMonitor);
                    }
                    catch (Exception exception) {
                        ImporterPlugin.INSTANCE.log(exception);
                        errorStatus = ImporterUtil.createErrorStatus(exception, true);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    progressMonitor.done();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                progressMonitor.done();
                if (errorStatus != null) {
                    ModelDetailPage.this.handleStatus(errorStatus, errorStatus.getMessage(), ImporterPlugin.INSTANCE.getString("_UI_LoadProblem_title"), ImporterPlugin.INSTANCE.getString("_UI_ProblemsEncounteredProcessing_message"));
                }
            }
        };
        this.getModelImporter().setModelLocation(this.modelLocationText.getText());
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
        }
        catch (Exception exception) {
            ImporterPlugin.INSTANCE.log(exception);
        }
        if (this.isPageComplete()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
            this.modelLocationText.selectAll();
            this.modelLocationText.setFocus();
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && !this.getModelImporter().getEPackages().isEmpty() && !this.getModelImporter().getModelLocationURIs().isEmpty();
    }

    protected void refreshModel(IProgressMonitor progressMonitor) throws Exception {
        Object status = null;
        try {
            status = this.getModelImporter().computeEPackages(progressMonitor);
            this.getModelImporter().adjustEPackages(progressMonitor);
        }
        catch (WrappedException wrappedException) {
            if (wrappedException.exception() instanceof FileNotFoundException) {
                this.setMessage(null);
                this.setErrorMessage(ImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidModel_message"));
                return;
            }
            throw wrappedException.exception();
        }
        this.internalSetGenModelFileName(this.getDefaultGenModelFileName());
        IStatus nameStatus = this.getModelImporter().checkGenModelFileName();
        if (!nameStatus.isOK()) {
            status = status.isOK() ? nameStatus : ImporterUtil.mergeStatus(status, nameStatus);
        }
        this.handleStatus((IStatus)status);
    }

    protected String getDefaultGenModelFileName() {
        return this.getModelImporter().computeDefaultGenModelFileName();
    }

    protected void internalSetGenModelFileName(String name) {
        if (this.usingInternalSetName && this.showGenModel() && name != null) {
            this.getModelImporter().setGenModelFileName(name);
            this.setHandlingEvent(false);
            this.genModelNameText.setText(this.getModelImporter().getGenModelFileName());
            this.setHandlingEvent(true);
        }
    }
}

