/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenBaseItemProvider;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProviderAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenPackageItemProvider;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.ui.celleditor.ExtendedTableEditor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.base.ModelImporterPage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class ModelPackagePage
extends ModelImporterPage {
    public static final int ECORE_FILE_COLUMN = 0;
    protected CheckboxTableViewer packagesCheckboxTableViewer;
    protected CheckboxTreeViewer referencedGenModelsCheckboxTreeViewer;
    protected List filteredEPackages = new ModelImporter.EPackageList();
    protected boolean isCellEditing = false;
    protected boolean showReferencedGenModels = false;

    public ModelPackagePage(ModelImporter modelImporter, String pageName) {
        super(modelImporter, pageName);
        this.setTitle(ImporterPlugin.INSTANCE.getString("_UI_PackageSelection_title"));
        this.setDescription(ImporterPlugin.INSTANCE.getString("_UI_PackageSelection_description"));
    }

    public void dispose() {
        this.packagesCheckboxTableViewer = null;
        this.referencedGenModelsCheckboxTreeViewer = null;
        if (this.filteredEPackages != null) {
            this.filteredEPackages.clear();
            this.filteredEPackages = null;
        }
        super.dispose();
    }

    public void setShowReferencedGenModels(boolean showReferencedGenModels) {
        this.showReferencedGenModels = showReferencedGenModels;
    }

    public boolean showReferencedGenModels() {
        return this.showReferencedGenModels;
    }

    protected void pageActivated(boolean firstTime, int cause) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ModelPackagePage.this.filterPackagesTable(true);
                ModelPackagePage.this.getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && !this.getModelImporter().getEPackages().isEmpty() && this.packagesCheckboxTableViewer != null && this.packagesCheckboxTableViewer.getCheckedElements().length > 0 && !this.isCellEditing;
    }

    public void createControl(Composite parent) {
        SashForm composite = null;
        if (this.showReferencedGenModels()) {
            composite = new SashForm(parent, 512);
            composite.setLayoutData((Object)new GridData(1808));
        } else {
            composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
        }
        Composite packageComposite = new Composite((Composite)composite, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        packageComposite.setLayout((Layout)layout);
        packageComposite.setLayoutData((Object)new GridData(1808));
        this.createPackageControl(packageComposite);
        if (this.showReferencedGenModels()) {
            Composite referencedGenModelComposite = new Composite((Composite)composite, 0);
            GridLayout layout2 = new GridLayout();
            layout2.verticalSpacing = 12;
            referencedGenModelComposite.setLayout((Layout)layout2);
            referencedGenModelComposite.setLayoutData((Object)new GridData(1808));
            this.createReferencedGenModelControl(referencedGenModelComposite);
            composite.setWeights(new int[]{70, 30});
        }
        this.setControl((Control)composite);
    }

    protected void createPackageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        layout.marginRight = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        composite.setLayout((Layout)layout);
        Label packagesLabel = new Label(composite, 16384);
        packagesLabel.setText(this.getPackagesLabel());
        packagesLabel.setLayoutData((Object)new GridData(768));
        Composite selectionComposite = new Composite(composite, 0);
        selectionComposite.setLayoutData((Object)new GridData(128));
        GridLayout layout2 = new GridLayout(2, true);
        layout2.marginLeft = -5;
        layout2.marginRight = -5;
        layout2.marginTop = -5;
        layout2.marginBottom = -5;
        selectionComposite.setLayout((Layout)layout2);
        Button selectAllButton = new Button(selectionComposite, 8);
        selectAllButton.setLayoutData((Object)new GridData(768));
        selectAllButton.setText(this.getSelectAllLabel());
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelPackagePage.this.packagesCheckboxTableViewer.setCheckedElements(ModelPackagePage.this.getModelImporter().getEPackages().toArray());
                ModelPackagePage.this.ePackageCheckStateChanged();
            }
        });
        Button deselectAllButton = new Button(selectionComposite, 8);
        deselectAllButton.setLayoutData((Object)new GridData(768));
        deselectAllButton.setText(this.getDeselectAllLabel());
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelPackagePage.this.packagesCheckboxTableViewer.setCheckedElements(new Object[0]);
                ModelPackagePage.this.ePackageCheckStateChanged();
            }
        });
        Table packagesTable = new Table(parent, 2080);
        this.packagesCheckboxTableViewer = new CheckboxTableViewer(packagesTable);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.heightHint = 90;
        packagesTable.setLayoutData((Object)data);
        packagesTable.setHeaderVisible(true);
        packagesTable.setLinesVisible(true);
        TableLayout layout3 = new TableLayout();
        TableColumn packageColumn = new TableColumn(packagesTable, 0);
        layout3.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        packageColumn.setText(this.getPackageColumnLabel());
        packageColumn.setResizable(true);
        TableColumn ecoreFileNameColumn = new TableColumn(packagesTable, 0);
        layout3.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        ecoreFileNameColumn.setText(this.getEcoreNameColumnLabel());
        ecoreFileNameColumn.setResizable(true);
        packagesTable.setLayout((Layout)layout3);
        new ExtendedTableEditor(packagesTable){

            protected void editItem(TableItem tableItem, int column) {
                switch (column) {
                    case 1: 
                    case 2: {
                        String string = tableItem.getText(column);
                        this.horizontalAlignment = 16384;
                        this.minimumWidth = Math.max(50, tableItem.getBounds((int)column).width);
                        Text text = new Text((Composite)this.table, 0);
                        this.setEditor((Control)text, tableItem, column);
                        text.setFocus();
                        text.setText(string);
                        text.setSelection(0, string.length());
                        ModelPackagePage.this.validateEcoreModelFileName(string, null);
                        text.addFocusListener((FocusListener)new FocusAdapter(this, tableItem, column, text){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ TableItem val$tableItem;
                            private final /* synthetic */ int val$column;
                            private final /* synthetic */ Text val$text;
                            {
                                this.this$1 = var1_1;
                                this.val$tableItem = tableItem;
                                this.val$column = n;
                                this.val$text = text;
                            }

                            public void focusLost(FocusEvent event) {
                                this.this$1.modify(this.val$tableItem, this.val$column, this.val$text);
                            }
                        });
                        text.addKeyListener((KeyListener)new KeyAdapter(this, tableItem, column, text){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ TableItem val$tableItem;
                            private final /* synthetic */ int val$column;
                            private final /* synthetic */ Text val$text;
                            {
                                this.this$1 = var1_1;
                                this.val$tableItem = tableItem;
                                this.val$column = n;
                                this.val$text = text;
                            }

                            public void keyPressed(KeyEvent event) {
                                if (event.character == '\r' || event.character == '\n') {
                                    this.this$1.modify(this.val$tableItem, this.val$column, this.val$text);
                                    this.this$1.setEditor(null);
                                    this.val$text.dispose();
                                } else if (event.character == '\u001b') {
                                    this.this$1.setEditor(null);
                                    this.val$text.dispose();
                                }
                            }
                        });
                        text.addModifyListener(new ModifyListener(this, column, text){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ int val$column;
                            private final /* synthetic */ Text val$text;
                            {
                                this.this$1 = var1_1;
                                this.val$column = n;
                                this.val$text = text;
                            }

                            public void modifyText(ModifyEvent event) {
                                if (this.val$column == 1) {
                                    4.access$0(this.this$1).validateEcoreModelFileName(this.val$text.getText(), null);
                                }
                            }
                        });
                        ModelPackagePage.this.isCellEditing = true;
                        ModelPackagePage.this.setPageComplete(false);
                    }
                }
            }

            protected void modify(TableItem tableItem, int column, Text text) {
                tableItem.setText(column, text.getText());
                String value = tableItem.getText(column);
                text.setVisible(false);
                ModelImporter.EPackageInfo ePackageInfo = ModelPackagePage.this.getModelImporter().getEPackageInfo((EPackage)tableItem.getData());
                StringBuffer ecoreFileName = new StringBuffer(ePackageInfo.getEcoreFileName());
                if (ecoreFileName != null) {
                    ecoreFileName.replace(0, ecoreFileName.length(), value);
                    ePackageInfo.setEcoreFileName(ecoreFileName.toString());
                }
                ModelPackagePage.this.isCellEditing = false;
                ModelPackagePage.this.validate();
                ModelPackagePage.this.setPageComplete(ModelPackagePage.this.isPageComplete());
            }

            static /* synthetic */ ModelPackagePage access$0(4 var0) {
                return var0.ModelPackagePage.this;
            }
        };
        AdapterFactoryImpl adapterFactory = new AdapterFactoryImpl();
        this.packagesCheckboxTableViewer.setColumnProperties(new String[]{"a", "b"});
        this.packagesCheckboxTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.packagesCheckboxTableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory){

            public Image getColumnImage(Object o, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ModelPackagePage.this.getEPackageImage();
                    }
                }
                return null;
            }

            public String getColumnText(Object o, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ((EPackage)o).getName();
                    }
                    case 1: 
                    case 2: {
                        return ModelPackagePage.this.getModelImporter().getEPackageInfo((EPackage)o).getEcoreFileName();
                    }
                }
                return "";
            }
        });
        this.packagesCheckboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ModelPackagePage.this.ePackageCheckStateChanged();
            }
        });
    }

    protected void ePackageCheckStateChanged() {
        this.validate();
        this.getContainer().updateButtons();
        HashSet<Object> checkedElements = new HashSet<Object>(Arrays.asList(this.packagesCheckboxTableViewer.getCheckedElements()));
        Iterator i = this.getModelImporter().getEPackages().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            this.getModelImporter().getEPackageInfo(ePackage).setGenerate(checkedElements.contains(ePackage));
        }
    }

    public List getCheckedEPackages() {
        if (this.packagesCheckboxTableViewer != null) {
            return Arrays.asList(this.packagesCheckboxTableViewer.getCheckedElements());
        }
        return Collections.EMPTY_LIST;
    }

    protected String getEcoreNameColumnLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_EcoreModelName_label");
    }

    protected String getPackageColumnLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_Package_label");
    }

    protected String getDeselectAllLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_DeselectAll_label");
    }

    protected String getSelectAllLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_SelectAll_label");
    }

    protected String getPackagesLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_RootPackages_label");
    }

    protected Image getEPackageImage() {
        return ExtendedImageRegistry.INSTANCE.getImage((Object)new GenBaseItemProvider.UnderlayedImage(GenModelEditPlugin.INSTANCE.getImage("full/obj16/EPackage")));
    }

    protected void createReferencedGenModelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        layout.marginRight = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        composite.setLayout((Layout)layout);
        Label referencedGenModelsLabel = new Label(composite, 16384);
        referencedGenModelsLabel.setText(this.getReferencedGenModelLabel());
        referencedGenModelsLabel.setLayoutData((Object)new GridData(768));
        Button referencedGenModelsTreeBrowseButton = new Button(composite, 8);
        referencedGenModelsTreeBrowseButton.setText(this.getBrowseButtonLabel());
        referencedGenModelsTreeBrowseButton.setLayoutData((Object)new GridData(128));
        referencedGenModelsTreeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] result;
                ArrayList genModelResources = new ArrayList();
                ResourceSelectionDialog resourceSelectionDialog = new ResourceSelectionDialog(ModelPackagePage.this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), ModelPackagePage.this.getSelectGenModelDialogTitle());
                resourceSelectionDialog.setInitialSelections(genModelResources.toArray());
                Object[] objectArray = result = resourceSelectionDialog.open() == 0 ? resourceSelectionDialog.getResult() : null;
                if (result != null) {
                    ResourceSet referencedGenModels = ModelPackagePage.this.getModelImporter().createResourceSet();
                    UniqueEList.FastCompare genModels = new UniqueEList.FastCompare((Collection)ModelPackagePage.this.getModelImporter().getExternalGenModels());
                    int i = 0;
                    while (i < result.length) {
                        IResource resource = (IResource)result[i];
                        if (resource.getType() == 1 && !CodeGenUtil.isInJavaOutput((IResource)resource) && "genmodel".equals(resource.getFullPath().getFileExtension())) {
                            URI genModelURI = URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
                            Resource genModelResource = referencedGenModels.getResource(genModelURI, true);
                            genModels.add(genModelResource.getContents().get(0));
                        }
                        ++i;
                    }
                    ModelPackagePage.this.referencedGenModelsCheckboxTreeViewer.getTree().deselectAll();
                    ModelPackagePage.this.referencedGenModelsCheckboxTreeViewer.setInput((Object)new ItemProvider((Collection)genModels));
                    Iterator i2 = genModels.iterator();
                    while (i2.hasNext()) {
                        ModelPackagePage.this.referencedGenModelsCheckboxTreeViewer.expandToLevel(i2.next(), -1);
                    }
                    ModelPackagePage.this.referencedGenModelsCheckboxTreeViewerCheckStateChanged();
                }
            }
        });
        Tree referencedGenModelsTree = new Tree(parent, 2082);
        referencedGenModelsTree.setLayoutData((Object)new GridData(1808));
        this.referencedGenModelsCheckboxTreeViewer = new CheckboxTreeViewer(referencedGenModelsTree);
        GenModelItemProviderAdapterFactory genModelItemProviderAdapterFactory = new GenModelItemProviderAdapterFactory(){

            public Adapter createGenPackageAdapter() {
                if (this.genPackageItemProvider == null) {
                    this.genPackageItemProvider = new GenPackageItemProvider(this, (AdapterFactory)this){
                        final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Collection getChildrenFeatures(Object object) {
                            return Collections.EMPTY_LIST;
                        }
                    };
                }
                return this.genPackageItemProvider;
            }
        };
        this.referencedGenModelsCheckboxTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)genModelItemProviderAdapterFactory));
        this.referencedGenModelsCheckboxTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)genModelItemProviderAdapterFactory){

            public String getText(Object element) {
                String text = super.getText(element);
                if (element instanceof GenModel) {
                    URI uri;
                    Resource resource = ((GenModel)element).eResource();
                    URI uRI = uri = resource != null ? resource.getURI() : null;
                    if (uri != null) {
                        String location = uri.toString();
                        if ("platform".equals(uri.scheme()) && uri.segmentCount() > 1) {
                            boolean plugin = "plugin".equals(uri.segment(0));
                            String type = ImporterPlugin.INSTANCE.getString(plugin ? "_UI_PlatformPlugin_label" : "_UI_PlatformResource_label");
                            location = ImporterPlugin.INSTANCE.getString("_UI_PlatformLocation_label", new Object[]{type, uri.segment(1)});
                        }
                        text = ImporterPlugin.INSTANCE.getString("_UI_ReferencedGenModel_label", new Object[]{text, location});
                    }
                }
                return text;
            }
        });
        this.referencedGenModelsCheckboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ModelPackagePage.this.referencedGenModelsCheckboxTreeViewerCheckStateChanged();
            }
        });
    }

    protected void referencedGenModelsCheckboxTreeViewerCheckStateChanged() {
        this.filterPackagesTable(false);
        this.validate();
        this.setPageComplete(this.isPageComplete());
    }

    protected String getBrowseButtonLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_Browse_label");
    }

    protected String getReferencedGenModelLabel() {
        return ImporterPlugin.INSTANCE.getString("_UI_ReferencedGeneratorModels_label");
    }

    protected String getSelectGenModelDialogTitle() {
        return ImporterPlugin.INSTANCE.getString("_UI_SelectAllGeneratorModels_description");
    }

    protected void validate() {
        List tableCheckedEPackages = this.getCheckedEPackages();
        ModelImporter.EPackageList referencedEPackages = new ModelImporter.EPackageList();
        Iterator i = this.getModelImporter().getEPackages().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            if (!tableCheckedEPackages.contains(ePackage) && this.filteredEPackages.contains(ePackage)) continue;
            TreeIterator j = ePackage.eAllContents();
            while (j.hasNext()) {
                EObject eObject = (EObject)j.next();
                Iterator k = eObject.eCrossReferences().iterator();
                while (k.hasNext()) {
                    Object o = k.next();
                    if (!(o instanceof EClassifier)) continue;
                    EClassifier eClassifier = (EClassifier)o;
                    referencedEPackages.add(eClassifier.getEPackage());
                }
            }
        }
        String errorMessage = null;
        Iterator i2 = referencedEPackages.iterator();
        while (i2.hasNext()) {
            EPackage ePackage = (EPackage)i2.next();
            if (tableCheckedEPackages.contains(ePackage) || !this.filteredEPackages.contains(ePackage)) continue;
            errorMessage = ImporterPlugin.INSTANCE.getString("_UI_PackageIsUsedBySelectedPackage_message", new Object[]{ePackage.getName()});
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            boolean allNamesAreValid = true;
            Iterator i3 = tableCheckedEPackages.iterator();
            while (i3.hasNext()) {
                EPackage ePackage = (EPackage)i3.next();
                String fileName = this.getModelImporter().getEPackageInfo(ePackage).getEcoreFileName();
                allNamesAreValid = this.validateEcoreModelFileName(fileName, ePackage.getName());
                if (!allNamesAreValid) break;
            }
            if (allNamesAreValid) {
                this.setErrorMessage(this.checkEcoreFileNames());
            }
        }
    }

    protected boolean validateEcoreModelFileName(String fileName, String packageName) {
        IStatus status = this.getModelImporter().checkEcoreModelFileName(fileName, packageName);
        this.handleStatus(status);
        return status.isOK();
    }

    protected void filterPackagesTable(boolean reloadReferencedGenPackagesTable) {
        if (this.referencedGenModelsCheckboxTreeViewer != null) {
            if (reloadReferencedGenPackagesTable) {
                if (!this.getModelImporter().getReferencedGenPackages().isEmpty() || !this.getModelImporter().getExternalGenModels().isEmpty()) {
                    Object[] referencedGenPackages = this.getModelImporter().getReferencedGenPackages().toArray(new GenPackage[this.getModelImporter().getReferencedGenPackages().size()]);
                    HashSet<GenModel> genModels = new HashSet<GenModel>();
                    int i = 0;
                    while (i < referencedGenPackages.length) {
                        genModels.add(referencedGenPackages[i].getGenModel());
                        ++i;
                    }
                    genModels.addAll(this.getModelImporter().getExternalGenModels());
                    this.referencedGenModelsCheckboxTreeViewer.setInput((Object)new ItemProvider(genModels));
                    this.referencedGenModelsCheckboxTreeViewer.expandAll();
                    this.referencedGenModelsCheckboxTreeViewer.setCheckedElements(referencedGenPackages);
                    this.referencedGenModelsCheckboxTreeViewer.setSelection((ISelection)new StructuredSelection(referencedGenPackages), true);
                }
            } else {
                this.getModelImporter().getReferencedGenPackages().clear();
                Object[] checkedElements = this.referencedGenModelsCheckboxTreeViewer.getCheckedElements();
                int i = 0;
                while (i < checkedElements.length) {
                    if (checkedElements[i] instanceof GenPackage) {
                        this.getModelImporter().getReferencedGenPackages().add(checkedElements[i]);
                    }
                    ++i;
                }
            }
        }
        this.filteredEPackages = this.getModelImporter().filterReferencedEPackages(this.getModelImporter().getEPackages());
        ArrayList<EPackage> checkedEPackages = new ArrayList<EPackage>();
        Iterator i = this.getModelImporter().getEPackages().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            ModelImporter.EPackageInfo ePackageInfo = this.getModelImporter().getEPackageInfo(ePackage);
            if (this.filteredEPackages.contains(ePackage) && ePackageInfo.isGenerate()) {
                checkedEPackages.add(ePackage);
                continue;
            }
            ePackageInfo.setGenerate(false);
        }
        this.packagesCheckboxTableViewer.setInput((Object)new ItemProvider((Collection)this.filteredEPackages));
        this.packagesCheckboxTableViewer.setCheckedElements(checkedEPackages.toArray());
    }

    protected String checkEcoreFileNames() {
        HashSet<String> fileNames = new HashSet<String>();
        int checkedCount = 0;
        Table table = this.packagesCheckboxTableViewer.getTable();
        TableItem[] tableItems = table.getItems();
        int i = 0;
        while (i < tableItems.length) {
            if (tableItems[i].getChecked()) {
                ++checkedCount;
                fileNames.add(tableItems[i].getText(1));
            }
            ++i;
        }
        return fileNames.size() < checkedCount ? ImporterPlugin.INSTANCE.getString("_UI_DuplicateEcoreNames_message") : null;
    }
}

