/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.xmi.XMLDefaultHandler;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLParserPool;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.xml.sax.SAXException;

public class XMLParserPoolImpl
implements XMLParserPool {
    private final Map parserCache = new HashMap();
    private final Map handlersCache = new HashMap();
    private final int SIZE = 200;

    public synchronized SAXParser get(Map features, Map properties, boolean useLexicalHandler) throws ParserConfigurationException, SAXException {
        Object o;
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.putAll(features);
        map.putAll(properties);
        map.put("USE_LEXICAL_HANDLER", useLexicalHandler ? Boolean.TRUE : Boolean.FALSE);
        if (this.parserCache.size() > 200) {
            this.parserCache.clear();
        }
        if ((o = this.parserCache.get(map)) != null) {
            ArrayList list = (ArrayList)o;
            int size = list.size();
            if (size > 0) {
                return (SAXParser)list.remove(size - 1);
            }
            return this.makeParser(features, properties);
        }
        this.parserCache.put(map, new ArrayList());
        return this.makeParser(features, properties);
    }

    public synchronized void release(SAXParser parser, Map features, Map properties, boolean useLexicalHandler) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.putAll(features);
        map.putAll(properties);
        map.put("USE_LEXICAL_HANDLER", useLexicalHandler ? Boolean.TRUE : Boolean.FALSE);
        ArrayList list = (ArrayList)this.parserCache.get(map);
        if (list.size() < 200) {
            list.add(parser);
        }
    }

    private SAXParser makeParser(Map features, Map properties) throws ParserConfigurationException, SAXException {
        Iterator i;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        if (features != null) {
            i = features.keySet().iterator();
            while (i.hasNext()) {
                String feature = (String)i.next();
                parser.getXMLReader().setFeature(feature, (Boolean)features.get(feature));
            }
        }
        if (properties != null) {
            i = properties.keySet().iterator();
            while (i.hasNext()) {
                String property = (String)i.next();
                parser.getXMLReader().setProperty(property, properties.get(property));
            }
        }
        return parser;
    }

    public synchronized XMLDefaultHandler getDefaultHandler(XMLResource resource, XMLLoad xmlLoad, XMLHelper helper, Map options) {
        Object o;
        if (this.handlersCache.size() > 200) {
            this.handlersCache.clear();
        }
        if ((o = this.handlersCache.get(options)) != null) {
            ArrayList list = (ArrayList)o;
            int size = list.size();
            if (size > 0) {
                XMLDefaultHandler handler = (XMLDefaultHandler)list.remove(size - 1);
                handler.prepare(resource, helper, options);
                return handler;
            }
            return xmlLoad.createDefaultHandler();
        }
        this.handlersCache.put(options, new ArrayList());
        return xmlLoad.createDefaultHandler();
    }

    public synchronized void releaseDefaultHandler(XMLDefaultHandler handler, Map options) {
        handler.reset();
        ArrayList<XMLDefaultHandler> list = (ArrayList<XMLDefaultHandler>)this.handlersCache.get(options);
        if (list == null) {
            list = new ArrayList<XMLDefaultHandler>();
            this.handlersCache.put(options, list);
        } else if (list.size() < 200) {
            list.add(handler);
        }
    }
}

