/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.ui.contribution.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenBaseItemProvider;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProvider;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProviderAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenPackageItemProvider;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.ui.celleditor.ExtendedTableEditor;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterPage;
import org.eclipse.emf.converter.util.ConverterUIUtil;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class ModelConverterPackagePage
extends ModelConverterPage {
    protected CheckboxTableViewer ePackagesCheckboxTableViewer;
    protected int ePackageDataTableColumn = 1;
    protected CheckboxTreeViewer referencedGenModelsCheckboxTreeViewer;
    protected List filteredEPackages = new ConverterUtil.EPackageList();
    protected boolean showReferencedGenModels = false;
    protected boolean isCellEditing = false;

    protected ModelConverterPackagePage(ModelConverter modelConverter, String pageName) {
        super(modelConverter, pageName);
        this.setTitle(ConverterPlugin.INSTANCE.getString("_UI_PackageSelection_title"));
    }

    public void dispose() {
        this.ePackagesCheckboxTableViewer = null;
        this.referencedGenModelsCheckboxTreeViewer = null;
        if (this.filteredEPackages != null) {
            this.filteredEPackages.clear();
            this.filteredEPackages = null;
        }
        super.dispose();
    }

    public void setShowReferencedGenModels(boolean showReferencedGenModels) {
        this.showReferencedGenModels = showReferencedGenModels;
    }

    public boolean showReferencedGenModels() {
        return this.showReferencedGenModels;
    }

    protected void pageActivated(boolean firstTime, int cause) {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ModelConverterPackagePage.this.filterEPackagesTable(true);
                ModelConverterPackagePage.this.validate();
                ModelConverterPackagePage.this.getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && !this.getModelConverter().getEPackages().isEmpty() && this.ePackagesCheckboxTableViewer != null && this.ePackagesCheckboxTableViewer.getCheckedElements().length > 0 && !this.isCellEditing;
    }

    public void createControl(Composite parent) {
        SashForm composite = null;
        if (this.showReferencedGenModels()) {
            composite = new SashForm(parent, 512);
            composite.setLayoutData((Object)new GridData(1808));
        } else {
            composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
        }
        Composite packageComposite = new Composite((Composite)composite, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        packageComposite.setLayout((Layout)layout);
        packageComposite.setLayoutData((Object)new GridData(1808));
        this.createPackageControl(packageComposite);
        if (this.showReferencedGenModels()) {
            Composite referencedGenModelComposite = new Composite((Composite)composite, 0);
            GridLayout layout2 = new GridLayout();
            layout2.verticalSpacing = 12;
            referencedGenModelComposite.setLayout((Layout)layout2);
            referencedGenModelComposite.setLayoutData((Object)new GridData(1808));
            this.createReferencedGenModelControl(referencedGenModelComposite);
            composite.setWeights(new int[]{60, 40});
        }
        this.setControl((Control)composite);
    }

    protected void createPackageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        layout.marginRight = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        composite.setLayout((Layout)layout);
        Label packagesLabel = new Label(composite, 16384);
        packagesLabel.setText(this.getPackagesLabel());
        packagesLabel.setLayoutData((Object)new GridData(768));
        Composite selectionComposite = new Composite(composite, 0);
        selectionComposite.setLayoutData((Object)new GridData(128));
        GridLayout layout2 = new GridLayout(2, true);
        layout2.marginLeft = -5;
        layout2.marginRight = -5;
        layout2.marginTop = -5;
        layout2.marginBottom = -5;
        selectionComposite.setLayout((Layout)layout2);
        Button selectAllButton = new Button(selectionComposite, 8);
        selectAllButton.setLayoutData((Object)new GridData(768));
        selectAllButton.setText(this.getSelectAllLabel());
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelConverterPackagePage.this.ePackagesCheckboxTableViewer.setCheckedElements(ModelConverterPackagePage.this.getModelConverter().getEPackages().toArray());
                ModelConverterPackagePage.this.ePackageCheckStateChanged();
            }
        });
        Button deselectAllButton = new Button(selectionComposite, 8);
        deselectAllButton.setLayoutData((Object)new GridData(768));
        deselectAllButton.setText(this.getDeselectAllLabel());
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelConverterPackagePage.this.ePackagesCheckboxTableViewer.setCheckedElements(new Object[0]);
                ModelConverterPackagePage.this.ePackageCheckStateChanged();
            }
        });
        Table packagesTable = new Table(parent, 2084);
        this.ePackagesCheckboxTableViewer = new CheckboxTableViewer(packagesTable);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.heightHint = 90;
        packagesTable.setLayoutData((Object)data);
        packagesTable.setLinesVisible(true);
        packagesTable.setLayout((Layout)new TableLayout());
        this.ePackagesCheckboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ModelConverterPackagePage.this.ePackageCheckStateChanged();
            }
        });
        this.adjustEPackagesTableViewer(this.ePackagesCheckboxTableViewer);
    }

    protected void addEPackagesTableColumns(CheckboxTableViewer ePackagesTableViewer) {
        ePackagesTableViewer.setColumnProperties(new String[]{"a", "b"});
        Table table = ePackagesTableViewer.getTable();
        table.setHeaderVisible(true);
        TableLayout tableLayout = (TableLayout)table.getLayout();
        TableColumn packageColumn = new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        packageColumn.setText(this.getEPackageColumnLabel());
        packageColumn.setResizable(true);
        TableColumn dataColumn = new TableColumn(table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        dataColumn.setText(this.getEPackageDataColumnLabel());
        dataColumn.setResizable(true);
    }

    protected void adjustEPackagesTableViewer(CheckboxTableViewer ePackagesTableViewer) {
        AdapterFactoryImpl adapterFactory = new AdapterFactoryImpl();
        ePackagesTableViewer.setContentProvider(this.getEPackagesTableViewerContentProvider((AdapterFactory)adapterFactory));
        ePackagesTableViewer.setLabelProvider((IBaseLabelProvider)this.getEPackagesTableViewerLabelProvider((AdapterFactory)adapterFactory));
        this.addEPackagesTableColumns(ePackagesTableViewer);
    }

    protected ExtendedTableEditor createEPackageDataColumnTableEditor() {
        return new ExtendedTableEditor(this.ePackagesCheckboxTableViewer.getTable()){

            protected void editItem(TableItem tableItem, int index) {
                if (index == ModelConverterPackagePage.this.ePackageDataTableColumn) {
                    String string = tableItem.getText(index);
                    this.horizontalAlignment = 16384;
                    this.minimumWidth = Math.max(50, tableItem.getBounds((int)index).width);
                    Text text = new Text((Composite)this.table, 0);
                    this.setEditor((Control)text, tableItem, index);
                    text.setFocus();
                    text.setText(string);
                    text.setSelection(0, string.length());
                    if (tableItem.getChecked()) {
                        ModelConverterPackagePage.this.validateEPackageData((EPackage)tableItem.getData(), string);
                    }
                    text.addFocusListener((FocusListener)new FocusAdapter(this, tableItem, index, text){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ TableItem val$tableItem;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ Text val$text;
                        {
                            this.this$1 = var1_1;
                            this.val$tableItem = tableItem;
                            this.val$index = n;
                            this.val$text = text;
                        }

                        public void focusLost(FocusEvent event) {
                            this.this$1.modify(this.val$tableItem, this.val$index, this.val$text);
                        }
                    });
                    text.addKeyListener((KeyListener)new KeyAdapter(this, tableItem, index, text){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ TableItem val$tableItem;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ Text val$text;
                        {
                            this.this$1 = var1_1;
                            this.val$tableItem = tableItem;
                            this.val$index = n;
                            this.val$text = text;
                        }

                        public void keyPressed(KeyEvent event) {
                            if (event.character == '\r' || event.character == '\n') {
                                this.this$1.modify(this.val$tableItem, this.val$index, this.val$text);
                                this.this$1.setEditor(null);
                                this.val$text.dispose();
                            } else if (event.character == '\u001b') {
                                this.this$1.setEditor(null);
                                this.val$text.dispose();
                            }
                        }
                    });
                    text.addModifyListener(new ModifyListener(this, index, tableItem, text){
                        final /* synthetic */ 5 this$1;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ TableItem val$tableItem;
                        private final /* synthetic */ Text val$text;
                        {
                            this.this$1 = var1_1;
                            this.val$index = n;
                            this.val$tableItem = tableItem;
                            this.val$text = text;
                        }

                        public void modifyText(ModifyEvent event) {
                            if (this.val$index == 1 && this.val$tableItem.getChecked()) {
                                5.access$0(this.this$1).validateEPackageData((EPackage)this.val$tableItem.getData(), this.val$text.getText());
                            }
                        }
                    });
                    ModelConverterPackagePage.this.isCellEditing = true;
                    ModelConverterPackagePage.this.setPageComplete(false);
                }
            }

            protected void modify(TableItem tableItem, int column, Text text) {
                String value = text.getText();
                tableItem.setText(column, value);
                text.setVisible(false);
                ModelConverterPackagePage.this.setEPackageData((EPackage)tableItem.getData(), value);
                ModelConverterPackagePage.this.isCellEditing = false;
                ModelConverterPackagePage.this.validate();
                ModelConverterPackagePage.this.setPageComplete(ModelConverterPackagePage.this.isPageComplete());
            }

            static /* synthetic */ ModelConverterPackagePage access$0(5 var0) {
                return var0.ModelConverterPackagePage.this;
            }
        };
    }

    protected boolean validateEPackageData(EPackage ePackage, String data) {
        return true;
    }

    protected void setEPackageData(EPackage ePackage, String data) {
    }

    protected String getEPackageData(EPackage ePackage) {
        return null;
    }

    protected IContentProvider getEPackagesTableViewerContentProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryContentProvider(adapterFactory);
    }

    protected ILabelProvider getEPackagesTableViewerLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider(adapterFactory){

            public Image getColumnImage(Object o, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ModelConverterPackagePage.this.getEPackageImage();
                    }
                }
                return null;
            }

            public String getColumnText(Object o, int columnIndex) {
                EPackage ePackage = (EPackage)o;
                String text = columnIndex == 0 ? ModelConverterPackagePage.this.getLabel(ePackage) : (columnIndex == ModelConverterPackagePage.this.ePackageDataTableColumn ? ModelConverterPackagePage.this.getEPackageData(ePackage) : null);
                return text == null ? "" : text;
            }
        };
    }

    protected String getLabel(EPackage ePackage) {
        return this.supportsNestedPackages() ? ConverterUtil.getQualifiedName(ePackage) : ePackage.getName();
    }

    protected void ePackageCheckStateChanged() {
        this.validate();
        this.getContainer().updateButtons();
        HashSet<Object> checkedElements = new HashSet<Object>(Arrays.asList(this.ePackagesCheckboxTableViewer.getCheckedElements()));
        Iterator i = this.getModelConverter().getEPackages().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            this.getModelConverter().getEPackageConvertInfo(ePackage).setConvert(checkedElements.contains(ePackage));
        }
    }

    public List getCheckedEPackages() {
        if (this.ePackagesCheckboxTableViewer != null) {
            return Arrays.asList(this.ePackagesCheckboxTableViewer.getCheckedElements());
        }
        return Collections.EMPTY_LIST;
    }

    public List getCheckedReferencedGenPackages() {
        if (this.referencedGenModelsCheckboxTreeViewer != null) {
            ConverterUtil.GenPackageList genPackages = new ConverterUtil.GenPackageList();
            Object[] checkedElements = this.referencedGenModelsCheckboxTreeViewer.getCheckedElements();
            int i = 0;
            while (i < checkedElements.length) {
                if (checkedElements[i] instanceof GenPackage) {
                    genPackages.add(checkedElements[i]);
                }
                ++i;
            }
            return genPackages;
        }
        return Collections.EMPTY_LIST;
    }

    protected String getEPackageColumnLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_Package_label");
    }

    protected String getEPackageDataColumnLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_EPackageData_label");
    }

    protected String getDeselectAllLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_DeselectAll_label");
    }

    protected String getSelectAllLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_SelectAll_label");
    }

    protected String getPackagesLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_Packages_label");
    }

    protected Image getEPackageImage() {
        return ExtendedImageRegistry.INSTANCE.getImage((Object)new GenBaseItemProvider.UnderlayedImage(GenModelEditPlugin.INSTANCE.getImage("full/obj16/EPackage")));
    }

    protected void createReferencedGenModelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = -5;
        layout.marginRight = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        composite.setLayout((Layout)layout);
        Label referencedGenModelsLabel = new Label(composite, 16384);
        referencedGenModelsLabel.setText(this.getReferencedGenModelsLabel());
        referencedGenModelsLabel.setLayoutData((Object)new GridData(768));
        Button referencedGenModelsBrowseButton = new Button(composite, 8);
        referencedGenModelsBrowseButton.setText(this.getBrowseButtonLabel());
        referencedGenModelsBrowseButton.setLayoutData((Object)new GridData(128));
        referencedGenModelsBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ModelConverterPackagePage.this.referencedGenModelsBrowseSelected(ModelConverterPackagePage.this.referencedGenModelsCheckboxTreeViewer);
            }
        });
        Tree referencedGenModelsTree = new Tree(parent, 2084);
        referencedGenModelsTree.setLayoutData((Object)new GridData(1808));
        referencedGenModelsTree.setLinesVisible(true);
        this.referencedGenModelsCheckboxTreeViewer = new CheckboxTreeViewer(referencedGenModelsTree);
        this.referencedGenModelsCheckboxTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ModelConverterPackagePage.this.referencedGenModelsCheckboxTreeViewerCheckStateChanged(event);
            }
        });
        this.adjustReferencedGenModelsTreeViewer(this.referencedGenModelsCheckboxTreeViewer);
    }

    protected void addReferencedGenModelsTreeColumns(CheckboxTreeViewer referencedGenModelsTreeViewer) {
    }

    protected boolean supportsNestedPackages() {
        return false;
    }

    protected void adjustReferencedGenModelsTreeViewer(CheckboxTreeViewer referencedGenModelsTreeViewer) {
        GenModelItemProviderAdapterFactory genModelItemProviderAdapterFactory = new GenModelItemProviderAdapterFactory(){

            public Adapter createGenModelAdapter() {
                if (this.genModelItemProvider == null) {
                    this.genModelItemProvider = new GenModelItemProvider(this, (AdapterFactory)this){
                        final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Collection getChildrenFeatures(Object object) {
                            return Collections.singleton(GenModelPackage.Literals.GEN_MODEL__GEN_PACKAGES);
                        }
                    };
                }
                return this.genModelItemProvider;
            }

            public Adapter createGenPackageAdapter() {
                if (this.genPackageItemProvider == null) {
                    this.genPackageItemProvider = new GenPackageItemProvider(this, (AdapterFactory)this){
                        final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Collection getChildrenFeatures(Object object) {
                            return 12.access$0(this.this$1).supportsNestedPackages() ? Collections.singleton(GenModelPackage.Literals.GEN_PACKAGE__NESTED_GEN_PACKAGES) : Collections.EMPTY_SET;
                        }
                    };
                }
                return this.genPackageItemProvider;
            }

            static /* synthetic */ ModelConverterPackagePage access$0(12 var0) {
                return var0.ModelConverterPackagePage.this;
            }
        };
        referencedGenModelsTreeViewer.setSorter(new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements.length > 0 && elements[0] instanceof GenModel) {
                    super.sort(viewer, elements);
                }
            }
        });
        referencedGenModelsTreeViewer.setContentProvider(this.getReferencedGenModelsTreeViewerContentProvider((AdapterFactory)genModelItemProviderAdapterFactory));
        referencedGenModelsTreeViewer.setLabelProvider((IBaseLabelProvider)this.getReferencedGenModelsTreeViewerLabelProvider((AdapterFactory)genModelItemProviderAdapterFactory));
        this.addReferencedGenModelsTreeColumns(this.referencedGenModelsCheckboxTreeViewer);
        this.addReferencedGenModelsTreeCheckStateManager(this.referencedGenModelsCheckboxTreeViewer.getTree());
    }

    protected void addReferencedGenModelsTreeCheckStateManager(Tree tree) {
        new ConverterUIUtil.TreeCheckStateManager(tree);
    }

    protected IContentProvider getReferencedGenModelsTreeViewerContentProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryContentProvider(adapterFactory);
    }

    protected ILabelProvider getReferencedGenModelsTreeViewerLabelProvider(AdapterFactory adapterFactory) {
        return new AdapterFactoryLabelProvider(adapterFactory){

            public String getText(Object element) {
                return ModelConverterPackagePage.this.getLabel(element, super.getText(element));
            }
        };
    }

    protected String getLabel(Object object, String defaultText) {
        if (object instanceof GenModel) {
            URI uri;
            GenModel genModel = (GenModel)object;
            Resource resource = genModel.eResource();
            URI uRI = uri = resource != null ? resource.getURI() : null;
            if (uri != null) {
                String location = uri.toString();
                if ("platform".equals(uri.scheme()) && uri.segmentCount() > 1) {
                    boolean plugin = "plugin".equals(uri.segment(0));
                    String type = ConverterPlugin.INSTANCE.getString(plugin ? "_UI_PlatformPlugin_label" : "_UI_PlatformResource_label");
                    location = ConverterPlugin.INSTANCE.getString("_UI_PlatformLocation_label", new Object[]{type, uri.segment(1)});
                }
                return ConverterPlugin.INSTANCE.getString("_UI_ReferencedGenModel_label", new Object[]{defaultText, location});
            }
        } else if (object instanceof GenPackage) {
            return this.getLabel((GenPackage)object);
        }
        return defaultText;
    }

    protected String getLabel(GenPackage genPackage) {
        return genPackage.getEcorePackage().getName();
    }

    protected void referencedGenModelsBrowseSelected(CheckboxTreeViewer treeViewer) {
        IPath path = null;
        Resource resource = this.getModelConverter().getGenModel().eResource();
        if (resource != null) {
            String stringURI = resource.getURI().toString();
            if (stringURI.startsWith("platform:/resource/")) {
                // empty if block
            }
            path = new Path(stringURI.substring("platform:/resource/".length())).makeAbsolute();
        }
        final IPath genModelPath = path;
        ViewerFilter genModelFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return "genmodel".equals(file.getFileExtension()) && !file.getFullPath().equals((Object)genModelPath);
                }
                return true;
            }
        };
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)this.getShell(), null, (String)ConverterPlugin.INSTANCE.getString("_UI_SelectGenModel_message"), (boolean)true, null, Collections.singletonList(genModelFilter));
        if (files.length > 0) {
            ResourceSet referencedGenModels = this.getModelConverter().createResourceSet();
            UniqueEList.FastCompare genModels = new UniqueEList.FastCompare();
            int i = 0;
            while (i < files.length) {
                URI genModelURI = URI.createPlatformResourceURI((String)files[i].getFullPath().toString(), (boolean)true);
                Resource genModelResource = referencedGenModels.getResource(genModelURI, true);
                GenModel genModel = (GenModel)genModelResource.getContents().get(0);
                genModels.add(genModel);
                ++i;
            }
            this.addExternalGenModels((List)genModels);
            treeViewer.getTree().deselectAll();
            treeViewer.setInput((Object)new ItemProvider((Collection)genModels));
            Iterator i2 = genModels.iterator();
            while (i2.hasNext()) {
                treeViewer.expandToLevel(i2.next(), -1);
            }
            this.referencedGenModelsCheckboxTreeViewerCheckStateChanged(null);
        }
    }

    protected void referencedGenModelsCheckboxTreeViewerCheckStateChanged(CheckStateChangedEvent event) {
        if (event == null || event.getElement() instanceof GenPackage) {
            this.filterEPackagesTable(false);
            this.validate();
            this.getContainer().updateButtons();
        }
    }

    protected String getBrowseButtonLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_Browse_label");
    }

    protected String getReferencedGenModelsLabel() {
        return ConverterPlugin.INSTANCE.getString("_UI_ReferencedGeneratorModels_label");
    }

    protected String getSelectGenModelDialogMessage() {
        return ConverterPlugin.INSTANCE.getString("_UI_SelectAllGeneratorModels_description");
    }

    protected void validate() {
        String message = null;
        HashMap<String, GenPackage> nsURIToGenPackage = new HashMap<String, GenPackage>();
        List referencedGenPackages = this.getModelConverter().getReferencedGenPackages();
        Iterator i = referencedGenPackages.iterator();
        while (i.hasNext()) {
            GenPackage genPackage = (GenPackage)i.next();
            GenPackage previousGenPackage = nsURIToGenPackage.put(genPackage.getNSURI(), genPackage);
            if (previousGenPackage == null) continue;
            message = ConverterPlugin.INSTANCE.getString("_UI_SameReferencedNSURI_error", new Object[]{this.getLabel(previousGenPackage), this.getLabel(genPackage)});
            break;
        }
        if (message == null) {
            EPackage ePackage;
            List tableCheckedEPackages = this.getCheckedEPackages();
            ConverterUtil.EPackageList referencedEPackages = new ConverterUtil.EPackageList();
            Iterator i2 = this.getModelConverter().getEPackages().iterator();
            while (i2.hasNext()) {
                ePackage = (EPackage)i2.next();
                if (!tableCheckedEPackages.contains(ePackage) && this.filteredEPackages.contains(ePackage)) continue;
                referencedEPackages.addAll(ConverterUtil.computeRequiredPackages(ePackage));
            }
            i2 = referencedEPackages.iterator();
            while (i2.hasNext()) {
                ePackage = (EPackage)i2.next();
                if (tableCheckedEPackages.contains(ePackage) || !this.filteredEPackages.contains(ePackage)) continue;
                message = ConverterPlugin.INSTANCE.getString("_UI_PackageIsUsedBySelectedPackage_message", new Object[]{this.getLabel(ePackage)});
                break;
            }
        }
        this.setErrorMessage(message);
    }

    protected void filterEPackagesTable(boolean reloadReferencedGenPackagesTable) {
        Iterator i;
        Object genPackagesToCheck = null;
        if (this.referencedGenModelsCheckboxTreeViewer != null) {
            GenPackage genPackage;
            if (reloadReferencedGenPackagesTable) {
                if (!this.getModelConverter().getReferencedGenPackages().isEmpty() || !this.getModelConverter().getExternalGenModels().isEmpty()) {
                    UniqueEList.FastCompare genModels = new UniqueEList.FastCompare();
                    genPackagesToCheck = new ConverterUtil.GenPackageList();
                    i = this.getModelConverter().getReferencedGenPackages().iterator();
                    while (i.hasNext()) {
                        genPackage = (GenPackage)i.next();
                        genModels.add(genPackage.getGenModel());
                        ModelConverter.ReferencedGenPackageConvertInfo genPackageInfo = this.getModelConverter().getReferenceGenPackageConvertInfo(genPackage);
                        if (!genPackageInfo.isValidReference()) continue;
                        genPackagesToCheck.add(genPackage);
                    }
                    this.addExternalGenModels((List)genModels);
                    this.referencedGenModelsCheckboxTreeViewer.setInput((Object)new ItemProvider((Collection)genModels));
                    this.referencedGenModelsCheckboxTreeViewer.expandAll();
                }
            } else {
                this.getModelConverter().getReferencedGenPackages().clear();
                Object[] checkedElements = this.referencedGenModelsCheckboxTreeViewer.getCheckedElements();
                int i2 = 0;
                while (i2 < checkedElements.length) {
                    if (checkedElements[i2] instanceof GenPackage) {
                        genPackage = (GenPackage)checkedElements[i2];
                        this.getModelConverter().getReferencedGenPackages().add(genPackage);
                        this.getModelConverter().getReferenceGenPackageConvertInfo(genPackage).setValidReference(true);
                    }
                    ++i2;
                }
                this.referencedGenModelsCheckboxTreeViewer.refresh();
                genPackagesToCheck = this.getModelConverter().getReferencedGenPackages();
            }
        }
        if ((genPackagesToCheck = this.getReferencedGenPackagesToCheck((List)(genPackagesToCheck == null ? Collections.EMPTY_LIST : genPackagesToCheck), reloadReferencedGenPackagesTable)).isEmpty()) {
            this.filteredEPackages = this.getModelConverter().getEPackages();
        } else {
            if (reloadReferencedGenPackagesTable) {
                this.referencedGenModelsCheckboxTreeViewer.setCheckedElements(genPackagesToCheck.toArray());
                this.referencedGenModelsCheckboxTreeViewer.setSelection((ISelection)new StructuredSelection(genPackagesToCheck.toArray()), true);
            }
            this.filteredEPackages = this.getModelConverter().filterReferencedEPackages(this.getModelConverter().getEPackages(), (List)genPackagesToCheck);
        }
        ArrayList<EPackage> checkedEPackages = new ArrayList<EPackage>();
        i = this.getModelConverter().getEPackages().iterator();
        while (i.hasNext()) {
            EPackage ePackage = (EPackage)i.next();
            ModelConverter.EPackageConvertInfo ePackageInfo = this.getModelConverter().getEPackageConvertInfo(ePackage);
            if (this.filteredEPackages.contains(ePackage) && ePackageInfo.isConvert()) {
                checkedEPackages.add(ePackage);
                continue;
            }
            ePackageInfo.setConvert(false);
        }
        this.ePackagesCheckboxTableViewer.setInput((Object)new ItemProvider((Collection)this.filteredEPackages));
        this.ePackagesCheckboxTableViewer.setCheckedElements(checkedEPackages.toArray());
    }

    protected List getReferencedGenPackagesToCheck(List genPackages, boolean reloadReferencedGenPackagesTable) {
        return genPackages;
    }

    protected void addExternalGenModels(List genModels) {
        ArrayList externalGenModels = new ArrayList(this.getModelConverter().getExternalGenModels());
        if (!externalGenModels.isEmpty()) {
            boolean hasExporterGenModel;
            GenModel exporterGenModel = this.getModelConverter().getGenModel();
            boolean bl = hasExporterGenModel = exporterGenModel != null && genModels.contains(exporterGenModel);
            if (!hasExporterGenModel) {
                genModels.add(exporterGenModel);
            }
            Iterator i = genModels.iterator();
            while (i.hasNext()) {
                GenModel genModel = (GenModel)i.next();
                Iterator j = externalGenModels.iterator();
                while (j.hasNext()) {
                    URI externalURI;
                    URI uri;
                    GenModel externalGenModel = (GenModel)j.next();
                    if (genModel == externalGenModel) {
                        j.remove();
                        continue;
                    }
                    URI uRI = uri = genModel.eResource() != null ? genModel.eResource().getURI() : null;
                    if (uri == null) continue;
                    URI uRI2 = externalURI = externalGenModel.eResource() != null ? externalGenModel.eResource().getURI() : null;
                    if (!uri.equals((Object)externalURI)) continue;
                    j.remove();
                }
            }
            genModels.addAll(externalGenModels);
            if (!hasExporterGenModel) {
                genModels.remove(exporterGenModel);
            }
        }
    }
}

