/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.util;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConverterUIUtil {

    public static class TreeCheckStateManager
    implements Listener {
        protected Tree tree;
        protected boolean internalChange = false;

        public TreeCheckStateManager(Tree tree) {
            this.tree = tree;
            tree.addListener(13, (Listener)this);
            tree.addListener(12, (Listener)this);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(Event event) {
            if (this.internalChange) return;
            if (event.widget != this.tree) return;
            if (event.detail != 32) return;
            switch (event.type) {
                case 13: {
                    try {
                        this.internalChange = true;
                        this.checkStateChanged((TreeItem)event.item, true);
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        this.internalChange = false;
                        throw throwable;
                    }
                }
                {
                    Object var2_4 = null;
                    this.internalChange = false;
                    return;
                }
                case 12: {
                    this.treeDisposed();
                    return;
                }
            }
        }

        protected void checkStateChanged(TreeItem item, boolean changeChildren) {
            this.setGray(item, false);
            TreeItem[] sibilings = item.getParentItem() != null ? item.getParentItem().getItems() : item.getParent().getItems();
            boolean checked = item.getChecked();
            if (changeChildren) {
                this.checkChildren(item, checked);
            }
            boolean grayParent = false;
            int i = 0;
            while (i < sibilings.length) {
                TreeItem sibiling = sibilings[i];
                if (checked ? !sibiling.getChecked() : sibiling.getChecked()) {
                    grayParent = true;
                    break;
                }
                ++i;
            }
            if (grayParent) {
                this.grayParents(item);
            } else {
                TreeItem parent = item.getParentItem();
                if (parent != null) {
                    this.setCheck(parent, checked);
                    this.setGray(parent, false);
                    this.checkStateChanged(parent, false);
                }
            }
        }

        protected void treeDisposed() {
            if (!this.tree.isDisposed()) {
                this.tree.removeListener(13, (Listener)this);
                this.tree.removeListener(12, (Listener)this);
            }
            this.tree = null;
        }

        protected void grayParents(TreeItem item) {
            item = item.getParentItem();
            while (item != null) {
                this.setCheck(item, true);
                this.setGray(item, true);
                item = item.getParentItem();
            }
        }

        protected void checkChildren(TreeItem item, boolean check) {
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                TreeItem child = items[i];
                this.setCheck(child, check);
                this.setGray(child, false);
                this.checkChildren(child, check);
                ++i;
            }
        }

        protected void setCheck(TreeItem item, boolean check) {
            if (item.getChecked() != check) {
                item.setChecked(check);
                this.tree.notifyListeners(13, this.createCheckEvent(item));
            }
        }

        protected Event createCheckEvent(TreeItem item) {
            Event event = new Event();
            event.type = 13;
            event.widget = item.getParent();
            event.item = item;
            event.detail = 32;
            event.display = item.getDisplay();
            return event;
        }

        protected void setGray(TreeItem item, boolean gray) {
            if (item.getGrayed() != gray) {
                item.setGrayed(gray);
            }
        }
    }
}

