/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ecore;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ecore.EcoreImporterPlugin;

public class EcoreImporter
extends ModelImporter {
    public String getID() {
        return "org.eclipse.emf.importer.ecore";
    }

    protected Diagnostic doComputeEPackages(Monitor monitor) throws Exception {
        Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
        List locationURIs = this.getModelLocationURIs();
        if (locationURIs.isEmpty()) {
            diagnostic = new BasicDiagnostic(4, EcoreImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, EcoreImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidCoreModel_message"), null);
        } else {
            monitor.beginTask("", 2);
            monitor.subTask(EcoreImporterPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{locationURIs}));
            ResourceSet ecoreResourceSet = this.createResourceSet();
            Iterator i = locationURIs.iterator();
            while (i.hasNext()) {
                URI ecoreModelLocation = (URI)i.next();
                ecoreResourceSet.getResource(ecoreModelLocation, true);
            }
            EcoreUtil.resolveAll((ResourceSet)ecoreResourceSet);
            i = ecoreResourceSet.getResources().iterator();
            while (i.hasNext()) {
                Resource resource = (Resource)i.next();
                this.getEPackages().addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE));
            }
        }
        return diagnostic;
    }

    public void addToResource(EPackage ePackage, ResourceSet resourceSet) {
        if (ePackage.eResource() != null && this.getGenModel().eResource() != null) {
            URI ePackageURI = ePackage.eResource().getURI();
            URI genModelURI = this.getGenModel().eResource().getURI();
            if (!ePackageURI.trimSegments(1).equals((Object)genModelURI.trimSegments(1))) {
                ePackage.eResource().getContents().remove((Object)ePackage);
            }
        }
        super.addToResource(ePackage, resourceSet);
    }

    protected void adjustGenModel(Monitor monitor) {
        super.adjustGenModel(monitor);
        URI genModelURI = this.createFileURI(this.getGenModelPath().toString());
        Iterator i = this.getModelLocationURIs().iterator();
        while (i.hasNext()) {
            this.getGenModel().getForeignModel().add((Object)this.makeRelative((URI)i.next(), genModelURI).toString());
        }
    }

    protected void loadOriginalGenModel(URI genModelURI) throws DiagnosticException {
        super.loadOriginalGenModel(genModelURI);
        StringBuffer text = new StringBuffer();
        Iterator i = this.getOriginalGenModel().getForeignModel().iterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            if (!value.endsWith(".ecore") && !value.endsWith(".emof")) continue;
            text.append(this.makeAbsolute(URI.createURI((String)value), genModelURI).toString());
            text.append(" ");
        }
        this.setModelLocation(text.toString().trim());
    }
}

