/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore.importer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreMapper;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.ecore.importer.XSDImporterPlugin;

public class XSDImporter
extends ModelImporter {
    protected boolean createEcoreMap = false;
    protected EObject mappingRoot;

    public void dispose() {
        this.mappingRoot = null;
        super.dispose();
    }

    public String getID() {
        return "org.eclipse.xsd.ecore.importer";
    }

    public boolean canCreateEcoreMap() {
        return Platform.getBundle((String)"org.eclipse.emf.mapping.xsd2ecore") != null;
    }

    public void setCreateEcoreMap(boolean createEcoreMap) {
        this.createEcoreMap = createEcoreMap;
    }

    public boolean createEcoreMap() {
        return this.createEcoreMap && this.canCreateEcoreMap();
    }

    public void setMappingRoot(EObject mappingRoot) {
        this.mappingRoot = mappingRoot;
    }

    public EObject getMappingRoot() {
        return this.mappingRoot;
    }

    protected Diagnostic doComputeEPackages(Monitor monitor) throws Exception {
        BasicDiagnostic basicDiagnostic = null;
        List locationURIs = this.getModelLocationURIs();
        if (locationURIs.isEmpty()) {
            basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.converter", 264, XSDImporterPlugin.INSTANCE.getString("_UI_SpecifyAValidXMLSchema_message"), null);
        } else {
            List result;
            Object lastElement;
            monitor.beginTask("", 2);
            monitor.subTask(XSDImporterPlugin.INSTANCE.getString("_UI_Loading_message", new Object[]{locationURIs}));
            XSDEcoreBuilder ecoreBuilder = new XSDEcoreBuilder();
            if (this.createEcoreMap()) {
                new MapHelper().setNewMapper(ecoreBuilder);
            }
            if ((lastElement = this.removeNonEPackageFromTheEnd(result = (List)ecoreBuilder.generate((Collection)locationURIs))) instanceof List) {
                List diagnostics = (List)lastElement;
                if (!diagnostics.isEmpty()) {
                    BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.converter", 1, XSDImporterPlugin.INSTANCE.getString("_UI_ErrorsWereDetectedXMLSchema_message"), null);
                    Iterator i = diagnostics.iterator();
                    while (i.hasNext()) {
                        List information = (List)i.next();
                        diagnostic.add((Diagnostic)new BasicDiagnostic("error".equals(information.get(0)) ? 4 : ("warning".equals(information.get(0)) ? 2 : 1), XSDImporterPlugin.getPlugin().getBundle().getSymbolicName(), 0, (String)information.get(1), null));
                    }
                    basicDiagnostic = diagnostic;
                }
                lastElement = this.removeNonEPackageFromTheEnd(result);
            }
            if (lastElement instanceof EObject) {
                this.setMappingRoot((EObject)lastElement);
            }
            this.getEPackages().addAll(result);
        }
        if (basicDiagnostic == null) {
            return Diagnostic.OK_INSTANCE;
        }
        return basicDiagnostic;
    }

    protected Object removeNonEPackageFromTheEnd(List list) {
        int lastIndex = list.size() - 1;
        if (lastIndex >= 0 && !(list.get(lastIndex) instanceof EPackage)) {
            return list.remove(lastIndex);
        }
        return null;
    }

    protected void adjustGenPackageDuringTraverse(GenPackage genPackage) {
        genPackage.setResource(GenResourceKind.XML_LITERAL);
    }

    protected void adjustGenModel(Monitor monitor) {
        super.adjustGenModel(monitor);
        IPath genModelFileFullPath = this.getGenModelPath();
        URI genModelURI = this.createFileURI(genModelFileFullPath.toString());
        Iterator i = this.getModelLocationURIs().iterator();
        while (i.hasNext()) {
            this.getGenModel().getForeignModel().add((Object)this.makeRelative((URI)i.next(), genModelURI).toString());
        }
        if (this.getMappingRoot() != null) {
            IPath mappingPath = genModelFileFullPath.removeFileExtension().addFileExtension("xsd2ecore");
            URI mappingModelURI = this.createFileURI(mappingPath.toString());
            Resource mappingModelResource = this.getGenModelResourceSet().createResource(mappingModelURI);
            mappingModelResource.getContents().add((Object)this.getMappingRoot());
        }
    }

    protected List computeResourcesToBeSaved() {
        List resources = super.computeResourcesToBeSaved();
        if (this.getMappingRoot() != null) {
            resources.add(this.getMappingRoot().eResource());
        }
        return resources;
    }

    protected void loadOriginalGenModel(URI genModelURI) throws DiagnosticException {
        super.loadOriginalGenModel(genModelURI);
        StringBuffer text = new StringBuffer();
        Iterator i = this.getOriginalGenModel().getForeignModel().iterator();
        while (i.hasNext()) {
            String value = (String)i.next();
            if (!value.endsWith(".xsd") && !value.endsWith(".wsdl")) continue;
            text.append(this.makeAbsolute(URI.createURI((String)value), genModelURI).toString());
            text.append(" ");
        }
        this.setModelLocation(text.toString().trim());
    }

    public static class MapHelper {
        public void setNewMapper(XSDEcoreBuilder ecoreBuilder) {
            try {
                XSD2EcoreMapper mapper = new XSD2EcoreMapper();
                ecoreBuilder.setMapper((MapBuilder.Mapper)mapper);
            }
            catch (Exception e) {
                XSDImporterPlugin.INSTANCE.log(e);
            }
        }
    }
}

