/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;

class GeneratedPackageRegistryReader
extends RegistryReader {
    static final String TAG_PACKAGE = "package";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";
    static final String ATT_GEN_MODEL = "genModel";
    protected Map ePackageNsURIToGenModelLocationMap;

    public GeneratedPackageRegistryReader() {
        super(Platform.getExtensionRegistry(), EcorePlugin.getPlugin().getBundle().getSymbolicName(), "generated_package");
    }

    public GeneratedPackageRegistryReader(Map ePackageNsURIToGenModelLocationMap) {
        this();
        this.ePackageNsURIToGenModelLocationMap = ePackageNsURIToGenModelLocationMap;
    }

    protected boolean readElement(IConfigurationElement element) {
        if (element.getName().equals(TAG_PACKAGE)) {
            String packageURI = element.getAttribute(ATT_URI);
            if (packageURI == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                String genModel;
                EPackage.Registry.INSTANCE.put(packageURI, new RegistryReader.EPackageDescriptor(element, ATT_CLASS));
                if (this.ePackageNsURIToGenModelLocationMap != null && (genModel = element.getAttribute(ATT_GEN_MODEL)) != null) {
                    URI genModelURI = URI.createURI((String)genModel);
                    if (genModelURI.isRelative()) {
                        genModelURI = URI.createURI((String)("platform:/plugin/" + element.getDeclaringExtension().getContributor().getName() + "/" + genModel));
                    }
                    this.ePackageNsURIToGenModelLocationMap.put(packageURI, genModelURI);
                }
                return true;
            }
        }
        return false;
    }
}

