/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui.contribution.base;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterWizard;
import org.eclipse.emf.importer.ImporterPlugin;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.IModelImporterWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;

public abstract class ModelImporterWizard
extends ModelConverterWizard
implements IModelImporterWizard {
    protected IFile originalGenModelFile;
    protected IFile modelFile;
    protected String fileName;
    protected IPath genModelContainerPath;
    protected IPath projectLocation;
    protected IPath projectPath;

    public ModelImporter getModelImporter() {
        return (ModelImporter)this.getModelConverter();
    }

    public List getFileExtensions() {
        return this.getModelImporter().getFileExtensions();
    }

    public void setOriginalGenModelFile(IFile originalGenModelFile) {
        this.originalGenModelFile = originalGenModelFile;
        if (originalGenModelFile != null) {
            this.setWindowTitle(ImporterPlugin.INSTANCE.getString("_UI_ReloadWizard_title"));
            try {
                this.getModelImporter().defineOriginalGenModelPath(originalGenModelFile.getFullPath());
            }
            catch (DiagnosticException exception) {
                Diagnostic diagnostic = exception.getDiagnostic();
                ErrorDialog.openError((Shell)this.getShell(), (String)GenModelEditPlugin.INSTANCE.getString("_UI_ModelProblems_title"), (String)ImporterPlugin.INSTANCE.getString("_UI_InvalidModel_message"), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
            }
        }
    }

    public IFile getOriginalGenModelFile() {
        return this.originalGenModelFile;
    }

    public void setModelFile(IFile modelFile) {
        this.modelFile = modelFile;
        this.getModelImporter().setModelFile(modelFile);
    }

    public IFile getModelFile() {
        return this.modelFile;
    }

    public void setGenModelFileName(String fileName) {
        this.fileName = fileName;
        this.getModelImporter().setGenModelFileName(fileName);
    }

    public String getGenModelFileName() {
        return this.fileName;
    }

    public void setGenModelContainerPath(IPath genModelContainerPath) {
        this.genModelContainerPath = genModelContainerPath;
        this.getModelImporter().setGenModelContainerPath(genModelContainerPath);
    }

    public IPath getGenModelContainerPath() {
        return this.genModelContainerPath;
    }

    public void setGenModelProjectLocation(IPath projectLocation) {
        this.projectLocation = projectLocation;
        this.getModelImporter().setGenModelProjectLocation(projectLocation);
    }

    public IPath getGenModelProjectLocation() {
        return this.projectLocation;
    }

    public void setGenModelProjectPath(IPath projectPath) {
        this.projectPath = projectPath;
        this.getModelImporter().setGenModelContainerPath(this.getModelImporter().computeGenModelContainerPath(projectPath));
    }

    public IPath getGenModelProjectPath() {
        return this.projectPath;
    }

    protected void doPerformFinish(Monitor monitor) throws Exception {
        this.getModelImporter().prepareGenModelAndEPackages(monitor);
        this.getModelImporter().saveGenModelAndEPackages(monitor);
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            IFile genModelFile = this.getFile(this.getModelImporter().getGenModelPath());
            if (this.getModelImporter().getOriginalGenModelPath() == null) {
                this.selectFile(genModelFile);
            }
            try {
                this.openEditor(genModelFile);
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)this.getShell(), (String)ImporterPlugin.INSTANCE.getString("_UI_OpenEditor_title"), (String)partInitException.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }
}

