/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.ui.contribution.base;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class ModelConverterPage
extends WizardPage
implements Listener {
    public static final int CAUSE_UNKNOWN = 0;
    public static final int CAUSE_BACK = 1;
    public static final int CAUSE_NEXT = 2;
    public static final int CAUSE_FINISH = 3;
    public static final int CAUSE_CANCEL = 4;
    protected ModelConverter modelConverter;
    protected boolean neverVisible = true;
    protected boolean forwardDirection = true;
    protected boolean handlingEvent = true;

    protected ModelConverterPage(ModelConverter modelConverter, String pageName) {
        super(pageName);
        this.modelConverter = modelConverter;
        this.setPageComplete(false);
    }

    public void dispose() {
        this.modelConverter = null;
        super.dispose();
    }

    protected ModelConverter getModelConverter() {
        return this.modelConverter;
    }

    protected void pageActivated(boolean firstTime, int cause) {
    }

    protected void pageDeactivated(int cause) {
    }

    public IWizardPage getNextPage() {
        this.forwardDirection = true;
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        this.forwardDirection = false;
        return super.getPreviousPage();
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null;
    }

    public boolean isHandlingEvent() {
        return this.handlingEvent;
    }

    public void setHandlingEvent(boolean handlingEvent) {
        this.handlingEvent = handlingEvent;
    }

    public void handleEvent(Event event) {
        if (this.isHandlingEvent()) {
            this.doHandleEvent(event);
        }
    }

    protected void doHandleEvent(Event event) {
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        this.handleDiagnostic(diagnostic, null, null, null);
    }

    protected void handleDiagnostic(Diagnostic diagnostic, String message, String dialogTitle, String dialogMessage) {
        if (diagnostic.getSeverity() == 0) {
            this.handleOKDiagnostic(diagnostic, message, dialogTitle, dialogMessage);
        } else {
            this.handleNotOKDiagnostic(diagnostic, this.decodeAction(diagnostic), message, dialogTitle, dialogMessage);
        }
    }

    protected ConverterUtil.DecodedAction decodeAction(Diagnostic diagnostic) {
        int actionCode = ConverterUtil.computeActionCode(diagnostic);
        return ConverterUtil.decodeAction(actionCode);
    }

    protected void handleOKDiagnostic(Diagnostic diagnostic, String message, String dialogTitle, String dialogMessage) {
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    protected void handleNotOKDiagnostic(Diagnostic diagnostic, ConverterUtil.DecodedAction decodedAction, String message, String dialogTitle, String dialogMessage) {
        int messageType = 0;
        switch (diagnostic.getSeverity()) {
            case 1: {
                messageType = 1;
                if (dialogTitle != null) break;
                dialogTitle = ConverterPlugin.INSTANCE.getString("_UI_DialogInformation_title");
                break;
            }
            case 2: {
                messageType = 2;
                if (dialogTitle != null) break;
                dialogTitle = ConverterPlugin.INSTANCE.getString("_UI_DialogWarning_title");
                break;
            }
            case 4: {
                messageType = 3;
                if (dialogTitle != null) break;
                dialogTitle = ConverterPlugin.INSTANCE.getString("_UI_DialogError_title");
            }
        }
        if (message == null) {
            message = diagnostic.getMessage();
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        switch (decodedAction.message) {
            case 2: {
                this.setMessage(message);
                break;
            }
            case 0: 
            case 4: {
                if (messageType == 3) {
                    this.setErrorMessage(message);
                    break;
                }
                this.setMessage(message, messageType);
                break;
            }
            case 8: {
                this.setErrorMessage(message);
            }
        }
        switch (decodedAction.dialog) {
            case 0: 
            case 512: {
                if (diagnostic.getChildren().isEmpty()) break;
                ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)dialogMessage, (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
                break;
            }
            case 1024: {
                ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)dialogMessage, (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
                break;
            }
            case 2048: {
                new ErrorDialog(this.getShell(), dialogTitle, dialogMessage, BasicDiagnostic.toIStatus((Diagnostic)diagnostic), 7){

                    protected Image getImage() {
                        return this.getErrorImage();
                    }
                }.open();
            }
        }
    }
}

