/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.converter.ui.contribution.base;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.converter.ConverterPlugin;
import org.eclipse.emf.converter.ModelConverter;
import org.eclipse.emf.converter.ui.contribution.base.ModelConverterPage;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class ModelConverterWizard
extends Wizard
implements IWorkbenchWizard {
    protected static PageHelper pageHelper;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected ModelConverter modelConverter;

    public ModelConverterWizard() {
        this.setNeedsProgressMonitor(true);
        if (pageHelper == null) {
            pageHelper = new PageHelper();
        }
    }

    public void dispose() {
        this.selection = null;
        this.workbench = null;
        if (this.modelConverter != null) {
            this.modelConverter.dispose();
            this.modelConverter = null;
        }
        if (pageHelper != null) {
            if (this.getContainer() instanceof WizardDialog) {
                ((WizardDialog)this.getContainer()).removePageChangedListener((IPageChangedListener)pageHelper);
            }
            pageHelper.dispose();
            pageHelper = null;
        }
        super.dispose();
    }

    protected abstract ModelConverter createModelConverter();

    protected ModelConverter getModelConverter() {
        if (this.modelConverter == null) {
            this.modelConverter = this.createModelConverter();
        }
        return this.modelConverter;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        super.setContainer(wizardContainer);
        if (wizardContainer instanceof WizardDialog && pageHelper != null && !pageHelper.isAttached()) {
            pageHelper.setAttached(true);
            ((WizardDialog)wizardContainer).addPageChangedListener((IPageChangedListener)pageHelper);
        }
    }

    public boolean performCancel() {
        pageHelper.firePageDeactivated(4);
        return true;
    }

    public boolean performFinish() {
        pageHelper.firePageDeactivated(3);
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)progressMonitor);
                    try {
                        try {
                            ModelConverterWizard.this.doPerformFinish(monitor);
                        }
                        catch (Exception exception) {
                            throw DiagnosticException.toCoreException((DiagnosticException)new DiagnosticException(ConverterUtil.createErrorDiagnostic(exception, true)));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var4_6 = null;
                    }
                    monitor.done();
                }
            };
            try {
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            }
            catch (Exception exception) {
                ConverterPlugin.INSTANCE.log(exception);
                ErrorDialog.openError((Shell)this.getShell(), (String)ConverterPlugin.INSTANCE.getString("_UI_DialogError_title"), null, (IStatus)BasicDiagnostic.toIStatus((Diagnostic)ConverterUtil.createErrorDiagnostic(exception, true)));
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            ConverterPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    protected void doPerformFinish(Monitor monitor) throws Exception {
    }

    protected IFile getFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    protected void selectFile(IFile file) {
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)file);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
    }

    protected void openEditor(IFile file) throws PartInitException {
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), this.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId());
    }

    public static class PageHelper
    implements IPageChangedListener,
    IDisposable {
        protected boolean attached = false;
        protected Object oldPage;
        protected IPageChangeProvider pageChangeProvider;

        public void dispose() {
            this.oldPage = null;
            this.pageChangeProvider = null;
        }

        public void setAttached(boolean attached) {
            this.attached = attached;
        }

        public boolean isAttached() {
            return this.attached;
        }

        public void pageChanged(PageChangedEvent event) {
            this.pageChangeProvider = event.getPageChangeProvider();
            this.pageChanged(event.getSelectedPage());
        }

        protected void pageChanged(Object currentPage) {
            if (this.oldPage != currentPage) {
                ModelConverterPage page;
                int cause = 0;
                if (this.oldPage instanceof ModelConverterPage) {
                    page = (ModelConverterPage)((Object)this.oldPage);
                    cause = page.forwardDirection ? 2 : 1;
                    page.pageDeactivated(cause);
                }
                this.oldPage = currentPage;
                if (currentPage instanceof ModelConverterPage) {
                    page = (ModelConverterPage)((Object)currentPage);
                    page.pageActivated(page.neverVisible, cause);
                    page.neverVisible = false;
                }
            }
        }

        public void firePageDeactivated(int cause) {
            if (this.pageChangeProvider != null && this.pageChangeProvider.getSelectedPage() instanceof ModelConverterPage) {
                ((ModelConverterPage)((Object)this.pageChangeProvider.getSelectedPage())).pageDeactivated(cause);
            }
        }
    }
}

