package org.eclipse.emf.codegen.ecore.templates.model;

import java.util.*;
import org.eclipse.emf.codegen.ecore.genmodel.*;
import org.eclipse.emf.codegen.util.CodeGenUtil;

public class ValidatorClass
{
  protected static String nl;
  public static synchronized ValidatorClass create(String lineSeparator)
  {
    nl = lineSeparator;
    ValidatorClass result = new ValidatorClass();
    nl = null;
    return result;
  }

  protected final String NL = nl == null ? (System.getProperties().getProperty("line.separator")) : nl;
  protected final String TEXT_1 = "";
  protected final String TEXT_2 = "/**" + NL + " * <copyright>" + NL + " * </copyright>" + NL + " *" + NL + " * ";
  protected final String TEXT_3 = "Id";
  protected final String TEXT_4 = NL + " */" + NL + "package ";
  protected final String TEXT_5 = ";" + NL;
  protected final String TEXT_6 = NL + NL + "/**" + NL + " * <!-- begin-user-doc -->" + NL + " * The <b>Validator</b> for the model." + NL + " * <!-- end-user-doc -->" + NL + " * @see ";
  protected final String TEXT_7 = NL + " * @generated" + NL + " */" + NL + "public class ";
  protected final String TEXT_8 = " extends ";
  protected final String TEXT_9 = NL + "{";
  protected final String TEXT_10 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_11 = " copyright = \"";
  protected final String TEXT_12 = "\";";
  protected final String TEXT_13 = NL;
  protected final String TEXT_14 = NL + "\t/**" + NL + "\t * The cached model package" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_15 = " INSTANCE = new ";
  protected final String TEXT_16 = "();" + NL + "" + NL + "\t/**" + NL + "\t * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @see org.eclipse.emf.common.util.Diagnostic#getSource()" + NL + "\t * @see org.eclipse.emf.common.util.Diagnostic#getCode()" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final String DIAGNOSTIC_SOURCE = \"";
  protected final String TEXT_17 = "\";";
  protected final String TEXT_18 = NL;
  protected final String TEXT_19 = NL + "\t/**" + NL + "\t * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint '";
  protected final String TEXT_20 = "' of '";
  protected final String TEXT_21 = "'." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final int ";
  protected final String TEXT_22 = " = ";
  protected final String TEXT_23 = ";" + NL;
  protected final String TEXT_24 = NL + "\t/**" + NL + "\t * A constant with a fixed name that can be used as the base value for additional hand written constants." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprivate static final int GENERATED_DIAGNOSTIC_CODE_COUNT = ";
  protected final String TEXT_25 = ";" + NL + "" + NL + "\t/**" + NL + "\t * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;" + NL;
  protected final String TEXT_26 = NL + "\t/**" + NL + "\t * The cached base package validator." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_27 = " ";
  protected final String TEXT_28 = "Validator;" + NL;
  protected final String TEXT_29 = NL + "\t/**" + NL + "\t * Creates an instance of the switch." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_30 = "()" + NL + "\t{" + NL + "\t\tsuper();";
  protected final String TEXT_31 = NL + "\t\t";
  protected final String TEXT_32 = "Validator = ";
  protected final String TEXT_33 = ".INSTANCE;";
  protected final String TEXT_34 = NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * Returns the package of this validator switch." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected EPackage getEPackage()" + NL + "\t{" + NL + "\t  return ";
  protected final String TEXT_35 = ".eINSTANCE;" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * Calls <code>validateXXX</code> for the corresonding classifier of the model." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context)" + NL + "\t{" + NL + "\t\tswitch (classifierID)" + NL + "\t\t{";
  protected final String TEXT_36 = NL + "\t\t\tcase ";
  protected final String TEXT_37 = ".";
  protected final String TEXT_38 = ":";
  protected final String TEXT_39 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_40 = "(((";
  protected final String TEXT_41 = ")value).";
  protected final String TEXT_42 = "(), diagnostics, context);";
  protected final String TEXT_43 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_44 = "(value, diagnostics, context);";
  protected final String TEXT_45 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_46 = "((";
  protected final String TEXT_47 = ")value, diagnostics, context);";
  protected final String TEXT_48 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_49 = "((";
  protected final String TEXT_50 = ")value, diagnostics, context);";
  protected final String TEXT_51 = NL + "\t\t\tdefault: " + NL + "\t\t\t\treturn true;" + NL + "\t\t}" + NL + "\t}" + NL;
  protected final String TEXT_52 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic boolean validate";
  protected final String TEXT_53 = "(";
  protected final String TEXT_54 = " ";
  protected final String TEXT_55 = ", DiagnosticChain ";
  protected final String TEXT_56 = ", Map ";
  protected final String TEXT_57 = ")" + NL + "\t{";
  protected final String TEXT_58 = NL + "\t\treturn true;";
  protected final String TEXT_59 = NL + "\t\treturn validate_EveryDefaultConstraint(";
  protected final String TEXT_60 = "(";
  protected final String TEXT_61 = ")";
  protected final String TEXT_62 = ", ";
  protected final String TEXT_63 = ", ";
  protected final String TEXT_64 = ");";
  protected final String TEXT_65 = NL + "\t\tboolean ";
  protected final String TEXT_66 = " = ";
  protected final String TEXT_67 = "validate";
  protected final String TEXT_68 = "_";
  protected final String TEXT_69 = "(";
  protected final String TEXT_70 = ", ";
  protected final String TEXT_71 = ", ";
  protected final String TEXT_72 = ");";
  protected final String TEXT_73 = NL + "\t\tif (";
  protected final String TEXT_74 = " || ";
  protected final String TEXT_75 = " != null) result &= ";
  protected final String TEXT_76 = "validate";
  protected final String TEXT_77 = "_";
  protected final String TEXT_78 = "(";
  protected final String TEXT_79 = ", ";
  protected final String TEXT_80 = ", ";
  protected final String TEXT_81 = ");";
  protected final String TEXT_82 = NL + "\t\treturn ";
  protected final String TEXT_83 = ";";
  protected final String TEXT_84 = NL + "\t}" + NL;
  protected final String TEXT_85 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_86 = "_";
  protected final String TEXT_87 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_88 = " ";
  protected final String TEXT_89 = "__VALUE = ";
  protected final String TEXT_90 = ";" + NL;
  protected final String TEXT_91 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_92 = "_";
  protected final String TEXT_93 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_94 = " ";
  protected final String TEXT_95 = "__VALUE = ";
  protected final String TEXT_96 = ";" + NL;
  protected final String TEXT_97 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_98 = "_";
  protected final String TEXT_99 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_100 = " ";
  protected final String TEXT_101 = "__UPPER_BOUND = ";
  protected final String TEXT_102 = ";" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_103 = "_";
  protected final String TEXT_104 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_105 = " ";
  protected final String TEXT_106 = "__LOWER_BOUND = ";
  protected final String TEXT_107 = ";" + NL;
  protected final String TEXT_108 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_109 = "_";
  protected final String TEXT_110 = NL + "\t */" + NL + "\tpublic static final  PatternMatcher [][] ";
  protected final String TEXT_111 = "__VALUES =" + NL + "\t\tnew PatternMatcher [][] " + NL + "\t\t{";
  protected final String TEXT_112 = NL + "\t\t\tnew PatternMatcher [] " + NL + "\t\t\t{";
  protected final String TEXT_113 = NL + "\t\t\t\t";
  protected final String TEXT_114 = ".createPatternMatcher(";
  protected final String TEXT_115 = ")";
  protected final String TEXT_116 = NL + "\t\t\t}";
  protected final String TEXT_117 = NL + "\t\t};" + NL;
  protected final String TEXT_118 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_119 = "_";
  protected final String TEXT_120 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_121 = " ";
  protected final String TEXT_122 = "__VALUES =" + NL + "\t\twrapEnumerationValues" + NL + "\t\t\t(new Object[] " + NL + "\t\t\t {";
  protected final String TEXT_123 = NL + "\t\t\t\t ";
  protected final String TEXT_124 = "new ";
  protected final String TEXT_125 = "(";
  protected final String TEXT_126 = ")";
  protected final String TEXT_127 = NL + "\t\t\t });" + NL;
  protected final String TEXT_128 = NL + "\t/**" + NL + "\t * Validates the ";
  protected final String TEXT_129 = " constraint of '<em>";
  protected final String TEXT_130 = "</em>'." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic boolean validate";
  protected final String TEXT_131 = "_";
  protected final String TEXT_132 = "(";
  protected final String TEXT_133 = " ";
  protected final String TEXT_134 = ", DiagnosticChain ";
  protected final String TEXT_135 = ", Map ";
  protected final String TEXT_136 = ")" + NL + "\t{";
  protected final String TEXT_137 = NL + "\t\tboolean ";
  protected final String TEXT_138 = " = true;" + NL + "\t\tfor (";
  protected final String TEXT_139 = " i = ";
  protected final String TEXT_140 = ".iterator(); i.hasNext() && (result || diagnostics != null); )" + NL + "\t\t{" + NL + "\t\t\tObject item = i.next();" + NL + "\t\t\tif (";
  protected final String TEXT_141 = ".isInstance(item))" + NL + "\t\t\t{" + NL + "\t\t\t\tresult &= ";
  protected final String TEXT_142 = "validate";
  protected final String TEXT_143 = "(";
  protected final String TEXT_144 = "(";
  protected final String TEXT_145 = "(";
  protected final String TEXT_146 = ")";
  protected final String TEXT_147 = ").";
  protected final String TEXT_148 = "()";
  protected final String TEXT_149 = ", ";
  protected final String TEXT_150 = ", ";
  protected final String TEXT_151 = ");" + NL + "\t\t\t}" + NL + "\t\t\telse" + NL + "\t\t\t{" + NL + "\t\t\t\tresult = false;" + NL + "\t\t\t\treportDataValueTypeViolation(";
  protected final String TEXT_152 = ", item, ";
  protected final String TEXT_153 = ", ";
  protected final String TEXT_154 = ");" + NL + "\t\t\t}" + NL + "\t\t}" + NL + "\t\treturn result;";
  protected final String TEXT_155 = NL + "\t\tif (diagnostics != null)" + NL + "\t\t{" + NL + "\t\t\t";
  protected final String TEXT_156 = " tempDiagnostics = new BasicDiagnostic();";
  protected final String TEXT_157 = NL + "\t\t\tif (";
  protected final String TEXT_158 = "validate";
  protected final String TEXT_159 = "(";
  protected final String TEXT_160 = ", tempDiagnostics, ";
  protected final String TEXT_161 = ")) return true;";
  protected final String TEXT_162 = NL + "\t\t\tif (";
  protected final String TEXT_163 = ".isInstance(";
  protected final String TEXT_164 = "))" + NL + "\t\t\t{" + NL + "\t\t\t\tif (";
  protected final String TEXT_165 = "validate";
  protected final String TEXT_166 = "(";
  protected final String TEXT_167 = "(";
  protected final String TEXT_168 = "(";
  protected final String TEXT_169 = ")";
  protected final String TEXT_170 = ").";
  protected final String TEXT_171 = "()";
  protected final String TEXT_172 = ", tempDiagnostics, ";
  protected final String TEXT_173 = ")) return true;" + NL + "\t\t\t}";
  protected final String TEXT_174 = NL + "\t\t\t";
  protected final String TEXT_175 = " children = tempDiagnostics.getChildren();" + NL + "\t\t\tfor (int i = 0; i < children.size(); i++)" + NL + "\t\t\t{" + NL + "\t\t\t\tdiagnostics.add((";
  protected final String TEXT_176 = ")children.get(i));" + NL + "\t\t\t}" + NL + "\t\t}" + NL + "\t\telse" + NL + "\t\t{";
  protected final String TEXT_177 = NL + "\t\t\tif (";
  protected final String TEXT_178 = "validate";
  protected final String TEXT_179 = "(";
  protected final String TEXT_180 = ", null, ";
  protected final String TEXT_181 = ")) return true;";
  protected final String TEXT_182 = NL + "\t\t\tif (";
  protected final String TEXT_183 = ".isInstance(";
  protected final String TEXT_184 = "))" + NL + "\t\t\t{" + NL + "\t\t\t\tif (";
  protected final String TEXT_185 = "validate";
  protected final String TEXT_186 = "(";
  protected final String TEXT_187 = "(";
  protected final String TEXT_188 = "(";
  protected final String TEXT_189 = ")";
  protected final String TEXT_190 = ").";
  protected final String TEXT_191 = "()";
  protected final String TEXT_192 = ", null, ";
  protected final String TEXT_193 = ")) return true;" + NL + "\t\t\t}";
  protected final String TEXT_194 = NL + "\t\t}" + NL + "\t\treturn false;";
  protected final String TEXT_195 = NL + "\t\treturn validatePattern(";
  protected final String TEXT_196 = ", ";
  protected final String TEXT_197 = "new ";
  protected final String TEXT_198 = "(";
  protected final String TEXT_199 = ")";
  protected final String TEXT_200 = ", ";
  protected final String TEXT_201 = "__VALUES, ";
  protected final String TEXT_202 = ", ";
  protected final String TEXT_203 = ");";
  protected final String TEXT_204 = NL + "\t\t";
  protected final String TEXT_205 = " ";
  protected final String TEXT_206 = " = new ";
  protected final String TEXT_207 = "(";
  protected final String TEXT_208 = ");";
  protected final String TEXT_209 = NL + "\t\tboolean ";
  protected final String TEXT_210 = " = ";
  protected final String TEXT_211 = "__VALUES.contains(";
  protected final String TEXT_212 = ");" + NL + "\t\tif (!";
  protected final String TEXT_213 = " && ";
  protected final String TEXT_214 = " != null) " + NL + "\t\t\treportEnumerationViolation(";
  protected final String TEXT_215 = ", ";
  protected final String TEXT_216 = ", ";
  protected final String TEXT_217 = "__VALUES, ";
  protected final String TEXT_218 = ", ";
  protected final String TEXT_219 = ");" + NL + "\t\treturn ";
  protected final String TEXT_220 = "; ";
  protected final String TEXT_221 = NL + "\t\tboolean ";
  protected final String TEXT_222 = " = ";
  protected final String TEXT_223 = " ";
  protected final String TEXT_224 = " ";
  protected final String TEXT_225 = "__VALUE;" + NL + "\t\tif (!";
  protected final String TEXT_226 = " && ";
  protected final String TEXT_227 = " != null) " + NL + "\t\t\treportMinViolation(";
  protected final String TEXT_228 = ", new ";
  protected final String TEXT_229 = "(";
  protected final String TEXT_230 = "), new ";
  protected final String TEXT_231 = "(";
  protected final String TEXT_232 = "__VALUE), ";
  protected final String TEXT_233 = ", ";
  protected final String TEXT_234 = ", ";
  protected final String TEXT_235 = ");" + NL + "\t\treturn ";
  protected final String TEXT_236 = ";";
  protected final String TEXT_237 = NL + "\t\tint ";
  protected final String TEXT_238 = " = ";
  protected final String TEXT_239 = ".compareCalendar(";
  protected final String TEXT_240 = ", ";
  protected final String TEXT_241 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_242 = " = ";
  protected final String TEXT_243 = " == 0 || ";
  protected final String TEXT_244 = " == 1;";
  protected final String TEXT_245 = NL + "\t\tint ";
  protected final String TEXT_246 = " = ";
  protected final String TEXT_247 = ".compareDuration(";
  protected final String TEXT_248 = ", ";
  protected final String TEXT_249 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_250 = " = ";
  protected final String TEXT_251 = " == 0 || ";
  protected final String TEXT_252 = " == 1;";
  protected final String TEXT_253 = NL + "\t\tboolean ";
  protected final String TEXT_254 = " = ";
  protected final String TEXT_255 = ".compareTo(";
  protected final String TEXT_256 = "__VALUE) ";
  protected final String TEXT_257 = " 0;";
  protected final String TEXT_258 = NL + "\t\tif (!";
  protected final String TEXT_259 = " && ";
  protected final String TEXT_260 = " != null) " + NL + "\t\t\treportMinViolation(";
  protected final String TEXT_261 = ", ";
  protected final String TEXT_262 = ", ";
  protected final String TEXT_263 = "__VALUE, ";
  protected final String TEXT_264 = ", ";
  protected final String TEXT_265 = ", ";
  protected final String TEXT_266 = ");" + NL + "\t\treturn ";
  protected final String TEXT_267 = "; ";
  protected final String TEXT_268 = NL + "\t\tboolean ";
  protected final String TEXT_269 = " = ";
  protected final String TEXT_270 = " ";
  protected final String TEXT_271 = " ";
  protected final String TEXT_272 = "__VALUE;" + NL + "\t\tif (!";
  protected final String TEXT_273 = " && ";
  protected final String TEXT_274 = " != null) " + NL + "\t\t\treportMaxViolation(";
  protected final String TEXT_275 = ", new ";
  protected final String TEXT_276 = "(";
  protected final String TEXT_277 = "), new ";
  protected final String TEXT_278 = "(";
  protected final String TEXT_279 = "__VALUE), ";
  protected final String TEXT_280 = ", ";
  protected final String TEXT_281 = ", ";
  protected final String TEXT_282 = ");" + NL + "\t\treturn ";
  protected final String TEXT_283 = "; ";
  protected final String TEXT_284 = NL + "\t\tint ";
  protected final String TEXT_285 = " = ";
  protected final String TEXT_286 = ".compareCalendar(";
  protected final String TEXT_287 = ", ";
  protected final String TEXT_288 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_289 = " = ";
  protected final String TEXT_290 = " == 0 || ";
  protected final String TEXT_291 = " == -1;";
  protected final String TEXT_292 = NL + "\t\tint ";
  protected final String TEXT_293 = " = ";
  protected final String TEXT_294 = ".compareDuration(";
  protected final String TEXT_295 = ", ";
  protected final String TEXT_296 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_297 = " = ";
  protected final String TEXT_298 = " == 0 || ";
  protected final String TEXT_299 = " == -1;";
  protected final String TEXT_300 = NL + "\t\tboolean ";
  protected final String TEXT_301 = " = ";
  protected final String TEXT_302 = ".compareTo(";
  protected final String TEXT_303 = "__VALUE) ";
  protected final String TEXT_304 = " 0;";
  protected final String TEXT_305 = NL + "\t\tif (!";
  protected final String TEXT_306 = " && ";
  protected final String TEXT_307 = " != null) " + NL + "\t\t\treportMaxViolation(";
  protected final String TEXT_308 = ", ";
  protected final String TEXT_309 = ", ";
  protected final String TEXT_310 = "__VALUE, ";
  protected final String TEXT_311 = ", ";
  protected final String TEXT_312 = ", ";
  protected final String TEXT_313 = ");" + NL + "\t\treturn ";
  protected final String TEXT_314 = "; ";
  protected final String TEXT_315 = NL + "\t\tint length = ";
  protected final String TEXT_316 = ".";
  protected final String TEXT_317 = ";  " + NL + "\t\tboolean ";
  protected final String TEXT_318 = " = length >= ";
  protected final String TEXT_319 = ";" + NL + "\t\tif (!";
  protected final String TEXT_320 = " && ";
  protected final String TEXT_321 = " != null) " + NL + "\t\t\treportMinLengthViolation(";
  protected final String TEXT_322 = ", ";
  protected final String TEXT_323 = ", length, ";
  protected final String TEXT_324 = ", ";
  protected final String TEXT_325 = ", ";
  protected final String TEXT_326 = ");" + NL + "\t\treturn ";
  protected final String TEXT_327 = ";";
  protected final String TEXT_328 = NL + "\t\tint length = ";
  protected final String TEXT_329 = ".";
  protected final String TEXT_330 = ";  " + NL + "\t\tboolean ";
  protected final String TEXT_331 = " = length <= ";
  protected final String TEXT_332 = ";" + NL + "\t\tif (!";
  protected final String TEXT_333 = " && ";
  protected final String TEXT_334 = " != null) " + NL + "\t\t\treportMaxLengthViolation(";
  protected final String TEXT_335 = ", ";
  protected final String TEXT_336 = ", length, ";
  protected final String TEXT_337 = ", ";
  protected final String TEXT_338 = ", ";
  protected final String TEXT_339 = ");" + NL + "\t\treturn ";
  protected final String TEXT_340 = ";";
  protected final String TEXT_341 = NL + "\t\tboolean ";
  protected final String TEXT_342 = " = ";
  protected final String TEXT_343 = " > ";
  protected final String TEXT_344 = "__LOWER_BOUND && ";
  protected final String TEXT_345 = " < ";
  protected final String TEXT_346 = "__UPPER_BOUND;" + NL + "\t\tif (!";
  protected final String TEXT_347 = " && ";
  protected final String TEXT_348 = " != null) " + NL + "\t\t\treportTotalDigitsViolation(";
  protected final String TEXT_349 = ", new ";
  protected final String TEXT_350 = "(";
  protected final String TEXT_351 = "), ";
  protected final String TEXT_352 = ", ";
  protected final String TEXT_353 = ", ";
  protected final String TEXT_354 = ");";
  protected final String TEXT_355 = NL + "\t\tboolean ";
  protected final String TEXT_356 = " = ";
  protected final String TEXT_357 = ".unscaledValue().abs().toString().length() <= ";
  protected final String TEXT_358 = ";" + NL + "\t\tif (!";
  protected final String TEXT_359 = " && ";
  protected final String TEXT_360 = " != null) " + NL + "\t\t\treportTotalDigitsViolation(";
  protected final String TEXT_361 = ", ";
  protected final String TEXT_362 = ", ";
  protected final String TEXT_363 = ", ";
  protected final String TEXT_364 = ", ";
  protected final String TEXT_365 = ");";
  protected final String TEXT_366 = NL + "\t\tboolean ";
  protected final String TEXT_367 = " = ";
  protected final String TEXT_368 = ".compareTo(";
  protected final String TEXT_369 = "__LOWER_BOUND) > 0 && ";
  protected final String TEXT_370 = ".compareTo(";
  protected final String TEXT_371 = "__UPPER_BOUND) < 0;" + NL + "\t\tif (!";
  protected final String TEXT_372 = " && ";
  protected final String TEXT_373 = " != null) " + NL + "\t\t\treportTotalDigitsViolation(";
  protected final String TEXT_374 = ", ";
  protected final String TEXT_375 = ", ";
  protected final String TEXT_376 = ", ";
  protected final String TEXT_377 = ", ";
  protected final String TEXT_378 = ");";
  protected final String TEXT_379 = NL + "\t\treturn ";
  protected final String TEXT_380 = "; ";
  protected final String TEXT_381 = NL + "\t\tboolean ";
  protected final String TEXT_382 = " = ";
  protected final String TEXT_383 = ".scale() <= ";
  protected final String TEXT_384 = ";" + NL + "\t\tif (!";
  protected final String TEXT_385 = " && ";
  protected final String TEXT_386 = " != null) " + NL + "\t\t\treportFractionDigitsViolation(";
  protected final String TEXT_387 = ", ";
  protected final String TEXT_388 = ", ";
  protected final String TEXT_389 = ", ";
  protected final String TEXT_390 = ", ";
  protected final String TEXT_391 = ");" + NL + "\t\treturn ";
  protected final String TEXT_392 = "; ";
  protected final String TEXT_393 = NL + "\t\t// TODO override the constraint, if desired" + NL + "\t\t// -> uncomment the scaffolding" + NL + "\t\t// -> specify the condition that violates the constraint" + NL + "\t\t// -> verify the diagnostic details, including severity, code, and message" + NL + "\t\t// Ensure that you remove @generated or mark it @generated NOT" + NL + "\t\tif (false)" + NL + "\t\t{" + NL + "\t\t\tif (";
  protected final String TEXT_394 = " != null)" + NL + "\t\t\t{" + NL + "\t\t\t\t";
  protected final String TEXT_395 = ".add" + NL + "\t\t\t\t\t(new ";
  protected final String TEXT_396 = NL + "\t\t\t\t\t\t(";
  protected final String TEXT_397 = ".ERROR," + NL + "\t\t\t\t\t\t DIAGNOSTIC_SOURCE," + NL + "\t\t\t\t\t\t 0," + NL + "\t\t\t\t\t\t ";
  protected final String TEXT_398 = ".INSTANCE.getString(\"_UI_GenericConstraint_diagnostic\", new Object[] { \"";
  protected final String TEXT_399 = "\", getValueLabel(";
  protected final String TEXT_400 = ", ";
  protected final String TEXT_401 = ", ";
  protected final String TEXT_402 = ") }),";
  protected final String TEXT_403 = NL + "\t\t\t\t\t\t new Object[] { ";
  protected final String TEXT_404 = " }));" + NL + "\t\t\t}" + NL + "\t\t\treturn false;" + NL + "\t\t}" + NL + "\t\treturn ";
  protected final String TEXT_405 = "validate";
  protected final String TEXT_406 = "_";
  protected final String TEXT_407 = "(";
  protected final String TEXT_408 = ", ";
  protected final String TEXT_409 = ", ";
  protected final String TEXT_410 = ");";
  protected final String TEXT_411 = NL + "\t\t// TODO implement the constraint" + NL + "\t\t// -> specify the condition that violates the constraint" + NL + "\t\t// -> verify the diagnostic details, including severity, code, and message" + NL + "\t\t// Ensure that you remove @generated or mark it @generated NOT" + NL + "\t\tif (false)" + NL + "\t\t{" + NL + "\t\t\tif (";
  protected final String TEXT_412 = " != null)" + NL + "\t\t\t{" + NL + "\t\t\t\t";
  protected final String TEXT_413 = ".add" + NL + "\t\t\t\t\t(new ";
  protected final String TEXT_414 = NL + "\t\t\t\t\t\t(";
  protected final String TEXT_415 = ".ERROR," + NL + "\t\t\t\t\t\t DIAGNOSTIC_SOURCE," + NL + "\t\t\t\t\t\t 0," + NL + "\t\t\t\t\t\t ";
  protected final String TEXT_416 = ".INSTANCE.getString(\"_UI_GenericConstraint_diagnostic\", new Object[] { \"";
  protected final String TEXT_417 = "\", getValueLabel(";
  protected final String TEXT_418 = ", ";
  protected final String TEXT_419 = ", ";
  protected final String TEXT_420 = ") }),";
  protected final String TEXT_421 = NL + "\t\t\t\t\t\t new Object[] { ";
  protected final String TEXT_422 = " }));" + NL + "\t\t\t}" + NL + "\t\t\treturn false;" + NL + "\t\t}" + NL + "\t\treturn true;";
  protected final String TEXT_423 = NL + "\t\t// TODO override the constraint, if desired" + NL + "\t\t// -> uncomment the scaffolding" + NL + "\t\t// -> specify the condition that violates the constraint" + NL + "\t\t// -> verify the diagnostic details, including severity, code, and message" + NL + "\t\t// Ensure that you remove @generated or mark it @generated NOT" + NL + "\t\tif (false)" + NL + "\t\t{" + NL + "\t\t\tif (";
  protected final String TEXT_424 = " != null)" + NL + "\t\t\t{" + NL + "\t\t\t\t";
  protected final String TEXT_425 = ".add" + NL + "\t\t\t\t\t(new ";
  protected final String TEXT_426 = NL + "\t\t\t\t\t\t(";
  protected final String TEXT_427 = ".ERROR," + NL + "\t\t\t\t\t\t DIAGNOSTIC_SOURCE," + NL + "\t\t\t\t\t\t 0," + NL + "\t\t\t\t\t\t ";
  protected final String TEXT_428 = ".INSTANCE.getString(\"_UI_GenericConstraint_diagnostic\", new Object[] { \"";
  protected final String TEXT_429 = "\", getObjectLabel(";
  protected final String TEXT_430 = ", ";
  protected final String TEXT_431 = ") }),";
  protected final String TEXT_432 = NL + "\t\t\t\t\t\t new Object[] { ";
  protected final String TEXT_433 = " }));" + NL + "\t\t\t}" + NL + "\t\t\treturn false;" + NL + "\t\t}" + NL + "\t\treturn ";
  protected final String TEXT_434 = "validate";
  protected final String TEXT_435 = "_";
  protected final String TEXT_436 = "(";
  protected final String TEXT_437 = ", ";
  protected final String TEXT_438 = ", ";
  protected final String TEXT_439 = ");";
  protected final String TEXT_440 = NL + "\t\treturn ";
  protected final String TEXT_441 = ".";
  protected final String TEXT_442 = "(";
  protected final String TEXT_443 = ", ";
  protected final String TEXT_444 = ");";
  protected final String TEXT_445 = NL + "\t\t// TODO implement the constraint" + NL + "\t\t// -> specify the condition that violates the constraint" + NL + "\t\t// -> verify the diagnostic details, including severity, code, and message" + NL + "\t\t// Ensure that you remove @generated or mark it @generated NOT" + NL + "\t\tif (false)" + NL + "\t\t{" + NL + "\t\t\tif (";
  protected final String TEXT_446 = " != null)" + NL + "\t\t\t{" + NL + "\t\t\t\t";
  protected final String TEXT_447 = ".add" + NL + "\t\t\t\t\t(new ";
  protected final String TEXT_448 = NL + "\t\t\t\t\t\t(";
  protected final String TEXT_449 = ".ERROR," + NL + "\t\t\t\t\t\t DIAGNOSTIC_SOURCE," + NL + "\t\t\t\t\t\t 0," + NL + "\t\t\t\t\t\t ";
  protected final String TEXT_450 = ".INSTANCE.getString(\"_UI_GenericConstraint_diagnostic\", new Object[] { \"";
  protected final String TEXT_451 = "\", getObjectLabel(";
  protected final String TEXT_452 = ", ";
  protected final String TEXT_453 = ") }),";
  protected final String TEXT_454 = NL + "\t\t\t\t\t\t new Object[] { ";
  protected final String TEXT_455 = " }));" + NL + "\t\t\t}" + NL + "\t\t\treturn false;" + NL + "\t\t}" + NL + "\t\treturn true;";
  protected final String TEXT_456 = NL + "\t}" + NL;
  protected final String TEXT_457 = NL + "} //";
  protected final String TEXT_458 = NL;

  public String generate(Object argument)
  {
    final StringBuffer stringBuffer = new StringBuffer();
    
/**
 * <copyright>
 *
 * Copyright (c) 2002-2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 */

    GenPackage genPackage = (GenPackage)argument; GenModel genModel=genPackage.getGenModel();
    stringBuffer.append(TEXT_1);
    stringBuffer.append(TEXT_2);
    stringBuffer.append("$");
    stringBuffer.append(TEXT_3);
    stringBuffer.append("$");
    stringBuffer.append(TEXT_4);
    stringBuffer.append(genPackage.getUtilitiesPackageName());
    stringBuffer.append(TEXT_5);
    genModel.addImport("java.util.Map");
    genModel.addImport("org.eclipse.emf.common.util.DiagnosticChain");
    genModel.addImport("org.eclipse.emf.ecore.EPackage");
    if (!genPackage.hasJavaLangConflict() && !genPackage.getUtilitiesPackageName().equals(genPackage.getInterfacePackageName())) genModel.addImport(genPackage.getInterfacePackageName() + ".*");
    genModel.markImportLocation(stringBuffer);
    genModel.addPseudoImport("org.eclipse.emf.ecore.EValidator.Registry");
    genModel.addPseudoImport("org.eclipse.emf.ecore.EValidator.SubstitutionLabelProvider");
    genModel.addPseudoImport("org.eclipse.emf.ecore.EValidator.PatternMatcher");
    stringBuffer.append(TEXT_6);
    stringBuffer.append(genPackage.getQualifiedPackageInterfaceName());
    stringBuffer.append(TEXT_7);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_8);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.util.EObjectValidator"));
    stringBuffer.append(TEXT_9);
    if (genModel.getCopyrightText() != null) {
    stringBuffer.append(TEXT_10);
    stringBuffer.append(genModel.getImportedName("java.lang.String"));
    stringBuffer.append(TEXT_11);
    stringBuffer.append(genModel.getCopyrightText());
    stringBuffer.append(TEXT_12);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(TEXT_13);
    }
    stringBuffer.append(TEXT_14);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_15);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_16);
    stringBuffer.append(genPackage.getInterfacePackageName());
    stringBuffer.append(TEXT_17);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(TEXT_18);
    int count = 0; for (Iterator i=genPackage.getGenClasses().iterator(); i.hasNext();) { GenClass genClass = (GenClass)i.next();
    for (Iterator j=genClass.getInvariantOperations().iterator(); j.hasNext();) { GenOperation genOperation = (GenOperation)j.next();
    stringBuffer.append(TEXT_19);
    stringBuffer.append(genOperation.getFormattedName());
    stringBuffer.append(TEXT_20);
    stringBuffer.append(genClass.getFormattedName());
    stringBuffer.append(TEXT_21);
    stringBuffer.append(genClass.getOperationID(genOperation));
    stringBuffer.append(TEXT_22);
    stringBuffer.append(++count);
    stringBuffer.append(TEXT_23);
    }}
    stringBuffer.append(TEXT_24);
    stringBuffer.append(count);
    stringBuffer.append(TEXT_25);
    for (Iterator i = genPackage.getAllValidatorBaseGenPackages().iterator(); i.hasNext(); ) { GenPackage baseGenPackage = (GenPackage)i.next(); 
    stringBuffer.append(TEXT_26);
    stringBuffer.append(baseGenPackage.getImportedValidatorClassName());
    stringBuffer.append(TEXT_27);
    stringBuffer.append(genPackage.getValidatorPackageUniqueSafeName(baseGenPackage));
    stringBuffer.append(TEXT_28);
    }
    stringBuffer.append(TEXT_29);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_30);
    for (Iterator i = genPackage.getAllValidatorBaseGenPackages().iterator(); i.hasNext(); ) { GenPackage baseGenPackage = (GenPackage)i.next(); 
    stringBuffer.append(TEXT_31);
    stringBuffer.append(genPackage.getValidatorPackageUniqueSafeName(baseGenPackage));
    stringBuffer.append(TEXT_32);
    stringBuffer.append(baseGenPackage.getImportedValidatorClassName());
    stringBuffer.append(TEXT_33);
    }
    stringBuffer.append(TEXT_34);
    stringBuffer.append(genPackage.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_35);
    for (Iterator i=genPackage.getGenClassifiers().iterator(); i.hasNext();) { GenClassifier genClassifier = (GenClassifier)i.next();
    stringBuffer.append(TEXT_36);
    stringBuffer.append(genPackage.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_37);
    stringBuffer.append(genPackage.getClassifierID(genClassifier));
    stringBuffer.append(TEXT_38);
    if (genClassifier instanceof GenDataType) { GenDataType genDataType = (GenDataType)genClassifier;
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_39);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_40);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_41);
    stringBuffer.append(genDataType.getPrimitiveValueFunction());
    stringBuffer.append(TEXT_42);
    } else if (genDataType.isObjectType()) {
    stringBuffer.append(TEXT_43);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_44);
    } else {
    stringBuffer.append(TEXT_45);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_46);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_47);
    }
    } else { GenClass genClass = (GenClass)genClassifier;
    stringBuffer.append(TEXT_48);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_49);
    stringBuffer.append(genClass.getImportedInterfaceName());
    stringBuffer.append(TEXT_50);
    }
    }
    stringBuffer.append(TEXT_51);
    for (Iterator i=genPackage.getGenClassifiers().iterator(); i.hasNext();) { GenClassifier genClassifier = (GenClassifier)i.next(); String result = "result".equals(genClassifier.getSafeUncapName()) ? "theResult" : "result"; String diagnostics = "diagnostics".equals(genClassifier.getSafeUncapName()) ? "theDiagnostics" : "diagnostics"; String item = "item".equals(genClassifier.getSafeUncapName()) ? "theItem" : "item"; String context = "context".equals(genClassifier.getSafeUncapName()) ? "theContext" : "context";
    stringBuffer.append(TEXT_52);
    stringBuffer.append(genClassifier.getName());
    stringBuffer.append(TEXT_53);
    stringBuffer.append(genClassifier.getImportedInstanceClassName());
    stringBuffer.append(TEXT_54);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_55);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_56);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_57);
    if (genClassifier.getAllGenConstraints().isEmpty()) {
    stringBuffer.append(TEXT_58);
    } else if (genClassifier.hasOnlyDefaultConstraints()) {
    stringBuffer.append(TEXT_59);
    if (!((GenClass)genClassifier).isEObjectExtension()){
    stringBuffer.append(TEXT_60);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EObject"));
    stringBuffer.append(TEXT_61);
    }
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_62);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_63);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_64);
    } else { boolean first = true;
    for (Iterator j=genClassifier.getAllGenConstraints().iterator(); j.hasNext(); ) { String constraint = (String)j.next(); 
  GenClassifier constraintImplementor = genClassifier.getConstraintImplementor(constraint); 
  String delegate = constraintImplementor == null || constraintImplementor.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(constraintImplementor.getGenPackage()) + "Validator."; 
  String cast = constraintImplementor == null && genClassifier instanceof GenClass && !((GenClass)genClassifier).isEObjectExtension() ? "(" + genModel.getImportedName("org.eclipse.emf.ecore.EObject") + ")" : "";
  String accessor = constraintImplementor != null && genClassifier instanceof GenDataType && !((GenDataType)genClassifier).isPrimitiveType() && ((GenDataType)constraintImplementor).isPrimitiveType() ? "." + ((GenDataType)constraintImplementor).getPrimitiveValueFunction() + "()" : "";
    if (first) { first = false;
    stringBuffer.append(TEXT_65);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_66);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_67);
    stringBuffer.append(constraintImplementor == null ? "" : constraintImplementor.getName());
    stringBuffer.append(TEXT_68);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_69);
    stringBuffer.append(cast);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(accessor);
    stringBuffer.append(TEXT_70);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_71);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_72);
    } else {
    stringBuffer.append(TEXT_73);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_74);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_75);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_76);
    stringBuffer.append(constraintImplementor == null ? "" : constraintImplementor.getName());
    stringBuffer.append(TEXT_77);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_78);
    stringBuffer.append(cast);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(accessor);
    stringBuffer.append(TEXT_79);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_80);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_81);
    }
    }
    stringBuffer.append(TEXT_82);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_83);
    }
    stringBuffer.append(TEXT_84);
    for (Iterator j=genClassifier.getGenConstraints().iterator(); j.hasNext();) 
{ String constraint = (String)j.next();
  GenClassifier constraintDelegate = genClassifier.getConstraintDelegate(constraint); 
  String constant = genClassifier.getClassifierID() + "__" + CodeGenUtil.format(constraint, '_', null, false, false).toUpperCase();
  String delegate = constraintDelegate == null || constraintDelegate.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(constraintDelegate.getGenPackage()) + "Validator."; 
  String cast = constraintDelegate == null && genClassifier instanceof GenClass && !((GenClass)genClassifier).isEObjectExtension() ? "(" + genModel.getImportedName("org.eclipse.emf.ecore.EObject") + ")" : "";
  String accessor = constraintDelegate != null && genClassifier instanceof GenDataType && !((GenDataType)genClassifier).isPrimitiveType() && ((GenDataType)constraintDelegate).isPrimitiveType() ? "." + ((GenDataType)constraintDelegate).getPrimitiveValueFunction() + "()" : "";
    if (genClassifier instanceof GenDataType) { GenDataType genDataType = (GenDataType)genClassifier;
    if (constraint.equals("Min") && genDataType.getMinLiteral() != null) {
    stringBuffer.append(TEXT_85);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_86);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_87);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_88);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_89);
    stringBuffer.append(genDataType.getStaticValue(genDataType.getMinLiteral()));
    stringBuffer.append(TEXT_90);
    } else if (constraint.equals("Max") && genDataType.getMaxLiteral() != null) {
    stringBuffer.append(TEXT_91);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_92);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_93);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_94);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_95);
    stringBuffer.append(genDataType.getStaticValue(genDataType.getMaxLiteral()));
    stringBuffer.append(TEXT_96);
    } else if (constraint.equals("TotalDigits") && genDataType.getTotalDigits() != -1 && !"java.math.BigDecimal".equals(genDataType.getQualifiedInstanceClassName())) { String value = "1"; for (int digitCount = genDataType.getTotalDigits(); digitCount > 0; --digitCount) value += "0"; 
    stringBuffer.append(TEXT_97);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_98);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_99);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_100);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_101);
    stringBuffer.append(genDataType.getStaticValue(value));
    stringBuffer.append(TEXT_102);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_103);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_104);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_105);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_106);
    stringBuffer.append(genDataType.getStaticValue("-" + value));
    stringBuffer.append(TEXT_107);
    } else if (constraint.equals("Pattern") && !genDataType.getPatterns().isEmpty()) {
    stringBuffer.append(TEXT_108);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_109);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_110);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_111);
    for (Iterator k = genDataType.getPatterns().iterator(); k.hasNext(); ) { List patternList = (List)k.next();
    stringBuffer.append(TEXT_112);
    for (Iterator p = patternList.iterator(); p.hasNext(); ) { String pattern = (String)p.next();
    stringBuffer.append(TEXT_113);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_114);
    stringBuffer.append(pattern);
    stringBuffer.append(TEXT_115);
    stringBuffer.append(p.hasNext() ? "," : "");
    }
    stringBuffer.append(TEXT_116);
    stringBuffer.append(k.hasNext() ? "," : "");
    }
    stringBuffer.append(TEXT_117);
    } else if (constraint.equals("Enumeration") && !genDataType.getEnumerationLiterals().isEmpty()) {
    stringBuffer.append(TEXT_118);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_119);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_120);
    stringBuffer.append(genModel.getImportedName("java.util.Collection"));
    stringBuffer.append(TEXT_121);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_122);
    for (Iterator k = genDataType.getEnumerationLiterals().iterator(); k.hasNext(); ) { String literal = (String)k.next();
    stringBuffer.append(TEXT_123);
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_124);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_125);
    }
    stringBuffer.append(genDataType.getStaticValue(literal));
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_126);
    }
    stringBuffer.append(k.hasNext() ? "," : "");
    }
    stringBuffer.append(TEXT_127);
    }
    }
    stringBuffer.append(TEXT_128);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_129);
    stringBuffer.append(genClassifier.getFormattedName());
    stringBuffer.append(TEXT_130);
    stringBuffer.append(genClassifier.getName());
    stringBuffer.append(TEXT_131);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_132);
    stringBuffer.append(genClassifier.getImportedInstanceClassName());
    stringBuffer.append(TEXT_133);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_134);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_135);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_136);
    if (genClassifier instanceof GenDataType) { GenDataType genDataType = (GenDataType)genClassifier;
    if (constraint.equals("ItemType") && genDataType.getItemType() != null) { GenDataType itemType = genDataType.getItemType(); String itemDelegate = itemType.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(itemType.getGenPackage()) + "Validator.";
    stringBuffer.append(TEXT_137);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_138);
    stringBuffer.append(genModel.getImportedName("java.util.Iterator"));
    stringBuffer.append(TEXT_139);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_140);
    stringBuffer.append(itemType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_141);
    stringBuffer.append(itemDelegate);
    stringBuffer.append(TEXT_142);
    stringBuffer.append(itemType.getName());
    stringBuffer.append(TEXT_143);
    if (itemType.isPrimitiveType()) {
    stringBuffer.append(TEXT_144);
    }
    stringBuffer.append(TEXT_145);
    stringBuffer.append(itemType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_146);
    stringBuffer.append(item);
    if (itemType.isPrimitiveType()) {
    stringBuffer.append(TEXT_147);
    stringBuffer.append(itemType.getPrimitiveValueFunction());
    stringBuffer.append(TEXT_148);
    }
    stringBuffer.append(TEXT_149);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_150);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_151);
    stringBuffer.append(itemType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_152);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_153);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_154);
    } else if (constraint.equals("MemberTypes") && !genDataType.getMemberTypes().isEmpty()) {
    stringBuffer.append(TEXT_155);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.BasicDiagnostic"));
    stringBuffer.append(TEXT_156);
    for (ListIterator k = genDataType.getMemberTypes().listIterator(); k.hasNext(); ) { GenDataType memberType = (GenDataType)k.next(); String memberDelegate = memberType.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(memberType.getGenPackage()) + "Validator.";
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_157);
    stringBuffer.append(memberDelegate);
    stringBuffer.append(TEXT_158);
    stringBuffer.append(memberType.getName());
    stringBuffer.append(TEXT_159);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_160);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_161);
    } else {
    stringBuffer.append(TEXT_162);
    stringBuffer.append(memberType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_163);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_164);
    stringBuffer.append(memberDelegate);
    stringBuffer.append(TEXT_165);
    stringBuffer.append(memberType.getName());
    stringBuffer.append(TEXT_166);
    if (memberType.isPrimitiveType()) {
    stringBuffer.append(TEXT_167);
    }
    stringBuffer.append(TEXT_168);
    stringBuffer.append(memberType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_169);
    stringBuffer.append(genClassifier.getSafeUncapName());
    if (memberType.isPrimitiveType()) {
    stringBuffer.append(TEXT_170);
    stringBuffer.append(memberType.getPrimitiveValueFunction());
    stringBuffer.append(TEXT_171);
    }
    stringBuffer.append(TEXT_172);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_173);
    }
    }
    stringBuffer.append(TEXT_174);
    stringBuffer.append(genModel.getImportedName("java.util.List"));
    stringBuffer.append(TEXT_175);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.Diagnostic"));
    stringBuffer.append(TEXT_176);
    for (ListIterator k = genDataType.getMemberTypes().listIterator(); k.hasNext(); ) { GenDataType memberType = (GenDataType)k.next(); String memberDelegate = memberType.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(memberType.getGenPackage()) + "Validator.";
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_177);
    stringBuffer.append(memberDelegate);
    stringBuffer.append(TEXT_178);
    stringBuffer.append(memberType.getName());
    stringBuffer.append(TEXT_179);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_180);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_181);
    } else {
    stringBuffer.append(TEXT_182);
    stringBuffer.append(memberType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_183);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_184);
    stringBuffer.append(memberDelegate);
    stringBuffer.append(TEXT_185);
    stringBuffer.append(memberType.getName());
    stringBuffer.append(TEXT_186);
    if (memberType.isPrimitiveType()) {
    stringBuffer.append(TEXT_187);
    }
    stringBuffer.append(TEXT_188);
    stringBuffer.append(memberType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_189);
    stringBuffer.append(genClassifier.getSafeUncapName());
    if (memberType.isPrimitiveType()) {
    stringBuffer.append(TEXT_190);
    stringBuffer.append(memberType.getPrimitiveValueFunction());
    stringBuffer.append(TEXT_191);
    }
    stringBuffer.append(TEXT_192);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_193);
    }
    }
    stringBuffer.append(TEXT_194);
    } else if (constraint.equals("Pattern") && !genDataType.getPatterns().isEmpty()) {
    stringBuffer.append(TEXT_195);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_196);
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_197);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_198);
    }
    stringBuffer.append(genDataType.getSafeUncapName());
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_199);
    }
    stringBuffer.append(TEXT_200);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_201);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_202);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_203);
    } else if (constraint.equals("Enumeration") && !genDataType.getEnumerationLiterals().isEmpty()) { String variable = genDataType.getSafeUncapName();
    if (genDataType.isPrimitiveType()) { variable = variable + "Object";
    stringBuffer.append(TEXT_204);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_205);
    stringBuffer.append(variable);
    stringBuffer.append(TEXT_206);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_207);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_208);
    }
    stringBuffer.append(TEXT_209);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_210);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_211);
    stringBuffer.append(variable);
    stringBuffer.append(TEXT_212);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_213);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_214);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_215);
    stringBuffer.append(variable);
    stringBuffer.append(TEXT_216);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_217);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_218);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_219);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_220);
    } else if (constraint.equals("Min") && genDataType.getMinLiteral() != null) {
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_221);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_222);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_223);
    stringBuffer.append(genDataType.isMinInclusive() ? ">=" : ">");
    stringBuffer.append(TEXT_224);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_225);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_226);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_227);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_228);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_229);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_230);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_231);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_232);
    stringBuffer.append(genDataType.isMinInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_233);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_234);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_235);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_236);
    } else { String comparison = "comparison".equals(genClassifier.getSafeUncapName()) ? "theComparison" : "comparison";
    if (genDataType.isXMLCalendar()) {
    stringBuffer.append(TEXT_237);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_238);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_239);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_240);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_241);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_242);
    if (genDataType.isMinInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_243);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_244);
    } else if (genDataType.isXMLDuration()) {
    stringBuffer.append(TEXT_245);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_246);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_247);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_248);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_249);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_250);
    if (genDataType.isMinInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_251);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_252);
    } else {
    stringBuffer.append(TEXT_253);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_254);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_255);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_256);
    stringBuffer.append(genDataType.isMinInclusive() ? ">=" : ">");
    stringBuffer.append(TEXT_257);
    }
    stringBuffer.append(TEXT_258);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_259);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_260);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_261);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_262);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_263);
    stringBuffer.append(genDataType.isMinInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_264);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_265);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_266);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_267);
    }
    } else if (constraint.equals("Max") && genDataType.getMaxLiteral() != null) {
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_268);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_269);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_270);
    stringBuffer.append(genDataType.isMaxInclusive() ? "<=" : "<");
    stringBuffer.append(TEXT_271);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_272);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_273);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_274);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_275);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_276);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_277);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_278);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_279);
    stringBuffer.append(genDataType.isMaxInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_280);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_281);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_282);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_283);
    } else { String comparison = "comparison".equals(genClassifier.getSafeUncapName()) ? "theComparison" : "comparison";
    if (genDataType.isXMLCalendar()) {
    stringBuffer.append(TEXT_284);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_285);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_286);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_287);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_288);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_289);
    if (genDataType.isMaxInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_290);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_291);
    } else if (genDataType.isXMLDuration()) {
    stringBuffer.append(TEXT_292);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_293);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_294);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_295);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_296);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_297);
    if (genDataType.isMaxInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_298);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_299);
    } else {
    stringBuffer.append(TEXT_300);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_301);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_302);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_303);
    stringBuffer.append(genDataType.isMaxInclusive() ? "<=" : "<");
    stringBuffer.append(TEXT_304);
    }
    stringBuffer.append(TEXT_305);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_306);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_307);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_308);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_309);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_310);
    stringBuffer.append(genDataType.isMaxInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_311);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_312);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_313);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_314);
    }
    } else if (constraint.equals("MinLength") && genDataType.getMinLength() != -1) {
    stringBuffer.append(TEXT_315);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_316);
    stringBuffer.append(genDataType.getLengthAccessorFunction());
    stringBuffer.append(TEXT_317);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_318);
    stringBuffer.append(genDataType.getMinLength());
    stringBuffer.append(TEXT_319);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_320);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_321);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_322);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_323);
    stringBuffer.append(genDataType.getMinLength());
    stringBuffer.append(TEXT_324);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_325);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_326);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_327);
    } else if (constraint.equals("MaxLength") && genDataType.getMaxLength() != -1) {
    stringBuffer.append(TEXT_328);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_329);
    stringBuffer.append(genDataType.getLengthAccessorFunction());
    stringBuffer.append(TEXT_330);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_331);
    stringBuffer.append(genDataType.getMaxLength());
    stringBuffer.append(TEXT_332);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_333);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_334);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_335);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_336);
    stringBuffer.append(genDataType.getMaxLength());
    stringBuffer.append(TEXT_337);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_338);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_339);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_340);
    } else if (constraint.equals("TotalDigits") && genDataType.getTotalDigits() != -1) {
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_341);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_342);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_343);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_344);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_345);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_346);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_347);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_348);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_349);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_350);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_351);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_352);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_353);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_354);
    } else if ("java.math.BigDecimal".equals(genDataType.getQualifiedInstanceClassName())) {
    stringBuffer.append(TEXT_355);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_356);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_357);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_358);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_359);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_360);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_361);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_362);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_363);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_364);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_365);
    } else {
    stringBuffer.append(TEXT_366);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_367);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_368);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_369);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_370);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_371);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_372);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_373);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_374);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_375);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_376);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_377);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_378);
    }
    stringBuffer.append(TEXT_379);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_380);
    } else if (constraint.equals("FractionDigits") && genDataType.getFractionDigits() != -1 && "java.math.BigDecimal".equals(genDataType.getQualifiedInstanceClassName())) {
    stringBuffer.append(TEXT_381);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_382);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_383);
    stringBuffer.append(genDataType.getFractionDigits());
    stringBuffer.append(TEXT_384);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_385);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_386);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_387);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_388);
    stringBuffer.append(genDataType.getFractionDigits());
    stringBuffer.append(TEXT_389);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_390);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_391);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_392);
    } else if (constraintDelegate != null) {
    stringBuffer.append(TEXT_393);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_394);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_395);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.BasicDiagnostic"));
    stringBuffer.append(TEXT_396);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.Diagnostic"));
    stringBuffer.append(TEXT_397);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.plugin.EcorePlugin"));
    stringBuffer.append(TEXT_398);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_399);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_400);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_401);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_402);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(genModel.getNonNLS(2));
    stringBuffer.append(TEXT_403);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_404);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_405);
    stringBuffer.append(constraintDelegate.getName());
    stringBuffer.append(TEXT_406);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_407);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(accessor);
    stringBuffer.append(TEXT_408);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_409);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_410);
    } else {
    stringBuffer.append(TEXT_411);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_412);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_413);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.BasicDiagnostic"));
    stringBuffer.append(TEXT_414);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.Diagnostic"));
    stringBuffer.append(TEXT_415);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.plugin.EcorePlugin"));
    stringBuffer.append(TEXT_416);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_417);
    stringBuffer.append(genDataType.getQualifiedClassifierAccessor());
    stringBuffer.append(TEXT_418);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_419);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_420);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(genModel.getNonNLS(2));
    stringBuffer.append(TEXT_421);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_422);
    }
    } else if (constraintDelegate != null) {
    stringBuffer.append(TEXT_423);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_424);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_425);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.BasicDiagnostic"));
    stringBuffer.append(TEXT_426);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.Diagnostic"));
    stringBuffer.append(TEXT_427);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.plugin.EcorePlugin"));
    stringBuffer.append(TEXT_428);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_429);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_430);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_431);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(genModel.getNonNLS(2));
    stringBuffer.append(TEXT_432);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_433);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_434);
    stringBuffer.append(constraintDelegate.getName());
    stringBuffer.append(TEXT_435);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_436);
    stringBuffer.append(cast);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_437);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_438);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_439);
    } else { GenOperation genOperation = ((GenClass)genClassifier).getInvariantOperation(constraint); if (genOperation != null) {
    stringBuffer.append(TEXT_440);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_441);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_442);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_443);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_444);
    } else {
    stringBuffer.append(TEXT_445);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_446);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_447);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.BasicDiagnostic"));
    stringBuffer.append(TEXT_448);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.common.util.Diagnostic"));
    stringBuffer.append(TEXT_449);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.plugin.EcorePlugin"));
    stringBuffer.append(TEXT_450);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_451);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_452);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_453);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(genModel.getNonNLS(2));
    stringBuffer.append(TEXT_454);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_455);
    }}
    stringBuffer.append(TEXT_456);
    }
    }
    stringBuffer.append(TEXT_457);
    stringBuffer.append(genPackage.getValidatorClassName());
    genModel.emitSortedImports();
    stringBuffer.append(TEXT_458);
    return stringBuffer.toString();
  }
}
