/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.geronimo.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.generic.core.internal.GenericServerBehaviour;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.servertype.definition.ArchiveType;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.geronimo.core.internal.GeronimoUtils;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class GeronimoServerBehaviour
extends GenericServerBehaviour {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void stop(boolean force) {
        super.stop(true);
    }

    public void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        int state = this.getServer().getServerState();
        if (state == 4 || state == 1 || state == 3) {
            return;
        }
        if (deltaKind == 0) {
            deltaKind = 2;
        }
        if (deltaKind != 1 && deltaKind != 3 && deltaKind != 2) {
            return;
        }
        String[] commands = this.getCommands(deltaKind, module[module.length - 1]);
        int i = 0;
        while (i < commands.length) {
            this.executeExternalCommand(commands[i], true);
            ++i;
        }
    }

    private String[] getCommands(int deltaKind, IModule module) {
        StringBuffer command = new StringBuffer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJ2EEModule j2eeModule = (IJ2EEModule)module.getAdapter((Class)clazz);
        String moduleId = GeronimoUtils.getConfigId(module);
        GeronimoUtils.copyDeploymentPlanToDeployable(module);
        switch (deltaKind) {
            case 1: {
                String[] result = new String[1];
                File jarFile = this.createJarFile(j2eeModule.getLocation());
                command.append(" deploy ");
                command.append(jarFile.getAbsolutePath());
                result[0] = command.toString();
                return result;
            }
            case 2: {
                String[] result = new String[2];
                File jarFile = this.createJarFile(j2eeModule.getLocation());
                command.append(" undeploy ");
                command.append(moduleId);
                result[0] = command.toString();
                command.setLength(0);
                command.append(" deploy ");
                command.append(jarFile.getAbsolutePath());
                result[1] = command.toString();
                return result;
            }
            case 3: {
                String[] result = new String[1];
                command.append(" undeploy ");
                command.append(moduleId);
                result[0] = command.toString();
                return result;
            }
        }
        throw new IllegalArgumentException();
    }

    private int executeExternalCommand(String command, boolean blockForCompletion) {
        int rc = 0;
        try {
            Trace.trace((byte)Trace.FINEST, (String)"Publishing module");
            ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = mgr.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            String launchName = "GeronimoServerPublisher";
            String uniqueLaunchName = mgr.generateUniqueLaunchConfigurationNameFrom(launchName);
            ILaunchConfiguration conf = null;
            ILaunchConfiguration[] lch = mgr.getLaunchConfigurations(type);
            int i = 0;
            while (i < lch.length) {
                if (launchName.equals(lch[i].getName())) {
                    conf = lch[i];
                    break;
                }
                ++i;
            }
            ILaunchConfigurationWorkingCopy wc = null;
            wc = conf != null ? conf.getWorkingCopy() : type.newInstance(null, uniqueLaunchName);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getMainClass()));
            GenericServerRuntime runtime = (GenericServerRuntime)this.getRuntimeDelegate();
            IVMInstall vmInstall = runtime.getVMInstall();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, runtime.getVMInstallTypeId());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
            this.setupLaunchClasspath(wc, vmInstall, this.getPublishClasspath());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getWorkingDirectory()));
            String programArgs = String.valueOf(this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getProgramArguments())) + " " + command;
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArgs);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getVmParameters()));
            ILaunch launched = wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
            if (blockForCompletion) {
                IProcess[] processes = launched.getProcesses();
                int i2 = 0;
                while (i2 < processes.length) {
                    int maxDelay = 15000;
                    while (!processes[i2].isTerminated() && maxDelay > 0) {
                        Thread.sleep(100L);
                        maxDelay -= 100;
                    }
                    rc = processes[i2].getExitValue();
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)Trace.SEVERE, (String)"Error launching publish action", (Throwable)e);
            rc = -1;
        }
        return rc;
    }

    private File createJarFile(IPath location) {
        try {
            File zipFile;
            String rootFilename = location.toOSString();
            File rootDir = new File(rootFilename);
            String zipFilePrefix = rootDir.getName();
            if (zipFilePrefix.length() < 3) {
                zipFilePrefix = String.valueOf(zipFilePrefix) + "123";
            }
            if ((zipFile = File.createTempFile(zipFilePrefix, null)).exists()) {
                zipFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(zipFile);
            JarOutputStream jos = new JarOutputStream(fos);
            this.addToJar("", rootDir, jos);
            jos.close();
            fos.close();
            zipFile.deleteOnExit();
            return zipFile;
        }
        catch (IOException e) {
            Trace.trace((byte)Trace.SEVERE, (String)"Error creating zip file", (Throwable)e);
            return null;
        }
    }

    private void addToJar(String namePrefix, File dir, JarOutputStream jos) throws IOException {
        File[] contents = dir.listFiles();
        int i = 0;
        while (i < contents.length) {
            File f = contents[i];
            if (f.isDirectory()) {
                this.addToJar(String.valueOf(namePrefix) + f.getName() + "/", f, jos);
            } else {
                JarEntry entry = new JarEntry(String.valueOf(namePrefix) + f.getName());
                jos.putNextEntry(entry);
                byte[] buffer = new byte[10000];
                FileInputStream fis = new FileInputStream(f);
                int bytesRead = 0;
                while (bytesRead != -1) {
                    bytesRead = fis.read(buffer);
                    if (bytesRead <= 0) continue;
                    jos.write(buffer, 0, bytesRead);
                }
            }
            ++i;
        }
    }

    private List getPublishClasspath() {
        String cpRef = this.getServerDefinition().getStop().getClasspathReference();
        return this.serverClasspath(cpRef);
    }

    public Map getServerInstanceProperties() {
        return this.getRuntimeDelegate().getAttribute("generic_server_instance_properties", null);
    }

    private RuntimeDelegate getRuntimeDelegate() {
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.RuntimeDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (RuntimeDelegate)iRuntime.getAdapter((Class)clazz);
    }

    private List serverClasspath(String cpRef) {
        Classpath classpath = this.getServerDefinition().getClasspath(cpRef);
        ArrayList<String> mementoList = new ArrayList<String>(classpath.getArchive().size());
        Iterator iterator = classpath.getArchive().iterator();
        while (iterator.hasNext()) {
            ArchiveType archive = (ArchiveType)iterator.next();
            String cpath = this.getServerDefinition().getResolver().resolveProperties(archive.getPath());
            try {
                mementoList.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(cpath)).getMemento());
            }
            catch (CoreException coreException) {}
        }
        return mementoList;
    }

    private void setupLaunchClasspath(ILaunchConfigurationWorkingCopy wc, IVMInstall vmInstall, List cp) {
        if (vmInstall != null) {
            IPath toolsPath;
            try {
                cp.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType").append(vmInstall.getName()), (int)2).getMemento());
            }
            catch (Exception exception) {}
            Path jrePath = new Path(vmInstall.getInstallLocation().getAbsolutePath());
            if (jrePath != null && (toolsPath = jrePath.append("lib").append("tools.jar")).toFile().exists()) {
                try {
                    cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath).getMemento());
                }
                catch (CoreException coreException) {}
            }
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, cp);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }
}

