/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.geronimo.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntimeTargetHandler;
import org.eclipse.jst.server.generic.core.internal.ServerTypeDefinitionUtil;
import org.eclipse.jst.server.generic.servertype.definition.ArchiveType;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.wst.server.core.IRuntime;

public class GeronimoServerRuntimeTargetHandler
extends GenericServerRuntimeTargetHandler {
    public IClasspathEntry[] resolveClasspathContainer(IRuntime runtime, String id) {
        return GeronimoServerRuntimeTargetHandler.getServerClassPathEntry(runtime);
    }

    public static IClasspathEntry[] getServerClassPathEntry(IRuntime runtime) {
        ServerRuntime definition = ServerTypeDefinitionUtil.getServerTypeDefinition((IRuntime)runtime);
        String ref = definition.getProject().getClasspathReference();
        Classpath cp = definition.getClasspath(ref);
        Iterator archives = cp.getArchive().iterator();
        ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
        while (archives.hasNext()) {
            ArchiveType archive = (ArchiveType)archives.next();
            String item = definition.getResolver().resolveProperties(archive.getPath());
            Path path = new Path(item);
            File file = path.toFile();
            if (file.isDirectory()) {
                File[] list = file.listFiles();
                int i = 0;
                while (i < list.length) {
                    if (!list[i].isDirectory()) {
                        Path p = new Path(list[i].getAbsolutePath());
                        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)p, null, null);
                        entryList.add(entry);
                    }
                    ++i;
                }
                continue;
            }
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, null, null);
            entryList.add(entry);
        }
        return entryList.toArray(new IClasspathEntry[entryList.size()]);
    }
}

