/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.geronimo.core.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jst.j2ee.internal.web.deployables.J2EEFlexProjWebDeployable;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.geronimo.core.internal.Trace;
import org.eclipse.jst.server.geronimo.core.internal.WebAppDeploymentPlan;
import org.eclipse.wst.common.componentcore.resources.ComponentHandle;
import org.eclipse.wst.server.core.IModule;

public class GeronimoUtils {
    static /* synthetic */ Class class$0;

    public static String getConfigId(IModule module) {
        String configId = null;
        WebAppDeploymentPlan deploymentPlan = GeronimoUtils.getDeploymentPlan(module);
        if (deploymentPlan != null) {
            configId = deploymentPlan.getConfigId();
        }
        if (configId == null) {
            configId = GeronimoUtils.getWebAppId(module);
        }
        return configId;
    }

    public static String getContextRoot(IModule module) {
        String contextRoot = null;
        WebAppDeploymentPlan deploymentPlan = GeronimoUtils.getDeploymentPlan(module);
        if (deploymentPlan != null) {
            contextRoot = deploymentPlan.getContextRoot();
        }
        if (contextRoot == null) {
            contextRoot = GeronimoUtils.getWebAppId(module);
        }
        return contextRoot;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getWebAppId(IModule module) {
        IJ2EEModule j2eeModule;
        String moduleId;
        block9: {
            moduleId = module.getId();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            if ((j2eeModule = (IJ2EEModule)module.getAdapter((Class)clazz)) != null && j2eeModule instanceof J2EEFlexProjWebDeployable) {
                J2EEFlexProjWebDeployable j2eeFlexWeb = (J2EEFlexProjWebDeployable)j2eeModule;
                WebArtifactEdit webEdit = null;
                try {
                    ComponentHandle handle = j2eeFlexWeb.getComponentHandle();
                    webEdit = WebArtifactEdit.getWebArtifactEditForRead((ComponentHandle)handle);
                    WebApp webApp = webEdit.getWebApp();
                    XMIResource res = (XMIResource)webApp.eResource();
                    moduleId = res.getID((EObject)webApp);
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (webEdit == null) throw throwable;
                    webEdit.dispose();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                    if (webEdit == null) break block9;
                }
                webEdit.dispose();
            }
        }
        if (moduleId != null && moduleId.length() > 0) {
            return moduleId;
        }
        IPath moduleLocation = j2eeModule.getLocation();
        if (moduleLocation != null) {
            moduleId = moduleLocation.removeFileExtension().lastSegment();
        }
        if (!(j2eeModule instanceof IWebModule)) return moduleId;
        String contextRoot = ((IWebModule)j2eeModule).getContextRoot();
        if (contextRoot.charAt(0) != '/') return moduleId;
        return contextRoot.substring(1);
    }

    private static WebAppDeploymentPlan getDeploymentPlan(IModule module) {
        IProject project = module.getProject();
        IPath planPath = project.getProjectRelativePath().append(module.getName()).append("WebContent").append("WEB-INF").append("geronimo-jetty.xml");
        IFile planFile = project.getFile(planPath);
        WebAppDeploymentPlan plan = null;
        try {
            plan = planFile.exists() ? new WebAppDeploymentPlan(planFile.getContents()) : GeronimoUtils.createDeploymentPlan(planFile, project.getName(), module.getName());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error reading deployment plan", e);
        }
        return plan;
    }

    public static void copyDeploymentPlanToDeployable(IModule module) {
        IPath planPath;
        IProject project = module.getProject();
        IFile planFile = project.getFile(planPath = project.getProjectRelativePath().append(module.getName()).append("WebContent").append("WEB-INF").append("geronimo-jetty.xml"));
        if (planFile.exists()) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IJ2EEModule j2eeModule = (IJ2EEModule)module.getAdapter((Class)clazz);
                File deployableFile = j2eeModule.getLocation().addTrailingSeparator().append("WEB-INF").addTrailingSeparator().append("geronimo-jetty.xml").toFile();
                InputStream input = planFile.getContents();
                FileOutputStream output = new FileOutputStream(deployableFile);
                byte[] buffer = new byte[1000];
                int bytesRead = 0;
                while (bytesRead > -1) {
                    bytesRead = input.read(buffer);
                    if (bytesRead <= 0) continue;
                    output.write(buffer, 0, bytesRead);
                }
                output.close();
                input.close();
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error copying deployment plan", e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static WebAppDeploymentPlan createDeploymentPlan(IFile deployPlanFile, String projectName, String moduleName) {
        WebAppDeploymentPlan plan = null;
        InputStream is = null;
        try {
            try {
                plan = new WebAppDeploymentPlan();
                plan.setConfigId(String.valueOf(projectName) + "/" + moduleName);
                plan.setContextRoot("/" + moduleName);
                plan.setContextPriorityClassloader(false);
                is = plan.saveToStream();
                deployPlanFile.create(is, false, null);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error creating deployment plan", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (Exception exception) {
            return plan;
        }
        if (is == null) return plan;
        is.close();
        return plan;
    }
}

