/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.geronimo.core.internal;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jst.server.geronimo.core.internal.xml.IMemento;
import org.eclipse.jst.server.geronimo.core.internal.xml.XMLMemento;

public class WebAppDeploymentPlan {
    private static final String PARENT_ID = "parentId";
    private static final String CONTEXT_PRIORITY_CLASSLOADER = "context-priority-classloader";
    private static final String CONTEXT_ROOT = "context-root";
    private static final String CONFIG_ID = "configId";
    private static final String WEB_APP = "web-app";
    protected XMLMemento root;

    public WebAppDeploymentPlan(InputStream is) throws Exception {
        this.root = XMLMemento.loadMemento(is);
    }

    public WebAppDeploymentPlan() throws Exception {
        this.root = XMLMemento.createWriteRoot(WEB_APP);
        this.root.putString("xmlns", "http://geronimo.apache.org/xml/ns/web/jetty");
    }

    public String getConfigId() {
        String configId = this.root.getString(CONFIG_ID);
        return configId;
    }

    public void setConfigId(String configId) {
        if (configId.length() == 0) {
            configId = null;
        }
        this.root.putString(CONFIG_ID, configId);
    }

    public String getParentId() {
        String parentId = this.root.getString(PARENT_ID);
        return parentId;
    }

    public void setParentId(String parentId) {
        if (parentId.length() == 0) {
            parentId = null;
        }
        this.root.putString(PARENT_ID, parentId);
    }

    public String getContextRoot() {
        IMemento contextRootMemento = this.root.getChild(CONTEXT_ROOT);
        String contextRoot = contextRootMemento.getTextData();
        return contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        IMemento contextRootMemento = this.root.getChild(CONTEXT_ROOT);
        if (contextRootMemento == null) {
            contextRootMemento = this.root.createChild(CONTEXT_ROOT);
        }
        if (!(contextRootMemento instanceof XMLMemento)) {
            throw new IllegalStateException();
        }
        ((XMLMemento)contextRootMemento).setTextData(contextRoot);
    }

    public boolean getContextPriorityClassloader() {
        IMemento contextRootMemento = this.root.getChild(CONTEXT_ROOT);
        String data = contextRootMemento.getTextData();
        return new Boolean(data);
    }

    public void setContextPriorityClassloader(boolean contextPriorityClassloader) {
        IMemento memento = this.root.getChild(CONTEXT_PRIORITY_CLASSLOADER);
        if (memento == null) {
            memento = this.root.createChild(CONTEXT_PRIORITY_CLASSLOADER);
        }
        if (!(memento instanceof XMLMemento)) {
            throw new IllegalStateException();
        }
        ((XMLMemento)memento).setTextData(String.valueOf(contextPriorityClassloader));
    }

    public InputStream saveToStream() throws IOException {
        return this.root.getInputStream();
    }

    public byte[] getContents() throws IOException {
        return this.root.getContents();
    }
}

