/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.geronimo.ui.internal;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.geronimo.core.internal.WebAppDeploymentPlan;
import org.eclipse.jst.server.geronimo.ui.internal.Messages;
import org.eclipse.jst.server.geronimo.ui.internal.Trace;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;

public class DPEditor
extends EditorPart {
    protected FormToolkit toolkit;
    protected Text configId;
    protected Text parentId;
    protected Text contextRoot;
    protected Button cpClassLoaderWebAppFirst;
    protected Button cpClassLoaderServerFirst;
    protected WebAppDeploymentPlan plan;
    protected boolean dirty;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor monitor) {
        if (!this.isDirty()) return;
        InputStream is = null;
        try {
            try {
                IEditorInput input = this.getEditorInput();
                if (input instanceof IFileEditorInput) {
                    IFileEditorInput fei = (IFileEditorInput)input;
                    is = this.plan.saveToStream();
                    fei.getFile().setContents(is, false, false, null);
                    this.setDirty(false);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error saving", e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        if (is == null) return;
        is.close();
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fei = (IFileEditorInput)input;
            IFile file = fei.getFile();
            try {
                InputStream is = file.getContents();
                this.plan = new WebAppDeploymentPlan(is);
            }
            catch (Exception exception) {
                throw new PartInitException(Messages.errorCouldNotOpenFile);
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = this.toolkit.createScrolledForm(parent);
        form.setText(Messages.editorTitle);
        form.getBody().setLayout((Layout)new GridLayout());
        Composite columnComp = this.toolkit.createComposite(form.getBody());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 10;
        columnComp.setLayout((Layout)layout);
        columnComp.setLayoutData((Object)new GridData(784));
        Section section = this.toolkit.createSection(columnComp, 458);
        section.setText(Messages.editorSectionGeneralTitle);
        section.setDescription(Messages.editorSectionGeneralDescription);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = this.toolkit.createComposite((Composite)section);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        section.setClient((Control)composite);
        GridData gridData = new GridData(768);
        Label configIdLabel = this.toolkit.createLabel(composite, Messages.editorConfigId);
        configIdLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.configId = this.toolkit.createText(composite, this.plan.getConfigId(), 2048);
        this.configId.setLayoutData((Object)gridData);
        this.configId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DPEditor.this.plan.setConfigId(DPEditor.this.configId.getText());
                DPEditor.this.setDirty(true);
            }
        });
        Label parentIdLabel = this.toolkit.createLabel(composite, Messages.editorParentId);
        parentIdLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.parentId = this.toolkit.createText(composite, this.plan.getParentId(), 2048);
        this.parentId.setLayoutData((Object)gridData);
        this.parentId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DPEditor.this.plan.setParentId(DPEditor.this.parentId.getText());
                DPEditor.this.setDirty(true);
            }
        });
        Label crLabel = this.toolkit.createLabel(composite, Messages.editorContextRoot);
        crLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.contextRoot = this.toolkit.createText(composite, this.plan.getContextRoot(), 2048);
        this.contextRoot.setLayoutData((Object)gridData);
        this.contextRoot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DPEditor.this.plan.setContextRoot(DPEditor.this.contextRoot.getText());
                DPEditor.this.setDirty(true);
            }
        });
        Label classLoaderLabel = this.toolkit.createLabel(composite, Messages.editorClassloader);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        classLoaderLabel.setLayoutData((Object)data);
        parentIdLabel.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.cpClassLoaderServerFirst = this.toolkit.createButton(composite, Messages.editorClassloaderServer, 16);
        this.cpClassLoaderServerFirst.setLayoutData((Object)data);
        this.cpClassLoaderServerFirst.setSelection(!this.plan.getContextPriorityClassloader());
        this.cpClassLoaderWebAppFirst = this.toolkit.createButton(composite, Messages.editorClassloaderWebApp, 16);
        this.cpClassLoaderWebAppFirst.setLayoutData((Object)data);
        this.cpClassLoaderWebAppFirst.setSelection(this.plan.getContextPriorityClassloader());
        this.cpClassLoaderWebAppFirst.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DPEditor.this.plan.setContextPriorityClassloader(DPEditor.this.cpClassLoaderWebAppFirst.getSelection());
                DPEditor.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    protected void setDirty(boolean dirty) {
        if (dirty == this.dirty) {
            return;
        }
        this.dirty = dirty;
        this.firePropertyChange(257);
    }

    public void setFocus() {
    }
}

