/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.facet.FaceletFacet;
import org.eclipse.jst.jsf.facelet.core.internal.util.ViewUtil;
import org.eclipse.jst.jsf.facelet.ui.internal.validation.ValidationReporter;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.JSFValidatorFactory;
import org.eclipse.jst.jsf.validation.internal.ValidationPreferences;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HTMLValidator
implements IValidatorJob {
    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        try {
            this.validate(helper, reporter);
        }
        catch (ValidationException e) {
            status = new Status(4, "org.eclipse.jst.jsf.facelet.ui", 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                if (currentFile != null && currentFile.exists() && this.shouldValidate(currentFile)) {
                    int percent = i * 100 / uris.length + 1;
                    LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + uris[i]);
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                    this.validateFile(currentFile, reporter);
                }
                ++i;
            }
        }
    }

    private void validateFile(IFile file, IReporter reporter) {
        IJSFViewValidator validator = JSFValidatorFactory.createDefaultXMLValidator();
        ValidationPreferences prefs = new ValidationPreferences(JSFCorePlugin.getDefault().getPreferenceStore());
        prefs.load();
        ValidationReporter jsfReporter = new ValidationReporter((IValidator)this, reporter, file, prefs);
        validator.validateView(file, (IJSFViewValidator.IValidationReporter)jsfReporter);
        this.validateFaceletHtml(file, jsfReporter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateFaceletHtml(IFile file, ValidationReporter reporter) {
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(file);
                IStructuredDocument structuredDoc = model.getStructuredDocument();
                this.validateDocument(structuredDoc, reporter, file.getProject());
                return;
            }
            catch (CoreException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                JSFCorePlugin.log((String)"Error validating JSF", (Throwable)e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void validateDocument(IStructuredDocument structuredDoc, ValidationReporter reporter, IProject project) {
        this.validateRoot(structuredDoc, reporter, project);
    }

    private void validateRoot(IStructuredDocument structuredDoc, ValidationReporter reporter, IProject project) {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)structuredDoc, -1);
        IDOMContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Document document = resolver.getDOMDocument();
        Element rootElement = document.getDocumentElement();
        if ("html".equals(rootElement.getNodeName())) {
            Set declaredNamespaces = ViewUtil.getDeclaredNamespaces((NamedNodeMap)rootElement.getAttributes());
            ITagRegistry tagRegistry = ViewUtil.getHtmlTagRegistry((IProject)project);
            Collection namespaces = tagRegistry.getAllTagLibraries();
            for (Attr attr : declaredNamespaces) {
                if (attr.getPrefix() == null || !(attr instanceof IDOMAttr)) continue;
                String declaredUri = attr.getValue();
                String findUri = null;
                for (Namespace ns : namespaces) {
                    if (!ns.getNSUri().equals(declaredUri)) continue;
                    findUri = ns.getNSUri();
                    break;
                }
                if (findUri != null) continue;
                BasicDiagnostic diag = new BasicDiagnostic(2, "", -1, "Can't find facelet tag library for uri " + declaredUri, null);
                IDOMAttr domAttr = (IDOMAttr)attr;
                reporter.report((Diagnostic)diag, domAttr.getValueRegionStartOffset(), domAttr.getValue().length());
            }
        }
    }

    private boolean shouldValidate(IFile model) {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType contentType = manager.getContentType("org.eclipse.wst.html.core.htmlsource");
        return contentType.isAssociatedWith(model.getName()) && FaceletFacet.hasFacet((IProject)model.getProject());
    }
}

