/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.cm.ExternalTagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.IExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.JSPExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.MDExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.TagInfoStrategyComposite;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;

class MetadataTagInfo
extends ExternalTagInfo {
    private final String _uri;
    private final TagInfoStrategyComposite _compositeStrategy;

    private MetadataTagInfo(IProject project, TLDDocument doc, String uri) {
        this._uri = uri;
        IExternalMetadataStrategy mdStrategy = MDExternalMetadataStrategy.create(project);
        JSPExternalMetadataStrategy jspStrategy = new JSPExternalMetadataStrategy(doc);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.MDExternalMetadataStrategy");
        ids.add("org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.JSPExternalMetadataStrategy");
        this._compositeStrategy = new TagInfoStrategyComposite(ids);
        this._compositeStrategy.addStrategy(mdStrategy);
        this._compositeStrategy.addStrategy(jspStrategy);
    }

    public MetadataTagInfo(IProject project, String uri) {
        this(project, null, uri);
    }

    public MetadataTagInfo(IProject project, TLDDocument doc) {
        this(project, doc, doc.getUri());
    }

    public Object getTagProperty(String tagName, String key) {
        TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)this._uri, (String)tagName);
        this._compositeStrategy.resetIterator();
        ExternalTagInfo tagInfo = this.getNextExternalInfo(tagId);
        while (tagInfo != this._compositeStrategy.getNoResult()) {
            try {
                Object value;
                if (tagInfo != this._compositeStrategy.getNoResult() && (value = tagInfo.getTagProperty(tagName, key)) != null) {
                    return value;
                }
            }
            catch (Exception e) {
                FaceletCorePlugin.log("During meta-data strategy", e);
            }
            tagInfo = this.getNextExternalInfo(tagId);
        }
        return null;
    }

    public CMNamedNodeMap getAttributes(String tagName) {
        TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)this._uri, (String)tagName);
        this._compositeStrategy.resetIterator();
        ExternalTagInfo tagInfo = this.getNextExternalInfo(tagId);
        while (tagInfo != this._compositeStrategy.getNoResult()) {
            try {
                CMNamedNodeMap nodeMap;
                if (tagInfo != this._compositeStrategy.getNoResult() && (nodeMap = tagInfo.getAttributes(tagName)) != null) {
                    return nodeMap;
                }
            }
            catch (Exception e) {
                FaceletCorePlugin.log("During meta-data strategy", e);
            }
            tagInfo = this.getNextExternalInfo(tagId);
        }
        return null;
    }

    private ExternalTagInfo getNextExternalInfo(TagIdentifier input) {
        return (ExternalTagInfo)this._compositeStrategy.perform(input);
    }
}

