/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.internal.managedobject.IManagedObject;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.cm.AttributeCMAdapter;
import org.eclipse.jst.jsf.facelet.core.internal.cm.ExternalTagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.AddTagMDPackage;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.AttributeData;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.AttributeUsage;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.ElementData;
import org.eclipse.jst.jsf.facelet.core.internal.cm.addtagmd.provider.IResourceProvider;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.AbstractExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.IExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.util.TagMetadataLoader;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class MDExternalMetadataStrategy
extends AbstractExternalMetadataStrategy
implements IManagedObject {
    private static MySingletonManager MANAGER = new MySingletonManager();
    public static final String STRATEGY_ID = "org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.MDExternalMetadataStrategy";
    private final IProject _project;
    private final TagMetadataLoader _tagMetadataLoader;
    private final Map<String, MDExternalTagInfo> _cached;
    private final AtomicBoolean _isDisposed = new AtomicBoolean(false);
    private static final NullInternalNamedNodeMap NULL_INSTANCE = new NullInternalNamedNodeMap();
    static final Map<String, InternalNamedNodeMap> _faceletData;

    static {
        HashMap map = new HashMap();
        _faceletData = Collections.unmodifiableMap(map);
    }

    public static IExternalMetadataStrategy create(IProject project) {
        try {
            return (IExternalMetadataStrategy)MANAGER.getInstance((IResource)project);
        }
        catch (ObjectManager.ManagedObjectException e) {
            FaceletCorePlugin.log("Getting managed instance of tag metadata strategy", e);
            return new IExternalMetadataStrategy.NullExternalMetadataStrategy();
        }
    }

    private MDExternalMetadataStrategy(IProject project) {
        super(STRATEGY_ID, Messages.MDExternalMetadataStrategy_DisplayName);
        this._project = project;
        this._tagMetadataLoader = new TagMetadataLoader(this._project);
        this._cached = new HashMap<String, MDExternalTagInfo>();
    }

    public void checkpoint() {
    }

    public void destroy() {
    }

    public void dispose() {
        if (this._isDisposed.compareAndSet(false, true)) {
            this._cached.clear();
        }
    }

    public ExternalTagInfo perform(TagIdentifier input) throws Exception {
        MDExternalTagInfo tagInfo = this._cached.get(input.getUri());
        if (tagInfo == null) {
            tagInfo = new MDExternalTagInfo(input.getUri(), this._tagMetadataLoader);
            this._cached.put(input.getUri(), tagInfo);
        }
        return tagInfo;
    }

    private static CMAttributeDeclaration createAttribute(AttributeData attributeData) {
        AttributeCMAdapter attribute = new AttributeCMAdapter(attributeData.getName(), MDExternalMetadataStrategy.convertUsageEnum(attributeData.getUsage()));
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Adapter provider = factory.adapt((Notifier)attributeData, IResourceProvider.class);
        String description = attributeData.getDescription();
        if (provider instanceof IResourceProvider) {
            IResourceProvider resProvider = (IResourceProvider)provider;
            String translated = resProvider.getTranslatedString(attributeData, (EStructuralFeature)AddTagMDPackage.eINSTANCE.getAttributeData_Description());
            description = translated != null ? translated : description;
        }
        attribute.setDescription(description);
        return attribute;
    }

    private static int convertUsageEnum(AttributeUsage usage) {
        switch (usage) {
            case OPTIONAL: {
                return 1;
            }
            case REQUIRED: {
                return 2;
            }
            case FIXED: {
                return 3;
            }
            case PROHIBITED: {
                return 4;
            }
        }
        return 1;
    }

    /* synthetic */ MDExternalMetadataStrategy(IProject iProject, MDExternalMetadataStrategy mDExternalMetadataStrategy) {
        this(iProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalNamedNodeMap
    implements CMNamedNodeMap {
        private final List<CMNode> _nodes = new ArrayList<CMNode>();

        private InternalNamedNodeMap() {
        }

        public void add(CMNode node) {
            this._nodes.add(node);
        }

        public int getLength() {
            return this._nodes.size();
        }

        public CMNode getNamedItem(String name) {
            for (CMNode foundNode : this._nodes) {
                if (!name.equals(foundNode.getNodeName())) continue;
                return foundNode;
            }
            return null;
        }

        public CMNode item(int index) {
            if (index < this._nodes.size()) {
                return this._nodes.get(index);
            }
            return null;
        }

        public Iterator<?> iterator() {
            return Collections.unmodifiableList(this._nodes).iterator();
        }

        /* synthetic */ InternalNamedNodeMap(InternalNamedNodeMap internalNamedNodeMap, InternalNamedNodeMap internalNamedNodeMap2) {
            this();
        }
    }

    private static class MDExternalTagInfo
    extends ExternalTagInfo {
        private final String _uri;
        private final TagMetadataLoader _tagMetadataLoader;
        private final Map<String, InternalNamedNodeMap> _attributes;

        public MDExternalTagInfo(String uri, TagMetadataLoader tagMetadataLoader) {
            this._uri = uri;
            this._tagMetadataLoader = tagMetadataLoader;
            this._attributes = new HashMap<String, InternalNamedNodeMap>();
        }

        public CMNamedNodeMap getAttributes(final String tagName) {
            InternalNamedNodeMap nodeMap = this._attributes.get(tagName);
            final InternalNamedNodeMap[] innerClassNodeMap = new InternalNamedNodeMap[]{nodeMap};
            if (nodeMap == null) {
                SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        ElementData data = MDExternalTagInfo.this._tagMetadataLoader.getElementData(MDExternalTagInfo.this._uri, tagName);
                        if (data != null) {
                            innerClassNodeMap[0] = new InternalNamedNodeMap();
                            for (AttributeData attribute : data.getAttributes()) {
                                innerClassNodeMap[0].add((CMNode)MDExternalMetadataStrategy.createAttribute(attribute));
                            }
                            MDExternalTagInfo.this._attributes.put(tagName, innerClassNodeMap[0]);
                        } else {
                            MDExternalTagInfo.this._attributes.put(tagName, NULL_INSTANCE);
                        }
                    }

                    public void handleException(Throwable exception) {
                        FaceletCorePlugin.log("While loading attribute meta-data", exception);
                    }
                });
            }
            if (innerClassNodeMap[0] == NULL_INSTANCE) {
                return null;
            }
            return innerClassNodeMap[0];
        }

        public Object getTagProperty(final String tagName, final String key) {
            final Object[] value = new Object[]{null};
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() {
                    if ("description".equals(key)) {
                        value[0] = MDExternalTagInfo.this._tagMetadataLoader.getDescription(MDExternalTagInfo.this._uri, tagName);
                    }
                }

                public void handleException(Throwable exception) {
                    FaceletCorePlugin.log("While loading tag property meta-data", exception);
                }
            });
            return value[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySingletonManager
    extends ResourceSingletonObjectManager<MDExternalMetadataStrategy, IProject> {
        private MySingletonManager() {
        }

        protected MDExternalMetadataStrategy createNewInstance(IProject resource) {
            return new MDExternalMetadataStrategy(resource, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullInternalNamedNodeMap
    extends InternalNamedNodeMap {
        private NullInternalNamedNodeMap() {
            super(null, null);
        }

        @Override
        public void add(CMNode node) {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public CMNode getNamedItem(String name) {
            return null;
        }

        @Override
        public CMNode item(int index) {
            return null;
        }

        @Override
        public Iterator<?> iterator() {
            return Collections.EMPTY_LIST.iterator();
        }
    }
}

