/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.jsf.common.internal.managedobject.AbstractManagedObject;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagModelParser;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.WebappConfiguration;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibDefn;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ContextParamSpecifiedFaceletTaglibLocator
extends AbstractFaceletTaglibLocator {
    private final IProject _project;
    private final Map<String, IFaceletTagRecord> _records;
    private final TagRecordFactory _factory;
    private final TaglibFileManager _fileManager;

    public ContextParamSpecifiedFaceletTaglibLocator(IProject project, TagRecordFactory factory) {
        this._project = project;
        this._records = new HashMap<String, IFaceletTagRecord>();
        this._factory = factory;
        this._fileManager = new TaglibFileManager(project, new LibraryChangeHandler());
    }

    @Override
    public void startLocating() {
        this._fileManager.initFiles();
    }

    @Override
    public void stopLocating() {
        this._fileManager.dispose();
    }

    @Override
    public Map<String, ? extends IFaceletTagRecord> locate() {
        return this.findInWebRoot();
    }

    private Map<String, ? extends IFaceletTagRecord> findInWebRoot() {
        List<IFile> files = this._fileManager.getFiles();
        this._records.clear();
        for (IFile file : files) {
            if (!file.exists()) continue;
            TaglibFileTracker tracker = null;
            try {
                tracker = (TaglibFileTracker)this._fileManager.getInstance((IResource)file);
            }
            catch (ObjectManager.ManagedObjectException e) {
                FaceletCorePlugin.log("Creating record", e);
            }
            IFaceletTagRecord record = this.createTagRecord(file);
            if (record == null) continue;
            this._records.put(record.getURI(), record);
            if (tracker == null) continue;
            tracker.setUri(record.getURI());
        }
        return this._records;
    }

    private IFaceletTagRecord createTagRecord(IFile file) {
        InputStream is = null;
        try {
            is = file.getContents();
            FaceletTaglibDefn taglib = TagModelParser.loadFromInputStream(is, null);
            if (taglib != null) {
                IFaceletTagRecord iFaceletTagRecord = this._factory.createRecords(taglib);
                return iFaceletTagRecord;
            }
        }
        catch (CoreException e) {
            FaceletCorePlugin.log("Loading web root taglibs for project: " + this._project.getName(), e);
        }
        catch (IOException e) {
            FaceletCorePlugin.log("Loading web root taglibs for project: " + this._project.getName(), e);
        }
        catch (ParserConfigurationException e) {
            FaceletCorePlugin.log("Loading web root taglibs for project: " + this._project.getName(), e);
        }
        catch (SAXException e) {
            FaceletCorePlugin.log("Loading web root taglibs for project: " + this._project.getName(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    FaceletCorePlugin.log("Closing taglib.xml", e);
                }
            }
        }
        return null;
    }

    private class LibraryChangeHandler {
        private LibraryChangeHandler() {
        }

        public void added(IFile file) {
            IFaceletTagRecord tagRecord = ContextParamSpecifiedFaceletTaglibLocator.this.createTagRecord(file);
            TaglibFileTracker tracker = null;
            try {
                tracker = (TaglibFileTracker)ContextParamSpecifiedFaceletTaglibLocator.this._fileManager.getInstance((IResource)file);
            }
            catch (ObjectManager.ManagedObjectException e) {
                FaceletCorePlugin.log("Adding new library", e);
            }
            if (tagRecord != null) {
                ContextParamSpecifiedFaceletTaglibLocator.this._records.put(tagRecord.getURI(), tagRecord);
                if (tracker != null) {
                    tracker.setUri(tagRecord.getURI());
                }
                ContextParamSpecifiedFaceletTaglibLocator.this.fireEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, null, tagRecord, Listener.TaglibChangedEvent.CHANGE_TYPE.ADDED));
            }
        }

        public void removed(String uri, IFile file) {
            IFaceletTagRecord tagRecord = (IFaceletTagRecord)ContextParamSpecifiedFaceletTaglibLocator.this._records.remove(uri);
            ContextParamSpecifiedFaceletTaglibLocator.this.fireEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, tagRecord, null, Listener.TaglibChangedEvent.CHANGE_TYPE.REMOVED));
        }

        public void changed(String uri, IFile file) {
            IFaceletTagRecord oldValue = (IFaceletTagRecord)ContextParamSpecifiedFaceletTaglibLocator.this._records.remove(uri);
            IFaceletTagRecord newValue = ContextParamSpecifiedFaceletTaglibLocator.this.createTagRecord(file);
            if (newValue != null) {
                ContextParamSpecifiedFaceletTaglibLocator.this._records.put(uri, newValue);
                ContextParamSpecifiedFaceletTaglibLocator.this.fireEvent(new Listener.TaglibChangedEvent(ContextParamSpecifiedFaceletTaglibLocator.this, oldValue, newValue, Listener.TaglibChangedEvent.CHANGE_TYPE.CHANGED));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaglibFileManager
    extends ResourceSingletonObjectManager<TaglibFileTracker, IFile> {
        private final LibraryChangeHandler _handler;
        private final WebappConfiguration _webAppConfiguration;
        private final IResourceChangeListener _newFileListener;

        public TaglibFileManager(final IProject project, LibraryChangeHandler handler) {
            this._handler = handler;
            this._webAppConfiguration = new WebappConfiguration(project);
            this._newFileListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    if (event.getType() == 1 && event.getDelta().findMember(project.getFullPath()) != null) {
                        for (IFile file : TaglibFileManager.this._webAppConfiguration.getFiles()) {
                            IResourceDelta delta = event.getDelta().findMember(file.getFullPath());
                            if (delta == null || delta.getKind() != 1) continue;
                            TaglibFileManager.this._handler.added(file);
                        }
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this._newFileListener);
        }

        public List<IFile> getFiles() {
            return this._webAppConfiguration.getFiles();
        }

        public void initFiles() {
            this._webAppConfiguration.start();
            this._webAppConfiguration.addListener(new WebappConfiguration.WebappListener(){

                public void webappChanged(WebappConfiguration.WebappListener.WebappChangeEvent event) {
                    for (IFile file : event.getRemoved()) {
                        try {
                            TaglibFileTracker tracker = (TaglibFileTracker)TaglibFileManager.this.getInstance((IResource)file);
                            TaglibFileManager.this._handler.removed(tracker._uri, file);
                        }
                        catch (ObjectManager.ManagedObjectException e) {
                            FaceletCorePlugin.log("While removing for webapp change", e);
                        }
                    }
                    for (IFile file : event.getAdded()) {
                        TaglibFileManager.this._handler.added(file);
                    }
                }
            });
        }

        protected TaglibFileTracker createNewInstance(IFile file) {
            return new TaglibFileTracker(file, this, this._handler);
        }

        public void addListener(IResourceLifecycleListener listener) {
            super.addLifecycleEventListener(listener);
        }

        public void removeListener(IResourceLifecycleListener listener) {
            super.removeLifecycleEventListener(listener);
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this._newFileListener);
            Collection managedResources = this.getManagedResources();
            for (IFile file : managedResources) {
                this.unmanageResource((IResource)file);
            }
            this._webAppConfiguration.dispose();
        }
    }

    private static class TaglibFileTracker
    extends AbstractManagedObject
    implements IResourceLifecycleListener {
        private final IFile _file;
        private String _uri;
        private final AtomicLong _lastModifiedStamp = new AtomicLong();
        private TaglibFileManager _manager;
        private final LibraryChangeHandler _handler;

        public TaglibFileTracker(IFile file, TaglibFileManager manager, LibraryChangeHandler handler) {
            this._manager = manager;
            this._manager.addListener(this);
            this._file = file;
            this._lastModifiedStamp.set(file.getModificationStamp());
            this._handler = handler;
        }

        public final void setUri(String uri) {
            this._uri = uri;
        }

        public void checkpoint() {
        }

        public void destroy() {
        }

        public void dispose() {
            this._manager.removeListener(this);
            this._manager = null;
        }

        public IResourceLifecycleListener.EventResult acceptEvent(ResourceLifecycleEvent event) {
            if (!this._file.equals((Object)event.getAffectedResource())) {
                return IResourceLifecycleListener.EventResult.getDefaultEventResult();
            }
            ResourceLifecycleEvent.EventType eventType = event.getEventType();
            switch (eventType) {
                case RESOURCE_ADDED: {
                    this._handler.added(this._file);
                    break;
                }
                case RESOURCE_CHANGED: {
                    this._handler.changed(this._uri, this._file);
                    break;
                }
                case RESOURCE_INACCESSIBLE: {
                    this._handler.removed(this._uri, this._file);
                }
            }
            return IResourceLifecycleListener.EventResult.getDefaultEventResult();
        }
    }
}

