/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagModelParser;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibDefn;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarFileFaceletTaglibLocator
extends AbstractFaceletTaglibLocator {
    private final IProject _project;
    private final TagRecordFactory _factory;
    private Map<String, IFaceletTagRecord> _records;

    public JarFileFaceletTaglibLocator(IProject project, TagRecordFactory factory) {
        this._project = project;
        this._factory = factory;
        this._records = new HashMap<String, IFaceletTagRecord>();
    }

    @Override
    public Map<String, ? extends IFaceletTagRecord> locate() {
        try {
            return this.findInJars();
        }
        catch (JavaModelException e) {
            FaceletCorePlugin.log("Couldn't locate jar file taglibs: " + this._project.getProject(), e);
            return Collections.EMPTY_MAP;
        }
    }

    private Map<String, ? extends IFaceletTagRecord> findInJars() throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)this._project);
        IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
        ArrayList<FaceletTaglibDefn> tagLibsFound = new ArrayList<FaceletTaglibDefn>();
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            switch (entry.getEntryKind()) {
                case 3: {
                    break;
                }
                case 1: {
                    tagLibsFound.addAll(this.processJar(entry));
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++n2;
        }
        for (FaceletTaglibDefn tag : tagLibsFound) {
            IFaceletTagRecord record = this._factory.createRecords(tag);
            if (record == null) continue;
            this._records.put(record.getURI(), record);
        }
        return this._records;
    }

    private static JarFile getJarFileFromCPE(IClasspathEntry entry) throws IOException {
        IPath libraryPath;
        if (entry.getEntryKind() == 1 && (libraryPath = entry.getPath()).getFileExtension() != null && libraryPath.getFileExtension().length() > 0) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (libraryPath.getDevice() == null && workspaceRoot.getProject(libraryPath.segment(0)).exists()) {
                libraryPath = workspaceRoot.getFile(libraryPath).getLocation();
            }
            String libraryPathString = libraryPath.toString();
            return new JarFile(libraryPathString);
        }
        return null;
    }

    private List<FaceletTaglibDefn> processJar(IClasspathEntry entry) {
        ArrayList<FaceletTaglibDefn> tagLibsFound;
        block20: {
            JarFile jarFile = null;
            tagLibsFound = new ArrayList<FaceletTaglibDefn>();
            try {
                try {
                    jarFile = JarFileFaceletTaglibLocator.getJarFileFromCPE(entry);
                    if (jarFile != null) {
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry jarEntry = jarEntries.nextElement();
                            String name = jarEntry.getName();
                            if (!name.startsWith("META-INF/") || !name.endsWith(".taglib.xml")) continue;
                            InputStream is = null;
                            try {
                                is = jarFile.getInputStream(jarEntry);
                                FaceletTaglibDefn tagLib = TagModelParser.loadFromInputStream(is, null);
                                if (tagLib == null) continue;
                                tagLibsFound.add(tagLib);
                            }
                            catch (ParserConfigurationException e) {
                                FaceletCorePlugin.log("Error initializing facelet registry entry", e);
                            }
                            catch (IOException ioe) {
                                FaceletCorePlugin.log("Error initializing facelet registry entry", ioe);
                            }
                            catch (SAXException ioe) {
                                FaceletCorePlugin.log("Error initializing facelet registry entry", ioe);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    FaceletCorePlugin.log("Error opening classpath jar file", e);
                    if (jarFile == null) break block20;
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        FaceletCorePlugin.log("Error closing jar file", ioe);
                    }
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ioe) {
                        FaceletCorePlugin.log("Error closing jar file", ioe);
                    }
                }
            }
        }
        return tagLibsFound;
    }

    @Override
    public void startLocating() {
    }

    @Override
    public void stopLocating() {
    }
}

