/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jst.jsf.core.internal.jem.BeanProxyUtil;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.FaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.ComponentTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.ConverterTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletLibraryClassTagLib;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.TagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.ValidatorTagDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LibraryClassBasedTagRecord
extends FaceletTagRecord {
    private static final String METHOD_NAME_GET_VALUE = "getValue";
    private static final String METHOD_NAME_GET_KEY = "getKey";
    private static final String METHOD_NAME_HAS_NEXT = "hasNext";
    private static final String METHOD_NAME_NEXT = "next";
    private static final String METHOD_NAME_ITERATOR = "iterator";
    private static final String METHOD_NAME_ENTRY_SET = "entrySet";
    private static final String PROPERTY_NAME_FACTORIES = "factories";
    private static final String QUALIFIED_CLASS_NAME__COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY = "com.sun.facelets.tag.AbstractTagLibrary";
    private static final String QUALIFIED_CLASS_NAME_JAVA_UTIL_MAP = "java.util.Map";
    private static final String COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_HANDLER_FACTORY = "com.sun.facelets.tag.AbstractTagLibrary$HandlerFactory";
    private static final String COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_USER_CONVERTER_HANDLER_FACTORY = "com.sun.facelets.tag.AbstractTagLibrary$UserConverterHandlerFactory";
    private static final String COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_CONVERTER_HANDLER_FACTORY = "com.sun.facelets.tag.AbstractTagLibrary$ConverterHandlerFactory";
    private static final String COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_USER_VALIDATOR_HANDLER_FACTORY = "com.sun.facelets.tag.AbstractTagLibrary$UserValidatorHandlerFactory";
    private static final String COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_VALIDATOR_HANDLER_FACTORY = "com.sun.facelets.tag.AbstractTagLibrary$ValidatorHandlerFactory";
    private static final String COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_USER_COMPONENT_HANDLER_FACTORY = "com.sun.facelets.tag.AbstractTagLibrary$UserComponentHandlerFactory";
    private static final String COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_COMPONENT_HANDLER_FACTORY = "com.sun.facelets.tag.AbstractTagLibrary$ComponentHandlerFactory";
    private static final String FIELD_NAME_CONVERTER_ID = "converterId";
    private static final String FIELD_NAME_VALIDATOR_ID = "validatorId";
    private static final String FIELD_NAME_RENDER_TYPE = "renderType";
    private static final String FIELD_NAME_COMPONENT_TYPE = "componentType";
    private static final long serialVersionUID = 4174629773250721041L;
    private static final String STATIC_MEMBER_NAMESPACE = "Namespace";
    private static final String METHOD_NAME_GET_NAMESPACE = "getNamespace";
    private final FaceletLibraryClassTagLib _model;
    private final ProxyFactoryRegistry _registry;
    private final AtomicBoolean _isInitialized = new AtomicBoolean(false);
    private String _uri;
    private BeanProxyUtil.BeanProxyWrapper _classTypeWrapper;
    private Map<String, TagDefn> _tags;

    public LibraryClassBasedTagRecord(ProxyFactoryRegistry registry, FaceletLibraryClassTagLib model) {
        this._registry = registry;
        this._model = model;
    }

    public void initURI() throws CoreException {
        if (this._isInitialized.get()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Cannot initURI once the library is initialized for: " + this._model.getLibraryClass()));
        }
        IBeanTypeProxy libFactoryTypeProxy = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(this._model.getLibraryClass());
        if (libFactoryTypeProxy == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Couldn't find type proxy for " + this._model.getLibraryClass()));
        }
        this._classTypeWrapper = new BeanProxyUtil.BeanProxyWrapper(libFactoryTypeProxy);
        try {
            this._classTypeWrapper.init();
        }
        catch (BeanProxyUtil.ProxyException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Couldn't load class: " + this._model.getLibraryClass(), (Throwable)e));
        }
        String namespace = this.resolveNS(this._classTypeWrapper);
        System.out.println(namespace);
        if (namespace == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.jsf.core", "Couldn't load uri: " + this._model.getLibraryClass()));
        }
        this._uri = namespace;
    }

    @Override
    public synchronized TagDefn getTag(String name) {
        this.initializeIfNecessary();
        return this._tags.get(name);
    }

    @Override
    public synchronized Collection<? extends TagDefn> getTags() {
        this.initializeIfNecessary();
        return Collections.unmodifiableCollection(this._tags.values());
    }

    private void initializeIfNecessary() {
        if (this._isInitialized.compareAndSet(false, true) && this._tags == null) {
            this._tags = this.resolveTags();
        }
    }

    @Override
    public String getURI() {
        return this._uri;
    }

    private Map<String, TagDefn> resolveTags() {
        IFieldProxy fieldProxy;
        HashMap<String, TagDefn> tags = new HashMap<String, TagDefn>();
        IBeanTypeProxy mapTypeProxy = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(QUALIFIED_CLASS_NAME_JAVA_UTIL_MAP);
        IBeanTypeProxy componentFactoryTypeProxy = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(QUALIFIED_CLASS_NAME__COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY);
        if (mapTypeProxy != null && componentFactoryTypeProxy != null && (fieldProxy = componentFactoryTypeProxy.getDeclaredFieldProxy(PROPERTY_NAME_FACTORIES)) != null && fieldProxy.getFieldType().isKindOf(mapTypeProxy)) {
            IMethodProxy entrySetMethod;
            IBeanProxy factories = null;
            try {
                fieldProxy.setAccessible(true);
                factories = fieldProxy.get(this._classTypeWrapper.getInstance());
            }
            catch (ThrowableProxy e) {
                FaceletCorePlugin.log("Error getting factories from bean instance", e);
            }
            if (factories != null && (entrySetMethod = fieldProxy.getFieldType().getMethodProxy(METHOD_NAME_ENTRY_SET)) != null) {
                try {
                    entrySetMethod.setAccessible(true);
                    IBeanProxy entrySetProxy = entrySetMethod.invoke(factories);
                    if (entrySetProxy != null) {
                        IMethodProxy iteratorMethod = entrySetProxy.getTypeProxy().getMethodProxy(METHOD_NAME_ITERATOR);
                        iteratorMethod.setAccessible(true);
                        IBeanProxy iteratorProxy = iteratorMethod.invoke(entrySetProxy);
                        if (iteratorProxy != null) {
                            IMethodProxy nextMethod = iteratorProxy.getTypeProxy().getMethodProxy(METHOD_NAME_NEXT);
                            nextMethod.setAccessible(true);
                            IMethodProxy hasNextMethod = iteratorProxy.getTypeProxy().getMethodProxy(METHOD_NAME_HAS_NEXT);
                            hasNextMethod.setAccessible(true);
                            while (((IBooleanBeanProxy)hasNextMethod.invoke(iteratorProxy)).booleanValue()) {
                                TagDefn tagDefn;
                                IBeanProxy entryProxy = nextMethod.invoke(iteratorProxy);
                                IMethodProxy getKeyProxy = entryProxy.getTypeProxy().getMethodProxy(METHOD_NAME_GET_KEY);
                                IMethodProxy getValueProxy = entryProxy.getTypeProxy().getMethodProxy(METHOD_NAME_GET_VALUE);
                                if (getKeyProxy == null || getValueProxy == null) continue;
                                getKeyProxy.setAccessible(true);
                                IBeanProxy key = getKeyProxy.invoke(entryProxy);
                                if (!(key instanceof IStringBeanProxy)) continue;
                                String name = ((IStringBeanProxy)key).stringValue();
                                getValueProxy.setAccessible(true);
                                IBeanProxy value = getValueProxy.invoke(entryProxy);
                                if (value == null || (tagDefn = this.createTagDefn(name, value)) == null) continue;
                                tags.put(name, tagDefn);
                            }
                        }
                    }
                }
                catch (ThrowableProxy e) {
                    FaceletCorePlugin.log("Error invoking entrySet", e);
                }
            }
        }
        return tags;
    }

    private TagDefn createTagDefn(String name, IBeanProxy handlerValueProxy) {
        TagDefn tagDefn;
        block17: {
            IBeanTypeProxy handlerTypeProxy = handlerValueProxy.getTypeProxy();
            FaceletTaglibFactory TAGDEFN_FACTORY = FaceletTaglibFactory.eINSTANCE;
            IBeanTypeProxy componentHandlerFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_COMPONENT_HANDLER_FACTORY);
            IBeanTypeProxy userComponentHandlerFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_USER_COMPONENT_HANDLER_FACTORY);
            IBeanTypeProxy validatorHandlerFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_VALIDATOR_HANDLER_FACTORY);
            IBeanTypeProxy userValidatorHandlerFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_USER_VALIDATOR_HANDLER_FACTORY);
            IBeanTypeProxy converterHandlerFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_CONVERTER_HANDLER_FACTORY);
            IBeanTypeProxy userConverterHandlerFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_USER_CONVERTER_HANDLER_FACTORY);
            IBeanTypeProxy handlerFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_HANDLER_FACTORY);
            IBeanTypeProxy userTagFactory = this._registry.getBeanTypeProxyFactory().getBeanTypeProxy(COM_SUN_FACELETS_TAG_ABSTRACT_TAG_LIBRARY$_HANDLER_FACTORY);
            tagDefn = null;
            if (handlerTypeProxy.isKindOf(componentHandlerFactory) || handlerTypeProxy.isKindOf(userComponentHandlerFactory)) {
                IFieldProxy componentTypeProxy = handlerTypeProxy.getDeclaredFieldProxy(FIELD_NAME_COMPONENT_TYPE);
                IFieldProxy rendererTypeProxy = handlerTypeProxy.getDeclaredFieldProxy(FIELD_NAME_RENDER_TYPE);
                try {
                    String componentTypeValue;
                    if (componentTypeProxy == null) break block17;
                    componentTypeProxy.setAccessible(true);
                    rendererTypeProxy.setAccessible(true);
                    IBeanProxy componentType = componentTypeProxy.get(handlerValueProxy);
                    if (componentType instanceof IStringBeanProxy && (componentTypeValue = this.getMeaningfulString(((IStringBeanProxy)componentType).stringValue())) != null) {
                        ComponentTagDefn compTagDefn = TAGDEFN_FACTORY.createComponentTagDefn();
                        compTagDefn.setComponentType(componentTypeValue);
                        tagDefn = compTagDefn;
                    }
                }
                catch (ThrowableProxy e) {
                    FaceletCorePlugin.log("Error get component info", e);
                }
            } else if (handlerTypeProxy.isKindOf(validatorHandlerFactory) || handlerTypeProxy.isKindOf(userValidatorHandlerFactory)) {
                IFieldProxy validatorIdProxy = handlerTypeProxy.getDeclaredFieldProxy(FIELD_NAME_VALIDATOR_ID);
                try {
                    String validatorIdValue;
                    if (validatorIdProxy == null) break block17;
                    validatorIdProxy.setAccessible(true);
                    IBeanProxy validatorId = validatorIdProxy.get(handlerValueProxy);
                    ValidatorTagDefn valTagDefn = TAGDEFN_FACTORY.createValidatorTagDefn();
                    tagDefn = valTagDefn;
                    if (validatorId instanceof IStringBeanProxy && (validatorIdValue = this.getMeaningfulString(((IStringBeanProxy)validatorId).stringValue())) != null) {
                        valTagDefn.setValidatorId(validatorIdValue);
                    }
                }
                catch (ThrowableProxy e) {
                    FaceletCorePlugin.log("Error getting validator info", e);
                }
            } else if (handlerTypeProxy.isKindOf(converterHandlerFactory) || handlerTypeProxy.isKindOf(userConverterHandlerFactory)) {
                IFieldProxy converterIdProxy = handlerTypeProxy.getDeclaredFieldProxy(FIELD_NAME_CONVERTER_ID);
                try {
                    String converterIdValue;
                    if (converterIdProxy == null) break block17;
                    converterIdProxy.setAccessible(true);
                    IBeanProxy converterId = converterIdProxy.get(handlerValueProxy);
                    ConverterTagDefn converterTagDefn = TAGDEFN_FACTORY.createConverterTagDefn();
                    tagDefn = converterTagDefn;
                    if (converterId instanceof IStringBeanProxy && (converterIdValue = this.getMeaningfulString(((IStringBeanProxy)converterId).stringValue())) != null) {
                        converterTagDefn.setConverterId(converterIdValue);
                    }
                }
                catch (ThrowableProxy e) {
                    FaceletCorePlugin.log("Error getting validator info", e);
                }
            } else if (handlerTypeProxy.isKindOf(handlerFactory) || handlerTypeProxy.isKindOf(userTagFactory)) {
                tagDefn = TAGDEFN_FACTORY.createHandlerTagDefn();
            }
        }
        if (tagDefn != null) {
            tagDefn.setName(name);
        }
        return tagDefn;
    }

    private String getMeaningfulString(String value) {
        if (value == null) {
            return null;
        }
        String retValue = value.trim();
        if ("".equals(retValue)) {
            retValue = null;
        }
        return retValue;
    }

    private String resolveNS(BeanProxyUtil.BeanProxyWrapper beanProxy) {
        IBeanProxy resultProxy = null;
        try {
            resultProxy = beanProxy.call(METHOD_NAME_GET_NAMESPACE);
            if (resultProxy instanceof IStringBeanProxy) {
                return ((IStringBeanProxy)resultProxy).stringValue();
            }
        }
        catch (BeanProxyUtil.ProxyException proxyException) {}
        return this.resolveNSAggressively(beanProxy);
    }

    private String resolveNSAggressively(BeanProxyUtil.BeanProxyWrapper beanProxy) {
        try {
            return beanProxy.getStringFieldValue(STATIC_MEMBER_NAMESPACE);
        }
        catch (BeanProxyUtil.ProxyException proxyException) {
            return null;
        }
    }

    @Override
    public synchronized int getNumTags() {
        this.initializeIfNecessary();
        return this._tags.size();
    }
}

