/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDERegistration;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.ELProxyContributor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.ServletBeanProxyContributor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.ContextParamSpecifiedFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IProjectTaglibDescriptor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.JarFileFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.Listener;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectTaglibDescriptor
implements IProjectTaglibDescriptor {
    private ProxyFactoryRegistry _registry;
    private final AtomicInteger _isInitialized = new AtomicInteger(0);
    private final IProject _project;
    private final List<AbstractFaceletTaglibLocator> _locators;
    private final MyChangeListener _libChangeListener;
    private final Map<String, IFaceletTagRecord> _tagRecords;

    public ProjectTaglibDescriptor(IProject project) {
        this._project = project;
        this._locators = new ArrayList<AbstractFaceletTaglibLocator>();
        this._tagRecords = new HashMap<String, IFaceletTagRecord>();
        try {
            this._registry = ProjectTaglibDescriptor.createProxyRegistry(this._project);
        }
        catch (CoreException e) {
            FaceletCorePlugin.log("While creatinng proxy", e);
        }
        TagRecordFactory factory = new TagRecordFactory(project, this._registry);
        this._locators.add(new JarFileFaceletTaglibLocator(this._project, factory));
        this._locators.add(new ContextParamSpecifiedFaceletTaglibLocator(this._project, factory));
        this._libChangeListener = new MyChangeListener();
    }

    private static ProxyFactoryRegistry createProxyRegistry(IProject project) throws CoreException {
        IConfigurationContributor[] contributor = new IConfigurationContributor[]{new ServletBeanProxyContributor(JSFVersion.V1_1), new ELProxyContributor(project)};
        return IDERegistration.startAnImplementation((IConfigurationContributor[])contributor, (boolean)false, (IProject)project, (String)project.getName(), (String)"org.eclipse.jst.jsf.facelet.core", (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this._isInitialized.addAndGet(1) == 1) {
            ProjectTaglibDescriptor projectTaglibDescriptor = this;
            synchronized (projectTaglibDescriptor) {
                for (final AbstractFaceletTaglibLocator locator : this._locators) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            FaceletCorePlugin.log("While locating facelet libraries on project: " + ProjectTaglibDescriptor.this._project.getName(), new Exception(exception));
                        }

                        public void run() throws Exception {
                            locator.addListener(ProjectTaglibDescriptor.this._libChangeListener);
                            locator.startLocating();
                            ProjectTaglibDescriptor.this._tagRecords.putAll(locator.locate());
                        }
                    });
                }
            }
        }
    }

    @Override
    public Collection<? extends IFaceletTagRecord> getTagLibraries() {
        this.initialize();
        return Collections.unmodifiableCollection(this._tagRecords.values());
    }

    void maybeLog(Exception e) {
        if (this._isInitialized.get() <= 1) {
            FaceletCorePlugin.log("Failed initializing taglib descriptor", e);
        }
    }

    @Override
    public IFaceletTagRecord getTagLibrary(String uri) {
        this.initialize();
        return this._tagRecords.get(uri);
    }

    @Override
    public void addListener(Listener listener) {
        for (AbstractFaceletTaglibLocator locator : this._locators) {
            locator.addListener(listener);
        }
    }

    @Override
    public void removeListener(Listener listener) {
        for (AbstractFaceletTaglibLocator locator : this._locators) {
            locator.removeListener(listener);
        }
    }

    public void checkpoint() {
    }

    public void destroy() {
    }

    public void dispose() {
        if (this._registry != null) {
            this._registry.terminateRegistry(false);
            for (AbstractFaceletTaglibLocator locator : this._locators) {
                locator.stopLocating();
            }
        }
    }

    private class MyChangeListener
    extends Listener {
        private MyChangeListener() {
        }

        public void tagLibChanged(Listener.TaglibChangedEvent event) {
            switch (event.getChangeType()) {
                case ADDED: {
                    ProjectTaglibDescriptor.this._tagRecords.put(event.getNewValue().getURI(), event.getNewValue());
                    break;
                }
                case CHANGED: {
                    ProjectTaglibDescriptor.this._tagRecords.put(event.getNewValue().getURI(), event.getNewValue());
                    break;
                }
                case REMOVED: {
                    ProjectTaglibDescriptor.this._tagRecords.remove(event.getOldValue());
                }
            }
        }
    }
}

