/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.internal.proxy.core.ICallbackRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.FaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IFaceletTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.LibraryClassBasedTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.XMLBasedTagRecord;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletLibraryClassTagLib;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletXMLDefnTaglib;

class TagRecordFactory {
    private final ProxyFactoryRegistry _registry;
    private static final NullProxyFactoryRegistry NULL_REGISTRY = new NullProxyFactoryRegistry();

    public TagRecordFactory(IProject project, ProxyFactoryRegistry registry) {
        this._registry = registry;
    }

    public IFaceletTagRecord createRecords(FaceletTaglibDefn taglibDefn) {
        FaceletTagRecord retValue = null;
        if (taglibDefn instanceof FaceletLibraryClassTagLib) {
            if (this._registry != NULL_REGISTRY) {
                LibraryClassBasedTagRecord record = new LibraryClassBasedTagRecord(this._registry, (FaceletLibraryClassTagLib)taglibDefn);
                try {
                    record.initURI();
                    retValue = record;
                }
                catch (CoreException e) {
                    FaceletCorePlugin.log("While creating record: " + record, e);
                }
            }
        } else if (taglibDefn instanceof FaceletXMLDefnTaglib) {
            XMLBasedTagRecord record;
            retValue = record = new XMLBasedTagRecord((FaceletXMLDefnTaglib)taglibDefn);
        }
        return retValue;
    }

    private static class NullProxyFactoryRegistry
    extends ProxyFactoryRegistry {
        private NullProxyFactoryRegistry() {
        }

        public ICallbackRegistry getCallbackRegistry() {
            throw new UnsupportedOperationException("This is null proxy");
        }

        protected void registryTerminated(boolean wait) {
            throw new UnsupportedOperationException("This is null proxy");
        }
    }
}

