/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappConfiguration {
    private static final String FACELET_LIBRARIES_CONTEXT_PARAM_NAME = "facelets.LIBRARIES";
    private final IProject _project;
    private final ContextParamAdapter _contextParamAdapter;
    private List<IFile> _cachedFiles;

    WebappConfiguration(IProject project) {
        this._project = project;
        this._contextParamAdapter = new ContextParamAdapter();
    }

    public void addListener(WebappListener listener) {
        this._contextParamAdapter.addListener(listener);
    }

    public void removeListener(WebappListener listener) {
        this._contextParamAdapter.removeListener(listener);
    }

    public List<IFile> getFiles() {
        IVirtualFolder folder = JSFAppConfigUtils.getWebContentFolder((IProject)this._project);
        if (folder == null) {
            return Collections.emptyList();
        }
        List<String> filenames = WebappConfiguration.getConfigFilesFromContextParam(this._project);
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (String filename : filenames) {
            IVirtualFile vfile = folder.getFile((IPath)new Path(filename));
            if (vfile == null) continue;
            files.add(vfile.getUnderlyingFile());
        }
        this._cachedFiles = files;
        return Collections.unmodifiableList(files);
    }

    private Object getModelObject() {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this._project);
        return provider.getModelObject();
    }

    public void start() {
        Object webAppObj = this.getModelObject();
        if (webAppObj != null) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                this.startLocatingJ2EEConfigs((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj);
            } else if (webAppObj instanceof WebApp) {
                this.startLocatingJEEConfigs((WebApp)webAppObj);
            }
        } else {
            FaceletCorePlugin.log("Could not get webApp for project: " + this._project, new Exception());
        }
    }

    public void dispose() {
        if (this._contextParamAdapter != null) {
            Object webAppObj = this.getModelObject();
            if (webAppObj != null) {
                if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                    this.stopLocatingJ2EEConfigs((org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj);
                } else if (webAppObj instanceof WebApp) {
                    this.stopLocatingJEEConfigs((WebApp)webAppObj);
                }
            } else {
                FaceletCorePlugin.log("Failed stopping locator for project: " + this._project.getName(), new Exception());
            }
        }
    }

    private void startLocatingJ2EEConfigs(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
        EList contextParams;
        webApp.eAdapters().add((Object)this._contextParamAdapter);
        EList contexts = webApp.getContexts();
        if (contexts != null) {
            for (ContextParam contextParam : contexts) {
                contextParam.eAdapters().add((Object)this._contextParamAdapter);
            }
        }
        if ((contextParams = webApp.getContextParams()) != null) {
            for (ParamValue paramValue : contextParams) {
                paramValue.eAdapters().add((Object)this._contextParamAdapter);
            }
        }
    }

    private void startLocatingJEEConfigs(WebApp webApp) {
        ((EObject)webApp).eAdapters().add((Object)this._contextParamAdapter);
        List params = webApp.getContextParams();
        if (params != null) {
            for (EObject contextParam : params) {
                contextParam.eAdapters().add((Object)this._contextParamAdapter);
            }
        }
    }

    private void stopLocatingJ2EEConfigs(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
        EList contextParams;
        webApp.eAdapters().remove((Object)this._contextParamAdapter);
        EList contexts = webApp.getContexts();
        if (contexts != null) {
            for (ContextParam contextParam : contexts) {
                contextParam.eAdapters().remove((Object)this._contextParamAdapter);
            }
        }
        if ((contextParams = webApp.getContextParams()) != null) {
            for (ParamValue paramValue : contextParams) {
                paramValue.eAdapters().remove((Object)this._contextParamAdapter);
            }
        }
    }

    private void stopLocatingJEEConfigs(WebApp webApp) {
        ((EObject)webApp).eAdapters().remove((Object)this._contextParamAdapter);
        List contextParams = webApp.getContextParams();
        if (contextParams != null) {
            for (EObject paramValue : contextParams) {
                paramValue.eAdapters().remove((Object)this._contextParamAdapter);
            }
        }
    }

    public static List<String> getConfigFilesFromContextParam(IProject project) {
        IModelProvider provider;
        Object webAppObj;
        List<String> filesList = Collections.EMPTY_LIST;
        if (JSFAppConfigUtils.isValidJSFProject((IProject)project) && (webAppObj = (provider = ModelProviderManager.getModelProvider((IProject)project)).getModelObject()) != null) {
            if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                filesList = WebappConfiguration.getConfigFilesForJ2EEApp(project);
            } else if (webAppObj instanceof WebApp) {
                filesList = WebappConfiguration.getConfigFilesForJEEApp((WebApp)webAppObj);
            }
        }
        return filesList;
    }

    private static List<String> getConfigFilesForJEEApp(WebApp webApp) {
        String filesString = null;
        List contextParams = webApp.getContextParams();
        for (org.eclipse.jst.javaee.core.ParamValue paramValue : contextParams) {
            if (!paramValue.getParamName().equals(FACELET_LIBRARIES_CONTEXT_PARAM_NAME)) continue;
            filesString = paramValue.getParamValue();
            break;
        }
        return WebappConfiguration.parseFilesString(filesString);
    }

    private static List<String> getConfigFilesForJ2EEApp(IProject project) {
        List<String> filesList;
        block11: {
            filesList = new ArrayList<String>();
            WebArtifactEdit webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project);
            if (webArtifactEdit != null) {
                try {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = null;
                    try {
                        webApp = webArtifactEdit.getWebApp();
                    }
                    catch (ClassCastException cce) {
                        JSFCorePlugin.log((int)4, (String)cce.getLocalizedMessage(), (Throwable)cce);
                        ArrayList<String> arrayList = filesList;
                        webArtifactEdit.dispose();
                        return arrayList;
                    }
                    if (webApp == null) break block11;
                    String filesString = null;
                    if (webApp.getVersionID() == 23) {
                        EList contexts = webApp.getContexts();
                        for (ContextParam contextParam : contexts) {
                            if (!contextParam.getParamName().equals(FACELET_LIBRARIES_CONTEXT_PARAM_NAME)) continue;
                            filesString = contextParam.getParamValue();
                            break;
                        }
                    } else {
                        EList contextParams = webApp.getContextParams();
                        for (ParamValue paramValue : contextParams) {
                            if (!paramValue.getName().equals(FACELET_LIBRARIES_CONTEXT_PARAM_NAME)) continue;
                            filesString = paramValue.getValue();
                            break;
                        }
                    }
                    filesList = WebappConfiguration.parseFilesString(filesString);
                }
                finally {
                    webArtifactEdit.dispose();
                }
            }
        }
        return filesList;
    }

    private static List parseFilesString(String filesString) {
        ArrayList<String> filesList = new ArrayList<String>();
        if (filesString != null && filesString.trim().length() > 0) {
            StringTokenizer stFilesString = new StringTokenizer(filesString, ";");
            while (stFilesString.hasMoreTokens()) {
                String configFile = stFilesString.nextToken().trim();
                filesList.add(configFile);
            }
        }
        return filesList;
    }

    private class ContextParamAdapter
    extends AdapterImpl {
        private final CopyOnWriteArrayList<WebappListener> _listeners = new CopyOnWriteArrayList();

        private ContextParamAdapter() {
        }

        public void addListener(WebappListener listener) {
            this._listeners.addIfAbsent(listener);
        }

        public void removeListener(WebappListener listener) {
            this._listeners.remove(listener);
        }

        private void fireEvent(WebappListener.WebappChangeEvent event) {
            for (WebappListener listener : this._listeners) {
                listener.webappChanged(event);
            }
        }

        public void notifyChanged(Notification notification) {
            Object objNotifier = notification.getNotifier();
            if (objNotifier instanceof org.eclipse.jst.j2ee.webapplication.WebApp || objNotifier instanceof WebApp) {
                int eventType = notification.getEventType();
                switch (eventType) {
                    case 3: {
                        Object objNewValue = notification.getNewValue();
                        if (objNewValue instanceof ContextParam || objNewValue instanceof org.eclipse.jst.javaee.core.ParamValue) {
                            this.contextParamAdded((EObject)objNewValue);
                            break;
                        }
                        if (!(objNewValue instanceof ParamValue)) break;
                        this.paramValueAdded((EObject)objNewValue);
                        break;
                    }
                    case 4: {
                        Object objOldValue = notification.getOldValue();
                        if (objOldValue instanceof ContextParam || objOldValue instanceof org.eclipse.jst.javaee.core.ParamValue) {
                            this.contextParamRemoved((EObject)objOldValue);
                            break;
                        }
                        if (!(objOldValue instanceof ParamValue)) break;
                        this.paramValueRemoved((EObject)objOldValue);
                    }
                }
            }
        }

        protected void contextParamAdded(EObject contextParam) {
            if (this.isConfigFilesContextParam(contextParam)) {
                this.checkAndFireFileChanges();
            }
            contextParam.eAdapters().add((Object)this);
        }

        private void checkAndFireFileChanges() {
            List oldFiles = WebappConfiguration.this._cachedFiles;
            List<IFile> newFiles = WebappConfiguration.this.getFiles();
            ArrayList<IFile> filesAdded = new ArrayList<IFile>();
            ArrayList<IFile> filesRemoved = new ArrayList<IFile>();
            for (IFile oldFile : oldFiles) {
                if (newFiles.contains(oldFile)) continue;
                filesRemoved.add(oldFile);
            }
            for (IFile newFile : newFiles) {
                if (oldFiles.contains(newFile)) continue;
                filesAdded.add(newFile);
            }
            if (filesAdded.size() > 0 || filesRemoved.size() > 0) {
                this.fireEvent(new WebappListener.WebappChangeEvent(filesRemoved, filesAdded));
            }
        }

        protected void paramValueAdded(EObject paramValue) {
            if (this.isConfigFilesParamValue(paramValue)) {
                this.checkAndFireFileChanges();
            }
            paramValue.eAdapters().add((Object)this);
        }

        protected void contextParamRemoved(EObject contextParam) {
            if (this.isConfigFilesContextParam(contextParam)) {
                this.checkAndFireFileChanges();
            }
            contextParam.eAdapters().remove((Object)this);
        }

        protected void paramValueRemoved(EObject paramValue) {
            if (this.isConfigFilesParamValue(paramValue)) {
                this.checkAndFireFileChanges();
            }
            paramValue.eAdapters().remove((Object)this);
        }

        protected boolean isConfigFilesContextParam(EObject contextParam) {
            boolean isConfigFiles = false;
            if (contextParam != null) {
                String name = null;
                if (contextParam instanceof ContextParam) {
                    name = ((ContextParam)contextParam).getParamName();
                } else if (contextParam instanceof org.eclipse.jst.javaee.core.ParamValue) {
                    name = ((org.eclipse.jst.javaee.core.ParamValue)contextParam).getParamName();
                }
                if (WebappConfiguration.FACELET_LIBRARIES_CONTEXT_PARAM_NAME.equals(name)) {
                    isConfigFiles = true;
                }
            }
            return isConfigFiles;
        }

        protected boolean isConfigFilesParamValue(EObject paramVal) {
            boolean isConfigFiles = false;
            if (paramVal != null) {
                String name = null;
                if (paramVal instanceof ParamValue) {
                    name = ((ParamValue)paramVal).getName();
                } else if (paramVal instanceof org.eclipse.jst.javaee.core.ParamValue) {
                    name = ((org.eclipse.jst.javaee.core.ParamValue)paramVal).getParamName();
                }
                if (WebappConfiguration.FACELET_LIBRARIES_CONTEXT_PARAM_NAME.equals(name)) {
                    isConfigFiles = true;
                }
            }
            return isConfigFiles;
        }
    }

    static abstract class WebappListener {
        WebappListener() {
        }

        public abstract void webappChanged(WebappChangeEvent var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class WebappChangeEvent {
            private final List<IFile> _removed;
            private final List<IFile> _added;

            WebappChangeEvent(List<IFile> removed, List<IFile> added) {
                this._removed = Collections.unmodifiableList(removed);
                this._added = Collections.unmodifiableList(added);
            }

            public final List<IFile> getRemoved() {
                return this._removed;
            }

            public final List<IFile> getAdded() {
                return this._added;
            }
        }
    }
}

