/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.tagmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttributeHandler;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.IAttributeAdvisor;
import org.eclipse.jst.jsf.facelet.core.internal.cm.ExternalTagInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeHandlerMapAdapter
implements Map<String, ITagAttributeHandler>,
Serializable {
    private static final long serialVersionUID = -6052662048278098351L;
    private final transient IAttributeAdvisor _advisor;
    private transient AtomicBoolean _isInitialized = new AtomicBoolean(false);
    private final transient ExternalTagInfo _tagInfo;
    private final Map<String, ITagAttributeHandler> _cache;
    private final String _tagName;

    public AttributeHandlerMapAdapter(ExternalTagInfo tagInfo, IAttributeAdvisor advisor, String tagName) {
        this._tagInfo = tagInfo;
        this._advisor = advisor;
        this._tagName = tagName;
        this._cache = new HashMap<String, ITagAttributeHandler>();
    }

    @Override
    public boolean containsKey(Object key) {
        this.ensureAllAttributes();
        return this._cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.ensureAllAttributes();
        return this._cache.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, ITagAttributeHandler>> entrySet() {
        this.ensureAllAttributes();
        return this._cache.entrySet();
    }

    @Override
    public ITagAttributeHandler get(Object key) {
        if (key instanceof String) {
            return this.getOrCreateAttribute((String)key);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        this.ensureAllAttributes();
        return Collections.unmodifiableSet(this._cache.keySet());
    }

    @Override
    public int size() {
        if (this._tagInfo != null) {
            return this._tagInfo.getAttributes(this._tagName).getLength();
        }
        return this._cache.size();
    }

    @Override
    public Collection<ITagAttributeHandler> values() {
        this.ensureAllAttributes();
        return Collections.unmodifiableCollection(this._cache.values());
    }

    private synchronized ITagAttributeHandler getOrCreateAttribute(String name) {
        ITagAttributeHandler tagAttr = this._cache.get(name);
        if (tagAttr == null) {
            try {
                tagAttr = this._advisor.createAttributeHandler(name);
                this._cache.put(name, tagAttr);
            }
            catch (IAttributeAdvisor.UnknownAttributeException e) {
                JSFCorePlugin.log((Exception)((Object)e), (String)("Trying to get attribute for " + name));
            }
        }
        return tagAttr;
    }

    private void ensureAllAttributes() {
        if (this._isInitialized.compareAndSet(false, true)) {
            for (CMAttributeDeclaration attrDecl : this._tagInfo.getAttributes(this._tagName)) {
                this.getOrCreateAttribute(attrDecl.getNodeName());
            }
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot modify map");
    }

    @Override
    public ITagAttributeHandler put(String key, ITagAttributeHandler value) {
        throw new UnsupportedOperationException("Cannot modify map");
    }

    @Override
    public void putAll(Map<? extends String, ? extends ITagAttributeHandler> t) {
        throw new UnsupportedOperationException("Cannot modify map");
    }

    @Override
    public ITagAttributeHandler remove(Object key) {
        throw new UnsupportedOperationException("Cannot modify map");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._isInitialized = new AtomicBoolean(true);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.ensureAllAttributes();
        out.defaultWriteObject();
    }
}

