/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.actions;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.xml.security.utils.XMLUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.security.core.decrypt.CreateDecryption;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.actions.Messages;
import org.eclipse.wst.xml.security.ui.actions.XmlSecurityActionAdapter;
import org.eclipse.wst.xml.security.ui.decrypt.NewDecryptionWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DecryptNewAction
extends XmlSecurityActionAdapter {
    private ITextEditor editor = null;
    private IFile file = null;
    private static final String ERROR_TEXT = "An error occured during decryption";
    private static final String ACTION = "decrypt";

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.file = (IFile)((IStructuredSelection)selection).getFirstElement();
        }
    }

    public void run(IAction action) {
        this.createDecryption();
    }

    private void createDecryption() {
        try {
            NewDecryptionWizard wizard = new NewDecryptionWizard();
            CreateDecryption decryption = new CreateDecryption();
            IWorkbenchPart workbenchPart = this.getWorkbenchPart();
            this.editor = workbenchPart != null && workbenchPart instanceof ITextEditor ? (ITextEditor)workbenchPart : null;
            if (this.editor != null && this.editor.isEditable()) {
                if (this.editor.isDirty()) {
                    this.saveEditorContent(this.editor);
                }
                IEditorInput input = this.editor.getEditorInput();
                this.file = (IFile)input.getAdapter(IFile.class);
                IDocument document = this.editor.getDocumentProvider().getDocument((Object)input);
                if (this.file != null) {
                    wizard.init(this.file);
                    this.decryptData(decryption, wizard, document, "");
                } else {
                    this.showInfo(Messages.decryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
                }
            } else if (this.file != null && this.file.isAccessible() && !this.file.isReadOnly()) {
                wizard.init(this.file);
                this.decryptData(decryption, wizard, null, this.file.getLocation().toString());
            } else {
                this.showInfo(Messages.decryptionImpossible, NLS.bind((String)Messages.protectedDoc, (Object)ACTION));
            }
        }
        catch (Exception ex) {
            this.showErrorDialog(Messages.error, Messages.decryptingError, ex);
            this.log(ERROR_TEXT, ex);
        }
    }

    private void decryptData(final CreateDecryption data, final NewDecryptionWizard wizard, final IDocument document, final String filename) throws Exception {
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0 && wizard.getModel() != null) {
            Job job = new Job("XML Decryption"){

                public IStatus run(IProgressMonitor monitor) {
                    block8: {
                        try {
                            monitor.beginTask(Messages.decryptionTaskInfo, 6);
                            Document doc = data.decrypt(wizard.getModel(), monitor);
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                if (doc == null) break block8;
                                if (document != null) {
                                    document.set(Utils.docToString((Document)doc, (boolean)false));
                                    break block8;
                                }
                                FileOutputStream fos = new FileOutputStream(filename);
                                XMLUtils.outputDOM((Node)doc, (OutputStream)fos);
                                fos.flush();
                                fos.close();
                            }
                            catch (Exception ex) {
                                DecryptNewAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        DecryptNewAction.this.showErrorDialog(Messages.error, Messages.decryptingError, ex);
                                        DecryptNewAction.this.log(DecryptNewAction.ERROR_TEXT, ex);
                                    }
                                });
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
        dialog.close();
        wizard.dispose();
    }
}

