/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.decrypt;

import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.decrypt.Decryption;
import org.eclipse.wst.xml.security.core.utils.Globals;
import org.eclipse.wst.xml.security.core.utils.Utils;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.decrypt.Messages;

public class PageResource
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "DecryptPageResource";
    private Button bOpen = null;
    private Button bEchoKeyPassword = null;
    private Button bEchoKeystorePassword = null;
    private Combo cEncryptionId = null;
    private Text tKeystore = null;
    private Text tKeystorePassword = null;
    private Text tKeyName = null;
    private Text tKeyPassword = null;
    private IFile file;
    private Decryption decryption = null;
    private static final int LABELWIDTH = 120;

    public PageResource(Decryption decryption, IFile file) {
        super(PAGE_NAME);
        this.setTitle(Messages.decryptionTitle);
        this.setDescription(Messages.decryptionDescription);
        this.decryption = decryption;
        this.file = file;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        this.createPageContent(container);
        this.determineIds();
        this.addListeners();
        this.setControl((Control)container);
        this.loadSettings();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_decryption_resource");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        Group gKeystore = new Group(parent, 16);
        gKeystore.setLayout((Layout)layout);
        gKeystore.setText(Messages.keystore);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKeystore.setLayoutData((Object)data);
        Group gKey = new Group(parent, 16);
        gKey.setLayout((Layout)layout);
        gKey.setText(Messages.key);
        data = new FormData();
        data.top = new FormAttachment((Control)gKeystore, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKey.setLayoutData((Object)data);
        Group gEncryptionId = new Group(parent, 16);
        gEncryptionId.setLayout((Layout)layout);
        gEncryptionId.setText(Messages.encryptionId);
        data = new FormData();
        data.top = new FormAttachment((Control)gKey, 10, -1);
        data.top = new FormAttachment((Control)gKey, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gEncryptionId.setLayoutData((Object)data);
        Label lKeystoreName = new Label((Composite)gKeystore, 4);
        lKeystoreName.setText(Messages.name);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)gKeystore);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystoreName.setLayoutData((Object)data);
        this.tKeystore = new Text((Composite)gKeystore, 4);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeystoreName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystoreName);
        this.tKeystore.setLayoutData((Object)data);
        this.bOpen = new Button((Composite)gKeystore, 8);
        this.bOpen.setText(Messages.selectButton);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeystore, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystore, 10);
        this.bOpen.setLayoutData((Object)data);
        Label lKeystorePassword = new Label((Composite)gKeystore, 4);
        lKeystorePassword.setText(Messages.password);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)lKeystoreName, 10);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystorePassword.setLayoutData((Object)data);
        this.tKeystorePassword = new Text((Composite)gKeystore, 4);
        this.tKeystorePassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystorePassword);
        this.tKeystorePassword.setEchoChar('*');
        this.tKeystorePassword.setLayoutData((Object)data);
        this.bEchoKeystorePassword = new Button((Composite)gKeystore, 8);
        this.bEchoKeystorePassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        this.bEchoKeystorePassword.setToolTipText(Messages.echoPassword);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystorePassword, 10);
        this.bEchoKeystorePassword.setLayoutData((Object)data);
        Label lKeyName = new Label((Composite)gKey, 4);
        lKeyName.setText(Messages.name);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)gKey);
        data.left = new FormAttachment((Control)gKey);
        lKeyName.setLayoutData((Object)data);
        this.tKeyName = new Text((Composite)gKey, 4);
        this.tKeyName.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyName);
        this.tKeyName.setLayoutData((Object)data);
        Label lKeyPassword = new Label((Composite)gKey, 4);
        lKeyPassword.setText(Messages.password);
        data = new FormData();
        data.width = 120;
        data.top = new FormAttachment((Control)lKeyName, 10);
        data.left = new FormAttachment((Control)gKey);
        lKeyPassword.setLayoutData((Object)data);
        this.tKeyPassword = new Text((Composite)gKey, 4);
        this.tKeyPassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyPassword);
        this.tKeyPassword.setEchoChar('*');
        this.tKeyPassword.setLayoutData((Object)data);
        this.bEchoKeyPassword = new Button((Composite)gKey, 8);
        this.bEchoKeyPassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        this.bEchoKeyPassword.setToolTipText(Messages.echoPassword);
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeyPassword, 10);
        this.bEchoKeyPassword.setLayoutData((Object)data);
        this.cEncryptionId = new Combo((Composite)gEncryptionId, 8);
        data = new FormData();
        data.top = new FormAttachment((Control)gEncryptionId);
        data.left = new FormAttachment((Control)gEncryptionId);
        data.width = 200;
        this.cEncryptionId.setLayoutData((Object)data);
    }

    private void determineIds() {
        String[] ids = null;
        try {
            ids = Utils.getIds((InputStream)this.file.getContents(), (String)"encryption");
        }
        catch (Exception exception) {
            ids = new String[]{};
        }
        this.cEncryptionId.setItems(ids);
        this.cEncryptionId.select(0);
    }

    private void addListeners() {
        this.bOpen.addListener(13, (Listener)this);
        this.bEchoKeyPassword.addListener(13, (Listener)this);
        this.bEchoKeystorePassword.addListener(13, (Listener)this);
        this.cEncryptionId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageResource.this.dialogChanged();
            }
        });
        this.tKeystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageResource.this.dialogChanged();
            }
        });
        this.tKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageResource.this.dialogChanged();
            }
        });
        this.tKeyName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageResource.this.dialogChanged();
            }
        });
        this.tKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageResource.this.dialogChanged();
            }
        });
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (message == null && this.getErrorMessage() == null) {
            this.setPageComplete(true);
            this.saveDataToModel();
        } else {
            this.setPageComplete(false);
        }
    }

    private void dialogChanged() {
        block11: {
            if (this.tKeystore.getText().length() == 0) {
                this.updateStatus(Messages.missingKeystore, 1);
                return;
            }
            if (!new File(this.tKeystore.getText()).exists()) {
                this.updateStatus(Messages.keystoreNotFound, 3);
                return;
            }
            if (this.tKeystorePassword.getText().length() == 0) {
                this.updateStatus(Messages.missingKeystorePassword, 1);
                return;
            }
            if (this.tKeyName.getText().length() == 0) {
                this.updateStatus(Messages.missingKeyName, 1);
                return;
            }
            if (this.tKeyPassword.getText().length() == 0) {
                this.updateStatus(Messages.missingKeyPassword, 1);
                return;
            }
            if (new File(this.tKeystore.getText()).exists()) {
                try {
                    Keystore keystore = new Keystore(this.tKeystore.getText(), this.tKeystorePassword.getText(), "JCEKS");
                    keystore.load();
                    if (!keystore.containsKey(this.tKeyName.getText())) {
                        this.updateStatus(Messages.verifyKeyName, 3);
                        return;
                    }
                    if (keystore.getSecretKey(this.tKeyName.getText(), this.tKeyPassword.getText().toCharArray()) == null) {
                        this.updateStatus(Messages.verifyKeyPassword, 3);
                        return;
                    }
                    break block11;
                }
                catch (Exception exception) {
                    this.updateStatus(Messages.verifyAll, 3);
                    return;
                }
            }
            this.updateStatus(Messages.keystoreNotFound, 3);
            return;
        }
        if (this.cEncryptionId.getText().equals("")) {
            this.updateStatus(Messages.missingEncryptionId, 1);
            return;
        }
        this.updateStatus(null, 0);
    }

    public void handleEvent(Event e) {
        if (e.widget == this.bOpen) {
            this.openKeystore();
        } else if (e.widget == this.bEchoKeystorePassword) {
            this.echoPassword(e);
        } else if (e.widget == this.bEchoKeyPassword) {
            this.echoPassword(e);
        }
    }

    private void echoPassword(Event e) {
        if (e.widget == this.bEchoKeystorePassword) {
            if (this.tKeystorePassword.getEchoChar() == '*') {
                this.tKeystorePassword.setEchoChar('\u0000');
            } else {
                this.tKeystorePassword.setEchoChar('*');
            }
            this.tKeystorePassword.redraw();
        } else if (e.widget == this.bEchoKeyPassword) {
            if (this.tKeyPassword.getEchoChar() == '*') {
                this.tKeyPassword.setEchoChar('\u0000');
            } else {
                this.tKeyPassword.setEchoChar('*');
            }
            this.tKeyPassword.redraw();
        }
    }

    private void openKeystore() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterNames(Globals.KEY_STORE_EXTENSION_NAME);
        dialog.setFilterExtensions(Globals.KEY_STORE_EXTENSION);
        dialog.setFilterPath(this.file.getLocation().removeFileExtension().removeLastSegments(1).toString());
        String fileName = dialog.open();
        if (fileName != null && !fileName.equals("")) {
            this.tKeystore.setText(fileName);
        }
    }

    public boolean isPageComplete() {
        this.saveDataToModel();
        return this.getMessage() == null && this.getErrorMessage() == null;
    }

    private void saveDataToModel() {
        this.decryption.setFile(this.file.getLocation().toString());
        this.decryption.setKeystore(this.tKeystore.getText());
        this.decryption.setKeystorePassword(this.tKeystorePassword.getText());
        this.decryption.setKeyName(this.tKeyName.getText());
        this.decryption.setKeyPassword(this.tKeyPassword.getText().toCharArray());
        this.decryption.setEncryptionId(this.cEncryptionId.getText());
        this.storeSettings();
    }

    private void loadSettings() {
        String previousKeystore = this.getDialogSettings().get("dec_keystore");
        if (previousKeystore == null) {
            previousKeystore = "";
        }
        this.tKeystore.setText(previousKeystore);
        String previousKey = this.getDialogSettings().get("dec_key_name");
        if (previousKey == null) {
            previousKey = "";
        }
        this.tKeyName.setText(previousKey);
    }

    private void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put("dec_keystore", this.tKeystore.getText());
        settings.put("dec_key_name", this.tKeyName.getText());
    }
}

