/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.sign;

import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.HashMap;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.security.core.cryptography.Keystore;
import org.eclipse.wst.xml.security.core.sign.Signature;
import org.eclipse.wst.xml.security.core.utils.Algorithms;
import org.eclipse.wst.xml.security.core.utils.Globals;
import org.eclipse.wst.xml.security.ui.XSTUIPlugin;
import org.eclipse.wst.xml.security.ui.sign.Messages;
import org.eclipse.wst.xml.security.ui.sign.NewSignatureWizard;
import org.eclipse.wst.xml.security.ui.sign.PageAlgorithms;

public class PageCreateKey
extends WizardPage
implements Listener {
    public static final String PAGE_NAME = "SignPageCreateKey";
    private String keystoreName;
    private String path;
    private boolean generated = false;
    private Button bOpen = null;
    private Button bGenerate = null;
    private Button bEchoKeystorePassword = null;
    private Button bEchoKeyPassword = null;
    private Combo cKeyAlgorithm = null;
    private Label lPreview = null;
    private Label lResult = null;
    private Text tCommonName = null;
    private Text tOrganizationalUnit = null;
    private Text tOrganization = null;
    private Text tLocation = null;
    private Text tState = null;
    private Text tCountry = null;
    private Text tKeyName = null;
    private Text tKeystore = null;
    private Text tKeystorePassword = null;
    private Text tKeyPassword = null;
    private static final int LABELWIDTH = 160;
    private static final int TEXTHEIGHT = 40;
    private Signature signature = null;
    private Keystore keystore = null;

    public PageCreateKey(Signature signature, String path) {
        super(PAGE_NAME);
        this.setTitle(Messages.signatureTitle);
        this.setDescription(Messages.createKeyDescription);
        this.signature = signature;
        this.path = path;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        container.setLayout((Layout)formLayout);
        this.createPageContent(container);
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.xml.security.doc.wizard_signature_create_key");
    }

    private void createPageContent(Composite parent) {
        FormLayout layout = new FormLayout();
        layout.marginTop = 5;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        parent.setLayout((Layout)layout);
        Group gDN = new Group(parent, 16);
        gDN.setLayout((Layout)layout);
        gDN.setText(Messages.certificate);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gDN.setLayoutData((Object)data);
        Group gKey = new Group(parent, 16);
        gKey.setLayout((Layout)layout);
        gKey.setText(Messages.key);
        data = new FormData();
        data.top = new FormAttachment((Control)gDN, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKey.setLayoutData((Object)data);
        Group gKeystore = new Group(parent, 16);
        gKeystore.setLayout((Layout)layout);
        gKeystore.setText(Messages.keystore);
        data = new FormData();
        data.top = new FormAttachment((Control)gKey, 10, -1);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        gKeystore.setLayoutData((Object)data);
        Label lCommonName = new Label((Composite)gDN, 4);
        lCommonName.setText(Messages.commonName);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)gDN);
        data.left = new FormAttachment((Control)gDN);
        lCommonName.setLayoutData((Object)data);
        this.tCommonName = new Text((Composite)gDN, 4);
        this.tCommonName.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lCommonName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lCommonName);
        this.tCommonName.setLayoutData((Object)data);
        Label lOrganizationalUnit = new Label((Composite)gDN, 4);
        lOrganizationalUnit.setText(Messages.organizationalUnit);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lCommonName, 10);
        data.left = new FormAttachment((Control)gDN);
        lOrganizationalUnit.setLayoutData((Object)data);
        this.tOrganizationalUnit = new Text((Composite)gDN, 4);
        this.tOrganizationalUnit.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lOrganizationalUnit, 0, 0x1000000);
        data.left = new FormAttachment((Control)lOrganizationalUnit);
        this.tOrganizationalUnit.setLayoutData((Object)data);
        Label lOrganization = new Label((Composite)gDN, 4);
        lOrganization.setText(Messages.organization);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lOrganizationalUnit, 10);
        data.left = new FormAttachment((Control)gDN);
        lOrganization.setLayoutData((Object)data);
        this.tOrganization = new Text((Composite)gDN, 4);
        this.tOrganization.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lOrganization, 0, 0x1000000);
        data.left = new FormAttachment((Control)lOrganization);
        this.tOrganization.setLayoutData((Object)data);
        Label lLocation = new Label((Composite)gDN, 4);
        lLocation.setText(Messages.location);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lOrganization, 10);
        data.left = new FormAttachment((Control)gDN);
        lLocation.setLayoutData((Object)data);
        this.tLocation = new Text((Composite)gDN, 4);
        this.tLocation.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lLocation, 0, 0x1000000);
        data.left = new FormAttachment((Control)lLocation);
        this.tLocation.setLayoutData((Object)data);
        Label lState = new Label((Composite)gDN, 4);
        lState.setText(Messages.state);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lLocation, 10);
        data.left = new FormAttachment((Control)gDN);
        lState.setLayoutData((Object)data);
        this.tState = new Text((Composite)gDN, 4);
        this.tState.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lState, 0, 0x1000000);
        data.left = new FormAttachment((Control)lState);
        this.tState.setLayoutData((Object)data);
        Label lCountry = new Label((Composite)gDN, 4);
        lCountry.setText(Messages.country);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lState, 10);
        data.left = new FormAttachment((Control)gDN);
        lCountry.setLayoutData((Object)data);
        this.tCountry = new Text((Composite)gDN, 4);
        this.tCountry.setTextLimit(50);
        data = new FormData();
        data.width = 225;
        data.top = new FormAttachment((Control)lCountry, 0, 0x1000000);
        data.left = new FormAttachment((Control)lCountry);
        this.tCountry.setLayoutData((Object)data);
        this.lPreview = new Label((Composite)gDN, 64);
        data = new FormData();
        data.height = 40;
        data.top = new FormAttachment((Control)lCountry, 10);
        data.left = new FormAttachment((Control)gDN);
        data.right = new FormAttachment(100);
        this.lPreview.setLayoutData((Object)data);
        Label lKeyName = new Label((Composite)gKey, 4);
        lKeyName.setText(Messages.name);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)gKey);
        data.left = new FormAttachment((Control)gKey);
        lKeyName.setLayoutData((Object)data);
        this.tKeyName = new Text((Composite)gKey, 4);
        this.tKeyName.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyName, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyName);
        this.tKeyName.setLayoutData((Object)data);
        Label lKeyPassword = new Label((Composite)gKey, 4);
        lKeyPassword.setText(Messages.password);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lKeyName, 10);
        data.left = new FormAttachment((Control)gKey);
        lKeyPassword.setLayoutData((Object)data);
        this.tKeyPassword = new Text((Composite)gKey, 4);
        this.tKeyPassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyPassword);
        this.tKeyPassword.setEchoChar('*');
        this.tKeyPassword.setLayoutData((Object)data);
        Label lKeyAlgorithm = new Label((Composite)gKey, 4);
        lKeyAlgorithm.setText(Messages.keyAlgorithm);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lKeyPassword, 14);
        data.left = new FormAttachment((Control)gKey);
        lKeyAlgorithm.setLayoutData((Object)data);
        this.cKeyAlgorithm = new Combo((Composite)gKey, 8);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeyAlgorithm, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeyAlgorithm);
        data.width = 150;
        this.cKeyAlgorithm.setLayoutData((Object)data);
        this.bEchoKeyPassword = new Button((Composite)gKey, 8);
        this.bEchoKeyPassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeyPassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeyPassword, 10);
        this.bEchoKeyPassword.setLayoutData((Object)data);
        Label lKeystore = new Label((Composite)gKeystore, 4);
        lKeystore.setText(Messages.name);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)gKeystore);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystore.setLayoutData((Object)data);
        this.tKeystore = new Text((Composite)gKeystore, 4);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystore, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystore);
        data.width = 200;
        this.tKeystore.setLayoutData((Object)data);
        this.bOpen = new Button((Composite)gKeystore, 8);
        this.bOpen.setText(Messages.open);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystore, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystore, 10);
        this.bOpen.setLayoutData((Object)data);
        Label lKeystorePassword = new Label((Composite)gKeystore, 4);
        lKeystorePassword.setText(Messages.password);
        data = new FormData();
        data.width = 160;
        data.top = new FormAttachment((Control)lKeystore, 10);
        data.left = new FormAttachment((Control)gKeystore);
        lKeystorePassword.setLayoutData((Object)data);
        this.tKeystorePassword = new Text((Composite)gKeystore, 4);
        this.tKeystorePassword.setTextLimit(20);
        data = new FormData();
        data.width = 200;
        data.top = new FormAttachment((Control)lKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)lKeystorePassword);
        this.tKeystorePassword.setEchoChar('*');
        this.tKeystorePassword.setLayoutData((Object)data);
        this.bEchoKeystorePassword = new Button((Composite)gKeystore, 8);
        this.bEchoKeystorePassword.setImage(XSTUIPlugin.getDefault().getImageRegistry().get("echo_password"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.tKeystorePassword, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.tKeystorePassword, 10);
        this.bEchoKeystorePassword.setLayoutData((Object)data);
        this.bGenerate = new Button((Composite)gKeystore, 8);
        this.bGenerate.setText(Messages.generate);
        this.bGenerate.setEnabled(false);
        data = new FormData();
        data.top = new FormAttachment((Control)lKeystorePassword, 20);
        data.left = new FormAttachment((Control)gKeystore);
        this.bGenerate.setLayoutData((Object)data);
        this.lResult = new Label((Composite)gKeystore, 64);
        data = new FormData();
        data.height = 40;
        data.top = new FormAttachment((Control)this.bGenerate, 20);
        data.left = new FormAttachment((Control)gKeystore);
        data.right = new FormAttachment(100);
        this.lResult.setLayoutData((Object)data);
    }

    private void addListeners() {
        this.bOpen.addListener(13, (Listener)this);
        this.bGenerate.addListener(3, (Listener)this);
        this.bEchoKeystorePassword.addListener(13, (Listener)this);
        this.bEchoKeyPassword.addListener(13, (Listener)this);
        this.tCommonName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tOrganizationalUnit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tOrganization.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tState.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tCountry.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tKeyName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tKeyPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.cKeyAlgorithm.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
        this.tKeystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PageCreateKey.this.dialogChanged();
            }
        });
    }

    private void dialogChanged() {
        block16: {
            if (this.tCommonName.getText().length() <= 0) {
                this.lPreview.setText("");
                this.updateStatus(Messages.enterCommonName, 1);
                return;
            }
            this.lPreview.setText("CN=" + this.tCommonName.getText());
            if (this.tOrganizationalUnit.getText().length() > 0) {
                this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText());
            }
            if (this.tOrganization.getText().length() > 0) {
                this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText());
            }
            if (this.tLocation.getText().length() > 0) {
                this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText() + ", L=" + this.tLocation.getText());
            }
            if (this.tState.getText().length() > 0) {
                this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText() + ", L=" + this.tLocation.getText() + ", ST=" + this.tState.getText());
            }
            if (this.tCountry.getText().length() > 0) {
                this.lPreview.setText("CN=" + this.tCommonName.getText() + ", OU=" + this.tOrganizationalUnit.getText() + ", O=" + this.tOrganization.getText() + ", L=" + this.tLocation.getText() + ", ST=" + this.tState.getText() + ", C=" + this.tCountry.getText());
            }
            if (this.tKeyName.getText().length() < 4) {
                this.updateStatus(Messages.enterNewKeyName, 1);
                return;
            }
            if (this.tKeyPassword.getText().length() < 6) {
                this.updateStatus(Messages.enterNewKeyPassword, 1);
                return;
            }
            if (this.cKeyAlgorithm.getSelectionIndex() < 0) {
                this.updateStatus(Messages.selectKeyAlgorithm, 1);
                return;
            }
            if (this.tKeystore.getText().length() == 0) {
                this.updateStatus(Messages.selectKeystoreForInsert, 1);
                return;
            }
            if (this.tKeystorePassword.getText().length() == 0) {
                this.updateStatus(Messages.enterKeystorePassword, 1);
                return;
            }
            if (this.tKeystore.getText().length() > 0 && this.tKeystorePassword.getText().length() > 0 && this.tKeyName.getText().length() > 0) {
                String file = this.tKeystore.getText();
                this.keystoreName = file.substring(file.lastIndexOf(System.getProperty("file.separator")) + 1);
                try {
                    this.keystore = new Keystore(file, this.tKeystorePassword.getText(), "JCEKS");
                    boolean loaded = this.keystore.load();
                    if (loaded) {
                        if (this.keystore.containsKey(this.tKeyName.getText())) {
                            this.updateStatus(Messages.keyExistsInKeystore, 3);
                            return;
                        }
                        break block16;
                    }
                    this.updateStatus(Messages.verifyKeystorePassword, 3);
                    return;
                }
                catch (Exception exception) {
                    this.updateStatus(Messages.verifyAll, 3);
                    return;
                }
            }
        }
        this.updateStatus(null, 0);
    }

    private void updateStatus(String message, int status) {
        this.setMessage(message, status);
        if (!this.generated && message == null) {
            this.bGenerate.setEnabled(true);
        } else {
            this.bGenerate.setEnabled(false);
        }
        this.setPageComplete(this.generated);
    }

    public void handleEvent(Event e) {
        if (e.widget == this.bOpen) {
            this.openKeystore();
        } else if (e.widget == this.bGenerate) {
            try {
                this.createKey();
                this.updateStatus(null, 0);
            }
            catch (Exception exception) {
                this.updateStatus(Messages.keyGenerationFailed, 3);
            }
        } else if (e.widget == this.bEchoKeystorePassword || e.widget == this.bEchoKeyPassword) {
            this.echoPassword(e);
        }
    }

    private void echoPassword(Event e) {
        if (e.widget == this.bEchoKeystorePassword) {
            if (this.tKeystorePassword.getEchoChar() == '*') {
                this.tKeystorePassword.setEchoChar('\u0000');
            } else {
                this.tKeystorePassword.setEchoChar('*');
            }
            this.tKeystorePassword.redraw();
        } else if (e.widget == this.bEchoKeyPassword) {
            if (this.tKeyPassword.getEchoChar() == '*') {
                this.tKeyPassword.setEchoChar('\u0000');
            } else {
                this.tKeyPassword.setEchoChar('*');
            }
            this.tKeyPassword.redraw();
        }
    }

    private void openKeystore() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterNames(Globals.KEY_STORE_EXTENSION_NAME);
        dialog.setFilterExtensions(Globals.KEY_STORE_EXTENSION);
        dialog.setFilterPath(this.path);
        String file = dialog.open();
        if (file != null && file.length() > 0) {
            this.tKeystore.setText(file);
        }
    }

    private void createKey() throws Exception {
        HashMap<String, String> certificateData = new HashMap<String, String>();
        certificateData.put("CN", this.tCommonName.getText());
        certificateData.put("OU", this.tOrganizationalUnit.getText());
        certificateData.put("O", this.tOrganization.getText());
        certificateData.put("L", this.tLocation.getText());
        certificateData.put("ST", this.tState.getText());
        certificateData.put("C", this.tCountry.getText());
        try {
            this.keystore = new Keystore(this.tKeystore.getText(), this.tKeystorePassword.getText(), "JCEKS");
            this.keystore.load();
            KeyPair kp = this.keystore.generateKeyPair(this.cKeyAlgorithm.getText(), 512);
            Certificate[] certs = new Certificate[1];
            this.generated = this.keystore.insertPrivateKey(this.tKeyName.getText(), this.tKeyPassword.getText().toCharArray(), kp.getPrivate(), certs);
            this.keystore.store();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.generated = false;
            this.lResult.setText(Messages.keyGenerationFailed);
        }
        if (this.generated) {
            this.lResult.setText(NLS.bind((String)Messages.keyGenerated, (Object)this.keystoreName));
            this.updateStatus(null, 0);
        }
    }

    public void onEnterPage() {
        if (this.signature.getBsp()) {
            this.cKeyAlgorithm.setItems(Algorithms.SIGNATURE_KEY_ALGORITHMS_BSP);
            this.cKeyAlgorithm.select(0);
        } else {
            this.cKeyAlgorithm.setItems(Algorithms.SIGNATURE_KEY_ALGORITHMS);
            this.cKeyAlgorithm.select(0);
        }
        this.setMessage(null);
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        PageAlgorithms page = ((NewSignatureWizard)this.getWizard()).getPageAlgorithms();
        page.onEnterPage();
        return page;
    }

    private void saveDataToModel() {
        this.signature.setKeystore(this.keystore);
        this.signature.setKeystorePassword(this.tKeystorePassword.getText().toCharArray());
        this.signature.setKeyPassword(this.tKeyPassword.getText().toCharArray());
        this.signature.setKeyName(this.tKeyName.getText());
        if (this.cKeyAlgorithm.getText().equals("DSA")) {
            this.signature.setKeyAlgorithm("SHA1withDSA");
        } else if (this.cKeyAlgorithm.getText().equals("EC")) {
            this.signature.setKeyAlgorithm("SHA1withECDSA");
        } else if (this.cKeyAlgorithm.getText().equals("RSA")) {
            this.signature.setKeyAlgorithm("SHA1withRSA");
        }
    }
}

