/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.security.ui.verify;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xml.security.utils.resolver.implementations.ResolverFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.security.core.verify.VerificationResult;
import org.eclipse.wst.xml.security.ui.dialogs.VerificationDialog;
import org.eclipse.wst.xml.security.ui.verify.Messages;

public final class Verification {
    private Verification() {
    }

    public static void showVerificationResult(VerificationResult result, Shell shell) {
        XMLSignature signature = result.getSignature();
        ResolverFragment fragmentResolver = new ResolverFragment();
        signature.addResourceResolver((ResourceResolverSpi)fragmentResolver);
        try {
            X509Certificate cert = signature.getKeyInfo().getX509Certificate();
            PublicKey pk = signature.getKeyInfo().getPublicKey();
            String additionalInfo = "";
            if (cert != null) {
                additionalInfo = "Certificate Type: " + cert.getType();
                additionalInfo = String.valueOf(additionalInfo) + ", Certificate Version: " + cert.getVersion();
                additionalInfo = String.valueOf(additionalInfo) + ", Certificate Algorithm: " + cert.getSigAlgName();
                additionalInfo = String.valueOf(additionalInfo) + ", Certificate Algorithm ID: " + cert.getSigAlgOID();
            } else if (pk != null) {
                additionalInfo = "Public Key Format: " + pk.getFormat();
                additionalInfo = String.valueOf(additionalInfo) + ", Public Key Algorithm: " + pk.getAlgorithm();
            }
            if ("valid".equals(result.getStatus())) {
                Verification.showVerificationDialog(result.getStatus(), NLS.bind((String)Messages.validSignature, (Object[])new Object[]{result.getId(), additionalInfo}), shell);
            } else if ("invalid".equals(result.getStatus())) {
                Verification.showVerificationDialog(result.getStatus(), NLS.bind((String)Messages.invalidSignature, (Object[])new Object[]{result.getId(), additionalInfo}), shell);
            } else {
                Verification.showVerificationDialog(result.getStatus(), NLS.bind((String)Messages.unknownSignature, (Object[])new Object[]{result.getId(), additionalInfo}), shell);
            }
        }
        catch (KeyResolverException keyResolverException) {
            MessageDialog.openInformation((Shell)shell, (String)Messages.verificationImpossible, (String)Messages.impossibleToGetKeyInformation);
        }
    }

    protected static void showVerificationDialog(String status, String message, Shell shell) {
        VerificationDialog dialog = new VerificationDialog(shell, Messages.title, message, status);
        dialog.open();
    }
}

